#define WINSWAT
#define WinTextLen 40

#include <windows.h>
#include <toolhelp.h>
#include <stdio.h>
#include <ctl3d.h>
#include <stdlib.h>
#include "winswat.h"

long _export FAR PASCAL WndProc(HWND, UINT, UINT, LONG);
BOOL FAR PASCAL IsWinOldApTask(HANDLE hTask);
BOOL FAR PASCAL SwitchToThisWindow(HWND hwnd, BOOL tRestore);

RECT rect;
short cxChar, cyChar;
static HANDLE hInst, hWinBeef;
static HICON hGuard;
static HWND hwnd;
static HWND ChldHwnd, EndtHwnd, KillHwnd, CanlHwnd;
static char szAppName[] = "WinSwat";

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                   LPSTR lpszCmdParam, int nCmdShow)
   {
   MSG msg;
   HDC hdc;
   WNDCLASS wndclass;
   UINT iXsize, iYsize;
   TEXTMETRIC tm;

   if (hPrevInstance)
      return FALSE;

   hGuard   = LoadIcon(hWinBeef, "swat");

   wndclass.style         = CS_HREDRAW | CS_VREDRAW;
   wndclass.lpfnWndProc   = WndProc;
   wndclass.cbClsExtra    = 0;
   wndclass.cbWndExtra    = 0;
   wndclass.hInstance     = hInstance;
   wndclass.hIcon         = hGuard;
   wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wndclass.hbrBackground = GetStockObject(LTGRAY_BRUSH);
   wndclass.lpszMenuName  = NULL;
   wndclass.lpszClassName = szAppName;

   RegisterClass (&wndclass);

   hdc = CreateDC("DISPLAY", NULL, NULL, NULL);
   GetTextMetrics(hdc, &tm);
   DeleteDC(hdc);
   hInst = hInstance;

   iXsize = 2 * GetSystemMetrics(SM_CXDLGFRAME) +
                (15 + WinTextLen) * tm.tmAveCharWidth;
   iYsize = 2 * GetSystemMetrics(SM_CYDLGFRAME) + 11 * tm.tmHeight;

   hwnd = CreateWindow(szAppName,
              "Windows Swatter",
              WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU |
              WS_MINIMIZEBOX,
              CW_USEDEFAULT,
              CW_USEDEFAULT,
              iXsize,
              iYsize,
              NULL,
              NULL,
              hInstance,
              NULL);

   ShowWindow(hwnd, nCmdShow);
   UpdateWindow(hwnd);

   while (GetMessage(&msg, NULL, 0, 0))
      {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      }
   return msg.wParam;
   }

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                     Debug Output With Parms                     */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
void VarDebug(char *szFormat, ...)
   {
   char szBuffer[256];
   char *pArguments;

   pArguments = (char *) &szFormat + sizeof szFormat;
   wvsprintf(szBuffer, szFormat, pArguments);
   OutputDebugString((LPSTR)szBuffer);
   }

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                   Get All Main Windows Titles                   */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
void SetTaskProc()
   {
   HDC hdc;
   HWND WorkHwnd;
   UINT txtlen;
   WORD index;
   char txtmsg[100];

   hdc = GetDC(hwnd);

   SendMessage(ChldHwnd, WM_SETREDRAW, FALSE, 0L);
   SendMessage(ChldHwnd, LB_RESETCONTENT, 0, 0L);
   WorkHwnd = GetWindow(hwnd, GW_HWNDFIRST);

   while (WorkHwnd)
      {
      if ((WorkHwnd != hwnd) && IsWindowVisible(WorkHwnd))
         if ((GetParent(WorkHwnd)) == NULL)
            {
            txtlen = GetWindowText(WorkHwnd, (LPSTR) txtmsg, 100);
            if (txtlen != 0)
               {
               index = (WORD)SendMessage(ChldHwnd, LB_ADDSTRING, 0,
                                        (LONG) (LPSTR) txtmsg);
               SendMessage(ChldHwnd, LB_SETITEMDATA, index,
                           WorkHwnd);
               }
            }
      WorkHwnd = GetWindow(WorkHwnd, GW_HWNDNEXT);
      }

   SendMessage(ChldHwnd, LB_SETCURSEL, 0, 0L);

   SendMessage(ChldHwnd, WM_SETREDRAW, TRUE, 0L);
   ReleaseDC(hwnd, hdc);
   VarDebug("WINSWAT: SetTaskProc Exit\n");
   }

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                       Get Selected Entry                        */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
HWND GetSelTask()
   {
   WORD x;
   HWND WorkHwnd;

   if ((x = (WORD)SendMessage(ChldHwnd, LB_GETCURSEL, 0, 0)) == LB_ERR)
      return 0;

   WorkHwnd = (HWND)SendMessage(ChldHwnd, LB_GETITEMDATA, x, 0);

   return WorkHwnd;
   }

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                    Transfer Control To Task                     */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
int TaskTran(HWND WorkHwnd)
   {
   HWND PopHwnd;

   if (IsWindow(WorkHwnd))
      {
      if (IsWindow(PopHwnd = GetLastActivePopup(WorkHwnd)))
         {
         if (! (GetWindowLong(PopHwnd, GWL_STYLE) & WS_DISABLED))
            SwitchToThisWindow(PopHwnd, TRUE);
         }
      }
   return 0;
   }

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                      Main Window Procedure                      */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
long FAR PASCAL WndProc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
   {
   HDC hdc;
   PAINTSTRUCT ps;
   TEXTMETRIC tm;
   HWND WorkHwnd;
   HTASK hTask;

   switch (message)
      {
      case WM_CREATE:
         Ctl3dRegister(hInst);
         Ctl3dAutoSubclass(hInst);
         hdc = GetDC(hwnd);
         GetTextMetrics(hdc,&tm);
         cxChar = tm.tmAveCharWidth;
         cyChar = tm.tmHeight;
         ReleaseDC(hwnd, hdc);
         rect.top = 3 * cyChar / 2;
         InitialiseSwat(TRUE, hwnd);
         ChldHwnd = CreateWindow("listbox", NULL,
                    WS_CHILD | WS_VISIBLE | LBS_NOTIFY | WS_VSCROLL,
                    0, 0,
                    tm.tmAveCharWidth * WinTextLen +
                       GetSystemMetrics(SM_CXVSCROLL),
                    tm.tmHeight * 10,
                    hwnd, 10,
                    hInst, NULL);

         EndtHwnd = CreateWindow("button", "&End Task",
                    WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                    tm.tmAveCharWidth * (WinTextLen + 1) +
                       GetSystemMetrics(SM_CXVSCROLL),
                    tm.tmHeight * 2,
                    tm.tmAveCharWidth * 11,
                    5 * (tm.tmHeight + tm.tmExternalLeading) / 4,
                    hwnd, TERMBUTN,
                    hInst, NULL);

         KillHwnd = CreateWindow("button", "&Swat Task",
                    WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                    tm.tmAveCharWidth * (WinTextLen + 1) +
                       GetSystemMetrics(SM_CXVSCROLL),
                    tm.tmHeight * 4,
                    tm.tmAveCharWidth * 11,
                    5 * (tm.tmHeight + tm.tmExternalLeading) / 4,
                    hwnd, KILLBUTN,
                    hInst, NULL);

         CanlHwnd = CreateWindow("button", "&Cancel",
                    WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                    tm.tmAveCharWidth * (WinTextLen + 1) +
                       GetSystemMetrics(SM_CXVSCROLL),
                    tm.tmHeight * 6,
                    tm.tmAveCharWidth * 11,
                    5 * (tm.tmHeight + tm.tmExternalLeading) / 4,
                    hwnd, CANLBUTN,
                    hInst, NULL);
         return 0;

      case WM_SIZE:
         rect.right = LOWORD(lParam);
         rect.bottom = HIWORD(lParam);
         UpdateWindow(hwnd);
         ShowWindow(hwnd, SW_HIDE);
         return 0;

      case WM_PAINT:
         InvalidateRect(hwnd, NULL, TRUE);
         hdc = BeginPaint(hwnd, &ps);
         SetTaskProc();
         SetBkMode(hdc, TRANSPARENT);
         EndPaint(hwnd, &ps);
         SetFocus(ChldHwnd);
         return 0;

      case WM_DESTROY :
         Ctl3dUnregister(hInst);
         InitialiseSwat(FALSE, NULL);
         PostQuitMessage(0);
         return 0;

      case WM_COMMAND:
         switch (wParam)
            {
            case KILLBUTN:
               {
               VarDebug("WINSWAT: Kill Key\n");
               if ((WorkHwnd = GetSelTask()) == 0)
                  {
                  MessageBeep(0);
                  return 0;
                  }
               if (IDYES == MessageBox(hwnd,
                            "Are You Sure You Want To SWAT This Task?",
                            (LPSTR) szAppName,
                            MB_ICONEXCLAMATION | MB_YESNO))
                  {
                  hTask = GetWindowTask(WorkHwnd);
                  TerminateApp(hTask, NO_UAE_BOX);
                  ShowWindow(hwnd, SW_HIDE);
                  return 0;
                  }
               break;
               }
            case TERMBUTN:
               {
               VarDebug("WINSWAT: Term Key\n");
               if ((WorkHwnd = GetSelTask()) == 0)
                  {
                  MessageBeep(0);
                  return 0;
                  }
               if (IsWinOldApTask(GetWindowTask(WorkHwnd)))
                  {
                  TaskTran(WorkHwnd);
                  return 0;
                  }
               if (IsWindow(WorkHwnd) &&
                  (! (GetWindowLong(WorkHwnd, GWL_STYLE) & WS_DISABLED)))
                  PostMessage(WorkHwnd, WM_CLOSE, 0, 0);
               ShowWindow(hwnd, SW_HIDE);
               return 0;
               }
            case CANLBUTN:
               {
               VarDebug("WINSWAT: Cancel Key\n");
               ShowWindow(hwnd, SW_HIDE);
               return 0;
               }
            case WAKESIGL:
               VarDebug("WINSWAT: Keyboard Activate\n");
               ShowWindow(hwnd, SW_SHOW);
               SetTaskProc();
               UpdateWindow(hwnd);
/*               InvalidateRect(hwnd, NULL, TRUE);*/
               break;
            }
         break;
      }
   return DefWindowProc(hwnd, message, wParam, lParam);
   }
