#define SWATDLL
#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include "winswat.h"

static HHOOK hKhook = NULL;
static HTASK hTASK = NULL;
static HWND  hHWND = NULL;
static HANDLE hInstance;

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                    Maint Entry Point For DLL                    */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
int WINAPI LibMain (HMODULE hModule, WORD wDataSeg, WORD wHeapSize,
                    LPSTR lpszCmdLine)
   {
   hInstance = hModule;

   if (wHeapSize > 0)
      UnlockData (0);

   return 1;
   }

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                     DLL Termination Routine                     */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
int WINAPI WEP (int nParam)
   {
   return 1;
   }

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                     Debug Output With Parms                     */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
void VarDebug(char *szFormat, ...)
   {
   static char szBuffer[256];
   static char far *pArguments;

   pArguments = (char *) &szFormat + sizeof szFormat;
   wvsprintf(szBuffer, szFormat, pArguments);
   OutputDebugString((LPSTR)szBuffer);
   }

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                   Install Windows SHELL Hook                    */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
void WINAPI _export InitialiseSwat(BOOL fAction, HWND hwnd)
   {
   if (fAction)
      {
      OutputDebugString("SWATDLL: Pre--SetHook\n");
      hKhook = SetWindowsHookEx(WH_KEYBOARD, (HOOKPROC) KeyboardHook,
                                hInstance, NULL);
      OutputDebugString("SWATDLL: Post-SetHook\n");
      hTASK = GetWindowTask(hwnd);
      hHWND = hwnd;
      }
   else
      {
      UnhookWindowsHookEx(hKhook);
      hKhook  = NULL;
      hHWND = NULL;
      hTASK = NULL;
      }
   }

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                          Keyboard Hook                          */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
DWORD CALLBACK KeyboardHook(int nCode, WPARAM wParam, LPARAM lParam)
   {
   static BOOL fPost;
   BYTE iBit;
   WORD iWord;
   static UINT iQky = 83;

   if (nCode >= 0)
      if (wParam == iQky)
         {
         OutputDebugString("SWATDLL: Key Hook Hit\n");
         iWord = HIWORD(lParam);
         iBit  = HIBYTE(iWord);
         if (iBit & 0x20)
            {
            fPost = PostMessage(hHWND, WM_COMMAND, WAKESIGL, 0);
            return 1;
            }
         }

   CallNextHookEx(hKhook, nCode, wParam, lParam);
   return 0;
   }
