/*==================================================================
PROGRAM:  EMFFCUT
 AUTHOR:  (Dare I claim ownership?) Stuart Whitmore
   DATE:  13 MAR 95

PURPOSE:  Take a specially-formatted text file and chop it into
	  smaller files based on name that is in format of the
	  file.  Intended for use between File Express (database
	  management program) and PostMaster (imports text files
	  as messages into Wildcat! BBS message base).

REQUIRED FILE FORMAT:
   This format can easily be generated using a File Express form
   letter.  You can buy File Express from UniNova Services Corp
   at a discount; log on to UniNova's BBS at 509-925-3893 for
   details and to shop the Virtual Mall.

   MSGID in the following is a unique five (or less) character
   code assigned to each intended recipient.  (See sample database
   format.)

   MSGID<newline>
   [message body; first line should be To:user@internet.address]
   <formfeed>MSGID<newline>
   [next message]
   .
   .
   .
   [last message]
   <formfeed>

Whew.... for something I didn't intend to document, I'm getting a
little out of hand!  :)
------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

/* Real C programmers do #defines in hex.  Note that I do mine in
   decimal.  This is not a coincidence! :) */
#define LF 10
#define FF 12
#define CR 13

int main(void)
	{
	int myeof, status, inchar, msgstart;
	FILE *in, *out;
	char userid[6];
	char outfilename[13];

	status = 0;
	myeof  = 0;
	inchar = NULL;

	if ((in = fopen("EMAIL.TXT","rt")) == NULL)
		{
		printf ("Couldn't find or open EMAIL.TXT.\n");
		status = 1;
		}
	else
		{
		if (fgets(userid, 6, in) == NULL)
			{
			printf ("Hmm. Opened file but couldn't read it.\n");
			status = 2;
			}
		else
			{
			while ((!status) && (inchar != EOF) && (!myeof))
				{
				strcpy(outfilename,userid);
				strcat(outfilename,".TXT");
				printf("Writing message to %s.\n",outfilename);
				if ((out = fopen(outfilename,"wt")) == NULL)
					{
					printf("Couldn't open %s for writing.\n",outfilename);
					status = 3;
					}
				else
					{
/* Kludge.  msgstart flags the beginning of a message, where a CR/LF combo
   may cause problems.  Note it's cleared after the first real character is
   read.  Oh, these late night programming sessions.  I should be studying. */
					msgstart = 1;
					inchar = NULL;
					while ((inchar != FF) && (inchar != EOF))
						{
/* The only reason I'm using a character variable here instead of sending
   the result of fputc directly to fgetc is to prevent putting FF characters
   into e-mail messages. */
						inchar = fgetc(in);
						if ((inchar != FF) && (!msgstart || ((inchar != CR) && (inchar != LF))))
							{
							msgstart = 0;
							if (fputc(inchar,out) == EOF)
								{
								printf("Error writing to %s.\n",outfilename);
								status = 4;
								}
							}
						}
					fclose(out);
					}
				if (fgets(userid,6,in) == NULL)
					{
					myeof = 1;
					}
				}
			}
		fclose(in);
		}

	printf ("EMFFCUT was a quick hack by Stuart Whitmore (firearms ownership advocate!).\n");
	printf ("Released with code (for improvement!) into public domain.\n");
	return status;
	}