/*
Function: int timechk(int min_left)
Purpose : Performs check of time left versus time used.
Return  : 0 if time remains, 1 if time has run out.
*/

#include <time.h>
#include <stdio.h>

extern char _slrerr[80];

int timechk(int min_left)
{
  clock_t ticks_now;
  float   secs_now;
  int     min_now;

  ticks_now = clock();
  secs_now = ticks_now / CLK_TCK;
  min_now = secs_now / 60;

  if (min_now > min_left) goto OutOfTime;
  if ((min_now + 5) >= min_left)
  {
    fprintf(stdout,"<warning> only %u minutes left\n", min_left - min_now);
    goto GoodExit;
  }
  if ((min_now + 1) >= min_left)
  {
    fprintf(stdout,"<warning> only %u minute left\n", min_left - min_now);
    goto GoodExit;
  }
GoodExit:
  return 0;
OutOfTime:
  strcpy(_slrerr,"time limit exceeded");
  return 1;
}
