/*===========================================================================
SOLAR solar v0.94 :: Module compress.c

This source code has been placed into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
04-20-93 KJH  Started history.
05-01-93 KJH  Added a chdir to solarwork before compression. This is to
              eliminate path problems with Info-ZIP's ZIP.
05-14-93 KJH  Added code to compress LIST file if present.
06-20-93 KJH  Cleaned up code and added comments.
07-15-94 KJH  Changed all printf() to fprintf()
07-18-94 KJH  Added extra debugging info for spawnlp().
===========================================================================*/

/* Header Files */
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <process.h>
#include <stdlib.h>
#include <spawno.h>

/* Module Definitions */
#define AREAS_NAME       "AREAS"    /* Complies with v1.1 of Helldiver */
#define BATCH_EXT          "MSG"    /* packet format.                  */
#define INDEX_EXT          "IDX"
#define LIST_NAME         "LIST"
#define INFO_NAME         "INFO"

/* External Data */
extern char temp_path[MAXPATH];          /* From solar.c */
extern char config_path[MAXPATH];        /* From solar.c */
extern char solar_path[MAXPATH];         /* From solar.c */
extern char user_path[MAXPATH];          /* From solar.c */
extern char speed[6];                    /* From solar.c */
extern char uucp_name[10];               /* From solar.c */
extern char compress[10];                /* From solar.c */
extern char _slrerr[80];                 /* From solar.c */

/* External Functions */
extern char *extract_parm(char string[128], char delimiter);
extern int  set_directory(char path[MAXPATH]);

/* Module Data */
char program[MAXPATH];
char options[40];

/* Module Functions */
int  load_compress_parms();
char *user_compress_type();

/*
Function: long compress_packet()
Purpose : Calls selected compression program to compress packet files.
Return  : Size of resulting packet in bytes, negative 1 on error and
          set _slrerr.
*/

long compress_packet()
{
	struct ffblk ffblk;

  FILE *tempfil = NULL;
  FILE *infofile = NULL;

  char compress_path[420];
	char packet_name[MAXPATH];
  char info_path[MAXPATH];
  char infobuf[80];
  char temp[MAXPATH];

  int done;

  /* Load the compression program info from the config file */

  if (load_compress_parms() != 0) goto ErrorExit;

  /* Set the current directory to the temporary directory. */

  if (set_directory(temp_path) != 0) goto ErrorExit;

  /* Determine where to build packet. In LOCAL mode,
     create in user's directory. Otherwise, create
     in Solar temporary directory. */

  if (strnicmp(speed,"LOCAL",5) == 0)
    strcpy(packet_name,user_path);
  else
    strcpy(packet_name,temp_path);

  /* Build the packet name based on the host
     site's uucp name and the compression type */

  strcat(packet_name,"\\");
	strcat(packet_name,uucp_name);
	strcat(packet_name,".");
	strcat(packet_name,compress);

  /* Test to see if a packet file exists.
     If so, unlink it. */

  if (findfirst(packet_name,&ffblk,0) == 0)
    unlink(packet_name);

  /* Add AREAS, *.MSG, and *.IDX files to
     compress path. */

  strcpy(compress_path,AREAS_NAME);
	strcat(compress_path," ");
  strcat(compress_path,"*.");
	strcat(compress_path,BATCH_EXT);
  strcat(compress_path," ");
  strcat(compress_path,"*.");
	strcat(compress_path,INDEX_EXT);

  /* Build path to INFO file */

  strcpy(temp,solar_path);
  strcat(temp,"\\");
  strcat(temp,INFO_NAME);

  /* Try to open the INFO file */

  if ((tempfil = fopen(temp,"rt")) != NULL)
  {

    /* INFO exists, so build path to INFO file
       in temporary directory. */

    strcpy(info_path,temp_path);
    strcat(info_path,"\\");
    strcat(info_path,INFO_NAME);

    /* Open the new INFO file in temp directory */

    if ((infofile = fopen(info_path,"wt")) == NULL)
    {
      /* Display a warning rather than using
         _slrerr, because this is not a fatal
         condition. */

      fprintf(stderr,"<solar> warning: cannot create INFO\n");
    }
    else
    {
      /* Copy the original INFO file to the
         INFO file in temp directory. */

      while (fgets(infobuf,80,tempfil) != NULL)
      {
        fprintf(infofile,"%s",infobuf);
      }
      fclose(infofile);

      /* Add the INFO file to compress path */

      strcat(compress_path," ");
      strcat(compress_path,INFO_NAME);
    }

    /* Close the original INFO file */

    fclose(tempfil);
  }

  /* Check to see if there was a LIST file
     built and present in temp directory. */

  if (findfirst(LIST_NAME,&ffblk,0) == 0)
  {
    /* Add LIST file to compress path */

    strcat(compress_path," ");
    strcat(compress_path,LIST_NAME);
  }

  /* Initialize SPAWNO to swap to disk. */

  init_SPAWNO(".",SWAP_DISK);

  /* Announce what we are doing, and spawn the
     compression program */

  fprintf(stdout,"\nCompressing packet in %s format...\n",compress);
  if (spawnlp(P_WAIT,program,program,options,packet_name,compress_path,NULL) != 0)
	{
    /* Something didn't work. This is an error. */
/*	sprintf(_slrerr,"error spawning %s",program); */
		fprintf(stdout,"Path to %s: %s\n",program, searchpath(program));
		sprintf(_slrerr,"%s",strerror(errno));
		goto ErrorExit;
	}

  /* Unlink all of the files we just compressed
     into the packet file */

  strcpy(compress_path,AREAS_NAME);
  unlink(compress_path);
  strcpy(compress_path,INFO_NAME);
  unlink(compress_path);
  strcpy(compress_path,LIST_NAME);
  unlink(compress_path);

  strcpy(compress_path,"*.");
	strcat(compress_path,BATCH_EXT);
  done = findfirst(compress_path,&ffblk,0);
	while (!done)
	{
    unlink(ffblk.ff_name);
		done = findnext(&ffblk);
	}

  strcpy(compress_path,"*.");
  strcat(compress_path,INDEX_EXT);
  done = findfirst(compress_path,&ffblk,0);
	while (!done)
	{
    unlink(ffblk.ff_name);
		done = findnext(&ffblk);
	}

  /* Check to make sure there is a packet */

  if (findfirst(packet_name,&ffblk,0) != 0)
	{
		strcpy(_slrerr,"No packet generated!");
		goto ErrorExit;
	}

GoodExit:
	return ffblk.ff_fsize;
ErrorExit:
  return -1L;
}

/*
Function: load_compress_parms()
Purpose : Load the appropriate compress parameters from the Solar
          configuration file.
Return  : 0 on success, non-zero on error and set _slrerr.
*/

int load_compress_parms()
{
	FILE *config_file = fopen(config_path,"rt");

	int idx  = 0;

	char buf[128];
	char search_string[20];
	char *p = NULL;

	if (!config_file)
	{
    sprintf(_slrerr,"error opening config file %s", config_path);
    goto ErrorExit;
  }

  strcpy(program,"NONE");
  options[0] = '\0';
  strcpy(search_string,"compress-");
  strcat(search_string,compress);

  while (fgets(buf,128,config_file) != NULL)
	{
		if (strnicmp(buf,"compress",8) == 0)
		{
			if ((p = strtok(buf,"=")) == NULL)
			{
        strcpy(_slrerr,"invalid \"compress\" line in config file");
        goto ErrorExit;
			}
			idx = 0;
      while ((p[idx] != '\n') && (p[idx] != '\0')) /* strip the LF and add a null character */
      {
				p[idx] = p[idx++];
      }
			p[idx] = '\0';
      if (stricmp(p,search_string) == 0)
			{
        if ((p = strtok(NULL,"=")) == NULL)
        {
          strcpy(_slrerr,"invalid \"compress\" line in config file");
          goto ErrorExit;
        }
				idx = 0;
        while ((p[idx] != '\n') && (p[idx] != '\0')) /* copy back into buf, drop LF */
        {
					buf[idx] = p[idx++];
        }
				buf[idx] = '\0';
        if ((p = strtok(buf," ")) != NULL)
				{
					idx = 0;
          while ((p[idx] != '\n') && (p[idx] != '\0')) /* strip the LF and add a null character */
          {
						program[idx] = p[idx++];
          }
					program[idx] = '\0';
          if ((p = strtok(NULL,"=")) != NULL)
          {
						idx = 0;
            while ((p[idx] != '\n') && (p[idx] != '\0')) /* strip the LF and add a null character */
            {
							options[idx] = p[idx++];
						}
						options[idx] = '\0';
          }
          else
          {
            options[0] = '\0';
          }
        }
        else
        {
          strcpy(_slrerr,"invalid \"compress\" line in config file");
          goto ErrorExit;
        }
				break;
      }
    }
  }
  fclose(config_file);

	if (strcmp(program,"NONE") == 0)
	{
    sprintf(_slrerr,"compress program not found for type %s",compress);
    goto ErrorExit;
	}

GoodExit:
  return 0;
ErrorExit:
  if (config_file) fclose(config_file);
  return 1;
}
