/*===========================================================================
SOLAR slrreply v0.94 :: Module rfctime.c

This source code has been placed into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
07-15-94 LL  Contributed by Lars Lindgren <lasse@argh.dude.pp.se>
===========================================================================*/

/*
Function: char *rfctime(char *timezone)
Purpose : Generates time string in RFC 822. Searches Waffle's STATIC
          file for 'timezone:' string.
          Format: Mon, 02 May 1994 00:26:18 +0200
Return  : Pointer to time string, NULL on error.
Non-ANSI functions used: strftime(), strncmpi()
*/

#define TRUE  (0==0)
#define FALSE (0==1)
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dir.h>

char *rfctime()
{
char *get_tz();
static char time_string[35];
struct tm *time_now;
time_t t;

time(&t);
time_now = localtime(&t);

if ((strftime(time_string,30,"%a, %d %b %Y %H:%M:%S ",time_now)) == 0) {
   return NULL;
   }

strcat(time_string, get_tz());

return(time_string);
}


char *get_tz()
/*
 * Returns timezone string from Waffle's STATIC file pointed to by
 * environment variable WAFFLE.
 */
{
FILE *in;
char static_name[MAXPATH];
char *ptr;
char static_str[80];
static char tz[15];  /* timezone string truncates after 15 chars */
int i, found;

ptr=getenv("WAFFLE");
if (ptr==NULL) {
   printf("Environment variable WAFFLE not found!\n");
   exit(-1);
   }

strcpy(static_name, ptr);

if ((in = fopen(static_name, "rt")) == NULL) {
   printf("Cannot open %s\n", static_name);
   exit(-1);
   }

found=FALSE;
do {
   if (fgets(static_str, 80, in)==0) break;  /* eof */
   if (strncmpi(static_str, "timezone:", 9)==0) found=TRUE;
   } while (!found);

fclose(in);

if (found) {
   ptr=strchr(static_str, ':')+1;  /* point to char after ':' */
   while (*ptr==32) ptr++;         /* eliminate spaces after ':' */
   i=0;
   while (*(ptr+i)!='\0' && *(ptr+i)!='\n' && i<sizeof(tz)) {
      tz[i]=*(ptr+i);     /* copy char */
      i++;
      }
   }
tz[i]='\0';

return (tz);
}
