/*===========================================================================
SOLAR slrreply v0.94 :: Module forums.c

This source code has been released into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
07-01-93 KJH  Created to check forum files for moderated newsgroups.
07-14-93 KJH  get_group_name's strtok was corrupting the Newsgroups:
              header by putting a null character in there. Fixed it.
              Also changed /nosolar flag to /noslrreply to differentiate
              between reading and posting limits. Temp. kludge.
07-15-94 KJH  Changed all printf() to fprintf()
===========================================================================*/

/* Include Files */
#include <string.h>
#include <stdio.h>
#include <dir.h>
#include <alloc.h>

/* External Data */
extern char static_path[MAXPATH];   /* From slrreply.c */
extern char system_path[MAXPATH];   /* From slrreply.c */
extern char backbone[40];           /* From slrreply.c */
extern char _slrerr[80];            /* From slrreply.c */

/* Global Data */
char mod_address[80];               /* Moderator's address */

/* Local Data */
typedef struct forum_type {
	char forum_path[MAXPATH];
	struct forum_type *next;
} FORUM;
FORUM *forum;

/* Local Functions */
int  get_mod_address(char *mod_line);
char *get_group_name(char *header);
void remove_list();
int load_forums();

/*
Function: int scan_forums(char *header)
Purpose : Check first group in Newsgroups: header against forum
          files.
Return  : 0  - group is OK, go ahead with posting.
          1  - group is marked /nosolar
          2  - group is moderated
          -1 - An error occurred, set _slrerr
*/

int scan_forums(char *header)
{
  FORUM *current = NULL;
  FILE *forum_file = NULL;
  char group_name[60];
  char buf[128];
  char *token = NULL;
  int found = 0;

  /* Parse Newsgroups: header for first group name */

  strcpy(group_name,get_group_name(header));
  if (strcmp(group_name,"NONE") == 0)
  {
		sprintf(_slrerr,"invalid newsgroups: header");
		goto ErrorExit;
  }

  /* Load the forum files into linked list */

  if (load_forums() != 0) goto ErrorExit;
  current = forum;

  /* Search each forum file for group */

  while ((current) && (found == 0))
	{
    /* Open the forum file for read */

		if ((forum_file = fopen(current->forum_path,"rt")) == NULL)
      goto ErrorExit;

    /* Read a line from forum file into buffer */

    while (fgets(buf,128,forum_file) != NULL)
		{
      /* Compare buffer against group name */

      if (strnicmp(buf,group_name,strlen(group_name)) == 0)
      {
        /* Convert to lowercase */

				strlwr(buf);

        /* Check to see if posting is allowed */

        if (strstr(buf,"/noslrreply") != NULL)
          goto NoSolarExit;

        /* Check for /mod flag */

        if ((token = strstr(buf,"/mod")) == NULL)
        {
          /* Unmoderated group, this one's OK */

					found = 1;
          break;
        }

        /* We have a moderated group, get
           the address */

        if (get_mod_address(token) != 0)
        {
          /* No address given, try backbone site */

          if (strcmp(backbone,"NONE") == 0)
          {
            /* No backbone site. Oh well. */

            sprintf(_slrerr,"cannot mail to moderator; no backbone");
            goto ErrorExit;
          }

          /* Make address to backbone; group_name@backbone */

          strcpy(mod_address,group_name);
          strcat(mod_address,"@");
          strcat(mod_address,backbone);
        }

        /* We have an address.. */

				goto ModExit;
			}
		}
		fclose(forum_file);
		current = current->next;
	}

GoodExit:
  if (forum_file) fclose(forum_file);
  if (forum) remove_list();
  current = NULL;
  return 0;
NoSolarExit:
  if (forum_file) fclose(forum_file);
  if (forum) remove_list();
  current = NULL;
  return 1;
ModExit:
	if (forum_file) fclose(forum_file);
  if (forum) remove_list();
  current = NULL;
  return 2;
ErrorExit:
  if (forum_file) fclose(forum_file);
  if (forum) remove_list();
  current = NULL;
  return -1;
}

/*
Function: load_forums()
Purpose : Load the parameters from Waffle's static forums: line into
          a linked list on the heap. Store full paths to the forum files.
Return  : 0 on success, non-zero on error and set _slrerr.
*/

int load_forums()
{
  FILE *static_file = fopen(static_path,"rt");
  FORUM *current = NULL;

  int idx  = 0;
  int idx2 = 0;

	char buf[128];
  char buf2[MAXPATH];
  char *p = NULL;

	forum = NULL;

  if (!static_file)
  {
    sprintf(_slrerr,"error opening static file %s",static_path);
		goto ErrorExit;
  }

  buf2[0] = '\0';

  while (fgets(buf,128,static_file) != NULL)
	{
		if (strnicmp(buf,"forums",6) == 0)
		{
      while ((buf[idx] != ':') && (buf[idx] != '\n') && (buf[idx] != '\0'))
			{
        idx++;
			}
			idx++;
      while ((buf[idx] == ' ') && (buf[idx] != '\0') && (buf[idx] != '\n'))
			{
        idx++;
			}
      while ((buf[idx] != '\0') && (buf[idx] != '\n'))
			{
				if (((buf[idx] == ' ') && (buf2[idx] != ' ')) || (buf[idx] != ' '))
        {
					buf2[idx2++] = buf[idx];
				}
        idx++;
			}
			buf2[idx2] = '\0';

      if (strlen(buf2) > 0)
      {
				p = strtok(buf2," ");
				while (p != NULL)
				{
					if (forum == NULL)
          {
						forum = current = malloc(sizeof(FORUM));
            if (!forum) goto ErrorExit;
            forum->next = NULL;
					}
					else
					{
						current->next = malloc(sizeof(FORUM));
            if (!current->next) goto ErrorExit;
						current = current->next;
						current->next = NULL;
					}
					strcpy(current->forum_path,system_path);
          strcat(current->forum_path,"\\");
          strcat(current->forum_path,p);
					p = strtok(NULL," ");
				}
			}
		}
	}
  current = NULL;
GoodExit:
	return 0;
ErrorExit:
  if (static_file) fclose(static_file);
	return 1;
}

/*
Function: remove_list()
Purpose : Remove forums linked list from memory.
Return  : N/A
*/

void remove_list()
{
  FORUM *current = forum;

	while (current != NULL)
	{
    forum = current;
		current = current->next;
    free(forum);
	}
	forum = NULL;
  return;
}

/*
Function: char *get_group_name(char *header)
Purpose : Parse first group name from Newsgroups: header
Return  : Name of group, or NONE
*/

char *get_group_name(char *header)
{
  static char group[60];
  char header_temp[1024];
  int x;
  char *token = NULL;

  strcpy(group,"NONE");
  strcpy(header_temp,header);

  if ((token = strtok(header_temp," ")) != NULL)
  {
    if ((token = strtok(NULL," ")) != NULL)
    {
      for (x = 0; x < strlen(token) + 1; x++)
      {
        if ((token[x] != ',') &&
            (token[x] != ' ') &&
            (token[x] != '\0') &&
            (token[x] != '\n'))
        {
          group[x] = token[x];
        }
        else
        {
          break;
        }
      }
      group[x] = '\0';
    }
  }
  return group;
}

/*
Function: int get_mod_address(char *mod_line)
Purpose : Build mail address for moderator and store globally.
Return  : zero on success, non zero if nout found.
*/

int  get_mod_address(char *mod_line)
{
	int idx = 0, idx2 = 0;

  strcpy(mod_address,"NONE");

  if (strstr(mod_line,"=") != NULL)
  {
    while (mod_line[idx++] != '=');
    while ((mod_line[idx] != ' ') && (mod_line[idx] != '\0') && (mod_line[idx] != '\n'))
    {
      if (mod_line[idx] != '\"') mod_address[idx2++] = mod_line[idx];
      idx++;
    }
    mod_address[idx2] = '\0';
  }

  if (strcmp(mod_address,"NONE") == 0)
    return 1;
  else
    return 0;
}
