#include	<malloc.h>
#include	<assert.h>
#include	<string.h>
#include	"mkstring.h"

/*
**	Make a new copy of the given string
*/

char *mkstring(char *string)	{
	static char *allocated=NULL;
	static unsigned int remaining=0;
	unsigned int length=1;
	char *p;

	if(!string) return NULL;

	for(p=string; *p; p++) length++;

	assert(length<=ALLOCATE);

	if(length>remaining)	{
		assert(allocated=malloc(ALLOCATE));
		remaining=ALLOCATE;
	}

	p=allocated;
	remaining-=length;
	while(*allocated++=*string++);

	return p;
}

#ifdef	MAIN
main()	{
	char *p="This is a test",*q,*r,*s,*t;
	int i;

	q=mkstring(p);
	r=mkstring(p);
	s=mkstring(r);

	printf("p=0x%04x=\"%s\"\n",p,p);
	printf("q=0x%04x=\"%s\"\n",q,q);
	printf("r=0x%04x=\"%s\"\n",r,r);
	printf("s=0x%04x=\"%s\"\n",s,s);

	for(i=0; i<100; i++)
		t=mkstring(r);
	printf("t=0x%04x=\"%s\"\n",t,t);

}
#endif
