/*
**	Find FAQ files from newsspool
**
**	Otto J. Makela <otto@jyu.fi>, Jyvaskyla, Finland, 1993
**	BBS V.32bis/HST +358 41 211 562
**	Distributed under the GNU General Public Licence:
**	see file COPYING for details
*/

#include	<stdlib.h>
#include        <string.h>
#include	<stdarg.h>
#include	<stdio.h>
#include	"wafcfg.h"
#include	"mkstring.h"
#include        "formatch.h"

	/* Maximum number of lines to read from a potential FAQ file */
#define	MAXLINES	50
	/* Maximum number of archived files */
#define	MAXARCHIVES	100
	/* Directory to search (trailing slash required) */
#define	DIRNAME		"c:/news/news/answers/"
	/* Last FAQ search article number file */
#define	LASTFAQ		"c:/waffle/faqfile/lastfind"
	/* Packer program */
#define	PACKER		"pkzip -mex"
	/* Where temporary files are collected (trailing slash req'd) */
#define	TEMP		"c:/"
	/* The name of the created batch file */
#define	BATCH		"c:/faqbatch.bat"

	/* God, how I hate ANSI C */
#define	READ_TEXT	"rt"
#define	READ_BINARY	"rb"
#define	WRITE_TEXT	"wt"
#define	WRITE_BINARY	"wb"

	/* Some almost-ANSI compilers don't have __DATE__ */
#ifndef	__DATE__
#define	__DATE__
#endif

	/* Some prototypes */
char *archivename(char *);
int checkfind(struct file_match *);
char *backslash(char *);

	/* Some common variables */
char dirname[65]=DIRNAME,packer[100]=PACKER,lastfaq[65]=LASTFAQ,
	temp[65]=TEMP,batch[65]=BATCH;
unsigned int nolast=0,norun=0,lastsearch=0,nowsearch=0,archives=0;
struct {
	char *file,*archive,*name;
	unsigned int found;
} archive[MAXARCHIVES] = {NULL,NULL,NULL,0};


main(int argc,char *argv[])	{
	char line[BUFSIZ];
	int i,loop;
	char *p;
	FILE *f;

        fprintf(stderr,"%s 1.0 "__DATE__
		" by Otto J. Makela (BBS V.32bis/HST +358 41 211 562)\n"
		"Distributed under the GNU General Public Licence: "
		"see file COPYING for details\n",*argv="faqfile");

        if(argc<2)	{
                fprintf(stderr,"usage: %s config_file [config_params...]\n",
			*argv);
                exit(2);
	}

		/* Open configuration file */
	if(!(f=fopen(argv[1],READ_TEXT)))	{
		fprintf(stderr,"%s: can't open configuration file \"%s\"\n",
			*argv,argv[1]);
		exit(1);
	}

		/* Parse configuration file lines */
	while(fgets(line,sizeof(line),f))	{
parse:		if(!parse_line(line)) continue;

		if(p=token_value("dir",NULL))		strcpy(dirname,p);
		if(p=token_value("last",NULL))		strcpy(lastfaq,p);
		if(p=token_value("packer",NULL))	strcpy(packer,p);
		if(p=token_value("batch",NULL))		strcpy(batch,p);

		if(p=token_value("temp",NULL))	strcpy(temp,backslash(p));

		if(token_set("nolast")!=-1)
			nolast=atoi(token_value("nolast","1"));
		if(token_set("norun")!=-1)
			norun=atoi(token_value("norun","1"));

		if(p=token_value("file",NULL))
			archive[archives].file=mkstring(backslash(p));
		if(p=token_value("archive",NULL))	{
			if(!archive[archives].file && archives)
				archive[archives].file=archive[archives-1].file;
			archive[archives].archive=mkstring(p);
			archive[archives].name=
				mkstring(backslash(token_value("name","")));
			archives++;
		}
	}

		/* If extra arguments are given, fake a line and parse them */
	if(argc>2)	{
		for(p=line, i=2; i<argc; i++)
			p+=sprintf(p," %s",argv[i]);
		argc=2;
		goto parse;
	}

	fclose(f);

	if(!nolast && (f=fopen(lastfaq,READ_TEXT)))	{
		fscanf(f,"%u",&lastsearch);
		nowsearch=lastsearch;
		fclose(f);
	}

#ifdef	DEBUG
	for(loop=0; loop<archives; loop++)
		printf("file=\"%s\"\tarchive=\"%s\"\tname=\"%s\"\n",
			archive[loop].file,archive[loop].archive,
			archive[loop].name);
#endif

	for(loop=1; loop<argc; loop++)
		formatch(dirname,ARCHIVE,checkfind);

	if(!(f=fopen(batch,WRITE_TEXT)))	{
		fprintf(stderr,"%s: cannot open batch file \"%s\" for write\n",
			*argv,batch);
		exit(1);
	}

	for(p=backslash(dirname), i=0, loop=0; loop<archives; loop++)
		if(archive[loop].found)	{
			fprintf(f,"copy %s%u %s%s\n%s %s %s%s\n",
				p,archive[loop].found,
				temp,archive[loop].name,packer,
				archive[loop].file,temp,archive[loop].name);
			i++;
		}

	fclose(f);
	if(!i) unlink(batch);

	if(f=fopen(lastfaq,WRITE_TEXT))	{
		fprintf(f,"%u\n",nowsearch);
		fclose(f);
	} else
		fprintf(stderr,"%s: could not open file \"%s\" for writing "
			"last search number\n",*argv,lastfaq);
	exit(norun|!i);
}

/*
**	Search for a "Archive-Name:" header in the given file
*/
char *archivename(char *filename)	{
	int line;
	static char buffer[BUFSIZ];
	FILE *f;

	if(f=fopen(filename,"r"))	{
		for(line=1; fgets(buffer,BUFSIZ,f) && line<MAXLINES; line++)
			if(!strnicmp(buffer,"archive-name:",13))	{
				char *p=buffer+13,*q;
				while(isspace(*p)) p++;
				if(q=strchr(p,'\n')) *q='\0';
				if(q=strchr(p,'\t')) *q='\0';
				if(q=strchr(p,' '))  *q='\0';
				fclose(f);
				return p;
			}
		fclose(f);
	}
	return NULL;
}

	/* Routine to check the found files, called thru formatch() */
int checkfind(struct file_match *match)	{
	unsigned int i,n;
	char *p;

	if((n=atoi(match->shortname))<=lastsearch) return 0;
	if(n>nowsearch) nowsearch=n;

	if(!(p=archivename(match->filename))) return 0;

	for(i=0; i<archives; i++)	{
		if(!stricmp(archive[i].archive,p))	{
			printf("%s (%s)\n",backslash(match->filename),p);
			if(n>archive[i].found) archive[i].found=n;
		}
	}

	return 0;
}

/*
**	Return given string with /'s replaced by \'s
*/
char *backslash(char *string)	{
	static char buffer[BUFSIZ];
	char *p=buffer;

	do	{
		if(*string=='/')
			*p++='\\';
		else
			*p++=*string;
	} while(*string++);
	return buffer;
}
