{************************************************}
{   GrDriver.pas                                 }
{   Graph Vision unit                            }
{   Sergey E. Levov, Moscow,1992-1993            }
{************************************************}

unit GrDriver;

{$F+,S-,X+,D-}

interface
uses Graph;

type
   BiosFontParams = record
      Width : word;
      Height : word;
      BytesPerChar : word;
      case TwoPart : boolean of
      false : (ImageTable : pointer);
      true :  (Base,Top : pointer);
   end;

const
   Planes = 4;
   BitPerPlane = 1;
   DefaultSysFont = 2;   {default font for EGA/VGA}
   FontNames : Array[1..3] of String = ('8x8 BIOS font',
                                        '8x14 BIOS font',
                                        '8x16 BIOS font');
   Mode : integer = 0;              {write mode for text drawing}
   FillBackground : boolean = true; {draw background pixels if true}

var
   ViewPort : ViewPortType;      {used internally with character generator}
   TextSettings : TextSettingsType;
   FillSettings : FillSettingsType;

procedure GraphDriver;
function ValidMode(Driver,Mode : integer) : boolean;

{ procedures for support ROM-based fonts }

function GetMaxFont : integer;
procedure GetFontParams(Font : integer; var Params : BiosFontParams);
function GetFontName(Font : integer) : String;

{ character generator routines }

procedure SetController(Mode : word);
procedure ResetController;
procedure OutCharPrim(X,Y : Integer; Width,Height : word; Image : pointer);

procedure SetWriteMode(WriteMode : integer);

implementation
uses Objects;

const
   Font8x8 = 1;
   Font8x14 = 2;
   Font8x16 = 3;

   VideoSeg = $A000;
   BytesPerLine = 80;

procedure GraphDriver; external;

{$L egavga.obj}

function ValidMode(Driver,Mode : integer) : boolean;
begin
   ValidMode := true;
end;

function GetMaxFont : integer;
begin
   case GetGraphMode of
      VGALo, VGAMed : GetMaxFont := 2;
      VGAHi : GetMaxFont := 3;
   else
      GetMaxFont := 0;
   end;
end;

procedure GetFontParams(Font : integer; var Params : BiosFontParams);
var
   H : word;
   B : byte absolute $40:$85;
   T : byte;
   P : Pointer;
begin
   if Font > GetMaxFont then
   with Params do begin
      ImageTable := nil;
      Width := 0;
      Height := 0;
      BytesPerChar := 0;
   end else
   begin
     case Font of
        Font8x8 : T := $23;
        Font8x14 : T := $22;
        Font8x16 : T := $24;
     end;
     asm
        push    bp
        push    ds
        mov     ah,$11
        mov     bl,2
        mov     al,T
        int     $10
        pop     ds
        pop     bp
     end;
     Params.BytesPerChar := word(B);
     Params.Width := 8;
     case Font of
        Font8x8 : T := 3;
        Font8x14 : T := 2;
        Font8x16 : T := 6;
     end;
     asm
        mov     ah,$11
        mov     al,$30
        mov     bh,T
        push    ds
        push    bp
        int     $10
        mov     ax,bp
        pop     bp
        pop     ds
        mov     H,cx
        mov     P.word[0],ax
        mov     P.word[2],es
     end;
     Params.Height := H;
     if Font <> Font8x8 then begin
        Params.TwoPart := false;
        Params.ImageTable := P
     end else begin
        Params.TwoPart := true;
        Params.Base := P;
        inc(T);
        asm
           mov     ah,$11
           mov     al,$30
           mov     bh,T
           push    ds
           push    bp
           int     $10
           mov     ax,bp
           pop     bp
           pop     ds
           mov     P.word[0],ax
           mov     P.word[2],es
        end;
        Params.Top := P;
     end;
   end;
end;

function GetFontName(Font : integer) : String;
begin
   GetFontName := FontNames[Font];
end;

procedure SetController(Mode : word); assembler;
asm
   mov  dx,$3CE
   mov  ax,$0A05
   out  dx,ax
   mov  ah,byte ptr Mode
   mov  al,3
   mov  cl,al
   shl  ah,cl
   out  dx,ax
   mov  ax,7
   out  dx,ax
end;

procedure ResetController; assembler;
asm
   mov  dx,$3CE
   mov  ax,$FF08
   out  dx,ax
   mov  ax,5
   out  dx,ax
   mov  ax,3
   out  dx,ax
   mov  ax,$0F07
   out  dx,ax
end;

procedure OutCharPrim(X,Y : Integer; Width,Height : word; Image : pointer);
var
   Work : array[0..255] of byte;
   Mask : array[0..255] of byte;
   ImagePtr : PByteArray absolute Image;
   i,j,l,First,Last,Count,ImageWidth : integer;
   Shift,Shift1,Extra : integer;
   StartByte,EndByte,ClipByte : integer;
   VideoPtr : PByteArray;
   Fore : WordRec;
   R : WordRec;
   Mask1,ExtraMask : byte;
begin
   if ((X + Width) > ViewPort.X1) and (X <= ViewPort.X2) then begin
      word(Fore) := GetColor;
      asm
         mov       ax,Width
         mov       cx,ax
         shr       ax,1
         shr       ax,1
         shr       ax,1
         mov       dx,ax
         and       cx,7
         or        cx,cx
         jz        @@1
         mov       ax,$FF00
         shr       ax,cl
         mov       byte ptr ExtraMask,al
         inc       dx
   @@1:  mov       Count,dx
         mov       ImageWidth,dx
         mov       Extra,cx
      end;
      if X >= 0 then Shift := X mod 8
      else Shift := 8-Abs(X) mod 8;
      asm
         lea      di,Mask
         push     ss
         pop      es
         mov      cx,Count
         cld
         xor      al,al
         not      al
         cld
         push     di
         rep stosb
         pop      di
         mov      ax,Shift
         or       ax,ax
         jnz      @@3
         mov      cx,Extra
         or       cx,cx
         jz       @@2
         dec      di
         mov      dl,byte ptr ExtraMask
         mov      es:[di],dl
   @@2:  jmp      @@7
   @@3:  mov      cx,ax
         xor      ax,ax
         not      ah
         shr      ax,cl
         mov      es:[di],ah
         mov      dx,Count
         mov      bx,dx
         add      bx,di
         mov      es:[bx],al
         inc      dx
         mov      Count,dx
         mov      cx,Extra
         or       cx,cx
         jz       @@7
         mov      ax,cx
         add      ax,dx
         mov      cl,3
         shr      ax,cl
         or       ax,ax
         jz       @@4
         mov      ah,byte ptr ExtraMask
         xor      al,al
         jmp      @@5
   @@4:  mov      al,byte ptr ExtraMask
         xor      ah,ah
         not      ah
         dec      dx
   @@5:  mov      cx,Shift
         shr      ax,cl
         add      di,dx
         dec      di
         mov      es:[di],al
         mov      Count,dx
   @@7:
      end;
      StartByte := X div 8;
      if X < 0 then if Shift <> 0 then dec(StartByte);
      asm
         xor      si,si
         mov      ax,ViewPort.X1
         mov      bx,ax
         mov      cl,3
         shr      ax,cl
         cmp      ax,StartByte
         jl       @@9
         mov      si,ax
         sub      si,StartByte
         mov      StartByte,ax
         and      bx,$7
         mov      Shift1,bx
         or       bx,bx
         jz       @@9
         mov      cx,bx
         mov      ax,$FF
         shr      ax,cl
         and      Mask.byte[si],al
   @@9:  mov      First,si
      end;

{      First := 0;
      ClipByte := ViewPort.X1 div 8;
      if ClipByte >= StartByte then begin
         First := ClipByte - StartByte;
         StartByte := ClipByte;
         Shift1 := ViewPort.X1 mod 8;
         if Shift1 <> 0 then Mask[First] := Mask[First] and ($FF shr Shift1);
      end;}
      Last := Count-1;
      ClipByte := ViewPort.X2 div 8;
      EndByte := StartByte + Last-First;
      if ClipByte <= EndByte then begin
         EndByte := ClipByte;
         Last := First + (EndByte - StartByte);
         Shift1 := ViewPort.X2 mod 8;
         inc(Shift1);
         word(R) := $FF00 shr Shift1;
         Mask[Last] := Mask[Last] and R.Lo;
      end;
      for i := 0 to Height-1 do begin
         if ((i+Y) >= ViewPort.Y1) and ((i+Y) <= ViewPort.Y2) then begin
            Mask1 := 0;
            for j := 0 to ImageWidth-1 do begin
               if Shift <> 0 then
               asm
                  xor   ax, ax
                  mov   bx, ax
                  mov   bx, j
                  les   di, ImagePtr
                  mov   ah, es:[di+bx]
                  mov   cx, Shift
                  shr   ax, cl
                  or    ah, Mask1
                  mov   si, bx
                  mov   byte ptr Work[si],ah
                  mov   Mask1, al
               end else Work[j] := ImagePtr^[j];
            end;
            if Shift <> 0 then Work[ImageWidth] := Mask1;
            VideoPtr := Ptr(VideoSeg,(Y+i)*BytesPerLine+StartByte);
            asm
               mov   di, First
               les   si, VideoPtr
               mov   cl, FillBackground
               mov   dx, $3CE
               mov   al, 8
        @@1:   mov   ah, Work.byte[di]
               and   ah, Mask.byte[di]
               out   dx, ax
               mov   bl, es:[si]
               and   bl, Fore.Lo
               mov   es:[si], bl
               or    cl, cl
               jz    @@2
               xor   ah, Mask.byte[di]
               out   dx, ax
               mov   bl, es:[si]
               and   bl, FillSettings.Color.byte
               mov   es:[si], bl
        @@2:   inc   di
               inc   si
               cmp   di, Last
               jle   @@1
            end;
         end;
         inc(LongInt(ImagePtr),ImageWidth);
      end;
   end;
end;

procedure SetWriteMode(WriteMode : integer);
begin
   Mode := WriteMode;
   Graph.SetWriteMode(WriteMode);
end;
   
end.
