{****************************************************************************}
{*                                                                          *}
{*  TTTypes                                                                 *}
{*                                                                          *}
{*  Cette unit contient les types des donnes manipules par               *}
{*  l'interprteur TrueType                                                 *}
{*                                                                          *}
{****************************************************************************}


unit TTTypes;

interface

uses FreeType;

type

  {* BYTE is already defined in Pascal       *}
  {* They are equivalent to C unsigned chars *}

  UShort   = Word;          {* unsigned short integer, must be on 16 bits *}
  Short    = Integer;       {* signed short integer,   must be on 16 bits *}

  ShortRec = record
               Low,         {* a structure used for various type casts *}
               High : Byte;
             end;

  ULong = LongInt;         {* unsigned long integer, must be on 32 bits *}
                           {* NOTE : There is no 'LongWord' in Pascal,  *}
                           {*        but the unsigned ops are all in    *}
                           {*        the inline assembly routines       *}

  Long  = LongInt;         {* signed long integer,   must be on 32 bits *}

  Fixed    = Longint;      {* Signed Fixed 16.16 Float *}

  FixedRec = record        {* Structure used for various typecasts *}
               Low,
               High  : Integer;
             end;

  FixedPoint = FixedRec;

{$IFDEF OS2}
  Int = LongInt;      {* the 'int' type is used for loop counters and  *}
{$ELSE}               {* indexes.. Their size must be the one a given  *}
  Int = Integer;      {* system handles most easily ( 16 bits on Turbo *}
{$ENDIF}              {* and 32 on Virtual Pascals )                   *}

  {* Simple access types : pointers and tables *}

  PUShort     = ^UShort;
  PShort      = ^Short;

  PULong      = ^ULong;
  PLong       = ^Long;

  PFixed      = ^Fixed;
  PFixedRec   = ^FixedRec;

  TByteArray  = array[0..63999] of Byte;
  PByteArray  = ^TByteArray;

  PShortArray = ^TShortArray;
  TShortArray = array[0..1023] of Integer;

  TStorage    = array[0..16000] of Long;
  PStorage    = ^TStorage;

  TPoint = Record
             GlyphNum : integer; {* this point's glyph number   *}
             V        : TT_Vector; {* current pixel position      *}
             Touch    : Byte;    {* touch flags                 *}
            end;

  PTTZone = ^TTTZone;
  TTTZone = Array[0..1023] of TPoint;

  TCVTRecord  = record
                 N : int;       {* size in 32 bits elements *}
                 A : PStorage;  {* table address            *}
                end;
  {* The CVT is a simple storage whose values are defined and used *}
  {* by the font and glyphs programs                               *}



const

  TT_Round_Off            = 0;
  TT_Round_To_Half_Grid   = 1;
  TT_Round_To_Grid        = 2;
  TT_Round_To_Double_Grid = 3;
  TT_Round_Up_To_Grid     = 4;
  TT_Round_Down_To_Grid   = 5;
  TT_Round_Super          = 6;

  SUCCESS = True;
  FAILURE = False;

  CTTFlagTouchedX = $01;  {* X touched flag *}
  CTTFlagTouchedY = $02;  {* Y touched flag *}





implementation


end.
