Unit TTTables;

interface

uses FreeType, TTTypes, TTCalc;

{*****************************************************}
{*                                                   *}
{*              TrueType Tables Types                *}
{*                                                   *}
{*****************************************************}

type
  {* Graphics State                            *}
  {*                                           *}
  {* The Graphics State (GS) is managed by the *}
  {* instruction field, but does not come from *}
  {* the font file. Thus, we can use 'int's    *}
  {* where needed.                             *}
  {*                                           *}

  PGraphicsState = ^TGraphicsState;
  TGraphicsState = record
                     autoFlip                : boolean;
                     controlValueCutIn       : TT_F26dot6;
                     deltaBase               : int;
                     deltaShift              : int;

                     dualVector,
                     projVector,
                     freeVector              : TT_UnitVector;

                     gep0,
                     gep1,
                     gep2                    : int;

                     instructControl         : byte;
                     loop                    : longint;

                     minimumDistance         : TT_F26dot6;
                     roundState              : int;

                     rp0,
                     rp1,
                     rp2                     : int;

                     scanControl             : boolean;
                     singleWidthCutIn        : TT_F26dot6;
                     singleWidthValue        : TT_F26dot6;
                   end;



  {* TrueType Table Directory type *}

  TTableDir = Record
                version     : FixedPoint;   {* should be $10000 *}
                numTables   : word;         {* Tables number    *}

                searchRange,           {* These parameters are only used  *}
                entrySelector,         {* for a dichotomy search in the   *}
                rangeShift     : Word; {* directory. We ignore them       *}
               end;

  {* The 'TableDir' is followed by 'numTables' TableDirEntries *}

  TTableDirEntry = Record
                     Tag      : array[0..3] of Char; {*        table type *}
                     CheckSum : Long;                {*    table Checksum *}
                     Offset   : Long;                {* Table file offset *}
                     Length   : Long;                {*      Table length *}
                    end;

  TTableDirEntries = array[0..100] of TTableDirEntry;
  PTableDirEntries = ^TTableDirEntries;

  {* "cmap" Table *}

  TCMapDir = Record
               TableVersionNumber : UShort;  {* should be 0 *}
               cMapNum            : UShort;  {* number of entries *}
              end;

  {* The "cmap" is followed by cMapNum TCMapDirEntries *}

  TCMapDirEntry = Record
                    PlatformID,                   {* Windows = 3          *}
                    PlatformEncodingID : UShort;  {* Microsoft UGL = 1    *}
                    offset             : Long;    {*       offset         *}
                   end;

  {* Il existe 4 formats distincts : 0,2,4 et 6
     Nous ne nous intresserons ici qu'au format 4 *}

  TCMap4 = Record
             Format,                {* doit tre 4 *}
             Length,                {* taille en octets *}
             Version,               {* numro de version, dbute  0 *}
             segCountX2,            {* nombre de segments * 2 *}

             SearchRange,           {* paramtres utiliss pour une *}
             EntrySelector,         {* recherche optimise *}
             RangeShift     : UShort;
            end;

  TCMap4Segment = Record
                    endCount,
                    startCount,
                    idDelta,
                    idRangeOffset : UShort;
                   end;

  {* table "maxp" des 'Maximum Profiles' *}

  TMaxProfile = Record
                  Version                 : Fixed;
                  numGlyphs,
                  maxPoints,
                  maxContours,
                  maxCompositePoints,
                  maxCompositeContours,
                  maxZones,
                  maxTwilightPoints,
                  maxStorage,
                  maxFunctionDefs,
                  maxInstructionDefs,
                  maxStackElements,
                  maxSizeOfInstructions,
                  maxComponentElements,
                  maxComponentDepth       : UShort;
                end;


  {* table de tag "glyph" *}

  TPointRec = record
               x, y, flag : integer;
              end;

  TPoints = array[0..1023] of TPointRec;
  PPoints = ^TPoints;

  PGlyphContour = ^TGlyphContour;
  TGlyphContour = record
                   Start,
                   Finish : word;
                  end;

  PGlyphContours = ^TGlyphContours;
  TGlyphContours = array[0..1023] of TGlyphContour;

  PGlyph = ^TGlyph;
  TGlyph = Record
            numberOfContours,
            xMin,
            yMin,
            xMax,
            yMax,
            numberOfPoints : Short;

            Contours : PGlyphContours;
            Points   : PPoints;
           end;

  TGlyphs = array[0..1000] of TGlyph;
  PGlyphs = ^TGlyphs;

  {* table de type "head" *}

  TLongDateTime = record
                    L1,
                    L2 : long;
                  end;

  THeader = Record
             TableVersion : FixedPoint;
             FontRevision : FixedPoint;

             CheckSumAdjust : Long;
             MagicNumber    : Long;

             Flags      : UShort;
             UnitsPerEM : UShort;

             Created  : TLongDateTime;
             Modified : TLongDateTime;

             xMin : Short;
             yMin : Short;
             xMax : Short;
             yMax : Short;

             MacStyle      : UShort;
             LowestRecPPEM : UShort;

             FontDirection     : Short;
             IndexToLocFormat  : Short;
             GlyphDataFormat   : Short;
            end;


{* Les tableaux apparatront dans la mmoire selon l'ordre des
   dclarations suivantes                                      *}

type
  (* "loca" tableau des indices dans Glyph *)
  TLoca = Record
            Size  : word;
            Table : PStorage;
          end;

  TLocas = array[0..1000] of TLoca;


var
  Table_Dir          : TTableDir;
  Table_Dir_Entries  : PTableDirEntries;
  Num_TDE            : int;

  MaxProfile         : TMaxProfile;

  Font_Header        : ^THeader;
  Glyph_Locations    : ^TLoca;
  Glyphs             : ^TGlyphs;

  Num_Glyphs         : int;    (* Number of glyphs in current font file   *)

  GS        : TGraphicsState; (* Current Graphics State record  *)
                              (* NOTE : this is not a pointer ! *)

  CVT       : PShortArray;   (* Pointer to the current CVT *)
  CvtSize   : int;           (* Size of the current CVT    *)

  Scale1,               (* These values are used to scale quickly *)
  Scale2    : LongInt;  (* from EM to pixel coordinates           *)

  PointSize : TT_F26dot6;  (* The PointSize in 26.6 fixed point *)


function   Open_TrueType_File( AName : String ) : boolean;
procedure  Close_TrueType_File;

function Load_TrueType_Tables : boolean;
function LookUp_TrueType_Table( ATag : string ) : int;
function Load_TrueType_Header : boolean;
function Load_TrueType_CVT : boolean;
function Load_TrueType_Locations : Boolean;

function Load_TrueType_MaxProfile : boolean;
function Load_TrueType_Glyphs : integer;

implementation

uses TTMemory,
{$IFDEF OS2}
     TTFileM;
{$ELSE}
     TTFile;
{$ENDIF}

(*************************)
(*  Load_TrueType_Tables *)
(*************************)

function Load_TrueType_Tables : Boolean;
var
  T : LongInt;
  L : LongInt;
begin
  Load_TrueType_Tables := False;

  if not Read_At_Font_File( 0, Table_Dir, sizeof(Table_Dir) ) then exit;

  Do32( Fixed( Table_Dir.Version ) );
  Do16( Table_Dir.NumTables );

{$IFDEF DEBUG}
  Writeln('Version de rpertoire : ',TableDir.version/$10000);
  Writeln('Nombre de Tables      : ',TableDir.numTables);

{$ENDIF}

  Num_TDE := Table_Dir.NumTables;

  L := sizeof(TTableDirEntry) * Num_TDE;

  if not Alloc( L, Pointer(Table_Dir_Entries) ) or
     not Read_Font_File( Table_Dir_Entries^, L ) then exit;

  for t:=0 to Num_TDE-1 do with Table_Dir_Entries^[t] do
    begin
     CheckSum:=0;
     Do32( Offset );
     Do32( Length );
   end;

  Load_TrueType_Tables := True;
end;

(***************************)
(*  LookUp_TrueType_Table  *)
(***************************)

function LookUp_TrueType_Table( ATag : string ) : int;
var
  TAG : String[4];
  i   : int;
begin
  TAG[0] := #4;
  LookUp_TrueType_Table := -1;

  if Table_Dir_Entries = nil then exit;

  for i := 0 to Num_TDE-1 do
    begin

      move( Table_Dir_Entries^[i].Tag, Tag[1], 4 );

      if Tag = ATag then
        begin
          LookUp_TrueType_Table := i;
          exit;
        end

    end
end;

(**************************)
(*  Load_TrueType_Header  *)
(**************************)

function  Load_TrueType_Header : Boolean;
var
  i : int;
begin
  Load_TrueType_Header := False;

  i := LookUp_TrueType_Table('head');
  if i <= 0 then exit;

  if not Alloc( sizeof(THeader), Pointer(Font_Header) ) or

     not Read_At_FOnt_File( Table_Dir_Entries^[i].Offset,
                            Font_Header^, sizeof(THeader) )
      then exit;

  with Font_Header^ do
    begin

      Do16( word(IndexToLocFormat) );
      Do16( UnitsPerEM );
  {$IFDEF DEBUG}
      Writeln('Units per EM       : ',UnitsPerEM );
      Writeln('IndexToLocFormat   : ',IndexToLocFormat );
      Writeln('Glyphs number      : ',numGlyphs );
  {$ENDIF}
    end;

  Load_TrueType_Header := True;
end;

(***************************)
(* Load_TrueType_Locations *)
(***************************)

function Load_TrueType_Locations : Boolean;
var
  i           : int;
  sz          : longint;
  t           : int;
  LongOffsets : int;
  locs        : PStorage;
  locs2       : PShortArray;
  Mrk         : TMarkRecord;

begin

  Load_TrueType_Locations := False;
  LongOffsets             := 0;

  if Font_Header = nil then
    if not Load_TrueType_Header then exit;

  LongOffsets :=  Font_Header^.IndexToLocFormat;

  (* default offsets format is short *)

  T := LookUp_TrueType_Table('loca');
  if T < 0 then exit;

  if not Alloc( sizeof(TLoca), Pointer(Glyph_Locations) ) then exit;

  if LongOffsets <> 0 then
    begin
      sz := Table_Dir_Entries^[T].Length shr 2;
      Glyph_Locations^.Size := sz;

      {$IFDEF DEBUG}
      Writeln('Glyph Slots # ( 32-bits offsets ) : ', sz );
      {$ENDIF}

      if not Alloc( 4*Sz, Pointer( Locs ) ) then exit;

      Glyph_Locations^.Table := locs;

      if not Read_At_Font_File( Table_Dir_Entries^[T].Offset,
                                Locs^[0], Sz*4 ) then exit;

      Do32s( locs^[0], sz );
    end
  else
    begin
      sz := Table_Dir_Entries^[T].Length shr 1;
      Glyph_Locations^.Size := Sz;

      {$IFDEF DEBUG}
      Writeln('Glyph Slots # ( 16-bits offsets ) : ', Sz );
      {$ENDIF}

      if not Alloc( 4*Sz, Pointer(locs) ) then exit;
      Mark( Mrk );
      if not Alloc( 2*Sz, Pointer(locs2)  ) then exit;

      Glyph_Locations^.Table := locs;

      if not Read_At_Font_File( Table_Dir_Entries^[T].Offset,
                                locs2^[0], 2*sz ) then exit;

      Do16s( locs2^[0], sz );
      for i := 0 to sz-1 do Locs^[i] := 2*longint( locs2^[i] );

      if not Release( Mrk ) then exit;
    end;

  Load_TrueType_Locations := True;
end;



function Load_TrueType_CVT : boolean;
var
  m : int;
begin
  Load_TrueType_CVT := False;
  m := LookUp_TrueType_Table('cvt ');
  if m<0 then exit;

  with Table_Dir_Entries^[m] do
   begin
     GetMem( CVT, Length );
     CvtSize := Length div sizeof(Short);
     if not Read_At_Font_File( Offset, CVT^, Length ) then exit;
     Do16s( CVT^, CvtSize );
   end;

  Load_TrueType_CVT := True;
end;

(******************************)
(*  Load_TrueType_MaxProfile  *)
(******************************)

function Load_TrueType_MaxProfile : boolean;
var
  m : int;
begin

  Load_TrueType_MaxProfile := False;

  m:=LookUp_TrueType_Table('maxp');
  if m<0 then exit;

  if not Read_At_Font_File( Table_Dir_Entries^[m].Offset,
                            MaxProfile, sizeof(MaxProfile) ) then exit;

  with MaxProfile do
   begin
    Do32( Version );
    Do16( numGlyphs );
    Do16( maxPoints );
    Do16( maxContours );
    Do16( maxCompositePoints );
    Do16( maxCompositeContours );
    Do16( maxZones );
    Do16( maxTwilightPoints );
    Do16( maxStorage );
    Do16( maxFunctionDefs );
    Do16( maxInstructionDefs );
    Do16( maxStackElements );
    Do16( maxSizeOfInstructions );
    Do16( maxComponentElements );
    Do16( maxCOmponentDepth );
   end;

  Num_Glyphs               := MaxProfile.NumGlyphs;
  Load_TrueType_MaxProfile := True;
end;

(**************************)
(*  Load_TrueType_Glyphs  *)
(**************************)

function Load_TrueType_Glyphs : integer;
var
  sz, szc, szp : int;
  i, j, k, cnt : int;
  b, c         : byte;

  offset : longint;
  locs   : PStorage;

  GL  : TGlyph;
  Con : PGlyphContours;
  Pts : PPoints;

label
  Suite,
  Fin;

begin
  Load_TrueType_Glyphs:=0;

  i:=LookUp_TrueType_Table('glyf');
  if i<0 then exit;

  Offset:=Table_Dir_Entries^[i].Offset;

  if Glyph_Locations=NIL then
   if not Load_TrueType_Locations then exit;

  locs := Glyph_Locations^.Table;
  sz   := Glyph_Locations^.Size;

  if not Alloc( Sizeof( TGlyph)*Sz, Pointer(Glyphs) ) then exit;

  j:=0;

  for i:=0 to sz-1 do

   begin

    if not Read_At_Font_File( Offset+locs^[i],
                              GL, 5*sizeof(Integer) ) then goto Suite;
    (* INVALID OFFSET ??? *)

    Do16( Word( Gl.numberOfContours ) );
    Do16( Word( Gl.xMin ) ); Do16( Word( Gl.yMin ) );
    Do16( Word( Gl.xMax ) ); Do16( Word( Gl.yMax ) );

    {$IFDEF DEBUG}
    Writeln(' # of Contours : ',Gl.numberOfContours );
    Writeln(' xMin : ',Gl.xMin:4,'  xMax : ',Gl.xMax);
    Writeln(' yMin : ',Gl.yMin:4,'  yMax : ',Gl.yMax);
    Writeln('-');
    {$ENDIF}

    szc:=Gl.numberOfContours;
    if szc<0 then Goto Suite;
    if szc>MaxProfile.maxContours then
     begin
{$IFDEF DEBUG}
      Writeln('ERROR: Glyph ',i,' has ',szc,' contours > ',
               maxProfile.maxContours );
      readkey;
{$ENDIF}
      goto Suite;
     end;

    GetMem( Con, Sizeof(TGlyphContour)*szc );
    If Con=NIL then Goto Fin;

    Gl.Contours:=Con;
    Szp:=0;
    For k:=0 to szc-1 do
     begin

      {$IFDEF DEBUG}
      Write( szp,' ');
      {$ENDIF}

      Con^[k].Start:=Szp;
      Read_16( Short(Szp) );
      Con^[k].Finish:=Szp;
      inc(Szp);
     end;

    Gl.numberOfPoints:=szp;

    (* Sauter les instructions *)

    Read_16(Short(k));

    {$IFDEF DEBUG}
    Writeln('Instructions size : ',k);
    {$ENDIF}

    Skip_Font_File( k );

    GetMem( Pts, sizeof(TPointRec)*szp );
    if pts=NIL then
     begin
      FreeMem( Con, SizeOf(TGlyphContour)*Szc );
      Goto Fin;
     end;

    Gl.Points:=Pts;

  (* Lecture des flags *)

    k:=0;
    while (k<szp) do
     begin

      Read_8(c);
      Pts^[k].flag := c;
      inc(k);

      if c and 8 <> 0 then
       begin
        Read_8( b );
        cnt := b;

        while (cnt>0) do
         begin
          Pts^[k].flag := c;
          inc( k );
          dec( cnt );
         end;
       end;
     end;

  (* Lecture des X *)

    for k:=0 to szp-1 do
     with pts^[k] do
      if flag and 2 <> 0 then
       begin
        Read_8( c );
        if flag and 16 <> 0 then x:=integer(c) else x:=-integer(c);
       end
      else
       if flag and 16 <> 0 then x:=0 else Read_16(x);

  (* Lecture des Y *)

    for k:=0 to szp-1 do
     with pts^[k] do
      if flag and 4 <> 0 then
       begin
        Read_8( c );
        if flag and 32 <> 0 then y:=integer(c) else y:=-integer(c);
       end
      else
       if flag and 32 <> 0 then y:=0 else Read_16(y);

  (* Ajustement des coordonnes relatives  absolues *)

    for k:=1 to szp-1 do with Pts^[k] do
     begin
      inc( x, Pts^[k-1].x );
      inc( y, Pts^[k-1].y );
     end;

    Glyphs^[j]:=Gl;
    inc(j);

 Suite:
   end;

 Fin:
  Num_Glyphs           := j;
  Load_TrueType_Glyphs := j;
end;



function Open_TrueType_File( AName : String ) : boolean;
begin
  Open_TrueType_File := Open_Font_File( AName );
end;

procedure Close_TrueType_File;
begin
  Close_Font_File;
end;



begin

  Num_TDE           := 0;
  Table_Dir_Entries := nil;

  Font_Header     := nil;
  Glyph_Locations := nil;
  Glyphs          := nil;

  Num_Glyphs := 0;

end.
