(* A Simple File abstraction layer *)
(*                                 *)
(* Next implementations should     *)
(* support buffered IO or memory-  *)
(* mapped files                    *)

Unit TTFile;

interface

uses TTTypes, TTError;


function Open_Font_File( AName : String ) : boolean;

function Read_Font_File( var ABuff; ACount : Int ) : boolean;

function Read_8( var C : Byte ): boolean;

function Read_16( var S : Short ): boolean;

function Read_32( var L : Long ): boolean;

function Seek_Font_File( APos : LongInt ) : boolean;

function Skip_Font_File( ADist : LongInt ) : boolean;

function Read_At_Font_File( APos : Long; var ABuff; ACount : Int ) : boolean;

procedure Close_Font_File;

implementation

uses TTCalc;

var
  Font_File : FILE;


function Open_Font_File( AName : String ) : boolean;
begin
  Open_Font_File := False;

  Assign( Font_File, AName );
  {$I-}
  Reset( Font_File, 1 );
  {$I+}
  if IOResult <> 0 then
    begin
      Error := TT_ErrMsg_File_Error;
      exit;
    end;

  Open_Font_File := True;
end;


function Seek_Font_File( APos : LongInt ) : boolean;
begin
  {$I-}
  Seek( Font_File, APos );
  {$I+}
  if IOResult <> 0 then
    begin
      Error          := TT_ErrMsg_File_Error;
      Seek_FOnt_File := False;
      exit;
    end;

  Seek_Font_File := True;
end;

function Skip_Font_File( ADist : LongInt ) : boolean;
begin
  Skip_Font_File := Seek_Font_File( FilePos(Font_File)+ADist );
end;

function Read_Font_File( var ABuff; ACount : Int ) : boolean;
begin
  Read_Font_File := False;
  {$I-}
  BlockRead( Font_File, ABuff, ACount );
  {$I+}

  if IOResult <> 0 then
    begin
      Error := TT_ErrMsg_File_Error;
      exit;
    end;

  Read_Font_File := True;
end;

function Read_At_Font_File( APos : Long; var ABuff; ACount : Int ) : boolean;
begin
  Read_At_Font_File := False;

  if not Seek_Font_File( APos ) or
     not Read_Font_File( ABuff, ACount ) then exit;

  Read_At_Font_File := True;
end;

function Read_8( var C : byte ): boolean;
begin
  Read_8 := Read_Font_File( C, 1 );
end;

function Read_16( var S : Short ) : boolean;
begin
  Read_16 := Read_Font_File( S, 2 );
  Do16(S);
end;

procedure Close_Font_File;
begin
  Close( Font_File );
end;

function Read_32( var L : Long ) : boolean;
begin
  Read_32 := Read_Font_File( L, 4 );
  Do32(L);
end;


end.