{**********************************************************}
{*                                                        *}
{* The following routines are inline assembly, they are   *}
{* thus processor and bitness specific. Replace them      *}
{* with your own if you want to port the TrueType Engine  *}


{**********************************************************}
{* Four operations to convert from Motorola to Intel      *}


procedure Do16( var S ); assembler;
asm
  push ecx
  mov ecx,[S].dword
  mov ax,[ecx]
  xchg al,ah
  mov [ecx],ax
  pop ecx
end;

procedure Do16s( var S; Cnt : Int ); assembler; {$USES ebx, ecx }
asm
  mov ebx,[S].dword
  mov ecx,[Cnt]
 @1:
  mov ax,[ebx]
  xchg al,ah
  mov [ebx],ax
  add ebx,2
  dec cx
  jnz @1
end;

procedure Do32( var L ); assembler; {$USES ebx}
asm
  mov ebx,[L]
  mov dx,[ebx].word
  mov ax,[ebx+2].word
  xchg al,ah
  xchg dl,dh
  mov [ebx+2].word,dx
  mov [ebx].word,ax
end;

procedure Do32s( var L; Cnt : int ); assembler; {$USES ebx, ecx}
asm
  mov ebx,[L].dword
  mov ecx,[Cnt]
 @1:
  mov dx,[ebx].word
  mov ax,[ebx+2].word
  xchg al,ah
  xchg dl,dh
  mov [ebx+2].word,dx
  mov [ebx].word,ax
  add ebx,4
  dec cx
  jnz @1
end;



{**********************************************************}
{* Calc A*B/C with Intermediate 64 bit precision          *}

function MulDiv( A, B, C : Int32 ): Int32; assembler; {$USES ebx, ecx}
asm
  mov eax,[A]
  mov ecx,[B]
  mov ebx,[C]
  imul ecx
  idiv ebx
end;



{**********************************************************}
{* 64 Bit Addition                                        *}

procedure Add64( var X, Y, Z : Int64 ); assembler; {$USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  add eax,[ebx]
  adc edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* 64 Bit Substraction                                    *}

procedure Sub64( var X, Y, Z : Int64 ); assembler; {$USES eax, ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  sub eax,[ebx]
  sbb edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* Multiply two Int32 to an Int64                         *}

procedure MulTo64( X, Y : Int32; var Z : Int64 ); assembler; {$USES ebx, eax, edx }
asm
  mov ebx,[Z].dword
  mov eax,[X]
  imul [Y]
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* Divide an Int64 by an Int32                            *}

function Div64by32( var X : Int64; Y : Int32 ) : Int32; assembler; {$USES eax, eax, edx }
         {$USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]
  idiv [Y]
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order64( var Z : Int64 ) : int; assembler; {$USES ebx, eax, ecx, edx}
asm
  mov ebx, [Z].dword
  mov eax, [ ebx ]
  mov edx, [ebx+4]
  mov ebx, 63
  mov ecx, $80000000

 @1:
  test edx, ecx
  jnz @3
  dec ebx
  ror ecx,1
  jns @1

 @2:
  test eax, ecx
  jnz @2
  dec ebx
  ror ecx,1
  jns @2

 @3:
  mov eax,ebx
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order32( Z : Int32 ) : int; assembler; {$USES eax, ebx, ecx, edx}
asm
  mov eax,[Z]
  mov ebx,31
  mov ecx,$80000000

 @1:
  test edx,ecx
  jnz @2
  dec ebx
  ror ecx,1
  jns @1

 @2:
  mov eax,ebx
end;

