{**********************************************************}
{*                                                        *}
{* The following routines are inline assembly, they are   *}
{* thus processor and bitness specific. Replace them      *}
{* with your own if you want to port the TrueType Engine  *}


{**********************************************************}
{* Four operations to convert from Motorola to Intel      *}


procedure Do16( var S ); assembler;
asm
  les  si, [S].dword
  mov  ax, es:[si]
  xchg al, ah
  mov  es:[si], ax
end;

procedure Do16s( var S; Cnt : Int ); assembler;
asm
  les  si, [S].dword
  mov  cx, [Cnt]     (* 'int' is 16 bit in Turbo-Pascal *)
 @1:
  mov  ax, es:[si]
  xchg al, ah
  mov  es:[si], ax
  add  si, 2
  dec  cx
  jnz  @1
end;

procedure Do32( var L ); assembler;
asm
  les  si, [L]
  mov  dx, es:[si].word
  mov  ax, es:[si+2].word
  xchg al, ah
  xchg dl, dh
  mov  es:[si+2].word, dx
  mov  es:[si].word, ax
end;

procedure Do32s( var L; Cnt : int ); assembler;
asm
  les  si,[L].dword
  mov  cx,[Cnt]    (* 'int' is 'longint' in Virtual Pascal *)
 @1:
  mov  dx, es:[si].word
  mov  ax, es:[si+2].word
  xchg al, ah
  xchg dl, dh
  mov  es:[si+2].word, dx
  mov  es:[si].word, ax
  add  si,4
  dec  cx
  jnz  @1
end;



{**********************************************************}
{* Calc A*B/C with Intermediate 64 bit precision          *}

function MulDiv( A, B, C : Int32 ): Int32; assembler;
var
  R : Int32;
asm
  db $66; mov ax,[A].word
  db $66; imul [B].word
  db $66; idiv [C].word
  db $66; mov [R].word,ax
  mov dx,[R+2].word
end;



{**********************************************************}
{* 64 Bit Addition                                        *}

procedure Add64( var X, Y, Z : Int64 ); assembler;
asm
  les si,[X]

  mov ax,es:[ si ].word
  mov dx,es:[si+2].word
  mov bx,es:[si+4].word
  mov cx,es:[si+6].word

  les si,[Y]
  add ax,es:[ si ].word
  adc dx,es:[si+2].word
  add bx,es:[si+4].word
  adc cx,es:[si+6].word

  les si,[Z]
  mov es:[ si ].word,ax
  mov es:[si+2].word,dx
  mov es:[si+4].word,bx
  mov es:[si+6].word,cx
end;


{**********************************************************}
{* 64 Bit Substraction                                    *}

procedure Sub64( var X, Y, Z : Int64 ); assembler;
asm
  les si,[X]

  mov ax,es:[ si ].word
  mov dx,es:[si+2].word
  mov bx,es:[si+4].word
  mov cx,es:[si+6].word

  les si,[Y]
  sub ax,es:[ si ].word
  sbb dx,es:[si+2].word
  sub bx,es:[si+4].word
  sbb cx,es:[si+6].word

  les si,[Z]
  mov es:[ si ].word,ax
  mov es:[si+2].word,dx
  mov es:[si+4].word,bx
  mov es:[si+6].word,cx
end;


{**********************************************************}
{* Multiply two Int32 to an Int64                         *}

procedure MulTo64( X, Y : Int32; var Z : Int64 ); assembler;
asm
  les si,[Z]
  db $66; mov ax,[X].word
  db $66; imul [Y].word
  db $66; mov es:[si],ax
  db $66; mov es:[si+4],dx
end;


{**********************************************************}
{* Divide an Int64 by an Int32                            *}

function Div64by32( var X : Int64; Y : Int32 ) : Int32; assembler;
asm
  les si,[X]

  db $66; mov ax,es:[si]
  db $66; mov dx,es:[si+2]
  db $66; idiv [Y].word
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order64( var Z : Int64 ) : int; assembler;
asm
  les si,[Z]
  db $66; mov ax,es:[si]
  db $66; mov dx,es:[si+4]
  mov bx,63
  db $66; mov cx,0; dw $8000

 @1:
  db $66; test dx,cx
  jnz @3
  dec bx
  db $66; ror cx,1
  jns @1

 @2:
  db $66; test ax,cx
  jnz @2
  dec bx
  db $66; ror cx,1
  jns @2

 @3:
  mov ax,bx
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order32( Z : Int32 ) : int; assembler;
asm
  les si,[Z]
  db $66; mov ax,es:[si]
  mov bx,31
  db $66; mov cx,0; dw $8000

 @1:
  db $66; test ax,cx
  jnz @2
  dec bx
  db $66; ror cx,1
  jns @1

 @2:
  mov ax,bx
end;



{* End of processor specific routines                     *}
{*                                                        *}
{**********************************************************}
