{**********************************************************}
{*                                                        *}
{* The following routines are inline assembly, they are   *}
{* thus processor and bitness specific. Replace them      *}
{* with your own if you want to port the TrueType Engine  *}

{ $DEFINE INLINE_ASSEMBLY}

{**********************************************************}
{* Four operations to convert from Motorola to Intel      *}


procedure Do16( var S );
var
  L : Int16 absolute S;
begin
  L :=    ( ( L shr 8 ) and $00FF )
       or ( ( L shl 8 ) and $FF00 );
end;


procedure Do16s( var S; Cnt : Int );
var
  L : array[0..0] of Int16 absolute S;
  i : Int;
begin
  for i := 0 to Cnt-1 do

    L[i] :=    (( L[i] shr 8 ) and $00FF )
            or (( L[i] shl 8 ) and $FF00 );
end;


procedure Do32( var L );
var
  S : Int32 absolute L;
begin
  S :=    ( ( S shr 24 ) and $000000FF )
       or ( ( S shl 24 ) and $FF000000 )
       or ( ( S shr 8  ) and $0000FF00 )
       or ( ( S shl 8  ) and $00FF0000 );
end;


procedure Do32s( var L; Cnt : int );
var
  S : array[0..0] of Int32 absolute L;
  i : Int;
  a : Int32;
begin
  for i := 0 to Cnt do
  begin
    a := S[i];
    S[i] :=    ( (a shr 24) and $000000F0 )
            or ( (a shl 24) and $FF000000 )
            or ( (a shr 8 ) and $0000FF00 )
            or ( (a shl 8 ) and $00FF0000 );
  end
end;


{**********************************************************}
{* Calc A*B/C with Intermediate 64 bit precision          *}

function MulDiv( A, B, C : Int32 ) : Int32;
const
  Bit31 = 1 shl 31;
label
  OverFlow;
var
  r, q, aq, ar, s1, s2 : Int32;
  i                    : Int;
begin
  s1 := a and Bit31; if s1 <> 0 then a := -a;
  s2 := b and Bit31; if s2 <> 0 then b := -b;

  s1 := s1 xor s2;

  s2 := c and Bit31; if s2 <> 0 then c := -c;

  s1 := s1 xor s2;

  if s1 <> 0 then
    s2 := $80000001
  else
    s2 := $7FFFFFFF;

  if c = 0 then goto OverFlow;

  { A Useful shortcut : most of the calculations fall here }

  if (a or b) shr 16 = 0 then
  begin
    q := a*b div c;
    if s1 <> 0 then q := -q;
    MulDiv := q;
    exit;
  end;

  aq := a div c;
  ar := a mod c;

  r := 0;
  q := 0;

  for i := 1 to 32 do
  begin
    r := r shl 1;
    q := q shl 1;

    { if q < 0 then goto OverFlow; }

    if b < 0 then
    begin
      inc( r, ar );
      inc( q, aq );

      { if q < 0 then goto OverFlow; }
    end;

    b := b shl 1;

    while (r-c) >= 0 do
    begin
      dec( r, c );
      inc( q );
     {  if q < 0 then goto OverFlow; }
    end;

  end;

  if s1 <> 0 then q := -q;
  MulDiv := q;
  exit;

OverFlow:
  MulDiv := s2;

end;


{**********************************************************}
{* 64 Bit Addition                                        *}

procedure Add64( var X, Y, Z : Int64 ); assembler; {$USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  add eax,[ebx]
  adc edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* 64 Bit Substraction                                    *}

procedure Sub64( var X, Y, Z : Int64 ); assembler; {$USES eax, ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  sub eax,[ebx]
  sbb edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* Multiply two Int32 to an Int64                         *}

procedure MulTo64( X, Y : Int32; var Z : Int64 ); assembler; {$USES ebx, eax, edx }
asm
  mov ebx,[Z].dword
  mov eax,[X]
  imul [Y]
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* Divide an Int64 by an Int32                            *}

function Div64by32( var X : Int64; Y : Int32 ) : Int32; assembler; {$USES eax, eax, edx }
         {$USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]
  idiv [Y]
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order64( var Z : Int64 ) : int; assembler; {$USES ebx, eax, ecx, edx}
asm
  mov ebx,[Z].dword
  mov eax,[ebx  ]
  mov edx,[ebx+4]
  mov ebx,63
  mov ecx,$80000000

 @1:
  test edx,ecx
  jnz @3
  dec ebx
  ror ecx,1
  jns @1

 @2:
  test eax,ecx
  jnz @2
  dec ebx
  ror ecx,1
  jns @2

 @3:
  mov eax,ebx
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order32( Z : Int32 ) : int; assembler; {$USES eax, ebx, ecx, edx}
asm
  mov eax,[Z]
  mov ebx,31
  mov ecx,$80000000

 @1:
  test edx,ecx
  jnz @2
  dec ebx
  ror ecx,1
  jns @1

 @2:
  mov eax,ebx
end;

