{****************************************************************************}
{*                                                                          *}
{*  TTTypes                                                                 *}
{*                                                                          *}
{*  This unit holds the declarations of the types used by the FreeType      *}
{*  engine.                                                                 *}
{*                                                                          *}
{*  NOTE : Many of the types declared here are only used internaly by the   *}
{*         engine, and won't be part of the high-level interface.           *}
{*                                                                          *}
{*         ( this being especially true for integer types )                 *}
{*                                                                          *}
{****************************************************************************}

unit FreeType;

interface

type

  TT_Fixed  = LongInt;  {* Signed Fixed 16.16 Float *}

  TT_FWord  = Integer;  {* Distance in FUnits *}

  TT_UFWord = Word;     {* Unsigned Distance *}

  TT_F2Dot14 = Integer; {* signed fixed float 2.14 used for *}
                        {* unary vectors, with layout :     *}
                        {*                                  *}
                        {*  s : 1  -- sign bit              *}
                        {*  m : 1  -- mantissa bit          *}
                        {*  f : 14 -- unsigned fractional   *}
                        {*                                  *}
                        {*  's:m' is the 2-bit signed int   *}
                        {*  value to which the positive     *}
                        {*  fractional part should be       *}
                        {*  added.                          *}
                        {*                                  *}

  TT_UnitVector = record
                    x : TT_F2Dot14;
                    y : TT_F2Dot14;
                  end;

  TT_F26Dot6 = LongInt; {* 26.6 fixed float, used for pts pixel coordinates *}

  TT_Vector = record
                x : TT_F26Dot6;
                y : TT_F26Dot6;
              end;

  TT_VecTable  = array[0..9] of TT_Vector;
  TT_PVecTable = ^TT_VecTable;

  TT_TouchTable   = array[0..9] of byte;
  TT_PTouchTable = ^TT_TouchTable;

  TT_VecRecord = record
                   n     : integer;        {* Number of points in zone    *}
                   org   : TT_PVecTable;   {* Original points coordinates *}
                   cur   : TT_PVecTable;   {* Current points coordinates  *}
                   touch : TT_PTouchTable; {* Current touch table         *}
                 end;
  {* This type defining a set of glyph points will be used to represent *}
  {* each zone ( regular and twilight ) during instructions execution   *}

  TT_Contour = record
                first : integer; {* Indexes of first and last contour *}
                last  : integer; {* points in regular zone.           *}
               end;

  TT_ContourTable  = array[0..9] of TT_Contour;
  TT_PContourTable = ^TT_ContourTable;

  TT_ContourRecord = record
                       n  : integer;          {* Contours number *}
                       c  : TT_PContourTable; {* Contours table  *}
                     end;

implementation

end.

