#include "tttypes.h"
#include "ttcalc.h"
#include "tttables.h"
#include "ttmemory.h"
#include "raster.h"
#include "ttdisp.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>    /* libc ANSI */

#ifndef __linux__
#include <conio.h>
#else
#include <ncurses.h>
#define NCURSES
#endif

#define Pi  3.1415926535

#define  Precis   64
#define  Precis2  32

#define  PrecisAux  1024

#define  Centre_X   320
#define  Centre_Y   225

#define  Profile_Buff_Size  64000      /* Size of the render pool   */
                                       /* Minimum is around 4 Kb    */
                                       /* experiment to see how its */
                                       /* size impacts on raster    */
                                       /* performance..             */

  PStorage    Font_Buffer;

  PGlyphContours  curGlyphContours;

  int   num_pts;
  int   num_ctr;

  int   glyfArray;

  PShort  epts_ctr;

  PStorage   x_coord;
  PStorage   y_coord;
  PByte      Flag;

  Long   ymin, ymax, xmax, xmin, xsize;
  Int    res, resB;

  float  resR, resX, resY;

  Int  numPoints, numContours;

  PGlyph         curGlyph;

  TRasterBlock  Bit;

  Int           Rotation;
  Int           Fail;


  void  Init_Engine()
  {
    PByte  p;

    Bit.rows  = 450;
    Bit.cols  = 80;
    Bit.width = 640;
    Bit.flow  = TT_Flow_Down;
    Bit.size  = 80*450;

    Bit.bitmap = (void*)malloc( Bit.size );
    if ( !Bit.bitmap )
    {
      fprintf(stderr,"ERROR : Not enough memory to allocate bitmap !!\n" );
      exit(1);
    }

    /* XXX Note that the render pool should be allocated within the   */
    /*     Font Pool. For various reasons, and because we're still in */
    /*     pre-alpha :) We still malloc it..                          */

    p = (PByte)malloc( Profile_Buff_Size );
    if ( !p )
    {
      fprintf(stderr,"ERROR : Not enough memory to allocate render pool !\n" );
      exit(1);
    }

    InitRasterizer( &Bit, (long*)p, Profile_Buff_Size );

    memset( Bit.bitmap, 0, Bit.size );
  }



  void ClearData()
  {
    memset( Bit.bitmap, 0, Bit.size );

    free( x_coord );
    free( y_coord );
    free( Flag );
  };



  Bool  LoadTrueTypeChar( Int idx )
  {
    Long    off;
    float   x, y;
    UShort  j;
    TGlyph  Gl;
    UShort  EM;
    float   Cr, Sr;

    if ( idx < 0 || idx > num_glyphs ) return FAILURE;

    curGlyph = glyphs + idx;

    memcpy( &Gl, curGlyph, sizeof(Gl) );

    numPoints        = Gl.numberOfPoints;
    numContours      = Gl.numberOfContours;
    curGlyphContours = Gl.contours;

    x_coord = (PStorage)malloc( sizeof(TT_Fixed)*numPoints );
    y_coord = (PStorage)malloc( sizeof(TT_Fixed)*numPoints );
    Flag   = (PByte)malloc( numPoints );

    xmin = Gl.xMin;
    xmax = Gl.xMax;
    ymin = Gl.yMin;
    ymax = Gl.yMax;

    EM = font_header->units_per_EM;

    xmax -= xmin;
    ymax -= ymin;

    res--;
    resR = (float)res/EM/2;

    xmax = xmax*resR + 0.5;
    ymax = ymax*resR + 0.5;

    Cr = cos( Rotation*Pi/512 );
    Sr = sin( Rotation*Pi/512 );

    for ( j = 0; j < numPoints; j++ )
    {
      x = Gl.points[j].x * (float)res/EM;
      y = Gl.points[j].y * (float)res/EM;

      off = Precis*( Cr*(x-xmax) + Sr*(y-ymax) );
      x_coord[j] = Precis*Centre_X + off;

      off = Precis*( -Sr*(x-xmax) + Cr*(y-ymax) );
      y_coord[j] = Precis*Centre_Y + off;

      Flag[j] = Gl.points[j].flag & 1;
    }

    xsize = ( xmax+7 )/8;
    res++;

    return SUCCESS;
  }




  Bool  ConvertRaster()
  {
    Int  B[128];
    Int  i;

    TGlyphRecord  G;

    for ( i = 0; i < numContours; i++ )
      B[i] = curGlyphContours[i].finish;

    G.outlines  = numContours;
    G.outStarts = B;
    G.points    = numPoints;
    G.xCoord    = x_coord;
    G.yCoord    = y_coord;
    G.flag      = Flag;

    return Render_Glyph( &G, res, res );
  }



  void main( int argc, char** argv )
  {
    int i;
    char c, filename[128+4];

#ifdef NCURSES
    initscr(); cbreak();
#endif

    Font_Buffer = (PStorage)malloc( 128000 );
    if ( !Font_Buffer )
    {
      fprintf( stderr, "Error : Could not even allocate font pool !!\n" );
      exit(1);
    }

    Init_FontPool( Font_Buffer, 128000 );

    curGlyphContours = NULL;

    num_pts = 0;
    num_ctr = 0;

    x_coord = NULL;
    y_coord = NULL;
    Flag   = NULL;

    if ( argc != 2 )
    {
      fprintf( stderr, "Zoom : simple TrueType glyph viewer - part of the FreeType project\n" );
      fprintf( stderr, "------------------------------------------------------------------\n\n");
      fprintf( stderr, "Usage : %s fontname[.ttf]\n\n", argv[0] );
      exit(1);
    }

    i = strlen( argv[1] );
    while ( i > 0 && argv[1][i] != '\\' )
    {
      if ( argv[1][i] == '.' )
      {
        i = 0;
      }
      i--;
    }

    filename[128] = 0;
    strncpy( filename, argv[1], 128 );
    if ( i >= 0 )
      strncpy( filename + strlen(filename), ".ttf", 4 );

    if ( !Open_TrueType_File( filename ) )
    {
      fprintf( stderr, "Error, could not find/open %s\n\n", filename );
      exit(1);
    }

    res  = 450;
    resB = (res+7) / 8;

    Rotation = 0;

    Load_TrueType_Tables();

    Load_TrueType_MaxProfile();

    if ( !Load_TrueType_Glyphs() )
    {
      fprintf( stderr, "Error while loading glyphs\n\n" );
      exit(1);
    }

    Init_Engine();

    fprintf( stderr, "num glyphs = %d\n", num_glyphs );

    SetGraphScreen();

    i = 0;

    Fail = 0;

    for ( ;; )
    {
      if ( LoadTrueTypeChar(i) )
      {
       if (ConvertRaster())
         Display_Bitmap_On_Screen( (char*)Bit.bitmap, 450, 80 );
       else Fail++;
      }
      else
        Fail++;

      c = getch();

      switch (c)
      {
        case  (char)27: goto Fin;

        case  'x' : Rotation = ( Rotation-1 ) & 1023;
                    break;

        case  'c' : Rotation = ( Rotation+1 ) & 1023;
                    break;

        case  'v' : Rotation = ( Rotation-16 ) & 1023;
                    break;

        case  'b' : Rotation = ( Rotation+16 ) & 1023;
                    break;

        case  '+' : if ( res < 1040 ) res += 10; else res = 1050;
                    break;

        case  '-' : if ( res > 11 ) res -= 10; else res = 1;
                    break;

        case  'i' : if ( i > 10 ) i-= 10; else i = 0;
                    break;

        case  'o' : if ( i < num_glyphs-11 ) i += 10; else i = num_glyphs-1;
                    break;

        case  'k' : if (i>0) i--;
                    break;

        case  'l' : if (i<num_glyphs-1) i++;
                    break;

        case  'u' : if ( res > 0 ) res--;
                    break;

        case  'j' : if ( res < 450 ) res++;
                    break;
      }

      ClearData();
    }

  Fin:
    RestoreScreen();
    Close_TrueType_File();

#ifdef NCURSES
    endwin();
#endif

  }

