#ifndef TTTABLES_H
#define TTTABLES_H

#include "tttypes.h"

  typedef TPoint          TTZone[64];
  typedef TPoint         *PTZone;

  struct _TCVTRecord
  {
    int       n;  /* size of 32 bits elements */
    PStorage  a;  /* table base address       */
  };
  typedef struct _TCVTRecord TCVTRecord;

  /*****************************************************)
  (*                                                   *)
  (*              TrueType Tables Types                *)
  (*                                                   *)
  (*****************************************************/

  /* Graphics State                            *)
  (*                                           *)
  (* The Graphics State (GS) is managed by the *)
  (* instruction field, but does not come from *)
  (* the font file. Thus, we can use 'int's    *)
  (* where needed.                             *)
  (*                                           */

  struct _TGraphicsState
  {
    Bool              auto_flip;
    TT_F26Dot6        control_value_cutin;
    Int               delta_base;
    Int               delta_shift;

    TT_UnitVector     dualVector,
                      projVector,
                      freeVector;

    Int               gep0,
                      gep1,
                      gep2;

    char              instruct_control;
    long              loop;

    TT_F26Dot6        minimum_distance;
    Int               round_state;

    Int               rp0,
                      rp1,
                      rp2;

    Bool              scan_control;
    TT_F26Dot6        single_width_cutin;
    TT_F26Dot6        single_width_value;
  };
  typedef struct _TGraphicsState TGraphicsState;

  /* TrueType Table Directory type */

  struct _TTableDir
  {
    TT_Fixed   version;          /* should be 0x10000 */
    UShort     numTables;        /* number of tables  */

    UShort     searchRange;     /* These parameters are only used */
    UShort     entrySelector;   /* for a binary search in the     */
    UShort     rangeShift;      /* directory. We ignore them      */
  };
  typedef struct _TTableDir TTableDir;

  /* The 'TableDir' is followed by 'numTables' TableDirEntries */

  struct _TTableDirEntry
  {
    char     tag[4];   /* table type        */
    Long     checksum; /* table checksum    */
    Long     offset;   /* table file offset */
    Long     length;   /* table length      */
  };
  typedef struct _TTableDirEntry TTableDirEntry;
  typedef TTableDirEntry         TTableDirEntries[32];
  typedef TTableDirEntry        *PTableDirEntries;

  /* 'cmap' table */

  struct _TCMapDir
  {
    UShort  tableVersionNumber; /* Should be 0       */
    UShort  cMapNum;            /* number of entries */
  };
  typedef struct _TCMapDir TCMapDir;

  /* The 'cmap' is followed by cMapNum TCMapDirEntries */
  struct _TCMapDirEntry
  {
    UShort   platformID;          /* Windows = 3        */
    UShort   platformEncondingID; /* Microsoft UGL = 1  */
    Long     offset;              /*    offset          */
  };
  typedef struct _TCMapDirEntry TCMapDirEntry;
  
  /* There exist several formats, we'll only look at format 4 */

  struct _TCMap4
  {
    UShort  format,         /* Shoudl be 4                 */
            length,         /* size in bytes               */
            version,        /* version number. starts at 0 */
            segCountX2,     /* segments number * 2         */

            searchRange,    /* these parameters are used   */
            entrySelector,  /* for az binary search        */
            rangeShift;
  };
  typedef struct _TCMap4 TCMap4;

  struct _TCMap4Segment
  {
    UShort   endCount;
    UShort   startCount;
    UShort   idDelta;
    UShort   idRangeOffset;
  };
  typedef struct _TCMap4Segment TCMap4Segment;

  /* 'maxp' Maximum Profiles table */

  struct _TMaxProfile
  {
    TT_Fixed  version;
    UShort    numGlyphs,
              maxPoints,
              maxContours,
              maxCompositePoints,
              maxCompositeContours,
              maxZones,
              maxTwilightPoints,
              maxStorage,
              maxFunctionDefs,
              maxInstructionDefs,
              maxStackElements,
              maxSizeOfInstructions,
              maxComponentElements,
              maxComponentDepth;
  };
  typedef struct _TMaxProfile TMaxProfile;

#define TMaxProfile_Size  32

  /* 'head' table type */

  struct _TLongDateTime
  {
    Long l1, l2;
  };
  typedef struct _TLongDateTime TLongDateTime;

  struct _THeader
  {
    TT_Fixed       table_version;
    TT_Fixed       font_revision;

    Long           cheksum_adjust;
    Long           magic_number;

    UShort         flags;
    UShort         units_per_EM;

    TLongDateTime  created;
    TLongDateTime  modified;

    Short          xMin;
    Short          yMin;
    Short          xMax;
    Short          yMax;

    UShort         mac_style;
    UShort         lowest_rec_PPEM;

    Short          font_direction;
    Short          index_to_loc_format;
    Short          glyph_data_format;
  };
  typedef struct _THeader THeader;

#define THeader_Size  54

/* Because some compilers may pad a structure with 0 bytes for  */
/* alignement purposes, and because we don't want to poise the  */
/* source code with compiler-specific pragmas, we define a      */
/* 'correct' size for each structure defined by the TrueType    */
/* specs. Don't laugh, this was a real problem with gcc..       */

/* The code using 'THeader_Size' is located in 'Load_TrueType_Header' */
/* within "ttcalc.c"                                                  */

  struct _TLoca
  {
    int        size;
    PStorage   table;
  };
  typedef struct _TLoca  TLoca;

  struct _TGlyphContour
  {
    UShort start;
    UShort finish;
  };
  typedef struct _TGlyphContour  TGlyphContour;
  typedef TGlyphContour         *PGlyphContour;

  typedef TGlyphContour          TGlyphContours[1024];
  typedef TGlyphContour         *PGlyphContours;

  struct _TGlyph
  {
    Short    numberOfContours;
    Short    xMin;
    Short    yMin;
    Short    xMax;
    Short    yMax;
    Short    numberOfPoints;

    PGlyphContours  contours;
    PPoints         points;
  };
  typedef struct _TGlyph  TGlyph;
  typedef TGlyph         *PGlyph;

  typedef TGlyph          TGlyphs[1000];
  typedef TGlyph         *PGlyphs;

  extern TTableDir           table_dir;
  extern PTableDirEntries    table_dir_entries;

  extern Int                 num_TDE;

  extern TMaxProfile         maxProfile;

  extern THeader            *font_header;

  extern TLoca              *glyph_locations;
  extern TGlyph             *glyphs;

  extern Int                 num_glyphs;

  extern  TGraphicsState  Gs;
  extern  PShort          Cvt;
  extern  Int             CvtSize;

  extern  Long  Scale1;
  extern  Long  Scale2;

  extern  TT_F26Dot6  PointSize;

  Bool Open_TrueType_File( char* name );
  void Close_TrueType_File();

  Bool Load_TrueType_Tables();
  Int  LookUp_TrueType_Table( char* tag );
  Bool Load_TrueType_Header();
  Bool Load_TrueType_MaxProfile();
  Bool Load_TrueType_CVT();
  Bool Load_TrueType_Locations();
  Bool Load_TrueType_MaxProfil();
  Int  Load_TrueType_Glyphs();

#endif
