#include "tttables.h"
#include "ttfile.h"
#include "ttcalc.h"
#include "ttmemory.h"
#include "malloc.h"
#include "string.h"

  TGraphicsState  Gs;
  PShort          Cvt;
  Int             CvtSize;

  Long  Scale1;
  Long  Scale2;

  TT_F26Dot6  PointSize;

  TTableDir           table_dir;
  PTableDirEntries    table_dir_entries = (PTableDirEntries)0;
 
  Int                 num_TDE = 0;
 
  TMaxProfile         maxProfile;
 
  THeader            *font_header = (THeader*)0;
 
  TLoca              *glyph_locations = (TLoca*)0;
  TGlyph             *glyphs = (TGlyph*)0;
 
  Int                 num_glyphs = 0;

  /*************************)
  (*  Load_TrueType_Tables *)
  (*************************/

  Bool Load_TrueType_Tables()
  {
    Int t, l;

    if ( !Read_At_Font_File( 0, &table_dir, sizeof(table_dir) ) )
      return FAILURE;

    Do32( (unsigned long* )&table_dir.version   );
    Do16( (unsigned short*)&table_dir.numTables );

#ifdef DEBUG
    fprintf( stderr, "Table directory version : %ld\n", table_dir.version );
    fprintf( stderr, "Number of tables        : %d\n", table_dir.numTables );
#endif

    num_TDE = table_dir.numTables;

    l = sizeof(TTableDirEntry)*num_TDE;

    if ( !Alloc( l, (void**)&table_dir_entries ) ) return FAILURE;
    if ( !Read_Font_File( table_dir_entries, l ) ) return FAILURE;

    for ( t = 0; t < num_TDE; t++ )
    {
      table_dir_entries[t].checksum = 0;
      Do32( (unsigned long*)&table_dir_entries[t].offset );
      Do32( (unsigned long*)&table_dir_entries[t].length );

#ifdef DEBUG
      fprintf( stderr, "%s : %lx : %ld\n", table_dir_entries[t].tag,
               table_dir_entries[t].offset, table_dir_entries[t].length );
#endif
    }

    return SUCCESS;
  }

  /***************************)
  (*  LookUp_TrueType_Table  *)
  (***************************/

  Int LookUp_TrueType_Table( char* tag )
  {
    Int i;

    if ( table_dir_entries )
      for ( i = 0; i < num_TDE; i++ )
        if ( !strncmp( tag, table_dir_entries[i].tag, 4 ) )
          return i;

    return -1;
  }

  /**************************)
  (*  Load_TrueType_Header  *)
  (**************************/

  Bool Load_TrueType_Header()
  {
    Int i;

    i = LookUp_TrueType_Table("head");
    if ( i < 0 ) return FAILURE;

    if ( Alloc( sizeof(THeader), (void**)&font_header ) )
    {
      if ( Read_At_Font_File( table_dir_entries[i].offset,
                              font_header,
                              THeader_Size ) )
    {
      Do16( (unsigned short*)&font_header->index_to_loc_format );
      Do16( (unsigned short*)&font_header->units_per_EM );
      return SUCCESS;
    }
    }

    return FAILURE;
  }

  /***************************)
  (* Load_TrueType_Locations *)
  (***************************/

  Bool Load_TrueType_Locations()
  {
    Int       i, t, longOffsets;
    Long      sz;
    PStorage  locs;
    Short*    locs2;

    TMarkRecord  mrk;

    longOffsets = 0;

    if ( !font_header )
      if ( !Load_TrueType_Header() ) return FAILURE;

    longOffsets = font_header->index_to_loc_format;

    /* default offsets format is Short */

    t = LookUp_TrueType_Table("loca");
    if ( t < 0 ) return FAILURE;

    if ( !Alloc( sizeof(TLoca), (void**)&glyph_locations ) ) return FAILURE;

    if ( longOffsets )   /* 32 bits offsets */
    {
#ifdef DEBUG
      fprintf( stderr, "offsets longs..\n" );
#endif
      sz = table_dir_entries[t].length / 4;
      glyph_locations->size = sz;

      if ( !Alloc( 4*sz, (void**)&locs ) ) return FAILURE;

      glyph_locations->table = locs;

      if ( !Read_At_Font_File( table_dir_entries[t].offset,
           (void*)locs, sz*4 ) ) return FAILURE;

      Do32s( (unsigned long*)locs, sz );
    }
    else   /* 16 bits offsets */
    {
#ifdef DEBUG
      fprintf( stderr, "offsets courts..\n" );
#endif
      sz = table_dir_entries[t].length / 2;
      glyph_locations->size = sz;

      if ( !Alloc( 4*sz, (void**)&locs )) return FAILURE;
      Mark( &mrk );
      if ( !Alloc( 2*sz, (void**)&locs2 )) return FAILURE;

      glyph_locations->table = locs;

      if ( !Read_At_Font_File( table_dir_entries[t].offset,
                               locs2, 2*sz ) ) return FAILURE;

      Do16s( (unsigned short*)locs2, sz );
      for ( i = 0; i < sz; i++ ) locs[i] = 2*(Long)locs2[i];

      if ( !Release(&mrk) ) return FAILURE;
    }

    return SUCCESS;
  }


  Bool Load_TrueType_CVT()
  {
    Int m;

    PTableDirEntries p;

    m = LookUp_TrueType_Table("cvt ");
    if ( m < 0 ) return FAILURE;

    p = table_dir_entries + m;

    Cvt     = (PShort) malloc( p->length );
    CvtSize = p->length / sizeof(Short);

    if ( !Read_At_Font_File( p->offset, (void*)Cvt, p->length ))
       return FAILURE;

    Do16s( (unsigned short*)Cvt, CvtSize );

    return SUCCESS;
  }

  /******************************)
  (*  Load_TrueType_MaxProfile  *)
  (******************************/

  Bool Load_TrueType_MaxProfile()
  {
    Int m;

    PTableDirEntries p;

    m = LookUp_TrueType_Table("maxp");
    if ( m < 0 ) return FAILURE;

#ifdef DEBUG
    fprintf( stderr, "table MAXP trouve\n" );
#endif

    p = table_dir_entries + m;

    if ( !Read_At_Font_File( p->offset, (void*)&maxProfile, sizeof(maxProfile) ) )
      return FAILURE;

#ifdef DEBUG
    fprintf( stderr, "MAXP charge\n" );
#endif

    Do32( (unsigned long* )&maxProfile.version );
    Do16( (unsigned short*)&maxProfile.numGlyphs );
    Do16( (unsigned short*)&maxProfile.maxPoints );
    Do16( (unsigned short*)&maxProfile.maxContours );
    Do16( (unsigned short*)&maxProfile.maxCompositePoints );
    Do16( (unsigned short*)&maxProfile.maxZones );
    Do16( (unsigned short*)&maxProfile.maxTwilightPoints );
    Do16( (unsigned short*)&maxProfile.maxStorage );
    Do16( (unsigned short*)&maxProfile.maxFunctionDefs );
    Do16( (unsigned short*)&maxProfile.maxInstructionDefs );
    Do16( (unsigned short*)&maxProfile.maxStackElements );
    Do16( (unsigned short*)&maxProfile.maxSizeOfInstructions );
    Do16( (unsigned short*)&maxProfile.maxComponentElements );
    Do16( (unsigned short*)&maxProfile.maxComponentDepth );

    num_glyphs = maxProfile.numGlyphs;
    return SUCCESS;
  }

  /**************************)
  (*  Load_TrueType_Glyphs  *)
  (**************************/

  Int Load_TrueType_Glyphs()
  {
    Int   sz, szc, szp;
    Int   i, j, k, cnt;
    Byte  b, c;

    Short  x, y;

    Long      offset;
    PStorage  locs;

    TGlyph          Gl;
    PGlyphContours  con;
    PPoints         pts;

    TMarkRecord     mrk;

    i = LookUp_TrueType_Table("glyf");
    if ( i<0 ) return FAILURE;

    offset = table_dir_entries[i].offset;

    if ( !glyph_locations )
      if ( !Load_TrueType_Locations() ) return FAILURE;

    locs = glyph_locations->table;
    sz   = glyph_locations->size;

    if ( !Alloc( sizeof(TGlyph)*sz, (void**)&glyphs ) ) return FAILURE;

    j = 0;
    k = 0;

    for ( i=0; i < sz; i++ )
    {

      Mark( &mrk );

#ifdef DEBUG
      fprintf( stderr, "---------------------------\n" );
      fprintf( stderr, "glyph number = %d\n", i );
#endif
      if ( !Read_At_Font_File( offset + locs[i], (void*)&Gl, 5*sizeof(Short) ))
        goto Suite;

      /* Invalid offset ?? */

      Do16( (unsigned short*)&Gl.numberOfContours );
      Do16( (unsigned short*)&Gl.xMin );
      Do16( (unsigned short*)&Gl.yMin );
      Do16( (unsigned short*)&Gl.xMax );
      Do16( (unsigned short*)&Gl.yMax );

#ifdef DEBUG
      fprintf( stderr, "n contours : %d\n", Gl.numberOfContours );
      fprintf( stderr, "x minimum  : %d\n", Gl.xMin );
      fprintf( stderr, "y minimum  : %d\n", Gl.yMin );
      fprintf( stderr, "x maximum  : %d\n", Gl.xMax );
      fprintf( stderr, "y maximum  : %d\n", Gl.yMax );
#endif

      szc = Gl.numberOfContours;
      if ( szc < 0 || szc > maxProfile.maxContours ) goto Suite;


      if ( !Alloc( szc*sizeof(TGlyphContour), (void**)&con ) ) goto Fin;

      Gl.contours = con;
      szp = 0;
      for ( k = 0; k < szc; k++ )
      {

#ifdef DEBUG
        fprintf( stderr, "%d.", szp );
#endif

        con[k].start = szp;
        Read_16( (unsigned short*)&szp );
        con[k].finish = szp++;
      }

      Gl.numberOfPoints = szp;

#ifdef DEBUG
      fprintf( stderr, "[%d]\n", szp );
#endif

      /* For now, we skip instructions */

      Read_16( (UShort*)&k );

#ifdef DEBUG
      fprintf( stderr, "instructions = %d\n", k );
#endif

      Skip_Font_File( k );

#ifdef DEBUG
      fprintf( stderr, "instructions skipped\n" );
#endif

      if ( !Alloc( sizeof(TPointRec)*szp, (void**)&pts ) )
      {

#ifdef DEBUG
        fprintf( stderr, "could not malloc points\n" );
#endif
        Release( &mrk );
        goto Fin;
      }

#ifdef DEBUG
      fprintf( stderr, "could malloc points\n" );
#endif

      Gl.points = pts;

      /* Reading the flags */

#ifdef DEBUG
      fprintf( stderr, "reading flags ..\n" );
#endif

      k = 0;
      while ( k < szp )
      {
        Read_8(&c);
        pts[k].flag = c;
        k++;

        if ( c & 8 )
        {
          Read_8(&b);
          cnt = b;
          while ( cnt > 0 )
          {
            pts[k++].flag = c;
            cnt --;
          }
        }
      }

#ifdef DEBUG
      fprintf( stderr, "flags lus ...\n" );
#endif

      /* Reading the Xs */

      for ( k = 0; k < szp; k++ )
      {
        if ( pts[k].flag & 2 )
        {
          Read_8(&c);
          if ( pts[k].flag & 16 ) x = c; else x = -c;
        }
        else
          if ( pts[k].flag & 16 ) x = 0; else Read_16((unsigned short*)&x);

        pts[k].x = x;
      }

#ifdef DEBUG
      fprintf( stderr, "x lus ...\n" );
#endif

      /* Reading the Ys */

      for ( k = 0; k < szp; k++ )
      {
        if ( pts[k].flag & 4 )
        {
          Read_8(&c);
          if ( pts[k].flag & 32 ) y = c; else y = -c;
        }
        else
          if ( pts[k].flag & 32 ) y = 0; else Read_16((unsigned short*)&y);

        pts[k].y = y;
      }

#ifdef DEBUG
      fprintf( stderr, "y lus ...\n" );
#endif

      /* Convert relative coords to absolute ones */

      for ( k = 1; k < szp; k++ )
      {
        pts[k].x += pts[k-1].x;
        pts[k].y += pts[k-1].y;
      }

      memcpy( glyphs+j, &Gl, sizeof(Gl) );

      j++;

   Suite:
    }

  Fin:
    num_glyphs = j;
    return SUCCESS;
  }


  Bool Open_TrueType_File( char* name )
  {
    return Open_Font_File( name );
  }

  void Close_TrueType_File()
  {
    Close_Font_File();
  }

