#ifndef TTMEMORY_H
#define TTMEMORY_H

#include "tttypes.h"

  struct _TMarkRecord
  {
    Long  magic;
    Int   top;
  };
  typedef struct _TMarkRecord  TMarkRecord;
  typedef TMarkRecord         *PMarkRecord;

  void Init_FontPool( void* buffer, long size );
  /* Initializes the Font Pool on a givne memory block */

  Bool Alloc( long size, void* *pointer );
  /* Allocates a chunk of 'size' bytes from the Font Pool.       */
  /* 'pointer' holds the address of the allocated block on exit  */
  /* returns 1 on success, 0 if no memory is left                */

  void Mark( PMarkRecord mark );
  /* Mark the current Font Pool state into the 'mark' record */

  Bool Release( PMarkRecord mark );
  /* Recover the Font Pool to a previous state saved by 'Mark' */
  /* Returns 1 on success, 0 if release is incoherent          */
  /* NOTE : A Release destroys the 'mark' !!                   */

#endif /* TTMEMORY_H */
