/****************************************************************************}
{*                                                                          *}
{*  TTMemory.c                                                              *}
{*                                                                          *}
{*  This unit holds the routines used to manage memory. The Font Pool is    *}
{*  a simple growing heap with Alloc/Mark/Release operations. This is the   *}
{*  fastest and simplest memory management you can have, though it          *}
{*  requires careful allocations from the programmer..                      *}
{*                                                                          *}
{****************************************************************************/

#include "ttmemory.h"

#define MARK_MAGIC  0xBabe0007

  char*  buffer_base;
  Long   buffer_size;
  Long   buffer_top;

  void Init_FontPool( void* buffer, long size )
  {
    buffer_base = (char*) buffer;
    buffer_size = size;
    buffer_top  = 0;
  }


  Bool Alloc( long size, void* *pointer )
  {
    Long l;

    l = buffer_top + (( size+3 ) & -4);

    if ( l >= buffer_size )
      return FAILURE;

    *pointer   = (void*)(buffer_base + buffer_top);
    buffer_top = l;

    return SUCCESS;
  }


  void Mark( PMarkRecord  mark )
  {
    mark->magic = MARK_MAGIC;
    mark->top   = buffer_top;
  }


  Bool Release( PMarkRecord mark )
  {
    if ( mark->magic == MARK_MAGIC )
    {
      mark->magic = 0;
      buffer_top  = mark->top;
      mark->top   = -1;
      return SUCCESS;
    }
    else
      return FAILURE;
  }

