#include "ttfile.h"
#include "tterror.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

  /* IMPORTANT NOTE :                                              */
  /*                                                               */
  /*   This version of the 'File' component will load the whole    */
  /*   file in memory before allowing to parse it. This is very    */
  /*   useful for debugging, though it limits 16 bits systems      */
  /*   to work on font file smaller than 64 Kb.                    */
  /*                                                               */
  /*   It is the equivalent of 'TTFileM.Pas' found in the 'PAS/'   */
  /*   source directory. Change it to reflect 'TTFile.Pas' to      */
  /*   use any file, on any system.                                */
  /*                                                               */
  /*                                                               */

  FILE* font_file;

  unsigned char* font_buff;
  long           font_size;
  long           font_pos;

  Bool Open_Font_File( char* name )
  {
    font_file = fopen( name, "rb" );
    if (!font_file)
    {
      Error = TT_Err_File_Error;
      return FAILURE;
    }

    fseek( font_file, 0, SEEK_END );
    font_size = ftell( font_file );

#ifdef DEBUG
    fprintf( stderr, "(Open_Font_File) file size is = %ld\n", font_size );
#endif

    fseek( font_file, 0, SEEK_SET );

    font_pos  = 0;

    font_buff = (char*)malloc( font_size );
    if (!font_buff)
    {
      Error = TT_Err_File_Error;
      return FAILURE;
    }
    fread( font_buff, 1, font_size, font_file );

    return SUCCESS;
  }

  Bool Close_Font_File()
  {
    fclose( font_file );
    return SUCCESS;
  }

  Bool Seek_Font_File( long pos )
  {
    if ( pos < 0 || pos >= font_size )
      return FAILURE;

    font_pos = pos;
    return SUCCESS;
  }

  Bool Skip_Font_File( long dist )
  {
    return Seek_Font_File( font_pos + dist );
  }

  Bool Read_Font_File( void* buff, long count )
  {
    if ( font_pos + count >= font_size )
    {
      fprintf( stderr, "tried to read bytes %ld-%ld\n", font_pos, font_pos+count );
      return FAILURE;
    }

    memcpy( buff, font_buff + font_pos, count );
    font_pos += count;
    return SUCCESS;
  }

  Bool Read_At_Font_File( long pos, void* buff, long count )
  {
    if ( !Seek_Font_File(pos) )
    {
      fprintf( stderr, "could not position file cursor at %ld\n", pos );
      return FAILURE;
    }
    return Read_Font_File(buff,count);
  }

  Bool Read_8( unsigned char* c )
  {
    if ( font_pos < font_size )
    {
      *c = font_buff[font_pos++];
      return SUCCESS;
    }
    else
      return FAILURE;
  }

  Bool Read_16( unsigned short* s )
  {
    if ( font_pos + 1 < font_size )
    {
      *s = ( (font_buff[font_pos] << 8 ) | font_buff[font_pos+1] );
      font_pos += 2;
      return SUCCESS;
    }
    else
      return FAILURE;
  }

