#ifndef TTDISP_H
#define TTDISP_H

/* Display component : used to set the 640x480x16 graphics mode and */
/*                     display the bitmaps generated by the engine  */

/* This component is only used for debugging purposes, and by the test */
/* programs 'zoom.c' and 'testtime.c'. It is not an real part of the   */
/* engine..                                                            */

/* It is necessary if you want to debug the 'raster' component, with the */
/* 'DEBUG3' constant defined                                             */

#include "tttypes.h"

  extern PByte  Vio;
  /* Pointer to VRAM buffer */

  void  SetGraphScreen();
  /* Set 640x480x16 Graphics Mode */

  void  RestoreScreen();
  /* Restore previous ( or text ) video mode */

  void  Display_Bitmap_On_Screen( PByte buffer, Int line, Int col );
  /* Display a bitmap of 'line' lines, and 'col' columns ( each */
  /* column made of 8 bits )                                    */

  void  Clear_Bitmap_On_Screen( Int line, Int col );
  /* Clear a bitmap on the screen */

#endif /* TTDISP_H */
