#include "ttdisp.h"

/* This implementation is OS/2 dependent, change it to display the results */
/* on Linux using the SVGA toolkit ( note that I did not have the time to  */
/* to use the toolkit myself )                                             */

#define INCL_SUB

#include <os2.h>
#include <os2thunk.h>

#include <stdio.h>
#include <memory.h>

  PByte  Vio;

  VIOMODEINFO    OrgMode;
  Long           VioBufOfs;
  unsigned short Status;

  /* BIOS Video Mode 640x480x16 */

  VIOMODEINFO VioMode =
  {
    sizeof(VIOMODEINFO),
    VGMT_OTHER + VGMT_GRAPHICS,
    COLORS_16,
    80,
    35,
    640,
    480
  };

  VIOPHYSBUF VioBuf =
  {
    (void*)0xA0000L,
    64*1024
  };

  /* Restores Screen to its original state */

  void RestoreScreen()
  {
    VioSetMode( &OrgMode, 0 );
  }

  /* Sets graphics mode */

  void SetGraphScreen()
  {
    OrgMode.cb = sizeof(VIOMODEINFO);
    VioGetMode( &OrgMode, 0 );

    if ( VioSetMode( &VioMode, 0 ) )
    {
      fprintf( stderr, "impossible de mettre le mode graphique\n" );
      exit(5);
    }

    if ( VioGetPhysBuf( &VioBuf, 0 ) )
    {
      fprintf( stderr, "impossible d'avoir access a la VRAM\n" );
      exit(7);
    }

    VioBufOfs = (Long)MAKEP( VioBuf.asel[0], 0 );

    memset( (void*)VioBufOfs, 0, 64*1024 );
    Vio = (PByte)VioBufOfs;
  };

  void  Display_Bitmap_On_Screen( PByte buffer, Int line, Int col )
  {
    int    y;
    char*  target;

    target = Vio + ( line-1 )*80;

    for ( y = 0; y < line; y++ )
    {
      memcpy( target, buffer, col );
      target -= 80;
      buffer += col;
    }
  };

  void  Clear_Bitmap_On_Screen_( Int line, Int col )
  {
    int    y;
    char*  target;

    target = Vio + ( line-1 )*80;

    for ( y = 0; y < line; y++ )
    {
      memset( target, 0, col );
      target -= 80;
    }
  };

