#ifndef RASTER_H
#define RASTER_H

#define TT_Flow_Down   -1  /* down-flowing bitmap and profile  */
#define TT_Flow_Up      1  /* up-flowing bitmap and profile    */
#define TT_Flow_Error   0  /* an error occured while rendering */

#define Raster_Err_None        0
#define Raster_Err_Not_Ini     1   /* Raster was not initialized     */
#define Raster_Err_Overflow    2   /* Profile table overflow         */
#define Raster_Err_Neg_Height  3   /* Negative height encountered !! */
#define Raster_Err_Invalid     4   /* Invalid value encountered      */

#define TT_DropOut_Control_None     0  /* No Drop-out control               */
#define TT_DropOut_Control_Simple   1  /* Simple drop-out control (rule #3) */
#define TT_DropOut_Control_Complex  2  /* Complex d-o control ( rule #4 )   */

  struct _TRasterBlock
  {
    unsigned long    rows;    /* Number of rows             */
    unsigned long    cols;    /* Number of 8-pixels columns */
    unsigned long    width;   /* Number of pixels per line  */
             long     flow;    /* Bitmap orientation         */

    void*    bitmap;  /* bitmap buffer        */
    unsigned long    size;    /* bitmap size in bytes */
  };
  typedef struct _TRasterBlock  TRasterBlock;
  typedef TRasterBlock         *PRasterBlock;
  /* A structure used to describe the target bitmap to the renderer */
  /* Note that we do not consider gray-levels yet !!                */

  struct _TGlyphRecord
  {
    unsigned long    outlines;    /* number of contours in glyph          */
    int*             outStarts;   /* points to an array of each contour's */
                                  /* start point index                    */
    unsigned long    points;      /* number of points in the glyph        */
    long*            xCoord;      /* table of x coordinates               */
    long*            yCoord;      /* table of y coordinates               */
    char*            flag;        /* table of flags                       */
  };
  typedef struct _TGlyphRecord  TGlyphRecord;
  typedef TGlyphRecord         *PGlyphRecord;
  /* A structure used to describe the source glyph to the renderer */

  extern int  Raster_Error;

  int  Render_Glyph( TGlyphRecord *AGlyph,
                     int           xmax,
                     int           ymax );

  int  InitRasterizer( TRasterBlock*  rasterBlock,
                       long*          profBuffer,
                       long           profSize );


#endif /* RASTER_H */
