
#include <string.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include "ttdisp.h"

/* This implementation is X11 dependent. */
/* robert@physiol.med.tu-muenchen.de  */

#define INCL_SUB


#include <stdio.h>

  static Window win;
  static GC gcblack;
  static GC gcwhite;

  PByte  Vio;

  Long         VioBufOfs;

  /* Restores Screen to its original state */

  void RestoreScreen()
  {
    printf("RestoreScreen\n");  /* FIXME */
  }

  /* Sets graphics mode */

 Display *display;
 char *displayname="";

  void x11init()
{
  int screen_num;
  int i;

  XrmInitialize();

  if(!(display=XOpenDisplay(displayname)))
    {
      fprintf(stderr,"Cannot open Display\n");
      exit(1);
    }

  Vio = (PByte) malloc(1024*64);

  if (!Vio)
    {
      fprintf(stderr,"Cannot malloc Display mem\n");
      exit(1);
    }

  screen_num=DefaultScreen(display);
  win=XCreateSimpleWindow(display,RootWindow(display,screen_num),0,0,640,480,10,
		      BlackPixel(display,screen_num),WhitePixel(display,screen_num));

  XMapWindow(display,win);

  gcblack=XCreateGC(display,RootWindow(display,screen_num),
	      0L,NULL);

  XSetForeground(display, gcblack, BlackPixel(display, screen_num));
  XSetBackground(display, gcblack, WhitePixel(display, screen_num));

  gcwhite=XCreateGC(display,RootWindow(display,screen_num),
	      0L,NULL);

  XSetForeground(display, gcwhite, WhitePixel(display, screen_num));
  XSetBackground(display, gcwhite, BlackPixel(display, screen_num));

  XSync(display,0);
}

  void SetGraphScreen()
  {
    printf("SetGraphScreen()\n");

    x11init();
  };

  void  Display_Bitmap_On_Screen( PByte buffer, Int line, Int col )
  {
    int    y,z,b;
    char*  target;

    XClearWindow(display,win);

    target = Vio + ( line-1 )*80;

    for ( y = 0; y < line; y++ )
    {
      memcpy( target, buffer, col );
      target -= 80;
      buffer += col;
    }


    for ( y = 0; y < line; y++ )
    {
      for ( z = 0; z < col; z++ )
	{
	  char c=Vio[y*80+z];
	  for ( b = 7; b >=0 ; b-- )
	    {

	      if ( ( 1 << b) & c)
		XDrawPoint(display,win,gcblack,z*8+7-b,y);
	    }
	}
    }
  }

  void  Clear( Int line, Int col )
  {
    int    y;
    char*  target;

    target = Vio + ( line-1 )*80;

    for ( y = 0; y < line; y++ )
    {
      memset( target, 0, col );
      target -= 80;
    }
  };

