#include "ttdisp.h"
#include <stdio.h>
#include <memory.h>
#include <dos.h>

/* This implementation is DOS dependent, change it to display the results  */
/* on Linux using the SVGA toolkit ( note that I did not have the time to  */
/* to use the toolkit myself )                                             */

  PByte  Vio;

#ifdef OS2

#define INCL_SUB

#include <os2.h>
#include <os2thunk.h>

  VIOMODEINFO  OrgMode;
  Long         VioBufOfs;
  Word16       Status;

  /* BIOS Video Mode 640x480x16 */

  VIOMODEINFO VioMode =
  {
    sizeof(VIOMODEINFO),
    VGMT_OTHER + VGMT_GRAPHICS,
    COLORS_16,
    80,
    35,
    640,
    480
  };

  VIOPHYSBUF VioBuf =
  {
    (void*)0xA0000L,
    64*1024
  };

  /* Restores Screen to its original state */

  void RestoreScreen()
  {
    VioSetMode( &OrgMode, 0 );
  }

  /* Sets graphics mode */

  void SetGraphScreen()
  {
    OrgMode.cb = sizeof(VIOMODEINFO);
    VioGetMode( &OrgMode, 0 );

    if ( VioSetMode( &VioMode, 0 ) )
    {
      fprintf( stderr, "impossible de mettre le mode graphique\n" );
      exit(5);
    }

    if ( VioGetPhysBuf( &VioBuf, 0 ) )
    {
      fprintf( stderr, "impossible d'avoir access a la VRAM\n" );
      exit(7);
    }

    VioBufOfs = (Long)MAKEP( VioBuf.asel[0], 0 );

    memset( (void*)VioBufOfs, 0, 64*1024 );
    Vio = (PByte)VioBufOfs;
  };

#else /* OS2 */

  void SetGraphScreen()
  {
    asm {
      mov ax, 0x0012
      int 0x10
    }
    Vio = (char*)MK_FP( 0xA000, 0 );
  }

  void RestoreScreen()
  {
    asm {
      mov ax, 0x0003
      int 0x10
    }
  }

#endif

  void  Display_Bitmap_On_Screen( PByte buffer, Int line, Int col )
  {
    int    y;
    char*  target;

    target = Vio + ( line-1 )*80;

    for ( y = 0; y < line; y++ )
    {
      memcpy( target, buffer, col );
      target -= 80;
      buffer += col;
    }
  };

  void  Clear_Bitmap_On_Screen( Int line, Int col )
  {
    int    y;
    char*  target;

    target = Vio + ( line-1 )*80;

    for ( y = 0; y < line; y++ )
    {
      memset( target, 0, col );
      target -= 80;
    }
  };

