/*	tick.h - the include file for timer and c_brk function installation */
/*	(c) - Amit Joshi, Princeton University 

	This code may be used freely for any noncommercial use. It may NOT
	be used in any commercial package without written permission from
	the author. This clause is to protect me from legal hassles with
	the university about code developed here. This code is supplied
	"AS IS" i.e. with no warranty. Do not remove this notice. Any 
	modifications should be clearly noted before redistribution.
**/

/**	Amit Joshi
	MAE Dept., Engg. Quad.
	Princeton University
	December 1987
**/

/**
	Change the values defined for NTIMERS and NCBRKS to increase 
	number of timer and cbrk functions installed.

	Amit Joshi
	January 1988
**/

#ifndef	__TICK_H__
#define	__TICK_H__

#include <dos.h>

/* Change the following definitions to increase number of timers and cbrks */
#define	NTIMERS	2	/* number of timers installable */
#define	NCBRKS	2	/* number of cbrks installable */

#define NULLIVFP	(void interrupt (*)())NULL
#define	NULLVFP		(void (*)())NULL
#define NULLFP		(int (*)())NULL 

#ifdef	HARDTIMER
#define	TIMER_INT	0x08
#else
#define TIMER_INT	0x1C 	
#endif

/* user callable functions */
int	_Cdecl		install_timer(void (*func)());	
int	_Cdecl		install_cbrk(void (*func)());
int	_Cdecl		remove_timer(void (*func)());
int	_Cdecl		remove_cbrk(void (*func)());

#endif	__TICK_H__
