/*	test.c - gently excersise the tick.c functions */

#include <stdio.h>
#include "tick.h"

#define	NT 300
#define ND 5

void test1(void) {
	printf("1");
}

void test2(void) {
	putc('a',stderr);
}

main() {
	int i;
	void test1(), test2();
	
	for (i = NT; i > 0; i--) {
		test1(); test2();
		delay(ND);
	}
	
	if ((i = install_timer(test1)) != 0) {
		printf("Install_timer failed: %d\n",i);
		exit(1);
	}
	
	printf("\nInstalled timer 1\n");
	
	for (i = NT; i > 0; i--) delay(ND);
	
	if ((i = install_timer(test2)) != 0) {
		printf("Install_timer failed: %d\n",i);
		exit(1);
	}
	
	printf("\nInstalled timer 2\n");
	
	for (i = NT; i > 0; i--) delay(ND);
	
	if ((i = remove_timer(test2)) != 0) {
		printf("Remove timer failed: %d\n",i);
		exit(1);
	}
	printf("\nRemoved timer 2\n");
	for (i = NT; i > 0; i--) delay(ND);
	if ((i = install_timer(test2)) != 0) {
		printf("Install_timer failed: %d\n",i);
		exit(1);
	}
	
	printf("\nInstalled timer 2\n");
	
	for (i = NT; i > 0; i--) delay(ND);
	if ((i = remove_timer(test1)) != 0) {
		printf("Remove timer failed: %d\n",i);
		exit(1);
	}
	printf("\nRemoved timer 1\n");
	for (i = NT; i > 0; i--) delay(ND);

	if ((i = install_timer(test1)) != 0) {
		printf("Install_timer failed: %d\n",i);
		exit(1);
	}
	
	printf("\nInstalled timer 1\n");
	for (i = NT; i > 0; i--) delay(ND);
	
	if ((i = remove_timer(NULLVFP)) != 0) {
		printf("Remove timer failed: %d\n",i);
		exit(1);
	}
	printf("\nRemoved all timers\n");
	for (i = NT; i < 0; i--) delay(ND);
}
	
