/**********************************************
*   X11   include file for MMM  Editor        *
*   Contains X11    Spacific functions        *
*   (Tested on i386 RedHat Linux 3.0+ X11R6)  *
***********************************************/

#ifndef __INCLUDED_MMM_LINUX__
#define __INCLUDED_MMM_LINUX__

#define EXECUTER_FILENAME "__mmm__.bat"
#define BASE_CONFIG_FILE_NAME "Xmmm_base.cfg"
//&<<&#include 
#include "mmmx.h"
#include "mmmgrep.h"
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <linux/tty.h>
#include <linux/kd.h>
#include <linux/vt.h>
#include <signal.h>
#include <termios.h>       /* for tcget(set)attr */
#include <sys/ioctl.h>
#include <dirent.h>
#include <sys/stat.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
//&>>&E 0 E 11

//&<<&X11 specific declarations
#define WND_X               10
#define WND_Y               10
#define WND_WDT           900
#define WND_HGH           600
#define WND_MIN_WDT       600
#define WND_MIN_HGH       400
#define WND_BORDER_WDT      5

#define WND_TITLE        "WT mmmX: "
#define WND_ICON_TITLE   "WIT mmmX: "
#define PRG_CLASS        "PC mmmX"

#define AltMask 8
//&>>&D 0 D 22

//&<<&struct mmm_Screen {
struct mmm_Screen {
    char cold,cattrold; // old char under cursor & cursor attribute
    unsigned long nPixel[0x10];
    int FontHeight;
    int FontWidth;
    int FontDescent;

    int WIDTH,HEIGHT;
    XFontStruct *prFontInfo;
    Display *prDisplay;
    int     nScreenNum;
    Window  nWnd;
    int cursx,cursy;
    int need;

    mmm_Screen();
    ~mmm_Screen();

    int GetH(){ return HEIGHT; }
    int GetW(){ return WIDTH; }
    int &Need(){ return need; }

    void Init(int argc, char **argv);
    void SetCursor(int x,int y,int attr);
    void ClrCursor();
    void InitColorMap();

    void ReadWindowParameters();

    };
//&>>&2 0 2 18
extern mmm_Screen mmm_screen;

extern void DrawLine(char *Str, int PosY, char Attr,int slen);
extern void SetSignalHandler();

//&<<&class mmm_KeyBoard{
class mmm_KeyBoard{
    void InitKeyboardLayout();
    char *InitDefaultAltCase();

public:
    char *AltCase;
    char keys[4][128];
    int LastScanCode;
    void SetACode(int n);
    mmm_KeyBoard();
    ~mmm_KeyBoard();
    int GetScan();
    friend void SegmentViolationHandler(int a);
    void ChangeConsole(int num);
};
//&>>&6 0 6 13
extern mmm_KeyBoard mmm_KBD;

void MkScan(int scancode);

#endif

extern volatile int mmm_f_Shift, mmm_f_Alt, mmm_f_Ctrl, mmm_f_Caps;

//&>>&F 0 F 2A
