/**************************
*  mmm.cfg file creator   *
* Creates default config. *
***************************/
//&<<&Headers
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//&>>&2 0 2 0
#include "mmmconst.h"

//&<<&void putExtensions(FILE *fptr);
void putExtensions(FILE *fptr){
    fprintf(fptr,"&<<&*EXTENSIONS*\n");
    fprintf(fptr,"cpp //\nc //\nhpp //\nh //\n"); // c/c++
    fprintf(fptr,"tex %%\nsty %%\n");               // TeX
    fprintf(fptr,"prg //\nch  //\nrmk #\n");      // Clipper
    fprintf(fptr,"bat @Rem -\nsys rem -\n");      // MSDOS config
    fprintf(fptr,"lsp ;\nasm ;\n");               // Lsp, asm
    fprintf(fptr,"conf #\n");                     // Linux ".conf"
    fprintf(fptr,"mif #\n");                      // makefiles
    fprintf(fptr," #\n");
    fprintf(fptr,"&>>&0 0 0 0\n");
    }
//&>>&A 0 A 4
//&<<&void putKeyboardLayouts(FILE *fptr);
//&<<&void pkl_PrintTable(FILE *fptr, char *keys[]){
void pkl_PrintTable(FILE *fptr, char *keys[]){
    int i;
    for(i=0;i<4;i++) fprintf(fptr,"%s\n",keys[i]);
    }
//&>>&2 0 2 0
void putKeyboardLayouts(FILE *fptr){
    int etype=100;
    while(etype!=0 && etype!=1 && etype!=2 && etype!=3 && etype!=4 ){
        printf("Keyboard layout (0-ALT, 1-KOI8, 2-ISO, 3-WIN, 4-X11) :");
        scanf("%d",&etype);
        }

    fprintf(fptr,"&<<&*KEYMAP*\n");
    if(etype==0){
//&<<&        Alt enc. (dos, os2)
    char *altCase="aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ"
          "";

    char *keys[]={                   /*  size = 4x108  */
      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    // 0..13
      "....qQwWeErRtTyYuUiIoOpP[{]}"                    // 14..27
      "....aAsSdDfFgGhHjJkKlL;:'\"`~"                   // 28..41
      "..\\|zZxXcCvVbBnNmM,<.>/?",                      // 42..53

      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    // 0..13
      "....㓨"                    // 14..27
      "....ᑤ䔣啩`~"                    // 28..41
      "..\\|斦/?",                      // 42..53

      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    // 0..13
      "....㓪陧"                    // 14..27
      "....뛢`~"                    // 28..41
      "..\\|ᑬ육/?",                      // 42..53

      "............"                    // 0..13
      "....ѿ˷..߰"                    // 14..27
      "....شζ޳.."                    // 28..41
      "....پʽ......"                        // 42..53
      };

//&>>&0 0 0 0
        fprintf(fptr,"%s\n", altCase);
        pkl_PrintTable(fptr, keys);
        }
    if(etype==1){
//&<<&        KOI8
    char *altCase="aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ"
          "";

    char *keys[]={      /* size = 4x108 */
      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    //  0..13
      "....qQwWeErRtTyYuUiIoOpP[{]}"                    // 14..27
      "....aAsSdDfFgGhHjJkKlL;:'\"`~"                   // 28..41
      "..\\|zZxXcCvVbBnNmM,<.>/?",                      // 42..53

      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    //  0..13
      "...."                    // 14..27
      "....`~"                    // 28..41
      "..\\|/?",                      // 42..53

      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    //  0..13
      "...."                    // 14..27
      "....`~"                    // 28..41
      "..\\|/?",                      // 42..53

      "..................."                    //  0..13
      "......"                    // 14..27
      "......"                    // 28..41
      ".........."                        // 42..53

      };
//&>>&0 0 0 8
        fprintf(fptr,"%s\n", altCase);
        pkl_PrintTable(fptr, keys);
        }
    if(etype==2){
//&<<&        ISO
    char *altCase="aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ"
          "аѱҲӳԴյֶ׷ظٹںۻܼݽ޾߿";

    char *keys[]={      /* size = 4x108 */
      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    //  0..13
      "....qQwWeErRtTyYuUiIoOpP[{]}"                    // 14..27
      "....aAsSdDfFgGhHjJkKlL;:'\"`~"                   // 28..41
      "..\\|zZxXcCvVbBnNmM,<.>/?",                      // 42..53

      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    //  0..13
      "....Ҳյظ޾߿"                    // 14..27
      "....аԴӳٹںۻ`~"                    // 28..41
      "..\\|׷Ҳѱݽܼ/?",                      // 42..53

      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    //  0..13
      "....ٹںյݽӳ׷"                    // 14..27
      "....Ҳа߿޾ۻԴֶ`~"                    // 28..41
      "..\\|ܼظѱ/?",                      // 42..53

      "............................"                    //  0..13
      "............................"                    // 14..27
      "............................"                    // 28..41
      "........................"                        // 42..53

      };
//&>>&17 0 14 0
        fprintf(fptr,"%s\n", altCase);
        pkl_PrintTable(fptr, keys);
        }
    if(etype==3){
//&<<&        WIN    (w95)
    char *altCase="aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ"
          "";

    char *keys[]={      /* size = 4x108 */
      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    // 0..13
      "....qQwWeErRtTyYuUiIoOpP[{]}"                    // 14..27
      "....aAsSdDfFgGhHjJkKlL;:'\"`~"                   // 28..41
      "..\\|zZxXcCvVbBnNmM,<.>/?",                      // 42..53

      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    // 0..13
      "...."                    // 14..27
      "....`~"                    // 28..41
      "..\\|/?",                      // 42..53

      "....1!2@3#4$5%6^7&8*9(0)-_=+"                    // 0..13
      "...."                    // 14..27
      "....`~"                    // 28..41
      "..\\|/?",                      // 42..53

      "............"                    // 0..13
      "......"                    // 14..27
      "......"                    // 28..41
      ".........."                        // 42..53
      };

//&>>&18 0 16 0
        fprintf(fptr,"%s\n", altCase);
        pkl_PrintTable(fptr, keys);
        }
    if(etype==4){
//&<<&        X11 R6
    char *altCase="aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ";

    char *keys[]={      /* size = 4x128 */

      "...................."                //
      "1!2@3#4$5%6^7&8*9(0)-_=+...."        //
      "qQwWeErRtTyYuUiIoOpP[{]}...."        //
      "aAsSdDfFgGhHjJkKlL;:'\"`~.."         //
      "\\|zZxXcCvVbBnNmM,<.>/?"        ,    //

      "...................."
      "1!2@3#4$5%6^7&8*9(0)-_=+...."
      "qQwWeErRtTyYuUiIoOpP[{]}...."
      "aAsSdDfFgGhHjJkKlL;:'\"`~.."
      "\\|zZxXcCvVbBnNmM,<.>/?"        ,

      "...................."
      "1!2@3#4$5%6^7&8*9(0)-_=+...."
      "jJcCuUkKeEnNgG[{]}zZhH......"
      "fFyYwWaApPrRoOlLdDvV'\"`~.."
      "\\|qQ`~sSmMiItTxXbB,<.>/?"        ,

      "...................."
      "1!2@3#4$5%6^7&8*9(0)-_=+...."
      "qQwWeErRtTyYuUiIoOpP[{]}...."
      "aAsSdDfFgGhHjJkKlL;:'\"`~.."
      "\\|zZxXcCvVbBnNmM,<.>/?"

      };

//&>>&12 0 12 0
        fprintf(fptr,"%s\n", altCase);
        pkl_PrintTable(fptr, keys);
        }

    fprintf(fptr,"&>>&0 0 0 0\n");
    }
//&>>&1E 0 18 3
//&<<&void putSetup(FILE *fptr);
void putSetup(FILE *fptr){
    int etype=100;
    while(etype!=0 && etype!=1&& etype!=2 ){
        printf("Color type (0-Dos,os2,win, 1-Linux-color, 2-X11-color) :");
        scanf("%d",&etype);
        }

    fprintf(fptr,"&<<&*SETUP*\n");
    switch(etype){
//&<<&        case 0:
        case 0:
            fprintf(fptr,"Attrs=7 70 a 60 17 6f 1a 31\n");
            break;
//&>>&1 0 1 32
//&<<&        case 1:
        case 1:
            fprintf(fptr,"Attrs=7 70 a 60 47 6f 4a 60\n");
            break;
//&>>&1 0 1 35
//&<<&        case 2:
        case 2:
            fprintf(fptr,"Attrs=1 10 8 80 91 61 98 91\n");
            break;
//&>>&2 0 2 0
        }
    fprintf(fptr,"Params=1 1 1 0\n");
    fprintf(fptr,"&>>&0 0 0 0\n");

    }
//&>>&B 0 B 19
//&<<&void putCommand(FILE *fptr);
void putCommand(FILE *fptr) {
    int etype=100;
    while(etype!=0 && etype!=1 && etype!=2 && etype!=3 && etype!=4 ){
        printf("Command Table (0-DOS, 1-OS2, 2-Linux, 3-Win95, 4-X11) :");
        scanf("%d",&etype);
        }
    fprintf(fptr,"&<<&*COMMAND*\n");
    fprintf(fptr,"40e HelloWorld\n");
//&<<&    if(etype==0 || etype==2 || etype==3 ){    /// Dos Linux Win95
    if(etype==0 || etype==2 || etype==3 ){    /// Dos Linux Win95
//&<<&        // Movement
    fprintf(fptr, "048 Up\n");
    fprintf(fptr, "068 Up\n");
    fprintf(fptr, "050 Down\n");
    fprintf(fptr, "06d Down\n");
    fprintf(fptr, "04b Left\n");
    fprintf(fptr, "06a Left\n");
    fprintf(fptr, "04d Right\n");
    fprintf(fptr, "06b Right\n");

    fprintf(fptr, "448 TUp\n");  // Ctrl + Up
    fprintf(fptr, "468 TUp\n");  // Ctrl + Up
    fprintf(fptr, "450 TDown\n");  // Ctrl + Down
    fprintf(fptr, "46d TDown\n");  // Ctrl + Down
    fprintf(fptr, "44b TLeft\n");  // Ctrl + Left
    fprintf(fptr, "46a TLeft\n");  // Ctrl + Left
    fprintf(fptr, "44d TRight\n");  // Ctrl + Right
    fprintf(fptr, "46b TRight\n");  // Ctrl + Right

    fprintf(fptr, "148 PUp\n");  // Shift + Up
    fprintf(fptr, "168 PUp\n");  // Shift + Up
    fprintf(fptr, "150 PDown\n");  // Shift + Down
    fprintf(fptr, "16d PDown\n");  // Shift + Down
    fprintf(fptr, "14b PLeft\n");  // Shift + Left
    fprintf(fptr, "16a PLeft\n");  // Shift + Left
    fprintf(fptr, "14d PRight\n");  // Shift + Right
    fprintf(fptr, "16b PRight\n");  // Shift + Right

    fprintf(fptr, "248 FUp\n");  // Alt + Up
    fprintf(fptr, "268 FUp\n");  // Alt + Up
    fprintf(fptr, "250 FDown\n");  // Alt + Down
    fprintf(fptr, "26d FDown\n");  // Alt + Down
    fprintf(fptr, "24b FLeft\n");  // Alt + Left
    fprintf(fptr, "26a FLeft\n");  // Alt + Left
    fprintf(fptr, "24d FRight\n");  // Alt + Right
    fprintf(fptr, "26b FRight\n");  // Alt + Right

    fprintf(fptr, "01c Enter\n");  // Enter
    fprintf(fptr, "061 Enter\n");  // Enter
    fprintf(fptr, "11c REnter\n");  // Shift + Enter
    fprintf(fptr, "161 REnter\n");  // Shift + Enter

    fprintf(fptr, "00f Tab\n");  // Tab
    fprintf(fptr, "10f LTab\n");  // Shift + Tab

//&>>&0 0 0 1B
//&<<&        // Insert and delete
// Insert and delete

    fprintf(fptr, "052 InsCh\n");  // Ins
    fprintf(fptr, "06f InsCh\n");  // Ins
    fprintf(fptr, "053 DelCh\n");  // Del
    fprintf(fptr, "070 DelCh\n");  // Del
    fprintf(fptr, "152 InsLine\n");  // Shift + Ins
    fprintf(fptr, "16f InsLine\n");  // Shift + Ins
    fprintf(fptr, "252 InsFold\n");  // Alt + Ins
    fprintf(fptr, "26f InsFold\n");  // Alt + Ins
    fprintf(fptr, "153 DelLine\n");  // Shift + Del
    fprintf(fptr, "170 DelLine\n");  // Shift + Del
    fprintf(fptr, "253 DelLine\n");  // Alt + Del
    fprintf(fptr, "270 DelLine\n");  // Alt + Del
    fprintf(fptr, "00E BS\n");  // BS
    fprintf(fptr, "10e R_BS\n");  // Shift + BS

//&>>&F 0 F B
//&<<&        // Line Killing
// Line Killing
    fprintf(fptr, "04a KillWord\n" );     // [+]
    fprintf(fptr, "14a KillEnd\n" );     // SHIFT [+]
    fprintf(fptr, "44a KillBeg\n" );     // CTRL [+]
    fprintf(fptr, "04e KillWord\n" );     // [-]
    fprintf(fptr, "14e KillEnd\n" );     // SHIFT [-]
    fprintf(fptr, "44e KillBeg\n" );     // CTRL [-]
//&>>&6 0 6 14
//&<<&        // Copying of chars
    fprintf(fptr,"03b CSave\n"      );  //  F1:            Ch
    fprintf(fptr,"13b CMove\n"      );  //  SHIFT-F1:      Ch
    fprintf(fptr,"23b WSave\n"      );  //  ALT-F1:        Wo
    fprintf(fptr,"33b WMove\n"      );  //  ALT-SHIFT-F1:  Wo
    fprintf(fptr,"63b BWord\n"      );  //  CTRL-ALT-F1
    fprintf(fptr,"73b BWord\n"      );  //  CTRL-SHIFT-ALT-F1
    fprintf(fptr,"43b TSave\n"      );  //  CTRL-F1:       Li
    fprintf(fptr,"53b TMove\n"      );  //  CTRL-SHIFT-F1: Li
    fprintf(fptr,"03c CRest\n"      );  //  F2: Clipboard =>
    fprintf(fptr,"13c CClear\n"     );  //  SHIFT-F2: Clear C
//&>>&6 0 6 1B
//&<<&        // Copying of lines
// Copying of lines
    fprintf(fptr, "03d LSave\n");  // F3:
    fprintf(fptr, "43d LTSave\n");  // CTRL-F3:
    fprintf(fptr, "13d LMove\n");  // SHIFT-F3:
    fprintf(fptr, "53d LTMove\n");  // CTRL-SHIFT-F3
    fprintf(fptr, "03e LRest\n");  // F4:
    fprintf(fptr, "13e LClear\n");  // SHIFT-F4:
//&>>&6 0 6 0
//&<<&        // Various types of exit
// Various types of exit

    fprintf(fptr,"001 Escape\n"); // ESC: temporary exit to DOS
    fprintf(fptr,"101 EscapeExec\n"); // SHIFT-ESC: execute current line
    fprintf(fptr,"23e EscapeExecLCB\n"); // ALT-F4: execute ClipBoard
//&>>&4 0 4 1E
//&<<&        // Various switchings  (ins/ovr , alt key , status line .........)
    fprintf(fptr, "21c S_AutoIndent\n");   // ALT-ENTER    (on/off auto-indent)
    fprintf(fptr, "452 S_ModeIns\n");   // CTRL-INS (insert mode)
    fprintf(fptr, "453 S_ModeOvr\n");   // CTRL-DEL (overwrite mode)
    fprintf(fptr, "46f S_ModeIns\n");   // CTRL-INS (insert mode)
    fprintf(fptr, "470 S_ModeOvr\n");   // CTRL-DEL (overwrite mode)
    fprintf(fptr, "802 S_ACode1\n");   // CAPS+1 switch to QQ keyboard as alt
    fprintf(fptr, "803 S_ACode2\n");   // CAPS+2 switch to QJ keyboard as alt
    fprintf(fptr, "804 S_ACode3\n");   // CAPS+3 switch to  keyboard as alt
    fprintf(fptr, "41f S_StatusLine\n");   // Ctrl+'S' switch status line ON/OFF
    fprintf(fptr, "837 S_SearchMode\n");   // CAPS + "*\n"  search modes switching
//&>>&8 0 8 1C
//&<<&        // Search & replace commands
    fprintf(fptr,"037 SearchFWD\n");       // "*\n" search forward
    fprintf(fptr,"137 SearchBCK\n");       // SHIFT+"*\n" search back
    fprintf(fptr,"237 Replace\n");       // ALT+"*\n" REPLACE
    fprintf(fptr,"437 SearchPage\n");       //  CTRL+"*\n"  switch into SearchPage
//&>>&3 0 3 13
        fprintf(fptr,"852 PageIns\n");    // CAPS+INS insert new page
        fprintf(fptr,"86f PageIns\n");    // CAPS+INS insert new page
//&<<&        // Marked Lines Commands

    fprintf(fptr,"848 MarkUp\n");  // CAPS+UP
    fprintf(fptr,"868 MarkUp\n");  // CAPS+UP
    fprintf(fptr,"850 MarkDown\n");  // CAPS+DOWN
    fprintf(fptr,"86d MarkDown\n");  // CAPS+DOWN
    fprintf(fptr,"c48 MarkTUp\n");  // CAPS+CTRL+UP
    fprintf(fptr,"c68 MarkTUp\n");  // CAPS+CTRL+UP
    fprintf(fptr,"c50 MarkTDown\n");  // CAPS+CTRL+DOWN
    fprintf(fptr,"c6d MarkTDown\n");  // CAPS+CTRL+DOWN
    fprintf(fptr,"948 MarkPUp\n");  // CAPS+SHIFT+UP
    fprintf(fptr,"968 MarkPUp\n");  // CAPS+SHIFT+UP
    fprintf(fptr,"950 MarkPDown\n");  // CAPS+SHIFT+DOWN
    fprintf(fptr,"96d MarkPDown\n");  // CAPS+SHIFT+DOWN

    fprintf(fptr,"03f MarkSaveB\n");  // F5 - push marked lines to stack
    fprintf(fptr,"040 MarkRestB\n");  // F6 - pop marked lines from stack

    fprintf(fptr,"c4b MarkLast\n");     // CAPS-CTRL-LEFT  : LastMarked();
    fprintf(fptr,"c6a MarkLast\n");     // CAPS-CTRL-LEFT  : LastMarked();
    fprintf(fptr,"c4d MarkFirst\n");     // CAPS-CTRL-RIGHT
    fprintf(fptr,"c6b MarkFirst\n");     // CAPS-CTRL-RIGHT

    fprintf(fptr,"84b MarkPrev\n");    // CAPS-Left
    fprintf(fptr,"86a MarkPrev\n");    // CAPS-Left
    fprintf(fptr,"84d MarkNext\n");    // CAPS-Right
    fprintf(fptr,"86b MarkNext\n");    // CAPS-Right

    fprintf(fptr,"80e MarkBS\n");                   // CAPS-BS

//&>>&1B 0 15 13
//&<<&        // Macros
    fprintf(fptr,"041 Macro\n");        // F7
    fprintf(fptr,"141 MacroRec\n");     // SHIFT+F7
//&>>&0 0 0 23
        }
//&>>&7 0 7 28
//&<<&    if(etype==1){    /// os2
    if(etype==1){    /// os2
//&<<&        // Movement
    fprintf(fptr, "048 Up\n");
    fprintf(fptr, "050 Down\n");
    fprintf(fptr, "04b Left\n");
    fprintf(fptr, "04d Right\n");

    fprintf(fptr, "48d TUp\n");  // Ctrl + Up
    fprintf(fptr, "491 TDown\n");  // Ctrl + Down
    fprintf(fptr, "473 TLeft\n");  // Ctrl + Left
    fprintf(fptr, "474 TRight\n");  // Ctrl + Right

    fprintf(fptr, "148 PUp\n");  // Shift + Up
    fprintf(fptr, "150 PDown\n");  // Shift + Down
    fprintf(fptr, "14b PLeft\n");  // Shift + Left
    fprintf(fptr, "14d PRight\n");  // Shift + Right

    fprintf(fptr, "298 FUp\n");  // Alt + Up
    fprintf(fptr, "2A0 FDown\n");  // Alt + Down
    fprintf(fptr, "29b FLeft\n");  // Alt + Left
    fprintf(fptr, "29d FRight\n");  // Alt + Right

    fprintf(fptr, "01c Enter\n");  // Enter
    fprintf(fptr, "11c REnter\n");  // Shift + Enter

    fprintf(fptr, "00f Tab\n");  // Tab
    fprintf(fptr, "10f LTab\n");  // Shift + Tab

//&>>&0 0 0 14
//&<<&        // Insert and delete
// Insert and delete

    fprintf(fptr, "052 InsCh\n");  // Ins
    fprintf(fptr, "053 DelCh\n");  // Del
    fprintf(fptr, "152 InsLine\n");  // Shift + Ins
    fprintf(fptr, "2a2 InsFold\n");  // Alt + Ins
    fprintf(fptr, "153 DelLine\n");  // Shift + Del
    fprintf(fptr, "2a3 DelLine\n");  // Alt + Del
    fprintf(fptr, "00e BS\n");  // BS
    fprintf(fptr, "10e R_BS\n");  // Shift + BS

//&>>&7 0 7 0
//&<<&        // Line Killing
// Line Killing
    fprintf(fptr, "04a KillWord\n" );     // [+]
    fprintf(fptr, "14a KillEnd\n" );     // SHIFT [+]
    fprintf(fptr, "490 KillBeg\n" );     // CTRL [+]
    fprintf(fptr, "04e KillWord\n" );     // [-]
    fprintf(fptr, "14e KillEnd\n" );     // SHIFT [-]
    fprintf(fptr, "48e KillBeg\n" );     // CTRL [-]
//&>>&6 0 6 14
//&<<&        // Copying of chars
    fprintf(fptr,"03b CSave\n"      );  //  F1:            Ch
    fprintf(fptr,"154 CMove\n"      );  //  SHIFT-F1:      Ch
    fprintf(fptr,"268 WSave\n"      );  //  ALT-F1:        Wo
    fprintf(fptr,"368 WMove\n"      );  //  ALT-SHIFT-F1:  Wo
    fprintf(fptr,"668 BWord\n"      );  //  CTRL-ALT-F1
    fprintf(fptr,"768 BWord\n"      );  //  CTRL-SHIFT-ALT-F1
    fprintf(fptr,"45e TSave\n"      );  //  CTRL-F1:       Li
    fprintf(fptr,"55e TMove\n"      );  //  CTRL-SHIFT-F1: Li
    fprintf(fptr,"03c CRest\n"      );  //  F2: Clipboard =>
    fprintf(fptr,"155 CClear\n"     );  //  SHIFT-F2: Clear C
//&>>&6 0 6 1B
//&<<&        // Copying of lines
// Copying of lines
    fprintf(fptr, "03d LSave\n");  // F3:
    fprintf(fptr, "460 LTSave\n");  // CTRL-F3:
    fprintf(fptr, "156 LMove\n");  // SHIFT-F3:
    fprintf(fptr, "560 LTMove\n");  // CTRL-SHIFT-F3
    fprintf(fptr, "03e LRest\n");  // F4:
    fprintf(fptr, "157 LClear\n");  // SHIFT-F4:
//&>>&6 0 6 0
//&<<&        // Various types of exit
// Various types of exit

    fprintf(fptr,"001 Escape\n"); // ESC: temporary exit to DOS
    fprintf(fptr,"101 EscapeExec\n"); // SHIFT-ESC: execute current line
    fprintf(fptr,"26b EscapeExecLCB\n"); // ALT-F4: execute ClipBoard
//&>>&2 0 2 13
//&<<&        // Various switchings  (ins/ovr , alt key , status line .........)
    fprintf(fptr, "21c S_AutoIndent\n");   // ALT-ENTER    (on/off auto-indent)
    fprintf(fptr, "492 S_ModeIns\n");   // CTRL-INS (insert mode)
    fprintf(fptr, "493 S_ModeOvr\n");   // CTRL-DEL (overwrite mode)
    fprintf(fptr, "802 S_ACode1\n");   // CAPS+1 switch to QQ keyboard as alt
    fprintf(fptr, "803 S_ACode2\n");   // CAPS+2 switch to QJ keyboard as alt
    fprintf(fptr, "804 S_ACode3\n");   // CAPS+3 switch to  keyboard as alt
    fprintf(fptr, "41f S_StatusLine\n");   // Ctrl+'S' switch status line ON/OFF
    fprintf(fptr, "837 S_SearchMode\n");   // CAPS + "*\n"  search modes switching
//&>>&1 0 1 0
//&<<&        // Search & replace commands
    fprintf(fptr,"037 SearchFWD\n");       // "*\n" search forward
    fprintf(fptr,"137 SearchBCK\n");       // SHIFT+"*\n" search back
    fprintf(fptr,"237 Replace\n");       // ALT+"*\n" REPLACE
    fprintf(fptr,"496 SearchPage\n");       //  CTRL+"*\n"  switch into SearchPage
//&>>&3 0 3 13
        fprintf(fptr,"852 PageIns\n");    // CAPS+INS insert new page
        fprintf(fptr,"86f PageIns\n");    // CAPS+INS insert new page
//&<<&        // Marked Lines Commands

    fprintf(fptr,"848 MarkUp\n");  // CAPS+UP
    fprintf(fptr,"850 MarkDown\n");  // CAPS+DOWN
    fprintf(fptr,"c8d MarkTUp\n");  // CAPS+CTRL+UP
    fprintf(fptr,"c91 MarkTDown\n");  // CAPS+CTRL+DOWN
    fprintf(fptr,"948 MarkPUp\n");  // CAPS+SHIFT+UP
    fprintf(fptr,"950 MarkPDown\n");  // CAPS+SHIFT+DOWN

    fprintf(fptr,"03f MarkSaveB\n");  // F5 - push marked lines to stack
    fprintf(fptr,"040 MarkRestB\n");  // F6 - pop marked lines from stack

    fprintf(fptr,"c73 MarkLast\n");     // CAPS-CTRL-LEFT  : LastMarked();
    fprintf(fptr,"c74 MarkFirst\n");     // CAPS-CTRL-RIGHT

    fprintf(fptr,"84b MarkPrev\n");    // CAPS-Left
    fprintf(fptr,"84d MarkNext\n");    // CAPS-Right

    fprintf(fptr,"80e MarkBS\n");                   // CAPS-BS

//&>>&12 0 12 10
//&<<&        // Macros
    fprintf(fptr,"041 Macro\n");     // F7
    fprintf(fptr,"15a MacroRec\n");     // SHIFT+F7
//&>>&1 0 1 0
        }
//&>>&0 0 0 23
//&<<&    if(etype==0 || etype==1 || etype==2 || etype==3){
    if(etype==0 || etype==1 || etype==2 || etype==3){
//&<<&        digits/Letters/Delimiters

fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" ,  2  , 0x100+ 2 , 0x200+ 2 , 0x300+ 2  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" ,  3  , 0x100+ 3 , 0x200+ 3 , 0x300+ 3  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" ,  4  , 0x100+ 4 , 0x200+ 4 , 0x300+ 4  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" ,  5  , 0x100+ 5 , 0x200+ 5 , 0x300+ 5  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" ,  6  , 0x100+ 6 , 0x200+ 6 , 0x300+ 6  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" ,  7  , 0x100+ 7 , 0x200+ 7 , 0x300+ 7  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" ,  8  , 0x100+ 8 , 0x200+ 8 , 0x300+ 8  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" ,  9  , 0x100+ 9 , 0x200+ 9 , 0x300+ 9  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" , 10  , 0x100+10 , 0x200+10 , 0x300+10  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" , 11  , 0x100+11 , 0x200+11 , 0x300+11  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" , 12  , 0x100+12 , 0x200+12 , 0x300+12  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" , 13  , 0x100+13 , 0x200+13 , 0x300+13  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" , 41  , 0x100+41 , 0x200+41 , 0x300+41  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" , 43  , 0x100+43 , 0x200+43 , 0x300+43  );
fprintf( fptr, " %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n %0004x Ascii0\n" , 53  , 0x100+53 , 0x200+53 , 0x300+53  );

fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 16  , 0x100+16 , 0x200+16 , 0x300+16  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 17  , 0x100+17 , 0x200+17 , 0x300+17  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 18  , 0x100+18 , 0x200+18 , 0x300+18  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 19  , 0x100+19 , 0x200+19 , 0x300+19  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 20  , 0x100+20 , 0x200+20 , 0x300+20  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 21  , 0x100+21 , 0x200+21 , 0x300+21  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 22  , 0x100+22 , 0x200+22 , 0x300+22  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 23  , 0x100+23 , 0x200+23 , 0x300+23  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 24  , 0x100+24 , 0x200+24 , 0x300+24  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 25  , 0x100+25 , 0x200+25 , 0x300+25  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 30  , 0x100+30 , 0x200+30 , 0x300+30  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 31  , 0x100+31 , 0x200+31 , 0x300+31  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 32  , 0x100+32 , 0x200+32 , 0x300+32  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 33  , 0x100+33 , 0x200+33 , 0x300+33  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 34  , 0x100+34 , 0x200+34 , 0x300+34  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 35  , 0x100+35 , 0x200+35 , 0x300+35  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 36  , 0x100+36 , 0x200+36 , 0x300+36  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 37  , 0x100+37 , 0x200+37 , 0x300+37  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 38  , 0x100+38 , 0x200+38 , 0x300+38  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 44  , 0x100+44 , 0x200+44 , 0x300+44  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 45  , 0x100+45 , 0x200+45 , 0x300+45  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 46  , 0x100+46 , 0x200+46 , 0x300+46  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 47  , 0x100+47 , 0x200+47 , 0x300+47  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 48  , 0x100+48 , 0x200+48 , 0x300+48  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 49  , 0x100+49 , 0x200+49 , 0x300+49  );
fprintf( fptr, " %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n %0004x Ascii1\n" , 50  , 0x100+50 , 0x200+50 , 0x300+50  );

fprintf( fptr, " %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n" , 26  , 0x100+26 , 0x200+26 , 0x300+26  );
fprintf( fptr, " %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n" , 27  , 0x100+27 , 0x200+27 , 0x300+27  );
fprintf( fptr, " %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n" , 39  , 0x100+39 , 0x200+39 , 0x300+39  );
fprintf( fptr, " %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n" , 40  , 0x100+40 , 0x200+40 , 0x300+40  );
fprintf( fptr, " %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n" , 51  , 0x100+51 , 0x200+51 , 0x300+51  );
fprintf( fptr, " %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n %0004x Ascii2\n" , 52  , 0x100+52 , 0x200+52 , 0x300+52  );

fprintf( fptr, " %0004x Space \n %0004x Space \n %0004x Space \n %0004x Space \n" , 57  , 0x100+57 , 0x200+57 , 0x300+57  );

//&>>&0 0 0 E
        }
//&>>&1 0 1 4
//&<<&    if(etype==2){    //// Linux Console
    if(etype==2){    //// Linux Console
        fprintf(fptr, " 702 Console\n");
        fprintf(fptr, " 703 Console\n");
        fprintf(fptr, " 704 Console\n");
        fprintf(fptr, " 705 Console\n");
        fprintf(fptr, " 706 Console\n");
        fprintf(fptr, " 707 Console\n");
        fprintf(fptr, " 708 Console\n");
        fprintf(fptr, " 709 Console\n");
        }
//&>>&A 0 A 28
//&<<&    if(etype==4){  /// X11 R6
    if(etype==4){  /// X11 R6
        fprintf(fptr,"062 Up\n");
        fprintf(fptr,"068 Down\n");
        fprintf(fptr,"064 Left\n");
        fprintf(fptr,"066 Right\n");
        fprintf(fptr,"462 TUp\n");
        fprintf(fptr,"468 TDown\n");
        fprintf(fptr,"464 TLeft\n");
        fprintf(fptr,"466 TRight\n");
        fprintf(fptr,"162 PUp\n");
        fprintf(fptr,"168 PDown\n");
        fprintf(fptr,"164 PLeft\n");
        fprintf(fptr,"166 PRight\n");
        fprintf(fptr,"262 FUp\n");
        fprintf(fptr,"268 FDown\n");
        fprintf(fptr,"264 FLeft\n");
        fprintf(fptr,"266 FRight\n");
        fprintf(fptr,"024 Enter\n");
        fprintf(fptr,"124 REnter\n");
        fprintf(fptr,"017 Tab\n");
        fprintf(fptr,"117 LTab\n");
        fprintf(fptr,"06a InsCh\n");
        fprintf(fptr,"06b DelCh\n");
        fprintf(fptr,"16a InsLine\n");
        fprintf(fptr,"26a InsFold\n");
        fprintf(fptr,"16b DelLine\n");
        fprintf(fptr,"26b DelLine\n");
        fprintf(fptr,"043 CSave\n");
        fprintf(fptr,"143 CMove\n");
        fprintf(fptr,"243 WSave\n");
        fprintf(fptr,"343 WMove\n");
        fprintf(fptr,"643 BWord\n");
        fprintf(fptr,"743 BWord\n");
        fprintf(fptr,"443 TSave\n");
        fprintf(fptr,"543 TMove\n");
        fprintf(fptr,"044 CRest\n");
        fprintf(fptr,"144 CClear\n");
        fprintf(fptr,"045 LSave\n");
        fprintf(fptr,"445 LTSave\n");
        fprintf(fptr,"145 LMove\n");
        fprintf(fptr,"545 LTMove\n");
        fprintf(fptr,"046 LRest\n");
        fprintf(fptr,"146 LClear\n");
        fprintf(fptr,"009 Escape\n");
        fprintf(fptr,"109 EscapeExec\n");
        fprintf(fptr,"246 EscapeExecLCB\n");
        fprintf(fptr,"46a S_ModeIns\n");
        fprintf(fptr,"46b S_ModeOvr\n");
        fprintf(fptr,"224 S_AutoIndent\n");
        fprintf(fptr,"43f SearchPage\n");
        fprintf(fptr,"83f S_SearchMode\n");
        fprintf(fptr,"03f SearchFWD\n");
        fprintf(fptr,"13f SearchBCK\n");
        fprintf(fptr,"23f Replace\n");
        fprintf(fptr,"862 MarkUp\n");
        fprintf(fptr,"868 MarkDown\n");
        fprintf(fptr,"c62 MarkTUp\n");
        fprintf(fptr,"c68 MarkTDown\n");
        fprintf(fptr,"962 MarkPUp\n");
        fprintf(fptr,"968 MarkPDown\n");
        fprintf(fptr,"047 MarkSaveB\n");
        fprintf(fptr,"048 MarkRestB\n");
        fprintf(fptr,"016 BS\n");
        fprintf(fptr,"116 R_BS\n");
        fprintf(fptr,"056 KillWord\n");
        fprintf(fptr,"156 KillEnd\n");
        fprintf(fptr,"456 KillBeg\n");
        fprintf(fptr,"049 Macro\n");
        fprintf(fptr,"149 MacroRec\n");
                fprintf(fptr,"\n");
        fprintf(fptr,"80a S_ACode1\n");   // CAPS+1 switch to QQ keyboard as alt
        fprintf(fptr,"80b S_ACode2\n");   // CAPS+2 switch to QJ keyboard as alt
        fprintf(fptr,"80c S_ACode3\n");   // CAPS+3 switch to  keyboard as alt
        fprintf(fptr,"041 Space\n");
        fprintf(fptr,"141 Space\n");
        fprintf(fptr,"241 Space\n");
        fprintf(fptr,"341 Space\n");
                fprintf(fptr,"\n");
        fprintf(fptr,"00a Ascii0\n");
        fprintf(fptr,"00b Ascii0\n");
        fprintf(fptr,"00c Ascii0\n");
        fprintf(fptr,"00d Ascii0\n");
        fprintf(fptr,"00e Ascii0\n");
        fprintf(fptr,"00f Ascii0\n");
        fprintf(fptr,"010 Ascii0\n");
        fprintf(fptr,"011 Ascii0\n");
        fprintf(fptr,"012 Ascii0\n");
        fprintf(fptr,"013 Ascii0\n");
        fprintf(fptr,"10a Ascii0\n");
        fprintf(fptr,"10b Ascii0\n");
        fprintf(fptr,"10c Ascii0\n");
        fprintf(fptr,"10d Ascii0\n");
        fprintf(fptr,"10e Ascii0\n");
        fprintf(fptr,"10f Ascii0\n");
        fprintf(fptr,"110 Ascii0\n");
        fprintf(fptr,"111 Ascii0\n");
        fprintf(fptr,"112 Ascii0\n");
        fprintf(fptr,"113 Ascii0\n");
        fprintf(fptr,"20a Ascii0\n");
        fprintf(fptr,"20b Ascii0\n");
        fprintf(fptr,"20c Ascii0\n");
        fprintf(fptr,"20d Ascii0\n");
        fprintf(fptr,"20e Ascii0\n");
        fprintf(fptr,"20f Ascii0\n");
        fprintf(fptr,"210 Ascii0\n");
        fprintf(fptr,"211 Ascii0\n");
        fprintf(fptr,"212 Ascii0\n");
        fprintf(fptr,"213 Ascii0\n");
        fprintf(fptr,"30a Ascii0\n");
        fprintf(fptr,"30b Ascii0\n");
        fprintf(fptr,"30c Ascii0\n");
        fprintf(fptr,"30d Ascii0\n");
        fprintf(fptr,"30e Ascii0\n");
        fprintf(fptr,"30f Ascii0\n");
        fprintf(fptr,"310 Ascii0\n");
        fprintf(fptr,"311 Ascii0\n");
        fprintf(fptr,"312 Ascii0\n");
        fprintf(fptr,"313 Ascii0\n");
                fprintf(fptr,"\n");
        fprintf(fptr,"018 Ascii1\n");
        fprintf(fptr,"019 Ascii1\n");
        fprintf(fptr,"01a Ascii1\n");
        fprintf(fptr,"01b Ascii1\n");
        fprintf(fptr,"01c Ascii1\n");
        fprintf(fptr,"01d Ascii1\n");
        fprintf(fptr,"01e Ascii1\n");
        fprintf(fptr,"01f Ascii1\n");
        fprintf(fptr,"020 Ascii1\n");
        fprintf(fptr,"021 Ascii1\n");
        fprintf(fptr,"022 Ascii1\n");
        fprintf(fptr,"023 Ascii1\n");
        fprintf(fptr,"026 Ascii1\n");
        fprintf(fptr,"027 Ascii1\n");
        fprintf(fptr,"028 Ascii1\n");
        fprintf(fptr,"029 Ascii1\n");
        fprintf(fptr,"02a Ascii1\n");
        fprintf(fptr,"02b Ascii1\n");
        fprintf(fptr,"02c Ascii1\n");
        fprintf(fptr,"02d Ascii1\n");
        fprintf(fptr,"02e Ascii1\n");
        fprintf(fptr,"02f Ascii1\n");
        fprintf(fptr,"030 Ascii1\n");
        fprintf(fptr,"034 Ascii1\n");
        fprintf(fptr,"035 Ascii1\n");
        fprintf(fptr,"036 Ascii1\n");
        fprintf(fptr,"037 Ascii1\n");
        fprintf(fptr,"038 Ascii1\n");
        fprintf(fptr,"039 Ascii1\n");
        fprintf(fptr,"03a Ascii1\n");
        fprintf(fptr,"03b Ascii1\n");
        fprintf(fptr,"03c Ascii1\n");
        fprintf(fptr,"118 Ascii1\n");
        fprintf(fptr,"119 Ascii1\n");
        fprintf(fptr,"11a Ascii1\n");
        fprintf(fptr,"11b Ascii1\n");
        fprintf(fptr,"11c Ascii1\n");
        fprintf(fptr,"11d Ascii1\n");
        fprintf(fptr,"11e Ascii1\n");
        fprintf(fptr,"11f Ascii1\n");
        fprintf(fptr,"120 Ascii1\n");
        fprintf(fptr,"121 Ascii1\n");
        fprintf(fptr,"122 Ascii1\n");
        fprintf(fptr,"123 Ascii1\n");
        fprintf(fptr,"126 Ascii1\n");
        fprintf(fptr,"127 Ascii1\n");
        fprintf(fptr,"128 Ascii1\n");
        fprintf(fptr,"129 Ascii1\n");
        fprintf(fptr,"12a Ascii1\n");
        fprintf(fptr,"12b Ascii1\n");
        fprintf(fptr,"12c Ascii1\n");
        fprintf(fptr,"12d Ascii1\n");
        fprintf(fptr,"12e Ascii1\n");
        fprintf(fptr,"12f Ascii1\n");
        fprintf(fptr,"130 Ascii1\n");
        fprintf(fptr,"134 Ascii1\n");
        fprintf(fptr,"135 Ascii1\n");
        fprintf(fptr,"136 Ascii1\n");
        fprintf(fptr,"137 Ascii1\n");
        fprintf(fptr,"138 Ascii1\n");
        fprintf(fptr,"139 Ascii1\n");
        fprintf(fptr,"13a Ascii1\n");
        fprintf(fptr,"13b Ascii1\n");
        fprintf(fptr,"13c Ascii1\n");
        fprintf(fptr,"218 Ascii1\n");
        fprintf(fptr,"219 Ascii1\n");
        fprintf(fptr,"21a Ascii1\n");
        fprintf(fptr,"21b Ascii1\n");
        fprintf(fptr,"21c Ascii1\n");
        fprintf(fptr,"21d Ascii1\n");
        fprintf(fptr,"21e Ascii1\n");
        fprintf(fptr,"21f Ascii1\n");
        fprintf(fptr,"220 Ascii1\n");
        fprintf(fptr,"221 Ascii1\n");
        fprintf(fptr,"222 Ascii1\n");
        fprintf(fptr,"223 Ascii1\n");
        fprintf(fptr,"226 Ascii1\n");
        fprintf(fptr,"227 Ascii1\n");
        fprintf(fptr,"228 Ascii1\n");
        fprintf(fptr,"229 Ascii1\n");
        fprintf(fptr,"22a Ascii1\n");
        fprintf(fptr,"22b Ascii1\n");
        fprintf(fptr,"22c Ascii1\n");
        fprintf(fptr,"22d Ascii1\n");
        fprintf(fptr,"22e Ascii1\n");
        fprintf(fptr,"22f Ascii1\n");
        fprintf(fptr,"230 Ascii1\n");
        fprintf(fptr,"234 Ascii1\n");
        fprintf(fptr,"235 Ascii1\n");
        fprintf(fptr,"236 Ascii1\n");
        fprintf(fptr,"237 Ascii1\n");
        fprintf(fptr,"238 Ascii1\n");
        fprintf(fptr,"239 Ascii1\n");
        fprintf(fptr,"23a Ascii1\n");
        fprintf(fptr,"23b Ascii1\n");
        fprintf(fptr,"23c Ascii1\n");
        fprintf(fptr,"318 Ascii1\n");
        fprintf(fptr,"319 Ascii1\n");
        fprintf(fptr,"31a Ascii1\n");
        fprintf(fptr,"31b Ascii1\n");
        fprintf(fptr,"31c Ascii1\n");
        fprintf(fptr,"31d Ascii1\n");
        fprintf(fptr,"31e Ascii1\n");
        fprintf(fptr,"31f Ascii1\n");
        fprintf(fptr,"320 Ascii1\n");
        fprintf(fptr,"321 Ascii1\n");
        fprintf(fptr,"322 Ascii1\n");
        fprintf(fptr,"323 Ascii1\n");
        fprintf(fptr,"326 Ascii1\n");
        fprintf(fptr,"327 Ascii1\n");
        fprintf(fptr,"328 Ascii1\n");
        fprintf(fptr,"329 Ascii1\n");
        fprintf(fptr,"32a Ascii1\n");
        fprintf(fptr,"32b Ascii1\n");
        fprintf(fptr,"32c Ascii1\n");
        fprintf(fptr,"32d Ascii1\n");
        fprintf(fptr,"32e Ascii1\n");
        fprintf(fptr,"32f Ascii1\n");
        fprintf(fptr,"330 Ascii1\n");
        fprintf(fptr,"334 Ascii1\n");
        fprintf(fptr,"335 Ascii1\n");
        fprintf(fptr,"336 Ascii1\n");
        fprintf(fptr,"337 Ascii1\n");
        fprintf(fptr,"338 Ascii1\n");
        fprintf(fptr,"339 Ascii1\n");
        fprintf(fptr,"33a Ascii1\n");
        fprintf(fptr,"33b Ascii1\n");
        fprintf(fptr,"33c Ascii1\n");
        fprintf(fptr,"\n");
        fprintf(fptr,"014 Ascii2\n");
        fprintf(fptr,"015 Ascii2\n");
        fprintf(fptr,"031 Ascii2\n");
        fprintf(fptr,"033 Ascii2\n");
        fprintf(fptr,"03d Ascii2\n");
        fprintf(fptr,"114 Ascii2\n");
        fprintf(fptr,"115 Ascii2\n");
        fprintf(fptr,"131 Ascii2\n");
        fprintf(fptr,"133 Ascii2\n");
        fprintf(fptr,"13d Ascii2\n");
        fprintf(fptr,"214 Ascii2\n");
        fprintf(fptr,"215 Ascii2\n");
        fprintf(fptr,"231 Ascii2\n");
        fprintf(fptr,"233 Ascii2\n");
        fprintf(fptr,"23d Ascii2\n");
        fprintf(fptr,"314 Ascii2\n");
        fprintf(fptr,"315 Ascii2\n");
        fprintf(fptr,"331 Ascii2\n");
        fprintf(fptr,"333 Ascii2\n");
        fprintf(fptr,"33d Ascii2\n");
        }
//&>>&48 0 9 19
    fprintf(fptr,"&>>&0 0 0 0\n");
    }
//&>>&C 0 C 1A
//&<<&void putMacro(FILE *fptr);
void putMacro(FILE *fptr){
    fprintf(fptr,"&<<&*MACRO*\n");

//&<<&    fprintf(fptr,"&<<&Arithmetics & ...\n");
    fprintf(fptr,"&<<&Arithmetics & ...\n");
    fprintf(fptr,"proc add %03x mathop endp\n",MATHOP_ADD);
    fprintf(fptr,"proc sub %03x mathop endp\n",MATHOP_SUB);
    fprintf(fptr,"proc mul %03x mathop endp\n",MATHOP_MUL);
    fprintf(fptr,"proc div %03x mathop endp\n",MATHOP_DIV);
    fprintf(fptr,"proc mod %03x mathop endp\n",MATHOP_MOD);
    fprintf(fptr,"proc and %03x mathop endp\n",MATHOP_AND);
    fprintf(fptr,"proc or  %03x mathop endp\n",MATHOP_OR );
    fprintf(fptr,"proc xor %03x mathop endp\n",MATHOP_XOR);
    fprintf(fptr,"proc eq  %03x predicate endp\n",PREDICATE_EQ);
    fprintf(fptr,"proc ne  %03x predicate endp\n",PREDICATE_NE);
    fprintf(fptr,"proc lt  %03x predicate endp\n",PREDICATE_LT);
    fprintf(fptr,"proc gt  %03x predicate endp\n",PREDICATE_GT);
    fprintf(fptr,"&>>&0 0 0 0\n");
//&>>&C 0 C 1F
//&<<&    fprintf(fptr,"&<<&Definitions...\n");
    fprintf(fptr,"&<<&Definitions...\n");

    fprintf(fptr,"proc pushf   %03x push endp\n",PUSH_FLAG);
    fprintf(fptr,"proc pushl   %03x push endp\n",PUSH_CLINE_L);
    fprintf(fptr,"proc pushls  %03x push endp\n",PUSH_CLINE_S);
    fprintf(fptr,"proc pushc   %03x push endp\n",PUSH_CHAR);
    fprintf(fptr,"proc pushlcb %03x push endp\n",PUSH_LCB);
    fprintf(fptr,"proc pushccb %03x push endp\n",PUSH_CCB);

    fprintf(fptr,"proc cvtI2SH %03x convert endp\n", CONVERT_I2SH);
    fprintf(fptr,"proc cvtI2SD %03x convert endp\n", CONVERT_I2SD);
    fprintf(fptr,"proc cvtS2IH %03x convert endp\n", CONVERT_S2IH);
    fprintf(fptr,"proc cvtS2ID %03x convert endp\n", CONVERT_S2ID);
    fprintf(fptr,"proc cvtS2L  %03x convert endp\n", CONVERT_S2L );
    fprintf(fptr,"proc cvtL2S  %03x convert endp\n", CONVERT_L2S );
    fprintf(fptr,"proc cvtI2C  %03x convert endp\n", CONVERT_I2C );
    fprintf(fptr,"proc cvtC2I  %03x convert endp\n", CONVERT_C2I );


    fprintf(fptr,"&>>&0 0 0 0\n");
//&>>&4 0 4 0
//&<<&    fprintf(fptr,"&<<&Movement...\n");
    fprintf(fptr,"&<<&Movement...\n");
//&<<&    fprintf(fptr,"proc PRight\n");
    fprintf(fptr,"&<<&proc PRight\n");
    fprintf(fptr,"proc PRight\n");
    fprintf(fptr,"    pushc \' \' gt\n");
    fprintf(fptr,"    do\n");
    fprintf(fptr,"        Right\n");
    fprintf(fptr,"        pushc \' \' gt\n");
    fprintf(fptr,"    enddo\n");
    fprintf(fptr,"    pushc \' \' eq\n");
    fprintf(fptr,"    do\n");
    fprintf(fptr,"        Right\n");
    fprintf(fptr,"        pushc \' \' eq\n");
    fprintf(fptr,"    enddo\n");
    fprintf(fptr,"endp\n");
    fprintf(fptr,"&>>&0 0 0 0\n");
//&>>&0 0 0 0
//&<<&    fprintf(fptr,"proc PLeft\n");
    fprintf(fptr,"&<<&proc PLeft\n");
    fprintf(fptr,"proc PLeft\n");
    fprintf(fptr,"    pushc \' \' ne\n");
    fprintf(fptr,"    do\n");
    fprintf(fptr,"        Left\n");
    fprintf(fptr,"        pushc \' \' ne pushf\n");
    fprintf(fptr,"        %03x ioctl 0 gt pushf\n",IOCTL_CX);
    fprintf(fptr,"        and pop\n");
    fprintf(fptr,"    enddo\n");
    fprintf(fptr,"    pushc \' \' eq\n");
    fprintf(fptr,"    do\n");
    fprintf(fptr,"        Left\n");
    fprintf(fptr,"        pushc \' \' eq pushf\n");
    fprintf(fptr,"        %03x ioctl 0 gt pushf\n",IOCTL_CX);
    fprintf(fptr,"        and pop\n");
    fprintf(fptr,"    enddo\n");
    fprintf(fptr,"endp\n");
    fprintf(fptr,"&>>&0 0 0 0\n");
//&>>&12 0 12 1
    fprintf(fptr,"&>>&0 0 0 0\n");
//&>>&2 0 2 1A
//&<<&    fprintf(fptr,"&<<&Editing,killing...\n");
    fprintf(fptr,"&<<&Editing,killing...\n");
//&<<&    fprintf(fptr,"proc KillWord\n");
    fprintf(fptr,"&<<&proc KillWord\n");
    fprintf(fptr,"proc KillWord\n");
    fprintf(fptr,"    %03x ioctl if ret endif\n",IOCTL_ISMARKED);
    fprintf(fptr,"    BWord\n");
    fprintf(fptr,"    pushc \' \' gt\n");
    fprintf(fptr,"    do\n");
    fprintf(fptr,"        DelCh\n");
    fprintf(fptr,"        pushc \' \' gt\n");
    fprintf(fptr,"    enddo\n");
    fprintf(fptr,"    pushc \' \' eq\n");
    fprintf(fptr,"    do\n");
    fprintf(fptr,"        DelCh\n");
    fprintf(fptr,"        pushc \' \' eq\n");
    fprintf(fptr,"    enddo\n");
    fprintf(fptr,"endp\n");
    fprintf(fptr,"&>>&0 0 0 0\n");
//&>>&E 0 E 0
//&<<&    fprintf(fptr,"proc R_BS\n");
    fprintf(fptr,"&<<&proc R_BS\n");
    fprintf(fptr,"proc R_BS\n");
    fprintf(fptr,"    %03x ioctl if ret endif\n",IOCTL_ISMARKED);
    fprintf(fptr,"    %03x ioctl if ret endif\n",IOCTL_ISFOLD);
    fprintf(fptr,"    %03x ioctl 0 eq if ret endif\n",IOCTL_SY);
    fprintf(fptr,"    KillBeg\n");
    fprintf(fptr,"    pushls\n");
    fprintf(fptr,"    DelLine\n");
    fprintf(fptr,"    Up\n");
    fprintf(fptr,"    TRight\n");
    fprintf(fptr,"    %03x ioctl\n",IOCTL_CX);
    fprintf(fptr,"    swp\n");
    fprintf(fptr,"    pop\n");
    fprintf(fptr,"    dup %03x ioctl lt\n",IOCTL_CX);
    fprintf(fptr,"    do\n");
    fprintf(fptr,"        Left\n");
    fprintf(fptr,"        dup %03x ioctl lt\n",IOCTL_CX);
    fprintf(fptr,"    enddo\n");
    fprintf(fptr,"endp\n");
    fprintf(fptr,"&>>&0 0 0 0\n");
//&>>&7 0 7 1C
//&<<&    fprintf(fptr,"proc REnter\n");
    fprintf(fptr,"&<<&proc REnter\n");
    fprintf(fptr,"proc REnter\n");
    fprintf(fptr,"    007 ioctl if ret endif\n");
    fprintf(fptr,"    pushls\n");
    fprintf(fptr,"    KillEnd\n");
    fprintf(fptr,"    Down\n");
    fprintf(fptr,"    cvtS2L\n");
    fprintf(fptr,"    pop\n");
    fprintf(fptr,"    KillBeg\n");
    fprintf(fptr,"endp\n");
    fprintf(fptr,"&>>&0 0 0 0\n");
//&>>&B 0 B 0
    fprintf(fptr,"&>>&0 0 0 0\n");
//&>>&2 0 2 2A

    fprintf(fptr,"proc HelloWorld\n");
    fprintf(fptr,"    InsLine\n");
    fprintf(fptr,"    TLeft\n");
    fprintf(fptr,"    Tab Tab Tab Tab\n");
    fprintf(fptr,"    \"Hello World! \"\n");
    fprintf(fptr,"    pop\n");
    fprintf(fptr,"endp\n");

    fprintf(fptr,"&>>&0 0 0 0\n");
    }
//&>>&11 0 11 12

//&<<&void main(){          
int main(int argc,char **argv){
    FILE *fptr;
    if(argc>1) {
         printf("Editing file <%s>\n",argv[1]);
         fptr=fopen(argv[1],"w");
         }
//&<<&    else {
    else {
        char *env_home,*env_mmm;
        env_home=getenv("HOME");
        env_mmm=getenv("MMM");
        char *RunDir=new char[0x100]; if(RunDir==0)exit(1);
        strcpy(RunDir,env_home!=0?env_home:
                      env_mmm!=0 ?env_mmm :
#ifdef __linux__
                      "./");
        if(RunDir[strlen(RunDir)-1]!='/') strcat(RunDir,"/");
#else
                      ".\\");
        if(RunDir[strlen(RunDir)-1]!='\\') strcat(RunDir,"\\");
#endif
        strcat(RunDir,"mmm_base.cfg");
        printf("Editing file <%s>\n",RunDir);
        fptr=fopen(RunDir,"w");
        }
//&>>&10 0 10 C

    if(fptr==0) {
        printf("Cannot open output file\n");
        exit(-1);
        }

    putExtensions(fptr);
    putKeyboardLayouts(fptr);
    putSetup(fptr);
    putCommand(fptr);
    putMacro(fptr);
    return 0;
    }
//&>>&3 0 3 0
#if 0
//&<<&*MACRO*
//&<<&Arithmetics & ...
proc add 0 mathop endp
proc sub 1 mathop endp
proc mul 2 mathop endp
proc div 3 mathop endp
proc mod 4 mathop endp
proc and 5 mathop endp
proc or  6 mathop endp
proc xor 7 mathop endp

proc eq  0 predicate endp
proc ne  1 predicate endp
proc lt  2 predicate endp
proc gt  3 predicate endp
//&>>&C 0 C 15
//&<<&proc PrintString
proc PrintString
    4 convert Enter pop
endp
//&>>&1 0 1 9
//&<<&proc PrintInt
proc PrintInt
    dup
    0 convert
%    pop
    PrintString
endp
//&>>&2 0 2 5
//&<<&proc TestQuery
proc TestQuery
    query
    0 convert
    "type is:" pop
    pop
    "." pop
endp
//&>>&7 0 7 0
//&<<&proc TestSgetSput
proc TestSgetSput
    "push5"
    "push4"
    "push3"
    "push2"
    "push1"

    " !StrangeValue(for3)! " 3 sput
    1 sget pop
    2 sget pop
    3 sget pop
    4 sget pop
    5 sget pop
    %del del del del del
    pop pop pop pop pop
endp
//&>>&E 0 E 1
//&<<&proc TestIf
proc TestIf
    10 20 eq
    if
        "a = b" pop
    else
        "a != b" pop
    endif

    10 20 gt
    if
        "a > b" pop
    else
        "a < b" pop
    endif
endp
//&>>&8 0 8 0
//&<<&proc Test2Z
proc Test2Z
    dup 0 eq
    if
        "==0 " pop
    else
        dup 0 gt
        if
            ">0 " pop
        else
            "<0 " pop
        endif
    endif
endp
//&>>&3 0 3 0
//&<<&proc TestDo
proc TestDo
'a'
dup 'z' lt
do
    Down TLeft
    dup 6 convert pop % enumerate lines by letters a-z
    1 add
    dup 'z' lt
enddo

endp
//&>>&5 0 5 0
//&<<&proc TestIoctl
proc TestIoctl
    "typing mode :" pop  1 ioctl if "Ins" else "Ovr" endif          pop Enter
    "search :" pop  3 ioctl if "sensetive" else "insensetive" endif pop Enter
    "In Search Page :" pop  0a ioctl if "yes" else "no" endif       pop Enter
    "In Temp Page :" pop  0b ioctl if "yes" else "no" endif         pop Enter
    "Number Of lines:" pop 0c  ioctl 1 convert                      pop Enter
    "Number Of col-s:" pop 0d  ioctl 1 convert                      pop Enter
    "Line Number    :" pop 012 ioctl 1 convert                      pop Enter
    "cx=" pop     0e  ioctl  1 convert                              pop Enter
    "sx=" pop     0f  ioctl  1 convert                              pop Enter
    "sy=" pop     011 ioctl  1 convert                              pop Enter
endp
//&>>&2 0 2 0
//&<<&proc nPRight
proc nPRight
    4 push 20 gt
    do
        Right
        4 push 20 gt
    enddo

    4 push 20 eq
    do
        Right
        4 push
        4 push 20 eq
    enddo
endp
//&>>&0 0 0 0

proc HelloWorld
    nPRight
endp
//&>>&A 0 A 7
#endif
///// mmm_cfg.err mmm_cfg.err mmm_cfg.err mmm_cfg.err mmm_cfg.err
///// -a mmm.cfg mmm.cfg mmm.cfg mmm.cfg mmm.cfg
///// -a ../../mmm_base.cfg ../mmm.cfg ../mmm.cfg ../mmm.cfg ../mmm.cfg
//&>>&9 0 6 19
