//==========================================================================+
//|                                                                         |
//|    Card Game Toolkit(tm)                                                |
//|    Copyright (c) 1996 EverGreenSys Inc. All rights reserved.            |
//|                                                                         |
//|        file:   shufmain.c                                               |
//|        note:   ANSI C (except all int values MUST be 32-bit)            |
//|                                                                         |
//|      author:   D. Taylor (908) 935-1409                                 |
//|                Box 56, Rumson, N.J. 07760                               |
//|                dtaylor@monmouth.com                                     |
//|                                                                         |
//|--------------------------Comments---------------------------------------|
//|      This file contains a simple test and benchmarking program          |
//|    which exercises the fast single deck card shuffle and deal           |
//|    functions found in these files,                                      |
//|          shufflea.c                                                     |
//|          shufflex.asm                                                   |
//|      In order to plan for any detailed card studies you may be          |
//|    undertaking, you should have an idea how long a simulation           |
//|    run is likely to take. By compiling, linking and running this        |
//|    program you will get an estimate of the number of rounds (or         |
//|    hands) your PC can run per hour for these two approaches.            |
//|      This also illustrates multi-lingual programming and at             |
//|    least one approach for benchmarking that does not require            |
//|    tinkering with on-board chip settings.                               |
//|-------------------------------------------------------------------------|
//|      This is NOT public domain software. It is fully copyrighted        |
//|    and made available to you to evaluate for 90 days. You may NOT       |
//|    re-distribute the source code or any compiled version of the         |
//|    source code for any purpose without prior permission of the          |
//|    author. If you register this shareware, however, you will            |
//|    receive an extended license for its use and other related            |
//|    materials.                                                           |
//|      See the register.txt file for details.                             |
//+-------------------------------------------------------------------------+
//
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <math.h>

extern void shuffleA(void);            // points to ->  shufflea.c
extern unsigned int cardsA[28]; 

extern void cdecl shuffleX(void);      // points to ->  shufflex.asm
extern unsigned int cdecl cardsX[28];
//  ------------------------------------------------------------
//  printCARD()
//    This function illustrates how card id numbers 1-52 could
//    be interpreted in your program. It is used here to show
//    the contents of one round each from the C and Assembly
//    language versions of 1-deck shufflers contained in
//    shufflea.c and shufflex.asm
//  ------------------------------------------------------------
void printCARD( int n ) {
  switch( n ) {
    case  1: case  2: case  3: case  4: printf("A"); break;
    case  5: case  6: case  7: case  8: printf("K"); break;
    case  9: case 10: case 11: case 12: printf("Q"); break;
    case 13: case 14: case 15: case 16: printf("J"); break;
    case 17: case 18: case 19: case 20: printf("T"); break;
    case 21: case 22: case 23: case 24: printf("9"); break;
    case 25: case 26: case 27: case 28: printf("8"); break;
    case 29: case 30: case 31: case 32: printf("7"); break;
    case 33: case 34: case 35: case 36: printf("6"); break;
    case 37: case 38: case 39: case 40: printf("5"); break;
    case 41: case 42: case 43: case 44: printf("4"); break;
    case 45: case 46: case 47: case 48: printf("3"); break;
    case 49: case 50: case 51: case 52: printf("2"); break;
    default: printf("ERROR"); break; }

  if( n==1||n==5||n==9||n==13||n==17||n==21||n==25||n==29 ) printf("s");
  if( n==33||n==37||n==41||n==45||n==49 )                   printf("s");
  if( n==2||n==6||n==10||n==14||n==18||n==22||n==26||n==30) printf("h");
  if( n==34||n==38||n==42||n==46||n==50 )                   printf("h");
  if( n==3||n==7||n==11||n==15||n==19||n==23||n==27||n==31) printf("d");
  if( n==35||n==39||n==43||n==47||n==51 )                   printf("d");
  if( n==4||n==8||n==12||n==16||n==20||n==24||n==28||n==32) printf("c");
  if( n==36||n==40||n==44||n==48||n==52 )                   printf("c");
}
//  ------------------------------------------------------------------
//  main()
//    This is a simple test and benchmarking program in
//    the context of a Texas Hold'em poker game.
//    It directly compares the execution times of the C 
//    and Assembly language versions of the 1-deck shuffler 
//    contained in files, shufflea.c and shufflex.asm.
//    You should first assembly the shufflex.asm file using
//    either tasm, masm or wasm. Then compile and link this
//    file with shufflea.c and shufflex.obj to create the
//    executable. You may do this with either Borland C/C++
//    version 4.5, Visual C/C++ if you're running Windows NT
//    or Watcom C/C++ 10.5. In Watcom C/C++, for example,
//    if you have a Pentium, you might try,
//      wcl386 /oneatx /zp4 /5 /fp5 shufmain.c shufflea.c shufflex.obj
//    Depending on your compiler and operating environment, 
//    the assembly language version should be about 1.2 up 
//    to 10 times faster than the C version.
//  ------------------------------------------------------------------
void main() {
  int j,k;
  double seconds,minutes,hours,period,persec,countA,countC;
  clock_t start_time,end_time;
    persec=CLOCKS_PER_SEC;
    printf("\n");
    
    //  shufflea.c
    
    printf("[1] Shuffle Tree in C\n");
    printf("    shuffleA();\n");
    shuffleA();
    printf("Player ");
    for(j=1;j<=11;j++) printf("%3d",j);
    printf("\n");
    printf("Pocket ");
    for(j=1;j<=11;j++)   { printf(" "); k=cardsA[j]; printCARD(k); }
    printf("\n");
    printf("       ");
    for(j=12;j<=22;j++)   { printf(" "); k=cardsA[j]; printCARD(k); }
    printf("\n");
    printf("Flop   ");      
    for(j=23;j<=25;j++)  { printf(" "); k=cardsA[j]; printCARD(k); }
    printf("\n");
    { printf("Turn    "); k=cardsA[26]; printCARD(k); }
    printf("\n");
    { printf("River   "); k=cardsA[27]; printCARD(k); }
    printf("\n\n");

    start_time=clock();
    for(j=1;j<=100000;j++) shuffleA();
    end_time=clock();
    countA=100000.0;
    period=(end_time-start_time)+1;
    seconds=(period/persec);
    minutes=(seconds/60.0);
    hours=(minutes/60.0);
    countC=(60.0/minutes)*countA;
    printf("shuffleA() deals %.1f rounds per hour\n",
      countC);
    
    //  shufflex.asm

    printf("\n");
    printf("[2] Shuffle Tree in Assembly Language\n");
    printf("    shuffleX();\n");
    shuffleX();
    printf("Player ");
    for(j=1;j<=11;j++) printf("%3d",j);
    printf("\n");
    printf("Pocket ");
    for(j=1;j<=11;j++)   { printf(" "); k=cardsX[j]; printCARD(k); }
    printf("\n");
    printf("       ");
    for(j=12;j<=22;j++)   { printf(" "); k=cardsX[j]; printCARD(k); }
    printf("\n");
    printf("Flop   ");      
    for(j=23;j<=25;j++)  { printf(" "); k=cardsX[j]; printCARD(k); }
    printf("\n");
    { printf("Turn    "); k=cardsX[26]; printCARD(k); }
    printf("\n");
    { printf("River   "); k=cardsX[27]; printCARD(k); }
    printf("\n\n");
    
    start_time=clock();
    for(j=1;j<=100000;j++) shuffleX();
    end_time=clock();
    countA=100000.0;
    period=(end_time-start_time)+1;
    seconds=(period/persec);
    minutes=(seconds/60.0);
    hours=(minutes/60.0);
    countC=(60.0/minutes)*countA;
    printf("shuffleX() deals %.1f rounds per hour\n",
      countC);
}
