;/==========================================================================+
;/|                                                                         |
;/|    Card Game Toolkit(tm)                                                |
;/|    Copyright (c) 1996, EverGreenSys Inc. All rights reserved.           |
;/|                                                                         |
;/|        file:   shufflex.asm                                             |
;/|        call:   shufflex();   (from C)                                   |
;/|     returns:   cards dealt in cardsX[]                                  |
;/|        note:   Assemble using either tasm, masm or wasm                 |
;/|                                                                         |
;/|      author:   D. Taylor (908) 935-1409                                 |
;/|                Box 56, Rumson, N.J. 07760                               |
;/|                dtaylor@monmouth.com                                     |
;/|                                                                         |
;/|-------------------------Comments----------------------------------------|
;/|      A general purpose shuffle and deal function for any card game      |
;/|    that uses a single deck of 52 playing cards.                         |
;/|      This version is configured by constants to deal a complete round   |
;/|    of play for the poker game known as Texas Hold'em. Here we provide   |
;/|    for 11 players. In this game each player starts with 2 cards dealt   |
;/|    face down, followed by 5 community cards dealt face up. A round      |
;/|    of play consists therefore of 2 x 11 + 5 = 27 cards. To change       |
;/|    the number of players, simply change the number of dwords reserved   |
;/|    for cardsX[] and the constant loaded into <eax> at the beginning     |
;/|    of the shuffle tree loop according to the formula above. To change   |
;/|    the game, simply figure out how many cards need to be dealt and      |
;/|    substitute those values.                                             |
;/|      After dealing a complete round of play, the function returns       |
;/|    with < cardsX[] > containing the index values for each card          |
;/|    dealt in slots 1-27, in this example. Card index values are always   |
;/|    1 to 52. You may assign real card identities to these as you wish.   |
;/|      Each time the function is invoked it returns a new shuffle and     |
;/|    round.                                                               |
;/|      We tested this function on tasm and wasm (which is believed to     |
;/|    provide a subset of masm) on a Pentium-S/133. It shuffled and        |
;/|    dealt an average of 290 million rounds (that's 3.19 billion          |
;/|    hands!) per hour.                                                    |
;/|      A static binary decision tree is defined. Each card is dealt       |
;/|    by traversing the tree guided by a primitive polynomials modulo 2    |
;/|    algorithm that randomly selects each branch. The random bit          |
;/|    generator built into the tree is believed to yield approximately     |
;/|    (2^30)x(2^30) unique shuffle sequences before it repeats, which      |
;/|    is much longer than the period for any known numeric random          |
;/|    number generator. Also, the algorithm as configured here passed      |
;/|    all of our spectral tests of 'randomness' more robustly than any     |
;/|    numeric random number generator we tested.                           |
;/|      This assembly language implementation of a 1-deck shuffle tree     |
;/|    has been hand optimized for the Pentium-S u/v pipelines.             |
;/|-------------------------------------------------------------------------|
;/|      This is NOT public domain software. It is fully copyrighted        |
;/|    and made available for you to evaluate for 90 days. You may NOT      |
;/|    re-distribute the source code or any compiled version of the         |
;/|    source code for any purpose without prior permission of the          |
;/|    author. If you register this shareware, however, you will receive    |
;/|    an extended license for its use and other related materials.         |
;/|      See the register.txt file for details.                             |
;/+-------------------------------------------------------------------------+
;/
    .586p
    .model flat
    .stack 8192
    
    .data
    public _cardsX

seedEAX  dd 00101010111101011011100001010101B
seedEBX  dd 10010001010101100000101011101010B
_cardsX  dd 28 dup(0)                  ; <- change this for different games

    .code
    assume cs:flat,ds:flat,ss:flat

    public _shufflex
_shufflex proc near    
    push ebp        
    mov  ebp,esp
    push ebx
    push esi
    push edi
       ;  Registers Used:  
       ;    <eax><ebx>          - dynamic random number seeds
       ;    <ecx,edx>           - bit record of cards already dealt
    mov  ecx,0        ; Start Cumulative Record Clean
    mov  edx,0           
    mov  edi,0        ; <= edi is the nth card index 
    mov  eax,28       ; loop counter
    mov  ebx,[seedEBX] 
;======================= loop control =======================================    
  @aroot:  
    push eax             ; LOOP counter           
    mov  eax,[seedEAX]    
;======================= body of shuffle tree ===============================    
  @root:                 ; root of the binary decision tree
    test eax,01000000000000000000000000000000B     
    jnz  @R                                       
; @L:                    
    shl  eax,1                                     
    test ebx,01000000000000000000000000000000B     
    jnz  @LR
; @LL:                   
    shl  ebx,1
    test eax,01000000000000000000000000000000B
    jnz  @LLR
; @LLL:                  
    shl  eax,1                                     
    test ebx,01000000000000000000000000000000B 
    jnz  @LLLR
; @LLLL:                 
    shl  ebx,1            
    test eax,01000000000000000000000000000000B
    jnz  @LLLLR
; @LLLLL:                
    shl  eax,1                                     
    test ebx,01000000000000000000000000000000B
    jnz  @C2

; @C1:                   ; Card 1 .. Ace spades
    test ecx,10000000000000000000000000000000B  ; u cycle 1 
    jnz  @root           ; already picked       ; v cycle 1 
    shl  ebx,1                                  ; u cycle 2 
    or   ecx,10000000000000000000000000000000B  ; v cycle 2 
    mov  esi,1                                  ; u cycle 3
    jmp  @ok                                    ; v cycle 3
    
  @C2:                   ; Card 2 .. Ace hearts
    test ecx,01000000000000000000000000000000B  ; u cycle 1   
    jnz  @root           ; already dealt        ; v cycle 1    
    xor  ebx,00000000000000000000000001010010B  ; u cycle 2   
    mov  esi,2                                  ; v cycle 2
    shl  ebx,1                                  ; u cycle 3   
    or   ecx,01000000000000000000000000000000B  ; v cycle 3        
    or   ebx,00000000000000000000000000000001B  ; u cycle 4   
    jmp  @ok                                    ; v cycle 4
    
  @LLLLR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C4

; @C3:                   ; Card 3 .. Ace diamonds
    test ecx,00100000000000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00100000000000000000000000000000B    
    mov  esi,3  
    jmp  @ok
    
  @C4:                   ; Card 4 .. Ace clubs
    test ecx,00010000000000000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,4
    shl  ebx,1
    or   ecx,00010000000000000000000000000000B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LLLR:
    xor  ebx,00000000000000000000000001010010B 
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    test eax,01000000000000000000000000000000B 
    jnz  @LLLRR

; @LLLRL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C6

; @C5:                   ; Card 5 .. King spades
    test ecx,00001000000000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00001000000000000000000000000000B    
    mov  esi,5
    jmp  @ok

  @C6:                   ; Card 6 .. King hearts
    test ecx,00000100000000000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,6 
    shl  ebx,1
    or   ecx,00000100000000000000000000000000B   
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LLLRR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C8

; @C7:                   ; Card 7 .. King diamonds
    test ecx,00000010000000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000010000000000000000000000000B    
    mov  esi,7
    jmp  @ok
  
  @C8:                   ; Card 8 .. King clubs
    test ecx,00000001000000000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,8 
    shl  ebx,1
    or   ecx,00000001000000000000000000000000B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok
      
  @LLR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B
    jnz  @LLRR

; @LLRL:
    shl  ebx,1
    test eax,01000000000000000000000000000000B
    jnz  @LLRLR

; @LLRLL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C10

; @C9:                   ; Card 9 .. Queen spades
    test ecx,00000000100000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000100000000000000000000000B    
    mov  esi,9
    jmp  @ok
      
  @C10:                  ; Card 10 .. Queen hearts
    test ecx,00000000010000000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,10 
    shl  ebx,1
    or   ecx,00000000010000000000000000000000B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok
  
  @LLRLR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C12

; @C11:                  ; Card 11 .. Queen diamonds
    test ecx,00000000001000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000001000000000000000000000B    
    mov  esi,11
    jmp  @ok
  
  @C12:                  ; Card 12 .. Queen clubs
    test ecx,00000000000100000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,12
    shl  ebx,1
    or   ecx,00000000000100000000000000000000B   
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LLRR:
    xor  ebx,00000000000000000000000001010010B 
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    test eax,01000000000000000000000000000000B 
    jnz  @LLRRR

; @LLRRL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C14

; @C13:                  ; Card 13 .. Jack spades
    test ecx,00000000000010000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000010000000000000000000B    
    mov  esi,13
    jmp  @ok

  @C14:                  ; Card 14 .. Jack hearts
    test ecx,00000000000001000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,14
    shl  ebx,1
    or   ecx,00000000000001000000000000000000B  
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LLRRR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C16

; @C15:                  ; Card 15 .. Jack diamonds
    test ecx,00000000000000100000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000000100000000000000000B    
    mov  esi,15
    jmp  @ok

  @C16:                  ; Card 16 .. Jack clubs
    test ecx,00000000000000010000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,16
    shl  ebx,1
    or   ecx,00000000000000010000000000000000B   
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LR:
    xor  ebx,00000000000000000000000001010010B 
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    test eax,01000000000000000000000000000000B 
    jnz  @LRR

; @LRL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B 
    jnz  @LRLR

; @LRLL:
    shl  ebx,1
    test eax,01000000000000000000000000000000B
    jnz  @LRLLR

; @LRLLL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C18

; @C17:                  ; Card 17 .. Ten spades
    test ecx,00000000000000001000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000000001000000000000000B    
    mov  esi,17
    jmp  @ok

  @C18:                  ; Card 18 .. Ten hearts
    test ecx,00000000000000000100000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,18 
    shl  ebx,1
    or   ecx,00000000000000000100000000000000B  
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LRLLR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C20

; @C19:                  ; Card 19 .. Ten diamonds
    test ecx,00000000000000000010000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000000000010000000000000B    
    mov  esi,19
    jmp  @ok

  @C20:                  ; Card 20 .. Ten clubs
    test ecx,00000000000000000001000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,20 
    shl  ebx,1
    or   ecx,00000000000000000001000000000000B  
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LRLR:
    xor  ebx,00000000000000000000000001010010B 
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    test eax,01000000000000000000000000000000B 
    jnz  @LRLRR

; @LRLRL:
    shl  eax,1
    
    test ebx,01000000000000000000000000000000B
    jnz  @C22

; @C21:                  ; Card 21 .. 9 spades
    test ecx,00000000000000000000100000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000000000000100000000000B    
    mov  esi,21
    jmp  @ok

  @C22:                  ; Card 22 .. 9 hearts
    test ecx,00000000000000000000010000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,22 
    shl  ebx,1
    or   ecx,00000000000000000000010000000000B     
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LRLRR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C24

; @C23:                  ; Card 23 .. 9 diamonds
    test ecx,00000000000000000000001000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000000000000001000000000B    
    mov  esi,23
    jmp  @ok

  @C24:                  ; Card 24 .. 9 clubs
    test ecx,00000000000000000000000100000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,24 
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    or   ecx,00000000000000000000000100000000B    
    jmp  @ok

  @LRR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B  
    jnz  @LRRR

; @LRRL:
    shl  ebx,1
    test eax,01000000000000000000000000000000B
    jnz  @LRRLR

; @LRRLL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C26

; @C25:                  ; Card 25 .. 8 spades
    test ecx,00000000000000000000000010000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000000000000000010000000B    
    mov  esi,25
    jmp  @ok
    
  @C26:                  ; Card 26 .. 8 hearts
    test ecx,00000000000000000000000001000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,26
    shl  ebx,1
    or   ecx,00000000000000000000000001000000B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LRRLR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C28

; @C27:                  ; Card 27 .. 8 diamonds
    test ecx,00000000000000000000000000100000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000000000000000000100000B    
    mov  esi,27
    jmp  @ok

  @C28:                  ; Card 28 .. 8 clubs
    test ecx,00000000000000000000000000010000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,28  
    shl  ebx,1
    or   ecx,00000000000000000000000000010000B   
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LRRR:
    xor  ebx,00000000000000000000000001010010B 
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    test eax,01000000000000000000000000000000B 
    jnz  @LRRRR

; @LRRRL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C30

; @C29:                  ; Card 29 .. 7 spades
    test ecx,00000000000000000000000000001000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000000000000000000001000B    
    mov  esi,29
    jmp  @ok

  @C30:                  ; Card 30 .. 7 hearts
    test ecx,00000000000000000000000000000100B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,30
    shl  ebx,1
    or   ecx,00000000000000000000000000000100B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @LRRRR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C32

; @C31:                  ; Card 31 .. 7 diamonds
    test ecx,00000000000000000000000000000010B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   ecx,00000000000000000000000000000010B    
    mov  esi,31
    jmp  @ok

  @C32:                  ; Card 32 .. 7 clubs
    test ecx,00000000000000000000000000000001B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,32 
    shl  ebx,1
    or   ecx,00000000000000000000000000000001B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok
  
  @R:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @RR

; @RL:
    shl  ebx,1
    test eax,01000000000000000000000000000000B
    jnz  @RLR

; @RLL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B 
    jnz  @RLLR

; @RLLL:
    shl  ebx,1
    test eax,01000000000000000000000000000000B
    jnz  @RLLLR

; @RLLLL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C34

; @C33:                  ; Card 33 .. 6 spades
    test edx,10000000000000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,10000000000000000000000000000000B    
    mov  esi,33
    jmp  @ok

  @C34:                  ; Card 34 .. 6 hearts
    test edx,01000000000000000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,34 
    shl  ebx,1
    or   edx,01000000000000000000000000000000B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @RLLLR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C36

; @C35:                  ; Card 35 .. 6 diamonds
    test edx,00100000000000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,00100000000000000000000000000000B    
    mov  esi,35
    jmp  @ok

  @C36:                  ; Card 36 .. 6 clubs 
    test edx,00010000000000000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,36   
    shl  ebx,1
    or   edx,00010000000000000000000000000000B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok
 
  @RLLR:
    xor  ebx,00000000000000000000000001010010B 
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    test eax,01000000000000000000000000000000B 
    jnz  @RLLRR

; @RLLRL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C38

; @C37:                  ; Card 37 .. 5 spades
    test edx,00001000000000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,00001000000000000000000000000000B    
    mov  esi,37
    jmp  @ok

  @C38:                  ; Card 38 .. 5 hearts
    test edx,00000100000000000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,38 
    shl  ebx,1
    or   edx,00000100000000000000000000000000B  
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @RLLRR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C40

; @C39:                  ; Card 39 .. 5 diamonds
    test edx,00000010000000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,00000010000000000000000000000000B    
    mov  esi,39
    jmp  @ok

  @C40:                  ; Card 40 .. 5 clubs
    test edx,00000001000000000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,40
    shl  ebx,1
    or   edx,00000001000000000000000000000000B  
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @RLR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B  
    jnz  @RLRR

; @RLRL:
    shl  ebx,1
    test eax,01000000000000000000000000000000B
    jnz  @RLRLR

; @RLRLL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C42

; @C41:                  ; Card 41 .. 4 spades
    test edx,00000000100000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,00000000100000000000000000000000B    
    mov  esi,41
    jmp  @ok

  @C42:                  ; Card 42 .. 4 hearts
    test edx,00000000010000000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,42
    shl  ebx,1
    or   edx,00000000010000000000000000000000B   
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @RLRLR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C44

; @C43:                  ; Card 43 .. 4 diamonds
    test edx,00000000001000000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,00000000001000000000000000000000B    
    mov  esi,43
    jmp  @ok

  @C44:                  ; Card 44 .. 4 clubs
    test edx,00000000000100000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,44  
    shl  ebx,1
    or   edx,00000000000100000000000000000000B      
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @RLRR:
    xor  ebx,00000000000000000000000001010010B 
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    test eax,01000000000000000000000000000000B 
    jnz  @RLRRR

; @RLRRL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C46

; @C45:                  ; Card 45 .. 3 spades
    test edx,00000000000010000000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,00000000000010000000000000000000B    
    mov  esi,45
    jmp  @ok

  @C46:                  ; Card 46 .. 3 hearts
    test edx,00000000000001000000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,46  
    shl  ebx,1
    or   edx,00000000000001000000000000000000B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @RLRRR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C48

; @C47:                  ; Card 47 .. 3 diamonds
    test edx,00000000000000100000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,00000000000000100000000000000000B    
    mov  esi,47
    jmp  @ok

  @C48:                  ; Card 48 .. 3 clubs
    test edx,00000000000000010000000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,48
    shl  ebx,1
    or   edx,00000000000000010000000000000000B    
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @RR:
    xor  ebx,00000000000000000000000001010010B 
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    test eax,01000000000000000000000000000000B 
    jz   @RRL
    xor  eax,00000000000000000000000001010010B  
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    jmp  @root           ; empty branch
  
  @RRL:  
    shl  eax,1
    test ebx,01000000000000000000000000000000B      
    jz   @RRLL
    xor  ebx,00000000000000000000000001010010B  
    shl  ebx,1
    or   ebx,00000000000000000000000000000001B
    jmp  @root           ; empty branch
  
  @RRLL:
    shl  ebx,1
    test eax,01000000000000000000000000000000B
    jnz  @RRLLR

; @RRLLL:
    shl  eax,1
    test ebx,01000000000000000000000000000000B
    jnz  @C50

; @C49:                  ; Card 49 .. 2 spades
    test edx,00000000000000001000000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,00000000000000001000000000000000B    
    mov  esi,49
    jmp  @ok

  @C50:                  ; Card 50 .. 2 hearts
    test edx,00000000000000000100000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,50 
    shl  ebx,1
    or   edx,00000000000000000100000000000000B    
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @RRLLR:
    xor  eax,00000000000000000000000001010010B 
    shl  eax,1
    or   eax,00000000000000000000000000000001B
    test ebx,01000000000000000000000000000000B 
    jnz  @C52

; @C51:                  ; Card 51 .. 2 diamonds
    test edx,00000000000000000010000000000000B                 
    jnz  @root           ; already dealt
    shl  ebx,1
    or   edx,00000000000000000010000000000000B    
    mov  esi,51
    jmp  @ok

  @C52:                  ; Card 52 .. 2 _clubs
    test edx,00000000000000000001000000000000B                 
    jnz  @root           ; already dealt
    xor  ebx,00000000000000000000000001010010B 
    mov  esi,52 
    shl  ebx,1
    or   edx,00000000000000000001000000000000B 
    or   ebx,00000000000000000000000000000001B
    jmp  @ok

  @ok:    
    mov  _cardsX[edi*4],esi  
    mov  [seedEAX],eax   ; save this seed value
    inc  edi             ; increment the card index pointer  
    pop  eax             ; update counter
    sub  eax,1
    jnz  @aroot          ; do it again if necessary
    
    pop  edi             ; otherwise, we're done
    pop  esi
    pop  ebx
    cld
    pop  ebp
    ret

_shufflex endp    
    END

