//+=========================================================================+
//|                                                                         |
//|    Card Game Toolkit(tm)                                                |
//|    Copyright (c) 1996, EverGreenSys Inc. All rights reserved.           |
//|                                                                         |
//|        file:   shuffleb.c                                               |
//|        call:   shuffleb();                                              |
//|     returns:   cards dealt in cardsB[]                                  |
//|        note:   ANSI C (except all int values MUST be 32-bit)            |
//|                                                                         |
//|      author:   D. Taylor (908) 935-1409                                 |
//|                Box 56, Rumson, N.J. 07760                               |
//|                dtaylor@monmouth.com                                     |
//|                                                                         |
//|-------------------------------Comments----------------------------------|
//|      A general purpose shuffle and deal function for any card game      |
//|    that either uses more than 1 deck of playing cards, or where the     |
//|    number of cards dealt depends upon either a player decision          |
//|    (such as draw poker) or on point counts of cards already dealt       |
//|    (such as baccarat), or on both (such as blackjack).                  |
//|      To configure this shuffle tree for your game of interest, you      |
//|    need to                                                              |
//|        1. specify how many decks of cards are in a shoe, the            |
//|           maximum number of cards the game would ever require in        |
//|           a single call, and the point in the shoe at which the         |
//|           house would require a re-shuffle.                             |
//|               #define NDECKS         8                                  |
//|               #define MAXCARDSWANTED 4                                  |
//|               #define SHUFFLEPOINT   26                                 |
//|           for example defines an 8-deck shoe where, except for the      |
//|           starting hands, cards are dealt one at a time followed        |
//|           by a game-specific table look-up to determine whether         |
//|           the hand is complete or not, and there would be an            |
//|           automatic new shuffle and shoe created whenever at the        |
//|           end of a request for cards there were 26 or fewer cards       |
//|           left in the shoe (as in baccarat).                            |
//|        2. initialize the shoe, by invoking                              |
//|               newSHOE();                                                |
//|        3. then, under the control of your game program, request         |
//|           a piece-meal deal by first setting the global variable        |
//|           and invoking the function, such as                            |
//|               cardswanted=4;                                            |
//|               shuffleb();                                               |
//|           which would deal the starting hands for Player and Banker     |
//|           in baccarat.                                                  |
//|        4. at the next step, depending on count, a single card           |
//|           would be dealt, so that the sequence would be                 |
//|               cardswanted=1;                                            |
//|               shuffleb();                                               |
//|           and so on, until a decision on the hand was reached.          |
//|        5. After one such hand the same shoe is used to then deal        |
//|           the next hand, until either the shuffle point was reached     |
//|           or your game program returned to step 2 (above).              |
//|      The function returns with < cardsB[] > containing the index        |
//|    value(s) for each card dealt in slots 1-cardswanted. Card index      |
//|    values are always 1 to 52. You may assign real card identities       |
//|      A static binary decision tree is defined. Each card is dealt       |
//|    by traversing the tree guided by a primitive polynomials modulo 2    |
//|    algorithm that randomly selects each branch. The random bit          |
//|    generator built into the tree is believed to yield approximately     |
//|    (2^30)x(2^30)x(2^30) unique shuffle sequences before it repeats,     |
//|    which is much longer than the period for any known 32-bit or         |
//|    less numeric random number generator. Also, the algorithm as         |
//|    configured here passed all of our spectral tests of 'randomness'     |
//|    more robustly than any numeric random number generator we tested.    |                       
//|-------------------------------------------------------------------------|
//|      This is NOT public domain software. It is fully copyrighted        |
//|    and made available for you to evaluate for 90 days. You may NOT      |
//|    re-distribute the source code or any compiled version of the         |
//|    source code for any purpose without prior permission of the          |
//|    author. If you register this shareware, however, you will receive    |
//|    an extended license for its use and other related materials.         |
//|      See the register.txt file for details.                             |                                
//+=========================================================================+
//

#define NDECKS         8
#define MAXCARDSWANTED 20
#define SHUFFLEPOINT   26
#define MTEST          000000000122  // these are critical octal constants
#define CHECK          010000000000  // do not modify

unsigned int seed1=05275334125;      // These seeds may be initialized
unsigned int seed2=02176635312;      // to any non-zero value.
unsigned int seed3=01166442233;

unsigned int cardsB[MAXCARDSWANTED+1];
unsigned int shoe[53];

int cardsleft;               //  declare this->  extern int cardsleft;
int cardswanted;             //  declare this->  extern int cardswanted;

void newSHOE() { int j; 
  for(j=1;j<=52;j++) shoe[j]=NDECKS; 
  cardsleft=NDECKS*52; }

int test1() {
  if(seed1&CHECK) { seed1=((seed1^MTEST)<<1)|01; return 1; }
  seed1=seed1<<1; 
  return 0; }
int test2() {
  if(seed2&CHECK) { seed2=((seed2^MTEST)<<1)|01; return 1; }
  seed2=seed2<<1; 
  return 0; }
int test3() {
  if(seed3&CHECK) { seed3=((seed3^MTEST)<<1)|01; return 1; }
  seed3=seed3<<1; 
  return 0; }

int deal(int icard) { if(shoe[icard]<1) return 0; 
                      shoe[icard]-=1;   return 1; }

void shuffleb() {
    int card,nth; nth=0;
    root:    if(test1()) goto R;  
/*  L:    */ if(test2()) goto LR;
/*  LL:   */ if(test3()) goto LLR;
/*  LLL:  */ if(test1()) goto LLLR;
/*  LLLL: */ if(test2()) goto LLLLR;
/*  LLLLL:*/ if(test3()) goto C2;
/*  C1:   */ card=1;  if(deal(card)) goto ok; goto root;
    C2:      card=2;  if(deal(card)) goto ok; goto root;
    LLLLR:   if(test3()) goto C4;
/*  C3:   */ card=3;  if(deal(card)) goto ok; goto root;
    C4:      card=4;  if(deal(card)) goto ok; goto root;
    LLLR:    if(test2()) goto LLLRR;
/*  LLLRL:*/ if(test3()) goto C6;
/*  C5:   */ card=5;  if(deal(card)) goto ok; goto root;
    C6:      card=6;  if(deal(card)) goto ok; goto root;
    LLLRR:   if(test3()) goto C8;
/*  C7:   */ card=7;  if(deal(card)) goto ok; goto root;
    C8:      card=8;  if(deal(card)) goto ok; goto root;
    LLR:     if(test1()) goto LLRR;
/*  LLRL: */ if(test2()) goto LLRLR;
/*  LLRLL:*/ if(test3()) goto C10;
/*  C9:   */ card=9;  if(deal(card)) goto ok; goto root;
    C10:     card=10; if(deal(card)) goto ok; goto root;
    LLRLR:   if(test3()) goto C12;
/*  C11:  */ card=11; if(deal(card)) goto ok; goto root;
    C12:     card=12; if(deal(card)) goto ok; goto root;
    LLRR:    if(test2()) goto LLRRR;
/*  LLRRL:*/ if(test3()) goto C14;
/*  C13:  */ card=13; if(deal(card)) goto ok; goto root;
    C14:     card=14; if(deal(card)) goto ok; goto root;
    LLRRR:   if(test3()) goto C16;
/*  C15:  */ card=15; if(deal(card)) goto ok; goto root;
    C16:     card=16; if(deal(card)) goto ok; goto root;
    LR:      if(test3()) goto LRR;
/*  LRL:  */ if(test1()) goto LRLR;
/*  LRLL: */ if(test2()) goto LRLLR;
/*  LRLLL:*/ if(test3()) goto C18;
/*  C17:  */ card=17; if(deal(card)) goto ok; goto root;
    C18:     card=18; if(deal(card)) goto ok; goto root;
    LRLLR:   if(test3()) goto C20;
/*  C19:  */ card=19; if(deal(card)) goto ok; goto root;
    C20:     card=20; if(deal(card)) goto ok; goto root;
    LRLR:    if(test2()) goto LRLRR;
/*  LRLRL:*/ if(test3()) goto C22;
/*  C21:  */ card=21; if(deal(card)) goto ok; goto root;
    C22:     card=22; if(deal(card)) goto ok; goto root;
    LRLRR:   if(test3()) goto C24;
/*  C23:  */ card=23; if(deal(card)) goto ok; goto root;
    C24:     card=24; if(deal(card)) goto ok; goto root;
    LRR:     if(test1()) goto LRRR;
/*  LRRL: */ if(test2()) goto LRRLR;
/*  LRRLL:*/ if(test3()) goto C26;
/*  C25:  */ card=25; if(deal(card)) goto ok; goto root;
    C26:     card=26; if(deal(card)) goto ok; goto root;
    LRRLR:   if(test3()) goto C28;
/*  C27:  */ card=27; if(deal(card)) goto ok; goto root;
    C28:     card=28; if(deal(card)) goto ok; goto root;
    LRRR:    if(test2()) goto LRRRR;
/*  LRRRL:*/ if(test3()) goto C30;
/*  C29:  */ card=29; if(deal(card)) goto ok; goto root;
    C30:     card=30; if(deal(card)) goto ok; goto root;
    LRRRR:   if(test3()) goto C32;
/*  C31:  */ card=31; if(deal(card)) goto ok; goto root;
    C32:     card=32; if(deal(card)) goto ok; goto root;
    R:       if(test2()) goto RR;
/*  RL:   */ if(test3()) goto RLR;
/*  RLL:  */ if(test1()) goto RLLR;
/*  RLLL: */ if(test2()) goto RLLLR;
/*  RLLLL:*/ if(test3()) goto C34;
/*  C33:  */ card=33; if(deal(card)) goto ok; goto root;
    C34:     card=34; if(deal(card)) goto ok; goto root;
    RLLLR:   if(test3()) goto C36;
/*  C35:  */ card=35; if(deal(card)) goto ok; goto root;
    C36:     card=36; if(deal(card)) goto ok; goto root;
    RLLR:    if(test2()) goto RLLRR;
/*  RLLRL:*/ if(test3()) goto C38;
/*  C37:  */ card=37; if(deal(card)) goto ok; goto root;
    C38:     card=38; if(deal(card)) goto ok; goto root;
    RLLRR:   if(test3()) goto C40;
/*  C39:  */ card=39; if(deal(card)) goto ok; goto root;
    C40:     card=40; if(deal(card)) goto ok; goto root;
    RLR:     if(test1()) goto RLRR;
/*  RLRL: */ if(test2()) goto RLRLR;
/*  RLRLL:*/ if(test3()) goto C42;
/*  C41:  */ card=41; if(deal(card)) goto ok; goto root;
    C42:     card=42; if(deal(card)) goto ok; goto root;
    RLRLR:   if(test3()) goto C44;
/*  C43:  */ card=43; if(deal(card)) goto ok; goto root;
    C44:     card=44; if(deal(card)) goto ok; goto root;
    RLRR:    if(test2()) goto RLRRR;
/*  RLRRL:*/ if(test3()) goto C46;
/*  C45:  */ card=45; if(deal(card)) goto ok; goto root;
    C46:     card=46; if(deal(card)) goto ok; goto root;
    RLRRR:   if(test3()) goto C48;
/*  C47:  */ card=47; if(deal(card)) goto ok; goto root;
    C48:     card=48; if(deal(card)) goto ok; goto root;
    RR:      if(!test3()) goto RRL;  goto root;
    RRL:     if(!test1()) goto RRLL; goto root;
    RRLL:    if(test2()) goto RRLLR;
/*  RRLLL:*/ if(test3()) goto C50;
/*  C49:  */ card=49; if(deal(card)) goto ok; goto root;
    C50:     card=50; if(deal(card)) goto ok; goto root;
    RRLLR:   if(test3()) goto C52;
/*  C51:  */ card=51; if(deal(card)) goto ok; goto root;
    C52:     card=52; if(deal(card)) goto ok; goto root;
    ok:
      nth+=1;
      cardsB[nth]=card;  
      cardsleft-=1;
      if(nth<cardswanted && cardsleft>0 ) goto root;
      if(cardsleft<=SHUFFLEPOINT) newSHOE();
    return;
}
