//+=========================================================================+
//|                                                                         |
//|    Card Game Toolkit(tm)                                                |
//|    Copyright (c) 1996, EverGreenSys Inc. All rights reserved.           |
//|                                                                         |
//|        file:   shufflea.c                                               |
//|        call:   shufflea();                                              |
//|     returns:   cards dealt in cardsA[]                                  |
//|        note:   ANSI C (except all int values MUST be 32-bit)            |
//|                                                                         |
//|      author:   D. Taylor (908) 935-1409                                 |
//|                Box 56, Rumson, N.J. 07760                               |
//|                dtaylor@monmouth.com                                     |
//|                                                                         |
//|-------------------------------Comments----------------------------------|
//|      A general purpose shuffle and deal function for any card game      |
//|    that uses a single deck of 52 playing cards.                         |
//|      This version is configured by constants to deal a complete round   |
//|    of play for the poker game known as Texas Hold'em. Here we provide   |
//|    for 11 players. In this game each player starts with 2 cards dealt   |
//|    face down, followed by 5 community cards dealt face up. A round      |
//|    of play consists therefore of 2 x 11 + 5 = 27 cards. To change       |
//|    the number of players, simply change the value of NPLAYERS. To       |
//|    change the game, change the formula for NCARDS. For a 6-player       |
//|    game of 7-card Stud, for example, you would substitute,              |
//|         #define NPLAYERS 6                                              |
//|         #define NCARDS (NPLAYERS*7)                                     |
//|      After dealing a complete round of play, the function returns       |
//|    with < cardsA[] > containing the index values for each card          |
//|    dealt in slots 1-27, in this example. Card index values are always   |
//|    1 to 52. You may assign real card identities to these as you wish.   |
//|      Each time the function is invoked it returns a new shuffle and     |
//|    round.                                                               |
//|      We tested this function on Borland C/C++ 4.5, Visual C/C++ and     |
//|    Watcom C/C++ 10.5 on a Pentium-S/133. The best performance was       |
//|    in 32-bit mode using the Watcom compiler where it shuffled and       |
//|    dealt an average of 125 million rounds (that's 1.375 billion         |
//|    hands!) per hour. For this we set the following switches:            |
//|         wcl386 /oneatx /zp4 /5 /fp5 ...                                 |
//|      A static binary decision tree is defined. Each card is dealt       |
//|    by traversing the tree guided by a primitive polynomials modulo 2    |
//|    algorithm that randomly selects each branch. The random bit          |
//|    generator built into the tree is believed to yield approximately     |
//|    (2^30)x(2^30)x(2^30) unique shuffle sequences before it repeats,     |
//|    which is much longer than the period for any known 32-bit or         |
//|    less numeric random number generator. Also, the algorithm as         |
//|    configured here passed all of our spectral tests of 'randomness'     |
//|    more robustly than any numeric random number generator we tested.    |                       
//|-------------------------------------------------------------------------|
//|      This is NOT public domain software. It is fully copyrighted        |
//|    and made available for you to evaluate for 90 days. You may NOT      |
//|    re-distribute the source code or any compiled version of the         |
//|    source code for any purpose without prior permission of the          |
//|    author. If you register this shareware, however, you will receive    |
//|    an extended license for its use and other related materials.         |
//|      See the register.txt file for details.                             |                                
//+=========================================================================+
//
#include "shuffleA.h"

#define NPLAYERS 11
#define NCARDS (NPLAYERS*2+5)

unsigned int cA7,c62;
unsigned int seed1=05275334125;   //  These seeds may be initialized
unsigned int seed2=02176635312;   //  to any non-zero value.
unsigned int seed3=01166442233;

unsigned int cardsA[NCARDS+1];
unsigned int cA7,c62;

int test1() {
  if(seed1&CHECK) { seed1=((seed1^MTEST)<<1)|01; return 1; }
  seed1=seed1<<1; 
  return 0; }
int test2() {
  if(seed2&CHECK) { seed2=((seed2^MTEST)<<1)|01; return 1; }
  seed2=seed2<<1; 
  return 0; }
int test3() {
  if(seed3&CHECK) { seed3=((seed3^MTEST)<<1)|01; return 1; }
  seed3=seed3<<1; 
  return 0; }
int dealA7(unsigned int BITS) {
  if(cA7&BITS) return 0; 
  cA7=(cA7|BITS);
  return 1; }
int deal62(unsigned int BITS) {
  if(c62&BITS) return 0;
  c62=(c62|BITS);
  return 1; }

void shuffleA() {
    int card,nth; nth=0; cA7=0; c62=0;        
    root:    if(test1()) goto R;  
/*  L:    */ if(test2()) goto LR;
/*  LL:   */ if(test3()) goto LLR;
/*  LLL:  */ if(test1()) goto LLLR;
/*  LLLL: */ if(test2()) goto LLLLR;
/*  LLLLL:*/ if(test3()) goto C2;
/*  C1:   */ if(dealA7(BIT31)) { card=1;  goto ok; } goto root;
    C2:      if(dealA7(BIT30)) { card=2;  goto ok; } goto root;
    LLLLR:   if(test3()) goto C4;
/*  C3:   */ if(dealA7(BIT29)) { card=3;  goto ok; } goto root;
    C4:      if(dealA7(BIT28)) { card=4;  goto ok; } goto root;
    LLLR:    if(test2()) goto LLLRR;
/*  LLLRL:*/ if(test3()) goto C6;
/*  C5:   */ if(dealA7(BIT27)) { card=5;  goto ok; } goto root;
    C6:      if(dealA7(BIT26)) { card=6;  goto ok; } goto root;
    LLLRR:   if(test3()) goto C8;
/*  C7:   */ if(dealA7(BIT25)) { card=7;  goto ok; } goto root;
    C8:      if(dealA7(BIT24)) { card=8;  goto ok; } goto root;
    LLR:     if(test1()) goto LLRR;
/*  LLRL: */ if(test2()) goto LLRLR;
/*  LLRLL:*/ if(test3()) goto C10;
/*  C9:   */ if(dealA7(BIT23)) { card=9;  goto ok; } goto root;
    C10:     if(dealA7(BIT22)) { card=10; goto ok; } goto root;
    LLRLR:   if(test3()) goto C12;
/*  C11:  */ if(dealA7(BIT21)) { card=11; goto ok; } goto root;
    C12:     if(dealA7(BIT20)) { card=12; goto ok; } goto root;
    LLRR:    if(test2()) goto LLRRR;
/*  LLRRL:*/ if(test3()) goto C14;
/*  C13:  */ if(dealA7(BIT19)) { card=13; goto ok; } goto root;
    C14:     if(dealA7(BIT18)) { card=14; goto ok; } goto root;
    LLRRR:   if(test3()) goto C16;
/*  C15:  */ if(dealA7(BIT17)) { card=15; goto ok; } goto root;
    C16:     if(dealA7(BIT16)) { card=16; goto ok; } goto root;
    LR:      if(test3()) goto LRR;
/*  LRL:  */ if(test1()) goto LRLR;
/*  LRLL: */ if(test2()) goto LRLLR;
/*  LRLLL:*/ if(test3()) goto C18;
/*  C17:  */ if(dealA7(BIT15)) { card=17; goto ok; } goto root;
    C18:     if(dealA7(BIT14)) { card=18; goto ok; } goto root;
    LRLLR:   if(test3()) goto C20;
/*  C19:  */ if(dealA7(BIT13)) { card=19; goto ok; } goto root;
    C20:     if(dealA7(BIT12)) { card=20; goto ok; } goto root;
    LRLR:    if(test2()) goto LRLRR;
/*  LRLRL:*/ if(test3()) goto C22;
/*  C21:  */ if(dealA7(BIT11)) { card=21; goto ok; } goto root;
    C22:     if(dealA7(BIT10)) { card=22; goto ok; } goto root;
    LRLRR:   if(test3()) goto C24;
/*  C23:  */ if(dealA7(BIT9) ) { card=23; goto ok; } goto root;
    C24:     if(dealA7(BIT8) ) { card=24; goto ok; } goto root;
    LRR:     if(test1()) goto LRRR;
/*  LRRL: */ if(test2()) goto LRRLR;
/*  LRRLL:*/ if(test3()) goto C26;
/*  C25:  */ if(dealA7(BIT7) ) { card=25; goto ok; } goto root;
    C26:     if(dealA7(BIT6) ) { card=26; goto ok; } goto root;
    LRRLR:   if(test3()) goto C28;
/*  C27:  */ if(dealA7(BIT5) ) { card=27; goto ok; } goto root;
    C28:     if(dealA7(BIT4) ) { card=28; goto ok; } goto root;
    LRRR:    if(test2()) goto LRRRR;
/*  LRRRL:*/ if(test3()) goto C30;
/*  C29:  */ if(dealA7(BIT3) ) { card=29; goto ok; } goto root;
    C30:     if(dealA7(BIT2) ) { card=30; goto ok; } goto root;
    LRRRR:   if(test3()) goto C32;
/*  C31:  */ if(dealA7(BIT1) ) { card=31; goto ok; } goto root;
    C32:     if(dealA7(BIT0) ) { card=32; goto ok; } goto root;
    R:       if(test2()) goto RR;
/*  RL:   */ if(test3()) goto RLR;
/*  RLL:  */ if(test1()) goto RLLR;
/*  RLLL: */ if(test2()) goto RLLLR;
/*  RLLLL:*/ if(test3()) goto C34;
/*  C33:  */ if(deal62(BIT31)) { card=33; goto ok; } goto root;
    C34:     if(deal62(BIT30)) { card=34; goto ok; } goto root;
    RLLLR:   if(test3()) goto C36;
/*  C35:  */ if(deal62(BIT29)) { card=35; goto ok; } goto root;
    C36:     if(deal62(BIT28)) { card=36; goto ok; } goto root;
    RLLR:    if(test2()) goto RLLRR;
/*  RLLRL:*/ if(test3()) goto C38;
/*  C37:  */ if(deal62(BIT28)) { card=37; goto ok; } goto root;
    C38:     if(deal62(BIT26)) { card=38; goto ok; } goto root;
    RLLRR:   if(test3()) goto C40;
/*  C39:  */ if(deal62(BIT25)) { card=39; goto ok; } goto root;
    C40:     if(deal62(BIT24)) { card=40; goto ok; } goto root;
    RLR:     if(test1()) goto RLRR;
/*  RLRL: */ if(test2()) goto RLRLR;
/*  RLRLL:*/ if(test3()) goto C42;
/*  C41:  */ if(deal62(BIT23)) { card=41; goto ok; } goto root;
    C42:     if(deal62(BIT22)) { card=42; goto ok; } goto root;
    RLRLR:   if(test3()) goto C44;
/*  C43:  */ if(deal62(BIT21)) { card=43; goto ok; } goto root;
    C44:     if(deal62(BIT20)) { card=44; goto ok; } goto root;
    RLRR:    if(test2()) goto RLRRR;
/*  RLRRL:*/ if(test3()) goto C46;
/*  C45:  */ if(deal62(BIT19)) { card=45; goto ok; } goto root;
    C46:     if(deal62(BIT18)) { card=46; goto ok; } goto root;
    RLRRR:   if(test3()) goto C48;
/*  C47:  */ if(deal62(BIT17)) { card=47; goto ok; } goto root;
    C48:     if(deal62(BIT16)) { card=48; goto ok; } goto root;
    RR:      if(!test3()) goto RRL;  goto root;
    RRL:     if(!test1()) goto RRLL; goto root;
    RRLL:    if(test2()) goto RRLLR;
/*  RRLLL:*/ if(test3()) goto C50;
/*  C49:  */ if(deal62(BIT15)) { card=49; goto ok; } goto root;
    C50:     if(deal62(BIT14)) { card=50; goto ok; } goto root;
    RRLLR:   if(test3()) goto C52;
/*  C51:  */ if(deal62(BIT13)) { card=51; goto ok; } goto root;
    C52:     if(deal62(BIT12)) { card=52; goto ok; } goto root;
    ok:
      nth+=1;
      cardsA[nth]=card;  
      if(nth<NCARDS) goto root;
    return;
}
