#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

/*
     This is not a good example of c programming, but only an
   example of how a TSR can be unloaded if it and all  subse-
   quently loaded TSRs respect the   IBM's INTERRUPT  SHARING
   PROTOCOL.
     Memory is not freed (but could be easily done), I'm  not
   in this moment really interested to this.
     I was only interested to the short TSR (here used  as an
   example) failwrta.com.
     But I  thought it would have been a good thing if I sha-
   red informations I collect to get my goal.

     Thanks a lot to Chris Dunford  for  posting informations
   about IBM's INTERRUPT-SHARING PROTOCOL

     Thanks to Kris Heidenstrom too for the precious informa-
   tions

   (c) 1996 by Luigi Mancinelli
   manci@alpha.science.unitn.it

   P.S:  Obviously in the case failwrta.com  is  the only TSR
   which hook int 24h, generally unchaining int 21h  could be
   enough, 'cause if int 21h isn't modified  command.com  ri-
   pristinate his int 24h handler.    But these are unintere-
   sting considerations...
*/

typedef struct TSRPROTSTRU {
    unsigned int ShortJmp;
    struct TSRPROTSTRU far * Old;
    unsigned int Signature;
    char flag;
    unsigned int ShortJmpHWreset;
    char bytes[7];
    unsigned int MyJump;
    char recognise[5];
    char retf;
    }  TsrProtStructure;

typedef TsrProtStructure far *TsrProt;


int IsCorrectTsrProtStru(TsrProt P)
{

    if (P==NULL) return 0;
    else if (P->Signature!=0x424B) return 0;
    /* comment following line for a less strict control */
    else if (P->ShortJmp!=0x10EB) return 0;
    else return 1;
}

int IsFailWrtA(TsrProt P)
{
    if (IsCorrectTsrProtStru(P)==0) return -1;
    else if ((P->recognise[0]=='F')&&(P->recognise[1]=='W')&&
             (P->recognise[2]=='R')&&(P->recognise[3]=='T')&&
             (P->recognise[4]=='A') ) return 1;
    else return 0;
}

TsrProt Pntr;
TsrProt OldPntr=NULL;
void interrupt (*Old)();



main() {
   int Fnd;

   /* now try to unhook int 24h */
   Pntr=(TsrProt) getvect(0x24);
   printf("Actual int 24h handler :%Fp\n",Pntr );
   while ((Fnd=IsFailWrtA(Pntr))==0) {
      printf("%Fp  %Fp\n",Pntr,&(Pntr->Old) );
      OldPntr=Pntr;
      Pntr=Pntr->Old;
   }
   if(Fnd==-1) {
      printf("Cannot inspect TSR chain - Failwrta not found\n");
   }
   else {
      Old=(void interrupt (*)()) Pntr->Old;
      if (OldPntr!=NULL) { /* adjust the after loaded TSR */
         OldPntr->Old=(TsrProt) Old;
      }
      else {
         Pntr->Old=NULL;
         setvect(0x24,Old);

         (*((unsigned int *) (&Pntr)))=0x12;
         ((unsigned int *) (&Pntr))[1]=_psp;
                  /* *((unsigned int far * far *) MK_FP(_psp,0x12)) */
             /*  printf("[PSP:12h]=%Fp =>",*((TsrProt far *) Pntr)); */
         *((TsrProt far *) Pntr)=(TsrProt) Old;
             /*  printf("%Fp\n",*((TsrProt far *) Pntr)); */
      }
      printf("int 24h successfully unhooked\n");

      /* now try to unhook int 0x21 */
      printf("trying to unhook int 21h\n");
      OldPntr=NULL;
      Pntr=(TsrProt) getvect(0x21);
      while ((Fnd=IsFailWrtA(Pntr))==0) {
         printf("%Fp  %Fp\n",Pntr,&(Pntr->Old) );
         OldPntr=Pntr;
         Pntr=Pntr->Old;
      }
      if(Fnd==-1) {
         printf("Cannot unhook int 21h\n");
      }
      else {
         Old=(void interrupt (*)()) Pntr->Old;
         printf("%Fp <= %Fp\n",Old,Pntr);
         if (OldPntr!=NULL) { /* adjust the after loaded TSR */
            OldPntr->Old=(TsrProt) Old;
         }
         else {
            setvect(0x21,Old);
         }
         printf("int 21h successfully unhooked\n");
         /* Now memory can be freed */
             /* ... */

         /*                         */
      }
   }
}
