	.ident "@(#)enable.s	1.0 94#03!18"

	.data				# Data section

	.text				# Text section

	.set    CR0_CD_ENB, 0xbfffffff	# Enable cache with CR0
	.set    CR0_NW_ENB, 0xdfffffff	# Enable writethru with CR0
					# Actually, the NW bit is hardwired
					# to 0 at all times on the Cyrix,
					# but we set and clear it anyway...

#
#	void cx_i486cacheon(void)
#
#	This routine flushes and enables the i486 internal cache.
#
	.align	4
	.globl	_cx_i486cacheon
_cx_i486cacheon:
	pushl	%ebp
	movl	%esp, %ebp
	.byte	0x0f			# INVD instruction:
	.byte	0x08			# Flush i486 cache
	.byte	0x0f			# WBINVD instruction:
	.byte	0x09			# Flush i486 cache with write back
	jmp	cx_postinvd1		# jmp to next to force queue flush
cx_postinvd1:
	movl    %cr0, %eax              # cr0 -> eax
	andl	$CR0_CD_ENB, %eax	# Turn "on" CD bit
	andl	$CR0_NW_ENB, %eax	# Turn "on" NW bit
	movl    %eax, %cr0              # eax -> cr0
	popl	%ebp
	ret
