; CPUTYPE.INC Routines to determine CPU type for high level languages
; (Pascal,C,C++,etc)
; CPU: 8086/80186, 80286, 80386, 80486, 80586 Pentium, 80686 P6 and higher(!)
; FPU: 8087, 80287, 80387, 80487, and higher (see 1. and 2. in CPU586P6.ASM)
;
; 1995 by XMAS coding (Dominik Freche, address see below)
; ********************** NOTE **********************
; For further pieces of information see CPU586P6.ASM
; **************************************************
;
; !!!!! THIS SOURCECODE IS FREEWARE !!!!!
; Including routines in high level languages (Pascal,C,C++,etc) :
; First assemble this file (for TASM : TASM CPUTYPE.INC) to an Object-file
; (*.OBJ). This file can be included in your high level language program.
; Add these lines in your high level language main (!) program
; (e.g. for Turbo-Pascal) :
;  {$L CPUTYPE.OBJ}
;  Function CPUType : Word; External;{1=86,2=286,3=386,4=486,5=586,etc.}
;  Function FPUType : Word; External;{0=None,1=87,2=287,3=387,4=487,Internal}
; For other languages use another syntax.
;
; If you have got any problems or if you want to contact me, do not hesitate,
; please write to the following address :
;   Dominik Freche
;   Vondernstrasse 45
;   45357 Essen
;   Germany, Europe
; or email to :
;   heckenb@mi.uni-erlangen.de (Frank Heckenbach)
;
; Dominik Freche, Mar 26 1995
; Inclusion routines :

        LOCALS  @@

CPUID   EQU     DB 0FH,0A2H     ;80586 Instruction to determine CPU type

DSeg    SEGMENT
  Temp       DW  0FFFFH
  FEnv       DW  7 DUP (0)
DSeg    ENDS

CSeg    SEGMENT
        ASSUME CS:CSeg,DS:DSeg

        PUBLIC CPUType,FPUType

        .8086

CPUType PROC    ;>AX CpuType (1=86,2=286,3=386,4=486,5=586,6=686,etc.)
        MOV     AX,1
        PUSHF
        POP     BX
        AND     BH,0FH
        PUSH    BX
        POPF
        PUSHF
        POP     CX
        AND     CH,0F0H
        CMP     CH,0F0H
        JE      @@1                     ;8086 or below 80286
        INC     AX
        OR      BH,0F0H
        PUSH    BX
        POPF
        PUSHF
        POP     CX
        AND     CH,0F0H
        JE      @@1                     ;80286
        .386
        INC     AX
        MOV     EBX,ESP
        AND     ESP,0FFFCH
        PUSHFD
        POP     EDX
        MOV     ECX,EDX
        XOR     EDX,000040000H
        PUSH    EDX
        POPFD
        PUSHFD
        POP     EDX
        PUSH    ECX
        POPFD
        XOR     EDX,ECX
        AND     EDX,000040000H          ;Test Alignment Check Bit
        MOV     ESP,EBX
        JZ      @@1                     ;80386
        ;.486
        INC     AX
        PUSHFD
        POP     EDX
        MOV     ECX,EDX
        XOR     EDX,000200000H
        PUSH    EDX
        POPFD
        PUSHFD
        POP     EDX
        PUSH    ECX
        POPFD
        XOR     EDX,ECX                 ;Test ID Bit
        JZ      @@1                     ;80486
        MOV     EAX,1
        ;.586 or higher, CPUID returns Cpu Generation Number in AX Bits 8-11
        CPUID
        AND     AH,0FH
        SHR     AX,8
        .8086
        .8087
@@1:    RET
CPUType ENDP

FPUType PROC    ;>AX FpuType (0=None (SX),1=87,2=287,3=387,
                ;4=487,5=586 or higher (FPU always internal))
        FNSTENV FEnv
        FNINIT
        FNSTSW  Temp
        CMP     BYTE PTR Temp,0
        JNE     @@1
        FNSTCW  Temp
        CMP     BYTE PTR [Temp+1],3
        JNE     @@1
        FLDENV  FEnv                    ;FPU exists
        CALL    CPUType                 ;Determine CPU type
        CMP     AX,4                    ;Test CPU(in AX)>=80486
        JAE     @@2                     ;CPU=80486,FPU exists=80487(Internal)
                                        ;CPU>=80586,FPU=Internal
        MOV     AX,3
        FLD1
        FLDZ
        FDIVP   ST(1),ST
        FLD     ST(0)
        FCHS
        FCOMPP
        FSTSW   Temp
        FWAIT
        TEST    Temp,100H
        JNZ     @@2                     ;80387
        DEC     AX
        FLD1
@@0:    FISTP   Temp
        FSTENV  FEnv
        MOV     BX,CS
        SHL     BX,1
        SHL     BX,1
        SHL     BX,1
        SHL     BX,1
        ADD     BX,OFFSET @@0
        INC     BX
        FWAIT
        CMP     BX,[FEnv+6]
        JE      @@2                     ;80287
        DEC     AX                      ;8087
        RET
@@1:    XOR     AX,AX                   ;None
@@2:    RET
FPUType ENDP

  IDString   DB  "1995 by XMAS coding (Dominik Freche)"

CSeg    ENDS

        END