unit netInfo;
{
written by Michael D. McCall  ==>  M-McCall@bgu.edu
}
interface

FUNCTION netInformation (var connectionNumber  : byte;
                         var socketNumber      : word;    {hi-lo}
                         var nodeAddress       : string;
                         var netAddress        : string;
                         var userID            : string;
                         var fullName          : string;
                         var year              : byte;
                         var month             : byte;
                         var day               : byte;
                         var hour              : byte;
                         var minute            : byte) : byte;

implementation

CONST
  HexCh : array[0..15] of char = '0123456789ABCDEF'; {Used by Hex functions}

VAR
  dta : array [0..511] of byte;

FUNCTION netInformation (var connectionNumber  : byte;
                         var socketNumber      : word;
                         var nodeAddress       : string;
                         var netAddress        : string;
                         var userID            : string;
                         var fullName          : string;
                         var year              : byte;
                         var month             : byte;
                         var day               : byte;
                         var hour              : byte;
                         var minute            : byte) : byte;

VAR
  requestBuffer : string absolute dta;
  connectionInformationReplyBuffer : record
      length : word;                     {lo-hi}
      objectID : array [1..4] of byte;   {hi-lo}
      objectType : byte;  {really a word, but second byte is used as
                           length byte for following string}
      objectName : string [48];          {ASCIIz string format}
      year : byte;                       {0..99}
      month : byte;                      {1..12}
      day : byte;                        {1..31}
      hour : byte;                       {0..23}
      minute : byte;                     {0..59}
      second : byte;                     {0..59}
      dayOfWeek : byte;                  {0..6, 0=Sunday}
      end absolute dta;
  fullNameReplyBuffer : record
      length : byte;      {really a word in lo-hi format but the second
			   byte is used for length of following string}
      name : string [128];               {ASCIIz string format}
      moreSegments : byte;               {FF=true, 00=false}
      propertyFlags : byte;              {1=set, 0=item}
      end absolute dta;
  internetAddressReplyBuffer : record
      length : word;                         {lo-hi}
      netAddress : array [1..4] of byte;     {hi-lo}
      nodeAddress : array [1..6] of byte;    {hi-lo}
      socketNumber : word;                   {hi-lo}
      end absolute dta;

  highestCompletionCode : byte;
  ii : byte;

  begin { netInformation }

  {********************************************************************}
  { Get connection number of user logged into station making the call. }
  {********************************************************************}

  inline (
    $B4/$DC/                { mov ah, dc                        }
    $CD/$21/                { int 21                            }
    $A2/dta);               { mov dta [0], al                   }
    {
    The connection number is returned via AL and is stored in completionCode.
    }

    connectionNumber := dta [0];

  {********************************************************************}
  { Get login name & time of user logged into station making the call. }
  {********************************************************************}

                     { lo order byte is requestBuffer [0] }
    requestBuffer := { hi order byte of length of buffer }          #0   +
                     { get connection information is sub function } #$16 +
                                                   chr (connectionNumber);

  inline (
    $1E/                    { push ds                            }
    $07/                    { pop es                             }
    $BE/dta/                { mov si, offset of requestBuffer    }
    $BF/dta/                { mov di, offset of replyBuffer      }
    $B4/$E3/                { mov ah,E3                          }
    $CD/$21/                { int 21                             }
    $A2/dta);               { mov dta [0], al                    }

  highestCompletionCode := dta [0];
  if dta [0] = 0 then
    begin {if}
      year := connectionInformationReplyBuffer.year;
      month := connectionInformationReplyBuffer.month;
      day := connectionInformationReplyBuffer.day;
      hour := connectionInformationReplyBuffer.hour;
      minute := connectionInformationReplyBuffer.minute;
      for ii := 1 to 48 do
        if connectionInformationReplyBuffer.objectName [ii] = #0 then
          begin {if}
            connectionInformationReplyBuffer.objectName [0] := chr(ii - 1);
            ii := 48
          end; {if}
      userID := connectionInformationReplyBuffer.objectName;
    end; {if}


  {********************************************************************}
  { Get full name of user logged into station making the call.         }
  {********************************************************************}

                   {lo order byte is requestBuffer [0]  }
  requestBuffer := {hi order byte of length of buffer   } #0 +
                   {read property value sub function    } #$3D +
                   {hi order byte of bindery object type} #0 +
                   {lo order byte of bindery object type} #1 +
                   {length of object name               } userID [0] +
                   {must be in upper case               } userID +
                   {segment number of property          } #1 +
                   {property name length                } #14 +
                   {Novell property name                } 'IDENTIFICATION';

  inline(
    $1E/                 {push ds                            }
    $07/                 {pop es                             }
    $BE/dta/             {mov si, offset of requestBuffer    }
    $BF/dta/             {mov di, offset of replyBuffer      }
    $B4/$E3/             {mov ah,E3                          }
    $CD/$21/             {int 21                             }
    $A2/dta);            {mov dta [0], al                    }

  if dta [0] > highestCompletionCode then
      highestCompletionCode := dta [0];
  if dta [0] = 0 then
    begin {if}
      for ii := 1 to 128 do
        if fullNameReplyBuffer.name [ii] = #0 then
          begin {if}
            fullNameReplyBuffer.name [0] := chr(ii - 1);
            ii := 128;
          end; {if}
        fullName := fullNameReplyBuffer.name;
    end; {if}

  {********************************************************************}
  { Get internetwork address of station making the call.               }
  {********************************************************************}

                     { lo order byte is requestBuffer [0] }
    requestBuffer := { hi order byte of length of buffer }          #0 +
                     { get internet address is sub function }     #$13 +
                                                 chr (connectionNumber);

  inline (
    $1E/                    { push ds                            }
    $07/                    { pop es                             }
    $BE/dta/                { mov si, offset of requestBuffer    }
    $BF/dta/                { mov di, offset of replyBuffe       }
    $B4/$E3/                { mov ah,E3                          }
    $CD/$21/                { int 21                             }
    $A2/dta);               { mov dta [0], al                    }

  if dta [0] > highestCompletionCode then
      highestCompletionCode := dta [0];
  if dta [0] = 0 then
    begin {if}
      netAddress := '';
      for ii := 1 to 4 do
        netAddress := netAddress +
                hexCh [internetAddressReplyBuffer.netAddress [ii] SHR 4] +
		hexCh [internetAddressReplyBuffer.netAddress [ii] AND $0F];
      nodeAddress := '';
      for ii := 1 to 6 do
        nodeAddress := nodeAddress +
		hexCh [internetAddressReplyBuffer.nodeAddress [ii] SHR 4] +
                hexCh [internetAddressReplyBuffer.nodeAddress [ii] AND $0F];
      socketNumber := internetAddressReplyBuffer.socketNumber;
    end; {if}

  netInformation := highestCompletionCode;

  end; { netInformation }

end.