program sp2a ;
  { Convert Sprint document files to pure ASCII.  Sprint exports to ASCII;
    this is for when you have a Sprint file but not Sprint itself.  The
    program reads the input file a byte at a time and only writes out ASCII
    characters.  It attempts to eliminate format commands, and converts
    Sprint's newline character to a hard carriage-return and line-feed.

    Public domain, no copyright.  Turbo Pascal 4.0.
    If you make improvments, please send me a copy.

    Wm. Meacham
    1004 Elm Street
    Austin, Tx  78703
    CIS:  73577,2175

    Revision history

    Date       Programmer          Revisions made
    --------------------------------------------------------------------
     8/ 6/88 | Bill Meacham      | First release
             |                   |
  }

{$V- Turn off strict type checking for string length }

uses crt ;

const
    cr        : char = ^M ;
    lf        : char = ^J ;
    eof_mark  : char = ^Z ;

type
    filename  = string[52] ;

var
    in_fname,
    out_fname : filename ;
    in_file,
    out_file  : file of char ;
    ch        : char ;
    in_ruler,
    in_format : boolean ;

{ ---------------------------------------------------------------- }

function UpcaseStr(S : String) : String;
{ Converts all characters in the string S to their upper case
  equivalents.   From Turbo Database Toolbox 4.0 }
var
  P : byte;
begin
  for P := 1 to Length(S) do
    S[P] := Upcase(S[P]);
  UpcaseStr := S;
end;

{ ---------------------------------------------------------------- }

{->>>>Deedle<<<<-----------------------------------------------}
{                                                              }
{ Filename: DEEDLE.SRC -- Last Modified 10/20/85               }
{                                                              }
{ This routine makes a sound not unlike certain electronic     }
{ telephone ringers you hear in lawyers' offices.  The number  }
{ of "deedles" is given by the value passed in Deedles.        }
{                                                              }
{        From: TURBO PASCAL SOLUTIONS by Jeff Duntemann        }
{    Scott, Foresman & Co., Inc. 1987   ISBN 0-673-18584-2     }
{--------------------------------------------------------------}

PROCEDURE Deedle(Deedles : Integer);

VAR I : Integer;

BEGIN
  FOR I := 1 TO Deedles DO
    BEGIN
      Sound(800); Delay(50); Sound(500); Delay(50)
    END;
  NoSound
END;

{ ---------------------------------------------------------------- }

begin  { program sp2a }
    writeln ('This program converts a Sprint document file to a pure ASCII file') ;
    in_fname  := '';
    out_fname := '';
                                         { get file names }
    if paramcount < 2 then
      begin
        if paramcount < 1 then
          begin
            write  (' Input file? ') ;
            readln (in_fname) ;
          end
        else
          in_fname := paramstr(1) ;

        write  ('Output file? ') ;
        readln (out_fname)
      end
    else
      begin
        in_fname  := paramstr(1) ;
        out_fname := paramstr(2) ;
      end;

    in_fname  := upcasestr(in_fname) ;
    out_fname := upcasestr(out_fname) ;

    if in_fname = out_fname then
      begin
        writeln ('File names must be different.', ^G) ;
        halt
      end ;
    assign  (in_file, in_fname) ;
    assign  (out_file, out_fname) ;

    {$i-}                                { Turn off auto i/o check }
    reset   (in_file) ;
    if not (ioresult = 0) then
      begin
        writeln ('Can''t find file ',in_fname, ^G) ;
        halt
      end ;
    rewrite (out_file) ;
    if not (ioresult = 0) then
      begin
        writeln ('Can''t create file ',out_fname, ^G) ;
        halt
      end ;
    {$i+}                                { Turn it back on }

    in_ruler  := false ;
    in_format := false ;
    writeln ('Converting ... ') ;        { Convert the file a char at a time }
    while not(eof(in_file)) do
      begin
        read (in_file,ch) ;
        case ch of
          ^K : in_ruler := true ;        { Begin ruler line }
          ^O,^V : in_format := true ;    { What else?  I got these from trial }
                                         { and error, but I have not looked }
                                         { at all possible formats. }
          ^N : in_format := false ;      { End format command }
          ^M : if not in_ruler then      { Hard carriage-return. Write it out }
                   write (out_file,ch) ; { only if it's not part of a ruler. }
          ^J : if in_ruler then          { Hard line-feed. Either write it }
                   in_ruler := false     { out or end ruler line. }
               else
                   write (out_file,ch) ;
          ^_ : write (out_file,cr,lf) ;  { Soft newline.  Write out hard }
                                         { carriage-return and line-feed. }
          ^I, ^L : write (out_file,ch) ; { Tab and Formfeed }
        else   if  (ch >= ' ')           { Eliminate all other control chars }
               and (not in_format)       { Eliminate all format commands }
               and (not in_ruler) then   { and ruler lines }
                  write (out_file,ch) ;
        end   { case }
      end ; { while }
    write (out_file, eof_mark) ;         { Write Ctrl-Z }
    close (in_file) ;                    
    close (out_file) ;
    writeln ('All done!') ;
    deedle (4)                           { Notify user }
end.
