
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

#include <stdio.h>
#include <dos.h>

#include "sb.h"

unsigned char major;
unsigned char minor;
unsigned char ca;
//------------------------------------------------------------------------------
void main ( void )
{
    sbinit();
    printf("Sound Blaster found at I/O address 220h\n");
    dspwrite(0xE1);
    major=dspread();
    minor=dspread();
    printf("DSP version %u.%u\n",major,minor);
    if(major==3)
    {
        printf("Mixer settings:\n");

        outportb(0x224,0x0C); ca=inportb(0x225);
        printf("Input source:  ");
        switch(ca&6)
        {
            case 0: printf("Microphone\n"); break;
            case 2: printf("CD Audio\n"); break;
            case 4: printf("Microphone\n"); break;
            case 6: printf("Line-in\n"); break;
            default: printf("\n"); break;
        }
        printf("Input filter:  ");
        switch(ca&0x28)
        {
            case 0x00: printf("Low filter\n"); break;
            case 0x08: printf("High filter\n"); break;
            case 0x20:
            case 0x28: printf("No filter\n"); break;
            default: printf("\n"); break;
        }

        outportb(0x224,0x0C); ca=inportb(0x225);
        if(ca&0x20) printf("Output filter is bypassed\n");
        else printf("Output filter is ON\n");
        if(ca&2) printf("Stereo voice mode\n");
        else printf("Mono voice mode\n");

        outportb(0x224,0x04); ca=inportb(0x225);
        printf("Voice volume left %u\n",(ca>>4)&15);
        printf("Voice volume right %u\n",ca&15);

        outportb(0x224,0x26); ca=inportb(0x225);
        printf("FM volume left %u\n",(ca>>4)&15);
        printf("FM volume right %u\n",ca&15);

        outportb(0x224,0x28); ca=inportb(0x225);
        printf("CD volume left %u\n",(ca>>4)&15);
        printf("CD volume right %u\n",ca&15);

        outportb(0x224,0x2E); ca=inportb(0x225);
        printf("Line-in volume left %u\n",(ca>>4)&15);
        printf("Line-in volume right %u\n",ca&15);

        outportb(0x224,0x0A); ca=inportb(0x225);
        printf("MIC mixing level %u\n",ca&7);

        outportb(0x224,0x22); ca=inportb(0x225);
        printf("Master volume left %u\n",(ca>>4)&15);
        printf("Master volume right %u\n",ca&15);


    }
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

