
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>

unsigned short keywait ( void );

unsigned short iobase;
unsigned short ra;
unsigned short rb;
short sa;
unsigned short row;
unsigned short keycode;

//------------------------------------------------------------------------------
void dspwrite ( unsigned char c )
{
    while(inp(iobase+0xC)&0x80);
    outp(iobase+0xC,c);
}
//------------------------------------------------------------------------------
unsigned char dspread ( void )
{
    while(!(inp(iobase+0xE)&0x80)) continue;
    return(inp(iobase+0xA));
}
//------------------------------------------------------------------------------
void main ( void )
{
    //Look for Sound Blaster 16
    for(iobase=0x220;iobase<=0x280;iobase+=0x20)
    {
        if(inp(iobase)==0xFF) continue;
        outp(iobase+0x6,0x01);  // Reset Sound Blaster
        for(ra=0;ra<65000;ra++) continue; //At least 3ms delay
        outp(iobase+0x6,0x00);
        for(ra=0;ra<65000;ra++) if(dspread()==0xAA) break;
        if(ra<65000) break;
    }
    if(iobase>0x280)
    {
        printf("Sound Blaster not detected\n");
        exit(1);
    }
    dspwrite(0xE1);   // Get DSP Version Number
    ra=dspread();
    rb=dspread();
    if(ra!=4)
    {
        printf("Only Sound Blaster DSP Versions 4.xx (SB16) supported.\n");
        exit(1);
    }
    textmode(C80); clrscr();
    gotoxy(1,1); printf("Sound Blaster Detected, DSP Version %u.%02u",ra,rb);

    outp(iobase+4,0x30); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1, 3); printf("Master Volume L -%2udB",62-ra);
    outp(iobase+4,0x31); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1, 4); printf("Master Volume R -%2udB",62-ra);
    outp(iobase+4,0x32); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1, 5); printf("Voice  Volume L -%2udB",62-ra);
    outp(iobase+4,0x33); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1, 6); printf("Voice  Volume R -%2udB",62-ra);
    outp(iobase+4,0x34); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1, 7); printf("MIDI   Volume L -%2udB",62-ra);
    outp(iobase+4,0x35); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1, 8); printf("MIDI   Volume R -%2udB",62-ra);
    outp(iobase+4,0x36); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1, 9); printf("CD     Volume L -%2udB",62-ra);
    outp(iobase+4,0x37); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1,10); printf("CD     Volume R -%2udB",62-ra);
    outp(iobase+4,0x38); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1,11); printf("LINE   Volume L -%2udB",62-ra);
    outp(iobase+4,0x39); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1,12); printf("LINE   Volume R -%2udB",62-ra);
    outp(iobase+4,0x3A); ra=(inp(iobase+5)>>2)&0x3E; gotoxy(1,13); printf("MIC    Volume   -%2udB",62-ra);
    row=0;
    while(1)
    {
        switch(row)
        {
            case 0:
                outp(iobase+4,0x30); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,3); textattr(0x0B);
                cprintf("Master Volume L -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row=10; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x30); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,3);
                printf("Master Volume L -%2udB",62-ra);
                break;
            case 1:
                outp(iobase+4,0x31); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,4); textattr(0x0B);
                cprintf("Master Volume R -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x31); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,4);
                printf("Master Volume R -%2udB",62-ra);
                break;
            case 2:
                outp(iobase+4,0x32); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,5); textattr(0x0B);
                cprintf("Voice  Volume L -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x32); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,5);
                printf("Voice  Volume L -%2udB",62-ra);
                break;
            case 3:
                outp(iobase+4,0x33); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,6); textattr(0x0B);
                cprintf("Voice  Volume R -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x33); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,6);
                printf("Voice  Volume R -%2udB",62-ra);
                break;
            case 4:
                outp(iobase+4,0x34); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,7); textattr(0x0B);
                cprintf("MIDI   Volume L -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x34); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,7);
                printf("MIDI   Volume L -%2udB",62-ra);
                break;
            case 5:
                outp(iobase+4,0x35); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,8); textattr(0x0B);
                cprintf("MIDI   Volume R -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x35); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,8);
                printf("MIDI   Volume R -%2udB",62-ra);
                break;
            case 6:
                outp(iobase+4,0x36); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,9); textattr(0x0B);
                cprintf("CD     Volume L -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x36); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,9);
                printf("CD     Volume L -%2udB",62-ra);
                break;
            case 7:
                outp(iobase+4,0x37); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,10); textattr(0x0B);
                cprintf("CD     Volume R -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x37); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,10);
                printf("CD     Volume R -%2udB",62-ra);
                break;
            case 8:
                outp(iobase+4,0x38); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,11); textattr(0x0B);
                cprintf("LINE   Volume L -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x38); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,11);
                printf("LINE   Volume L -%2udB",62-ra);
                break;
            case 9:
                outp(iobase+4,0x39); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,12); textattr(0x0B);
                cprintf("LINE   Volume R -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row++; break;
                }
                outp(iobase+4,0x39); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,12);
                printf("LINE   Volume R -%2udB",62-ra);
                break;
            case 10:
                outp(iobase+4,0x3A); ra=(inp(iobase+5)>>2)&0x3E;
                gotoxy(1,13); textattr(0x0B);
                cprintf("MIC    Volume   -%2udB",62-ra);
                keycode=keywait();
                switch(keycode)
                {
                    case 0x4B00: ra=(ra-2)&0x3E; break;
                    case 0x4D00: ra=(ra+2)&0x3E; break;
                    case 0x4800: row--; break;
                    case 0x5000: row=0; break;
                }
                outp(iobase+4,0x3A); outp(iobase+5,(ra<<2)&0xF8);
                gotoxy(1,13);
                printf("MIC    Volume   -%2udB",62-ra);
                break;
        }
        if(keycode==0x011B) break;
    }
    textmode(C80); clrscr();
}



