_TEXT   SEGMENT WORD PUBLIC 'CODE'
_TEXT   ENDS

_DATA SEGMENT WORD PUBLIC 'DATA'        
_DATA   ENDS

CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS

_BSS    SEGMENT WORD PUBLIC 'BSS'
;GLOBAL UNINITIATED DATA GOES HERE
_BSS    ENDS

DGROUP  GROUP CONST,_BSS,_DATA
;
	ASSUME DS:DGROUP,SS:DGROUP

;EXTRN EXTERNAL SUBROUTINE CALLS GO HERE
;
; _tplay FAR Procedure for C Written by John A. Ball  October 3, 1995
;
;Plays back sound on the Tandy DAC
;
;       void     tplay(char *buffer, unsigned number_read,unsigned frequency
;                     ,unsigned volume);
;
;       tplay(Buffer Pointer,Length,Frequency,Volume);
;
;       Buffer Pointer is a Far pointer to the sound buffer (64k max)
;       Length is the number of sound samples to play
;       Frequency is the playback frequency in hertz
;       Volume is the sound volume (0-7) where 0 is no sound
;
_TEXT   SEGMENT
	ASSUME CS:_TEXT
	PUBLIC _tplay
		
_tplay PROC FAR

PARMA           EQU [BP+6]      ;Sound Buffer Pointer
PARMB           EQU [BP+10]     ;Number of samples to play (Length)
PARMC           EQU [BP+12]     ;Frequency to playback samples
PARMD           EQU [BP+14]     ;Volume 0-7
PARMS           EQU 10          ;Number of bytes for local storage

BUFFERPNT       EQU [BP-4]      ;LOCAL VARIABLES GO HERE
SAMPLES         EQU [BP-6]
FREQUENCY       EQU [BP-8]
VOLUME          EQU [BP-10]

	PUSH BP                 ;Save stack Frame
	MOV BP,SP
	SUB SP,PARMS            ;MAKE SPACE FOR LOCAL VARIABLE (INT) ON STACK
	PUSH DS                 ;Save registers
	PUSH ES
	MOV AX,0                ;Reset error flag
	MOV CS:ERROR,AX
	
	JMP OVERDATA

DMAFLAG                 DB 0    ;Flag to indicate DMA for DAC in use
OLD_INTERRUPT   LABEL   WORD
OLD_INTERRUPT_ADDR      DD 0    ;Location of prevoius 15H System Interrupt
ERROR                   DW 0    ;Error status

OVERDATA:
	LES DI,PARMA            ;GET SOUND BUFFER POINTER
	MOV BUFFERPNT,DI        ;AND SAVE
	MOV DI,ES
	MOV BUFFERPNT+2,DI
	
	MOV BX,PARMB            ;Get number of samples
	MOV SAMPLES,BX          ;AND SAVE

	MOV BX,PARMC            ;Get frequency
	MOV DX,0036H            ;and convert 3,580,000 / freq = count
	MOV AX,0A060H
	DIV BX
	MOV FREQUENCY,AX        ;and save
	MOV CX,DX               ;check remainder for roundoff error
	MOV DX,0
	MOV AX,BX
	MOV BX,2
	DIV BX
	CMP AX,CX               ;is remainder > 1/2 the frequency
	JG NOROUNDERR
	MOV AX,FREQUENCY        ;if it is, add 1 more
	ADD AX,1
	MOV FREQUENCY,AX

NOROUNDERR:                     ;else

	MOV BX,CS               ;MAKE DS SAME AS CS
	MOV DS,BX
	MOV ES,BX
	push ds
	MOV AH,35H              ;GET INTERRUPT 15H VECTOR AND SAVE IT
	MOV AL,15H
	INT 21H
	MOV OLD_INTERRUPT,BX
	MOV OLD_INTERRUPT[2],ES
	pop ds
	CLI                     ;PREVENT INTERRUPTS
	MOV AX,2515H            ;AND SET NEW INTERRUPT
	LEA DX,HANDLER
	INT 21H
	STI                     ;ENABLE INTERRUPTS WHEN DON
	
	MOV AL,0
	MOV DMAFLAG,AL          ;SET DMAFLAG TO SHOW IN USE
	
	MOV BX,PARMD            ;Get Volume
	AND BX,07H              ;Limit Volume to 0-7
	MOV VOLUME,BX           ;and save

	MOV DX,FREQUENCY        ;GET FREQUENCY TO PLAY AT
	MOV CX,SAMPLES          ;NUMBER OF SAMPLES TO PLAY
	LES BX,BUFFERPNT        ;AND BUFFER LOCATION
	MOV AX,VOLUME           ;VOLUME (0-7)
	MOV AH,083H
	INT 1AH                 ;Call interrupt to play sound

	CALL IO_WAIT            ;Wait for io to be done
EXIT:
	CLI                     ;Disable Interrupts while restoring vector
	LDS DX,OLD_INTERRUPT_ADDR
	MOV AX,2515H
	INT 21H
	STI

	POP ES                  ;Restore registers
	POP DS
	ADD SP,PARMS            ;RESTORE SP
	POP BP                  ;RESTORE BP
	MOV AX,ERROR            ;Get error status
	RET                     ;RETURN FAR

HANDLER:                        ;Interrupt 15h comes here!
	PUSHF
	CMP AL,0FBH             ;IS IT SOUND DMA DONE?
	JNE HANDEND
	MOV CS:DMAFLAG,AL       ;Indicate it is
	POPF
	IRET
HANDEND:                        ;ELSE JUMP TO PREVIOUS VECTOR
	POPF
	JMP CS:OLD_INTERRUPT_ADDR

_tplay  ENDP

IO_WAIT PROC NEAR

IOWAIT:
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JNZ DMA_DONE            ;Exit if it isn't
	INT 28H                 ;MS-DOS idle handler
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JNZ DMA_DONE            ;Wait until done
	MOV AX,1680H
	INT 2FH                 ;MS-DOS idle call
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JNZ DMA_DONE            ;Exit if it isn't
	MOV AH,01H              ;See if key pressed
	INT 16H
	JZ IOWAIT
	MOV AX,0
	INT 16H                 ;Get the pressed key
	CMP AL,1BH              ;See if ESC key hit?
	JNE IOWAIT
	CALL HALT_DMA
	CMP CS:ERROR,0          ;Check for error when halting DMA
	JNE DMA_DONE
	MOV CS:ERROR,0FFFFH     ;EXIT ERROR CODE
	JMP EXIT_IO

DMA_DONE:
	MOV AX,0                ;OK
EXIT_IO:
	RET

IO_WAIT ENDP

HALT_DMA PROC NEAR

	MOV AX,8400H
	INT 1AH                 ;Call interrupt to HALT sound
	RET

HALT_DMA ENDP

_TEXT   ENDS        
	END

