/************************************************************************
 *																		*
 * RC-Flyer I															*
 *																		*
 * by Mikko Oksalahti & Harri Rautio									*
 * Per their message:
 * Copyright (c) 1995 Mikko Oksalahti and Harri Rautio
 * All Rights Reserved
 * However, source and executable may be freely distributed.
 * Not the operative word "free" .. NO, repeat, NO fee may be charged.
 * (This does not include the usual freeware/shareware CD-ROM costs.)
 *
 * v1.1 Toad Hall Tweak, 27 Apr 95
 * - Added joystick routines from C Snippets (SNIP9503.ZIP).
 * v1.2 28 Apr 95
 * - Found problem with joystick (hardware problem!), enabled.
 * - Minor tweaks, deleting old rem'ed out code.
 * - Added "speed" to debug display.  Works great!
 * - Increased aileron effectiveness in TRNER486.PLA, renamed
 *   changed file to TOAD486.PLA.
 * v1.3, 29 Apr 95
 * - Fixed bug in stick position indicator (my fault).
 * - Cleaned up throttle code, joystick constants.  Less WHAG now.
 * - Adding speed value display in any case.
 * 2 May 95
 * - Added drag when on ground.  (Looked silly before when landing.)
 * - Still doesn't look right when it crashes. (Spins too long.)
 *   Obviously "airspeed" is not bleeding off rapidly enough.
 * - Added altimeter (kinda).
 * - Wing length now varies according to wing lift coefficient.
 *   The more lift, the longer the wing, horizontal and vertical
 *   stabilizers.  (We now have gliders!)
 *   Just guessing at the constants now (in RC_FLY3.C), but seems
 *   to look just fine.
 * - Hard-coded in some glider-related things in RC_FLY3.C
 *   - If it's a glider (long wing), it'll be hand-launched
 *	   (Not enough power to get off the ground).  This changes
 *	   launch aspect entirely!  GLIDER.PLA shows some suggested
 *	   values (long wings, low power, less aileron throw, less
 *     gravity to show "lighter" aircraft).  GLIDER.PLA flies very
 *	   nicely indeed on my 486-33 DX!  (I learned to fly RC on a
 *     2-meter RC glider I modified with an 0.10 engine.)
 *     CLIPWING.PLA shows the other contrast:  a speed ship!
 *
 * v1.4, May 95
 * - Figured out how runway lights were being painted.
 * - Drawing runway outline itself is broke.
 *   Old routine seems to draw some vertical poles, but that's all.
 * - Tried to add runway stripes, failed.
 * - Trying to remove floating point when possible.
 *   - Runway light variables, code now integer.
 * - Added joystick test, zeroing.
 * - BIG bug report after Internet release:
 *   If there's a game card in the system, it'll report joystick
 *   present.  Joystick sensing then overrides keyboard controls!
 *   Adding toggle ('J' key) to toggle joystick on and off,
 *   overriding any initial sensing.

 * To do:
 * - Function to establish max joystick limits.
 * - Some sort of sound (with Doppler).  Include crashes :-)
 * - Add different color sky.
 *
 *   David Kirschbaum
 *   Toad Hall
 *   kirschd@hq.ljl.com
 ************************************************************************/

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <graphics.h>

#include "rc_flyer.h"

/* v1.1 Joystick-related stuff */

#include "joystick.h"
extern struct joystick JoyStick;

#define Aileron  JoyStick.pos_Ax
#define Elevator JoyStick.pos_Ay
#define Throttle JoyStick.pos_By
#define Trigger	 JoyStick.switch_0
#define Switch	 JoyStick.switch_1


floaT		Limit(floaT pos);
void		ReadKeyboardControls(void);
void		MoveAirplane(void);
void		UpdateScreen(void);
void		Calc_Boxes(void);			/* v1.3 */
void		Center_Joystick(void);		/* v1.4 */

extern void	InitAll(char *paramFilename);
extern void	InitFlight(void);
extern int	ReadParams(char *paramFilename);
extern void	ShowIntroScreen(void);
extern void	MyDelay(int);

extern floaT Angle(floaT fX, floaT fY);
extern void	CalcViewVectors(pointT * pTo, vectorT * vVects);
extern void	TwistPoint(pointT * p, vectorT * V, pointT * pRet);
extern void	ProjectToPixel(pointT * p, pixelT * pp);
extern void	ProjectToPoints(pointT * p, int *pp);
extern void	RotateVector(vectorT * v, vectorT * vRet, vectorT * axis, floaT fAng);
extern void	NormalVector(vectorT * v1, vectorT * v2, vectorT * vRet);
extern floaT VectorLength(vectorT * v);

char copyright[] = "Copyright (c) 1995 Mikko Oksalahti and Harri Rautio \
All Rights Reserved.  Free distribution and use permitted.";
char version[] = "Version 1.4";

floaT		fEnginePower;

vectorT 	vEngineVector;
vectorT 	vDragVector;
vectorT 	vLiftVector;
vectorT 	vElevatorVector;
vectorT 	vAileronVector;
vectorT 	vGravityVector;

pointT		pAirplanePosition;
pointT		pOldAirplanePosition;

vectorT 	vSpeedVector;
vectorT 	vOldSpeedVector;

floaT		fOldSpeed;		/* v1.2 */

airplaneT	aFlyer;

/* Runway lights */
pointT		pBox[12];		/* Position in world */
pixelT		xBox[12];		/* Position on screen */
int			iBoxWidth[12];	/* runway lights v1.4 was floaT*/

pointT		pAirplane[13];			/* Shape of airplane */
pointT		pAirplaneInWorld[13];	/* Airplane in world coordinates */
int			iAirplane[26];			/* Airplane in screen coordinates */

pointT	pShadowInWorld[8];		/* Airplane in world coordinates */
int		iShadow[16];			/* Wings only create shadow */

int		iHorizon;				/* new horizon position */

int		bAftVisible = FALSE;		/* Is the Aft of the plane visible?
									 * (if not, then fore is) */
int		bBottomVisible = FALSE;

floaT		fStickXPos;		/* Aileron control v1.1 */
floaT		fStickYPos;		/* Elevator control v1.1 */
floaT		fRollAngle = 0; /* how much is the airplane banked */


/*
 * The following values are somewhat suitable for normal
 * 386 w/ math co-processor
 */

#define AIRDRAG 0.01		/* v1.3 */
#define WHEELDRAG 0.03		/* increased drag when on ground v1.3 */

floaT		fA = 0.005;		/* coefficient for engine power */
floaT		fB = AIRDRAG;	/* coefficient for air drag */
floaT		fC = 0.001;		/* coefficient for lift */
floaT		fD = 0.01;		/* coefficient for gravity */
floaT		fE = 0.2;		/* coefficient for aileron throw */
floaT		fF = 0.1;		/* coefficient for elevator throw */
floaT		fG = 256;		/* view plane distance */

floaT		fBBackup;
floaT		fDBackup;
floaT		fGBackup;

floaT		fRatio;		/* used to calculate wing length v1.3 */

int		bQuit = FALSE;
int		bCrash = FALSE;
int		gear_up = FALSE;			/* v1.3 */

int		i;
floaT	fTmp;
int		iInLoop = 0,
		iInRoll = 0,
		iGraphPage = 0;
int		acenter,ecenter;		/* joystick center values v1.4 */
int		joyswitch = FALSE;		/* Assume user has no joystick v1.4 */
int		throttleswitch = FALSE;	/* nor throttle v1.4 */

#ifdef DEBUG		/* enable to get position reports, more */
int		midx,midy;
char	msg1[40],msg2[40];
char	msg3[40][3];
char	msg4[40];
#endif
char	speedstr[20];			/* for speed display v1.3 */
char	altstr[20];				/* altitude v1.3 */
//char	dragstr[20];
//char	wingstr[20];

int		main(int argc, char *argv[])
{

	InitAll(argv[1]);

	ShowIntroScreen();

#ifdef DEBUG	/* v1.3 */
	midx = getmaxx() / 2;
	midy = getmaxy() / 2;
#endif
	settextjustify(CENTER_TEXT, CENTER_TEXT);

	Center_Joystick();			/* Test for, center joystick v1.4 */

	/* Loop here until we exit.  All the flying is done in this loop. */

	do {
		InitFlight();

		do {
			ReadKeyboardControls();
			MoveAirplane();
			UpdateScreen();
		} while (!bQuit);

	} while (!bQuit);

	restorecrtmode();
	return (0);
}	/* main */


/* v1.4 Common routine. */

void Center_Joystick(void)
{
	if(!joyswitch)
		return;

	if(read_joystick())		/* no joystick */
		joyswitch = FALSE;		/* don't use it */
	else
	{
		/* For now, assume joystick is centered.
		 * Later, tell the user to release it.
		 */
		acenter = Aileron;
		ecenter = Elevator-8;		/* slight nose-up trim */
#ifdef DEBUG
		while(!kbhit())
		{
			read_joystick();
			fStickXPos = Limit((acenter-Aileron) / 40.0);	/* aileron  */
			fStickYPos = Limit((ecenter-Elevator)/ 40.0);	/* elevator */
			UpdateScreen();
		}
		(void) getch();
#endif
	}
}

/* v1.4 common routine */
floaT Limit(floaT pos)
{
	if(pos>1.0)
		return(1.0);
	else if(pos<-1.0)
		return(-1.0);
	else return(pos);
}

/* v1.1 Consolidate all our zooming around.
 * Add a "restore normal distance" function.
 */
#define NORMAL 0
#define IN	1
#define OUT 2

void zoom(int direction)
{
	switch(direction)
	{
		case NORMAL:fG = 256;
					break;
		case IN:	fG *= 1.5;		/* v1.4 2.0; */
					break;
		case OUT:	fG /= 1.5;		/* v1.4 2.0; */
					break;
	}
	Calc_Boxes();			/* v1.3 */
}	/* zoom */

void	ReadKeyboardControls(void)
{
	char	c;

	if (kbhit())
	{
		c = getch();

		switch (c)
		{
		case '8':				/* nose down */
			if (!bCrash)
				fStickYPos += ((fStickYPos < 1.0) ? 0.1 : 0.0);
			break;
		case '2':				/* nose up */
			if (!bCrash)
				fStickYPos -= ((fStickYPos > -1.0) ? 0.1 : 0.0);
			break;
		case '4':				/* roll left */
			if (!bCrash)
				fStickXPos += ((fStickXPos < 1.0) ? 0.1 : 0.0);
			break;
		case '6':				/* roll right */
			if (!bCrash)
				fStickXPos -= ((fStickXPos > -1.0) ? 0.1 : 0.0);
			break;
		case '5':				/* center aileron */
			if (!bCrash)
				fStickXPos = 0.0;
			/* fStickYPos = 0.0; */
			break;
		case 'i':				/* init flight */
			InitFlight();
			break;
		case 's':				/* full throttle */
			if (!bCrash)
				fEnginePower = 1.0;
			break;
		case 'a':				/* increase throttle */
			if (!bCrash)
				fEnginePower = ((fEnginePower < 0.9) ?
					(fEnginePower + 0.1) : 1.0);
			break;
		case 'z':				/* decrease throttle */
			if (!bCrash)
				fEnginePower = ((fEnginePower > 0.1) ?
					(fEnginePower - 0.1) : 0.0);
			break;
		case 'x':				/* no throttle at all */
			fEnginePower = 0.0;
			break;
		case '+':				/* zoom in */
			zoom(IN);			/* v1.1 */
			break;
		case '-':				/* zoom out */
			zoom(OUT);			/* v1.1 */
			break;
		case 'j':				/* Toggle joystick v1.4 */
			joyswitch ^= 1;		/* turn on or off */
			Center_Joystick();	/* If on, read and center */
			break;
		case 't':				/* Toggle throttle v1.4 */
			throttleswitch ^= 1;	/* turn on or off */
			break;
		case 'q':				/* quit altogether */
		case 27:				/* Escape v1.3 */
			bQuit = 1;
			break;
		}
	}	/* if kbdhit */

	if(joyswitch)						/* v1.4 */
	{
		if(!bCrash && !read_joystick())		/* v1.2 */
		{
		/*	JoyStick.pos_Ax,		/ left/right,	0..75
			JoyStick.pos_Ay,		/ up/down,		5..74
			JoyStick.pos_Bx,		/ increases with more left
			JoyStick.pos_By);		/ Throttle full/off  60..5
		*/

#ifdef DEBUG
			sprintf(msg1, "%02u %02u %02u, %1u%1u",
				Aileron, Elevator, Throttle, Trigger, Switch);	/* v1.3 */
#endif
			/* Elevator		Ay	fStickYPos
			 * Full Up		5	-1
			 * Full Down	74	+1
			 */
			fStickYPos = Limit((ecenter-Elevator) / 40.0);	/* elevator v1.4 */

			/* Aileron		Ax	fStickXPos
			 * Full Left	 0		+1
			 * Full Right	75		-1
			 */
			fStickXPos = Limit((acenter-Aileron) / 40.0);	/* aileron v1.4 */

			/* Engine		By	fEnginePower
			 * Off          60	1.0
			 * Full          5	0
			 * v1.3 Still twiddling constants
			 */
			if(throttleswitch)						/* v1.4 */
			{
				fEnginePower = (60-Throttle) /60.0;		/* Throttle full/off  60..5 */
				if(fEnginePower>1) fEnginePower=1;		/* v1.3 */
				else if(fEnginePower<0) fEnginePower=0;
			}

			/* v1.1 Add zoom in/out via button 1 and 2 */
			if(!Trigger && !Switch)				/* both pressed v1.3 */
				zoom(NORMAL);					/* reset to normal distance */
			else if(!Trigger)					/* v1.3 */
				zoom(IN);
			else if(!Switch)					/* My button #2 v1.3 */
				zoom(OUT);
		}
	}
#ifdef DEBUG
	/* prepare a global debug string for later display */
	sprintf(msg2, "%02.02f %02.02f %02.02f %02.02f",
				fStickXPos,fStickYPos,
				fEnginePower,
				fOldSpeed);
#endif
	sprintf(speedstr,"speed: %3d", (int) (fOldSpeed * 100));
	sprintf(altstr,  "alt:   %3d",
		(int) (pAirplanePosition.fZ+1.8) * 5);


//	sprintf(dragstr,"drag: %03.4f",fB);
//	sprintf(wingstr,"wingspan: %1.2f",fRatio*2.0);
}	/* ReadKeyboardControls */


void	MoveAirplane(void)
{
	static vectorT	vViewVectors[3],
			vTmp;
	static pointT	pTmp,
			pTmp2;
	static pixelT	xTmp;

	/* Move the airplane in the world */

	/* rotate the plane based on aileron stick position: */
	fRollAngle -= fStickXPos * fE;
	if (fRollAngle < 0)
		fRollAngle += PI2;
	else if (fRollAngle > PI2)
		fRollAngle -= PI2;

	/* create engine vector: */
	fTmp = fEnginePower * fA;		/* do this just once v1.1 */
	vEngineVector.fI = aFlyer.vFuselage.fI * fTmp;
	vEngineVector.fJ = aFlyer.vFuselage.fJ * fTmp;
	vEngineVector.fK = aFlyer.vFuselage.fK * fTmp;

	/* create lift vector: */
	fOldSpeed = VectorLength(&vOldSpeedVector);
	fTmp = fOldSpeed * fC;		/* do this just once v1.1 */
	vLiftVector.fI = aFlyer.vUp.fI * fTmp;
	vLiftVector.fJ = aFlyer.vUp.fJ * fTmp;
	vLiftVector.fK = aFlyer.vUp.fK * fTmp;

	/* create air drag vector: */
	fTmp = fOldSpeed * fB;		/* do this just once v1.1 */
	vDragVector.fI = -aFlyer.vFuselage.fI * fTmp;
	vDragVector.fJ = -aFlyer.vFuselage.fJ * fTmp;
	vDragVector.fK = -aFlyer.vFuselage.fK * fTmp;

	/* create elevator vector: */
	fTmp = fOldSpeed * -fStickYPos * fF;	/* do this just once v1.1 */
	vElevatorVector.fI = aFlyer.vUp.fI * fTmp;
	vElevatorVector.fJ = aFlyer.vUp.fJ * fTmp;
	vElevatorVector.fK = aFlyer.vUp.fK * fTmp;

	/* calculate new speed vector: */
	vSpeedVector.fI = vOldSpeedVector.fI +
		vEngineVector.fI +
		vLiftVector.fI +
		vDragVector.fI +
		vGravityVector.fI +
		vElevatorVector.fI;
	vSpeedVector.fJ = vOldSpeedVector.fJ +
		vEngineVector.fJ +
		vLiftVector.fJ +
		vDragVector.fJ +
		vGravityVector.fJ +
		vElevatorVector.fJ;
	vSpeedVector.fK = vOldSpeedVector.fK +
		vEngineVector.fK +
		vLiftVector.fK +
		vDragVector.fK +
		vGravityVector.fK +
		vElevatorVector.fK;

	/* calculate new position for airplane: */
	pAirplanePosition.fX += vSpeedVector.fI;
	pAirplanePosition.fY += vSpeedVector.fJ;
	pAirplanePosition.fZ += vSpeedVector.fK;
	if (pAirplanePosition.fZ < -1.8)		/* below ground level */
	{
		pAirplanePosition.fZ = -1.8;		/* no cratering */
		gear_up = FALSE;					/* assume gear down v1.3 */

		if ((vSpeedVector.fK < -0.03) && (!bCrash))
		{
			/* crash happened: increase gravity, increase drag & set
			 * control surfaces irrationally (simulates breaking of the
			 * pushrods).
			 */

			fB *= 10;
			fD *= 10;
			fStickYPos = 0;
			fStickXPos = 1.0;
			fEnginePower = 0.0;

			bCrash = TRUE;		// 1;
		}
		if (!bCrash)
		{
			vSpeedVector.fK = 0;	/* stop downward travel */
			fB = WHEELDRAG;			/* increase drag v1.3 */
		}
	}
	else
	{
		/* v1.3 Adding takeoff and landing drag.
		 * (Very unrealistic to see the landing aircraft
		 * skate along as if it were on ice.)
		 */
		if(!gear_up)					/* haven't taken off before */
		{
			fB = fBBackup;				/* we've lifted off, decrease drag */
			gear_up = TRUE;				/* Just do it once */
		}
	}
	/* Rotate the airplane so that it points where speed vector points:
	 * Do it the following way:
	 * First set fuselage vector to point same direction as speed vector.
	 * Then create wing based on new fuse and old up vector.
	 * was: Then create a wing vector that is horizontal and points right
	 *      of the fuselage.
	 * Then rotate wing about fuse if fStickXPos says so.
	 * was: Then rotate wing vector about fuselage fRollAngle degrees.
	 *      Then create up vector based on fuselage and wing.
	 */

	fTmp = VectorLength(&vSpeedVector);
	aFlyer.vFuselage.fI = vSpeedVector.fI / fTmp;
	aFlyer.vFuselage.fJ = vSpeedVector.fJ / fTmp;
	aFlyer.vFuselage.fK = vSpeedVector.fK / fTmp;


	/* new version: */
	NormalVector(&(aFlyer.vFuselage), &(aFlyer.vUp), &vTmp);
	fTmp = VectorLength(&vTmp);
	aFlyer.vWing.fI = vTmp.fI / fTmp;
	aFlyer.vWing.fJ = vTmp.fJ / fTmp;
	aFlyer.vWing.fK = vTmp.fK / fTmp;
	if (fStickXPos)
	{
		/* rotate with vector addition because it might be faster: */

		fTmp = fOldSpeed*fStickXPos*fE;		/* do this just once v1.1 */
		vTmp.fI = aFlyer.vWing.fI+aFlyer.vUp.fI * fTmp;
		vTmp.fJ = aFlyer.vWing.fJ+aFlyer.vUp.fJ * fTmp;
		vTmp.fK = aFlyer.vWing.fK+aFlyer.vUp.fK * fTmp;

		fTmp = VectorLength(&vTmp);
		aFlyer.vWing.fI = vTmp.fI / fTmp;
		aFlyer.vWing.fJ = vTmp.fJ / fTmp;
		aFlyer.vWing.fK = vTmp.fK / fTmp;
	}
	/* determine new up vector: */
	NormalVector(&aFlyer.vWing, &aFlyer.vFuselage, &vTmp);
	fTmp = VectorLength(&vTmp);
	aFlyer.vUp.fI = vTmp.fI / fTmp;
	aFlyer.vUp.fJ = vTmp.fJ / fTmp;
	aFlyer.vUp.fK = vTmp.fK / fTmp;

	/* save the speed vector for next round: */
	vOldSpeedVector.fI = vSpeedVector.fI;
	vOldSpeedVector.fJ = vSpeedVector.fJ;
	vOldSpeedVector.fK = vSpeedVector.fK;

	for (i = 0; i < 13; ++i) {
		pAirplaneInWorld[i].fX = pAirplanePosition.fX +
			(pAirplane[i].fX * aFlyer.vWing.fI +
			 pAirplane[i].fY * aFlyer.vFuselage.fI +
			 pAirplane[i].fZ * aFlyer.vUp.fI);

		pAirplaneInWorld[i].fY = pAirplanePosition.fY +
			(pAirplane[i].fX * aFlyer.vWing.fJ +
			 pAirplane[i].fY * aFlyer.vFuselage.fJ +
			 pAirplane[i].fZ * aFlyer.vUp.fJ);

		pAirplaneInWorld[i].fZ = pAirplanePosition.fZ +
			(pAirplane[i].fX * aFlyer.vWing.fK +
			 pAirplane[i].fY * aFlyer.vFuselage.fK +
			 pAirplane[i].fZ * aFlyer.vUp.fK);
	}

	for (i = 5; i < 13; ++i) {
		pShadowInWorld[i - 5].fX = pAirplaneInWorld[i].fX;
		pShadowInWorld[i - 5].fY = pAirplaneInWorld[i].fY;
		pShadowInWorld[i - 5].fZ = -2.0;	/* shadow always on the ground */
	}

	/* set the bAft & bBottom indicators */
	if (VectorLength((vectorT *) & pAirplaneInWorld[0])
	  > VectorLength((vectorT *) & pAirplaneInWorld[1]))
		bBottomVisible = TRUE;
	else
		bBottomVisible = FALSE;

	if (VectorLength((vectorT *) & pAirplaneInWorld[0])
	  > VectorLength((vectorT *) & pAirplaneInWorld[2]))
		bAftVisible = TRUE;
	else
		bAftVisible = FALSE;

	/* Project objects into screen */

	/* Project the runway and light boxes: */
	CalcViewVectors(&pAirplanePosition, vViewVectors);
	for (i = 0; i < 12; ++i) {
		TwistPoint(&pBox[i], vViewVectors, &pTmp);
		if (pTmp.fZ < 0)
			xBox[i].iX = -1;	/* clip point if it's behind camera */
		else
			ProjectToPixel(&pTmp, &xBox[i]);
	}

	/* Project the horizon */

	if (abs((int) pAirplanePosition.fX) > abs((int) pAirplanePosition.fY))
	{
		pTmp.fX = 2000.0;
		pTmp.fY = 1.0;
	} else
	{
		pTmp.fY = 2000.0;
		pTmp.fX = 1.0;
	}
	pTmp.fZ = -2.0;
	TwistPoint(&pTmp, vViewVectors, &pTmp2);
	ProjectToPixel(&pTmp2, &xTmp);
	if ((xTmp.iY > 480) || (xTmp.iY < 0))
		iHorizon = 0;		/* angle too high or low to see horizon */
	else
		iHorizon = xTmp.iY;

	/* Project the airplane: */
	for (i = 0; i < 13; ++i) {
		TwistPoint(&pAirplaneInWorld[i], vViewVectors, &pTmp);
		ProjectToPoints(&pTmp, &iAirplane[i << 1]);
	}

	/* Project the shadow: */
	for (i = 0; i < 8; ++i) {
		TwistPoint(&pShadowInWorld[i], vViewVectors, &pTmp);
		ProjectToPoints(&pTmp, &iShadow[i << 1]);
	}
}	/* MoveAirplane */


void	UpdateScreen(void)
{
	int	i, once;		/* v1.1 */

	/* clear old and draw new image: */

	cleardevice();

	if(iHorizon != 0)				/* v1.4 */
	{
		setcolor(DARKGRAY);				/* horizon */
		line(0, iHorizon, 640, iHorizon);
	}
	setcolor(RED);					/* throttle bar */
	line(10, 10, 10 + (int) (fEnginePower * 200), 10);	/* shorter v1.3 */

	/* Stick position indicator at screen top center */
	line(340, 30, 340, 10);
	line(330, 20, 350, 20);

	once = 340- (int) (fStickXPos * 10.0);		/* do this once v1.0 */
	line(once, 22, once, 18);
	once = 20- (int) (fStickYPos * 10.0);		/* do this once v1.0 */
	line(338, once, 342, once);
#ifdef DEBUG		/* v1.3 */
	outtextxy(midx,midy+10,msg2);		/* computed control settings */
	outtextxy(midx,midy+20,msg4);		/* fAng1, fAng2 rc_flyer2.C */
//	outtextxy(580,30,dragstr);			/* debug: show drag */
//	outtextxy(564,40,wingstr);			/* wingspan */
#endif
	outtextxy(580,10,speedstr);			/* display speed upper right v1.3 */
	outtextxy(580,20,altstr);			/* and altitude */

	if ((iShadow[1] < 480) &&		/* wing */
		(iShadow[3] < 480) &&
		(iShadow[5] < 480) &&
		(iShadow[7] < 480) &&
		(iShadow[9] < 480) &&		/* stab */
		(iShadow[11] < 480) &&
		(iShadow[13] < 480) &&
		(iShadow[15] < 480) &&
		(iShadow[1] > 0) &&			/* wing */
		(iShadow[3] > 0) &&
		(iShadow[5] > 0) &&
		(iShadow[7] > 0) &&
		(iShadow[9] > 0) &&			/* stab */
		(iShadow[11] > 0) &&
		(iShadow[13] > 0) &&
		(iShadow[15] > 0))
	{
		setfillstyle(SOLID_FILL, DARKGRAY);
		setcolor(DARKGRAY);
		fillpoly(4, iShadow);		/* wing */
		fillpoly(4, &iShadow[8]);	/* stab */
	}

/*	Runway light order
 *		7		6		5		4
 *		11		10		9	   +8
 *
 * acft starts out at #8
 */

/* v1.4 Runway can't get painted because it's seldom entirely onscreen. */

//#ifdef V14
	/* First the runway itself */
	setcolor(DARKGRAY);
	for (i = 0; i < 4; ++i)		/* 0..3 is runway corners */
	{
		if ((xBox[i].iX >= 0) &&
			(xBox[i].iX <= 640) &&
			(xBox[i].iY >= 0) &&
			(xBox[i].iY <= 350))
			line(xBox[i].iX,
				 xBox[i].iY,
				 xBox[i].iX,
				 xBox[i].iY +50);	// - (iBoxWidth[i] * 30));
	}
//#endif
	/* Now the runway lights */
	setfillstyle(SOLID_FILL, BLUE);
	for (i = 4; i < 12; ++i)
	{
		if ((xBox[i].iX >= 0) &&
			(xBox[i].iX <= 640) &&
			(xBox[i].iY >= 0) &&
			(xBox[i].iY <= 350))
		{
			bar(xBox[i].iX - iBoxWidth[i],
				xBox[i].iY - iBoxWidth[i],
				xBox[i].iX + iBoxWidth[i],
				xBox[i].iY + iBoxWidth[i]);
		}
	}

	setcolor(DARKGRAY);
	if (bAftVisible) {
		if (bBottomVisible) {
			setfillstyle(SOLID_FILL, RED);
			fillpoly(4, &iAirplane[18]);	/* Main wing */
			fillpoly(3, &iAirplane[4]);		/* Fin */
			fillpoly(4, &iAirplane[10]);	/* Stab */
			fillpoly(3, &iAirplane[0]);		/* Fuse */
		} else {
			setfillstyle(SOLID_FILL, RED);
			fillpoly(3, &iAirplane[0]);		/* Fuse */
			setfillstyle(SOLID_FILL, WHITE);
			fillpoly(4, &iAirplane[18]);	/* Main wing */
			fillpoly(4, &iAirplane[10]);	/* Stab */
			setfillstyle(SOLID_FILL, RED);
			fillpoly(3, &iAirplane[4]);		/* Fin last
											 * so it isn't covered by stab */
		}
	} else {
		if (bBottomVisible) {
			setfillstyle(SOLID_FILL, RED);
			fillpoly(4, &iAirplane[18]);	/* Main wing */
			fillpoly(3, &iAirplane[4]);		/* Fin */
			fillpoly(4, &iAirplane[10]);	/* Stab */
			fillpoly(3, &iAirplane[0]);		/* Fuse */
		} else {
			setfillstyle(SOLID_FILL, RED);
			fillpoly(3, &iAirplane[0]);		/* Fuse */
			setfillstyle(SOLID_FILL, WHITE);
			fillpoly(4, &iAirplane[10]);	/* Stab */
			setfillstyle(SOLID_FILL, RED);
			fillpoly(3, &iAirplane[4]);		/* Fin */
			setfillstyle(SOLID_FILL, WHITE);
			fillpoly(4, &iAirplane[18]);	/* Main wing */
		}
	}
#ifdef DEBUG		/* v1.1 */
	outtextxy(midx, midy, msg1);		/* raw joystick values */
	outtextxy(midx,midy+10,msg2);		/* computed control settings */
	for(i=0;i<4;i++)
		outtextxy(midx,midy+20+(i*10),msg3[i]);
#endif

	setvisualpage(iGraphPage % 2);
	++iGraphPage;
	setactivepage(iGraphPage % 2);

}	/* UpdateScreen */

/* v1.3 Consolidate this in one place */
void Calc_Boxes(void)
{
	/* Calc width of boxes on screen now once.
	 * We can use them later all the time,
	 * because boxes are stationary in the world.
	 */
	int i;

	for (i = 0; i < 12; i++)
		iBoxWidth[i] = (int) ((fG / 6) / sqrt(pBox[i].fX
			* pBox[i].fX + pBox[i].fY * pBox[i].fY));

	for(i = 0; i< 4; i++)
		if(xBox[i].iX > 640)
			xBox[i].iX = 640;
		else if(xBox[i].iX < 0)
			xBox[i].iX = 0;
		if(xBox[i].iY > 350)
			xBox[i].iY = 350;
		else if(xBox[i].iY < 0)
			xBox[i].iY=0;

}	/* Calc_Boxes */
