/************************************************************************
 *
 * RC-Flyer I
 *
 * by Mikko Oksalahti & Harri Rautio
 *
 * initall()  Initialize graphics, shapes

 v1.3, 2 May 95  Toad Hall Tweak
 - Modifying wing, horizontal stabilizer, rudder shape,
   depending on .PLA lift value.
   The bigger the lift value, the longer the wing.
   This gives us gliders!
   Also forcing hand-launch if low-powered (e.g., a glider).
v1.4, 20 May 95
 - Adding joystick toggle, must change menu screen as well.

 ************************************************************************/

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h>
#include <graphics.h>
#include <conio.h>
#include <dos.h>

#include "rc_flyer.h"
#include "joystick.h"		/* v1.3 */

void	InitAll(char *paramFilename);
void	InitFlight(void);
int		ReadParams(char *paramFilename);
void	ShowIntroScreen(void);
extern	void 	Calc_Boxes(void);			/* v1.3 */


extern floaT	fEnginePower;

extern vectorT	vEngineVector;
extern vectorT	vDragVector;
extern vectorT	vLiftVector;
extern vectorT	vElevatorVector;
extern vectorT	vAileronVector;
extern vectorT	vGravityVector;

extern pointT	pAirplanePosition;
extern pointT	pOldAirplanePosition;

extern vectorT	vSpeedVector;
extern vectorT	vOldSpeedVector;

extern airplaneT aFlyer;

/* Runway lights */
extern pointT	pBox[]; 		/* Position in world */
extern pixelT	xBox[]; 		/* Position on screen */

extern pointT	pAirplane[];		/* Shape of airplane */
extern pointT	pAirplaneInWorld[];	/* Airplane in world coordinates */
extern int		iAirplane[];		/* Airplane in screen coordinates */

extern pointT	pShadowInWorld[];	/* Airplane in world coordinates */
extern int		iShadow[];			/* Wings only create shadow */

extern int		bAftVisible;	/* Is the Aft of the plane visible? (if not,
								 * then fore is) */
extern int		bBottomVisible;

extern floaT	fStickXPos;		/* Elevator control */
extern floaT	fStickYPos;		/* Aileron control */

extern floaT	fA;				/* coefficient for engine power */
extern floaT	fB;				/* coefficient for air drag */
extern floaT	fC;				/* coefficient for lift */
extern floaT	fD;				/* coefficient for gravity */
extern floaT	fE;				/* coefficient for aileron throw */
extern floaT	fF;				/* coefficient for elevator throw */
extern floaT	fG;				/* view plane distance */

extern floaT	fBBackup;
extern floaT	fDBackup;
extern floaT	fGBackup;

#ifdef V14_UNUSED
extern floaT	mySin[];
extern floaT	myCos[];
#endif

extern floaT	fRatio;		/* used to calculate wing length v1.3 */

extern int		bCrash,
				gear_up;		/* v1.3 */

extern floaT	fTmp;
extern int		joyswitch,
				throttleswitch;	/* v1.4 */

extern char version[];			/* v1.4 */

floaT minim(floaT f)
{
	if(f < 0.1)
		return(0.1);
	else
		return(f);
}

void	InitAll(char *paramFilename)
{
	int	grMode,
		grDriver;

	/* read the aircraft etc. parameters from file */

	ReadParams(paramFilename);

	/* v1.3 if fC (wing lift coefficient) is 0.001,
	 * fRatio = 0.6			(normal)
	 * As wing lift coefficient goes up, so does fRatio.
	 * Range 0.001 (386) to 0.00133 (486) to ??
	 */
	if(fC > 0.001)			/* long wing */
		fRatio = 0.6 * ( (fC - 0.001) * 4000);		/* SWAG v1.3 */
	else if(fC <0.001)		/* clipped wing */
		fRatio = 0.6 * ( (fC-0.001) * 8000);		/* SWAG v1.3 */
	else
		fRatio = 0.6;			/* default */

	/* Make an airplane: */

	/* Fuselage: 0, 1, 2 */
	pAirplane[0].fX = 0;
	pAirplane[0].fY = 0.6;
	pAirplane[0].fZ = 0;

	pAirplane[1].fX = 0;
	pAirplane[1].fY = 0.6;
	pAirplane[1].fZ = -0.15;

	pAirplane[2].fX = 0;
	pAirplane[2].fY = -0.6;
	pAirplane[2].fZ = 0;

	/* Fin: 2, 3, 4 */
	/* 4 = vertical distance */

	fTmp = minim(0.25 * fRatio);	/* v1.3 */

	pAirplane[3].fX = 0;
	pAirplane[3].fY = -0.6;
	pAirplane[3].fZ = fTmp;		/* was 0.2 v1.3 */

	pAirplane[4].fX = 0;
	pAirplane[4].fY = -0.45;
	pAirplane[4].fZ = 0;

	/* Stabilizer: 5, 6, 7, 8
	 * 5 = stab width */

	fTmp = minim(0.36 * fRatio);	/* v1.3 */

	pAirplane[5].fX = fTmp;			/* was 0.25 v1.3 */
	pAirplane[5].fY = -0.45;
	pAirplane[5].fZ = 0;

	pAirplane[6].fX = fTmp;			/* was 0.25 v1.3 */
	pAirplane[6].fY = -0.6;
	pAirplane[6].fZ = 0;

	pAirplane[7].fX = -fTmp;		/* was -0.25 v1.3 */
	pAirplane[7].fY = -0.6;
	pAirplane[7].fZ = 0;

	pAirplane[8].fX = -fTmp;		/* was -0.25 v1.3 */
	pAirplane[8].fY = -0.45;
	pAirplane[8].fZ = 0;

	/* Wing: 9, 10, 11, 12 */
	/* 9 = width */

	pAirplane[9].fX = -fRatio;		/* was -0.6 v1.3 */
	pAirplane[9].fY = 0.3;
	pAirplane[9].fZ = 0;

	pAirplane[10].fX = fRatio;		/* was 0.6 v1.3 */
	pAirplane[10].fY = 0.3;
	pAirplane[10].fZ = 0;

	pAirplane[11].fX = fRatio;		/* was 0.6 v1.3 */
	pAirplane[11].fY = 0;
	pAirplane[11].fZ = 0;

	pAirplane[12].fX = -fRatio;		/* was -0.6 v1.3 */
	pAirplane[12].fY = 0;
	pAirplane[12].fZ = 0;

	/* Init points of interest */

/*	Runway light order
 *		7		6		5		4
 *		--		--		--		--
 *		11		10		9	   +8
 *
 * acft starts out at #8
 */

	pBox[0].fX = -50.0;
	pBox[0].fY = -20.0;
	pBox[0].fZ = -2.0;

	pBox[1].fX = -30.0;
	pBox[1].fY = -40.0;
	pBox[1].fZ = -2.0;

	pBox[2].fX = 40.0;
	pBox[2].fY = -40.0;
	pBox[2].fZ = -2.0;

	pBox[3].fX = -40.0;
	pBox[3].fY = 50.0;
	pBox[3].fZ = -2.0;

	pBox[4].fX = 8.0;
	pBox[4].fY = -5.0;
	pBox[4].fZ = -2.0;

	pBox[5].fX = 8.0;
	pBox[5].fY = 10.0;
	pBox[5].fZ = -2.0;

	pBox[6].fX = 8.0;
	pBox[6].fY = 25.0;
	pBox[6].fZ = -2.0;

	pBox[7].fX = 8.0;
	pBox[7].fY = 40.0;
	pBox[7].fZ = -2.0;

	pBox[8].fX = 3.0;
	pBox[8].fY = -5.0;
	pBox[8].fZ = -2.0;

	pBox[9].fX = 3.0;
	pBox[9].fY = 10.0;
	pBox[9].fZ = -2.0;

	pBox[10].fX = 3.0;
	pBox[10].fY = 25.0;
	pBox[10].fZ = -2.0;

	pBox[11].fX = 3.0;
	pBox[11].fY = 40.0;
	pBox[11].fZ = -2.0;

	/* Set gravity */

	vGravityVector.fI = 0.0;
	vGravityVector.fJ = 0.0;
	vGravityVector.fK = -1.0 * fD;

#ifdef V14_UNUSED		/* v1.4 no longer used */
	/* Precalculate sines & cosines for speed */

	for (i = 0; i < 630; ++i) {
		mySin[i] = sin(i / 100.0);
		myCos[i] = cos(i / 100.0);
	}
#endif

	/* Init graphics */

	grDriver = EGA;
	grMode = EGAHI;
	initgraph(&grDriver, &grMode, "");

	if (graphresult() != grOk) {
		printf("Could not initialize graphics!\n");
		exit(0);
	}
	fBBackup = fB;				/* save original coefficient for use after
								 * crash (in InitFlight) */
	fDBackup = fD;
	fGBackup = fG;

	gear_up = FALSE;			/* haven't taken off yet v1.3 */
}	/* InitAll */


void	InitFlight(void)
{
//	int	i;

	/* Create an airplane easy yet fast: */

	aFlyer.vFuselage.fI = 0;
	aFlyer.vFuselage.fJ = 1;
	aFlyer.vFuselage.fK = 0;
	aFlyer.vWing.fI = 1;
	aFlyer.vWing.fJ = 0;
	aFlyer.vWing.fK = 0;
	aFlyer.vUp.fI = 0;
	aFlyer.vUp.fJ = 0;
	aFlyer.vUp.fK = 1;

	/* Position airplane to the beginning of runway 18 with little speed:
	 * v1.3 Except .. if we have <0.0020 power (typically a glider),
	 * we'll need a hand-launch to overcome the (new) ground rolling
	 * resistance.
	 */

	pAirplanePosition.fX = 4.5;		/* v1.4 was 3.5; */
	pOldAirplanePosition.fX = 4.5;	/* v1.4 was 3.5; */

	vOldSpeedVector.fJ = 0.01;		/* horizontal vector */
	vOldSpeedVector.fK = 0;			/* vertical vector */

	if(fA <= 0.0020)		/* Low-powered v1.3 */
	{
		pAirplanePosition.fY = 0;		/* stand right behind aircraft */
		pOldAirplanePosition.fY = 0;

		pAirplanePosition.fZ = -1.2;	/* shoulder-height */
		pOldAirplanePosition.fZ = -1.2;

		vOldSpeedVector.fI = 0.1;		/* a little forward speed */
		fGBackup = 1024;				/* override .FLA distance.
										 * Aircraft is REAL close. */

		fEnginePower = 1.0;		/* Gotta have power for handlaunch */
	}
	else{
		pAirplanePosition.fY = -4;		/* standing off to side */
		pOldAirplanePosition.fY = -4;

		pAirplanePosition.fZ = -1.8;	/* acft on the ground */
		pOldAirplanePosition.fZ = -1.8;	/* little or no speed */
		vOldSpeedVector.fI = 0;
		fEnginePower = 0;				/* No power: let user do it */
	}

	fB = fBBackup;
	fD = fDBackup;
	fG = fGBackup;

	fStickXPos = 0;
	fStickYPos = 0;
	bCrash = 0;

	/* Calc widths of boxes on screen now once.
	 * We can use them later all the time,
	 * because boxes are stationary in the world.
	 */
		Calc_Boxes();		/* v1.3 */
}	/* InitFlight */


int	ReadParams(char *paramFilename)
{
	FILE	*fp;
	char	strLine[256];

	if ((fp = fopen(paramFilename, "r")) == NULL) {
		printf("Could not find file %s\nUse default airplane? (y/n): ",
			paramFilename);
		if (getch() == 'y') {
		} else
			exit(0);
	} else {

		/* read in coefficients from file */

/* from TOAD486.PLA
0.0035        (fA Engine power coefficient)
0.0066        (fB Air drag coefficient)
0.00133       (fC Wing lift coefficient)  default is 0.001
0.0066        (fD Gravity coefficient)
0.3           (fE 0.1333 Aileron throw coefficient)
0.066         (fF Elevator throw coefficient)
256           (fG Viewplane distance)
F			  (Any non-F to enable joystick v1.4)
*/
		fgets(strLine, 255, fp);			/* Engine power coefficient */
		sscanf(strLine, "%lf", &fA);
		fgets(strLine, 255, fp);			/* Air drag coefficient */
		sscanf(strLine, "%lf", &fB);
		fgets(strLine, 255, fp);			/* Wing lift coefficient */
		sscanf(strLine, "%lf", &fC);
		fgets(strLine, 255, fp);			/* Gravity coefficient */
		sscanf(strLine, "%lf", &fD);
		fgets(strLine, 255, fp);			/* 0.1333 Aileron throw coefficient */
		sscanf(strLine, "%lf", &fE);
		fgets(strLine, 255, fp);			/* Elevator throw coefficient */
		sscanf(strLine, "%lf", &fF);
		fgets(strLine, 255, fp);			/* Viewplane distance */
		sscanf(strLine, "%lf", &fG);
		if(fgets(strLine,255,fp))			/* adding joystick switch v1.4 */
		{
			joyswitch=(*strLine!= 'F');		/* Any non-F enables joystick v1.4 */
			if(fgets(strLine,255,fp))		/* adding throttle switch v1.4 */
				throttleswitch=(*strLine!='F');	/* any non-F enables throttle v1.4 */
		}
		fclose(fp);
	}

	return (1);
}


void	ShowIntroScreen(void)
{
	int		plane[26];
	int		planeX,
			planeY;
	floaT	fRatio = 0.6*2;		/* v1.3 */

	setactivepage(0);
	setvisualpage(1);
	setbkcolor(BLACK);
	cleardevice();

	/* draw background bars: */
	setfillstyle(SOLID_FILL, DARKGRAY);
	bar(100, 0, 284, 350);
	setfillstyle(SOLID_FILL, LIGHTGRAY);
	bar(284, 0, 540, 350);
	setcolor(WHITE);
	rectangle(100, 0, 540, 349);

	/* draw text */
	setcolor(RED);
	setfillstyle(SOLID_FILL, RED);
	fillellipse(192, 48, 50, 36);
	setcolor(WHITE);
	outtextxy(110, 26, " MIKKO'S AND HARRI'S");
	outtextxy(110, 46, "     MAGNIFICENT");
	outtextxy(110, 66, "    RC-SIMULATOR!");
	outtextxy(112, 100, "Virtual reality!");
	outtextxy(112, 115, "Flying on ice on a");
	outtextxy(112, 125, "cloudy day!");
	outtextxy(112, 140, "Realistic flight");
	outtextxy(112, 150, "characteristics!");
	outtextxy(112, 165, "Simple, yet powerful");
	outtextxy(112, 175, "aircraft design!");
	outtextxy(112, 190, "Automatic crash");
	outtextxy(112, 200, "detection!");
	outtextxy(112, 215, "Embedded on-screen");
	outtextxy(112, 225, "control panel!");
	outtextxy(112, 250, "'4','6' = aileron");
	outtextxy(112, 260, "'8','2' = elevator");
	outtextxy(112, 270, "'a','z' = throttle");
	outtextxy(112, 280, "'s','x' = fast -\"-");
	outtextxy(112, 290, "'5'     = center");
	outtextxy(112, 300, "'+','-' = zoom");
	outtextxy(112, 310, "'i'     = reset");
	outtextxy(112, 320, "'q'     = quit");
	setcolor(joyswitch ? GREEN : RED);
	outtextxy(112, 330, "'j'     = joystick");		/* v1.4 */
	setcolor(throttleswitch ? GREEN : RED);
	outtextxy(112, 340, "'t'     = throttle");		/* v1.4 */
	setcolor(LIGHTGRAY);
	/* v1.2 Toad Hall Tweaks */
	setcolor(GREEN);
	outtextxy(340,15,  version);				/* v1.4 */
	setcolor(LIGHTRED);
	outtextxy(300, 25, "  Now with joystick");
	outtextxy(300, 35, "   and instruments!");
	outtextxy(300, 45, "Courtesy of Toad Hall");

	/* draw finnish flag and stuff */
	setcolor(DARKGRAY);
	outtextxy(410, 290, "  Yet another");
	outtextxy(410, 300, "quality product");

	setfillstyle(SOLID_FILL, WHITE);
	bar(420, 310, 520, 336);
	setfillstyle(SOLID_FILL, BLUE);
	bar(450, 310, 466, 336);
	bar(420, 319, 520, 327);

	outtextxy(414, 338, " from Finland");
	setcolor(BLACK);
	rectangle(420, 310, 520, 336);


	/* draw horizon & stuff on ground */
	setcolor(DARKGRAY);
	line(284, 220, 539, 180);

	setcolor(BLUE);
	bar(330 - 2, 265 - 2, 330 + 2, 265 + 1);
	bar(350 - 2, 247 - 2, 350 + 2, 247 + 1);
	bar(368 - 2, 234 - 2, 368 + 2, 234 + 1);
	bar(384 - 2, 224 - 2, 384 + 2, 224 + 1);

	bar(456 - 2, 240 - 2, 456 + 2, 240 + 1);
	bar(452 - 2, 230 - 2, 452 + 2, 230 + 1);
	bar(448 - 2, 221 - 2, 448 + 2, 221 + 1);
	bar(444 - 2, 214 - 2, 444 + 2, 214 + 1);

	/* draw plane */
	planeX = 300;
	planeY = 70;
//	fRatio = 0.6;

	plane[0] = planeX + 80; 	/* fuse */
	plane[1] = planeY + 0 * fRatio;
	plane[2] = planeX + 60;
	plane[3] = planeY + 20 * fRatio;
	plane[4] = planeX + 150;
	plane[5] = planeY + 180 * fRatio;
	plane[6] = planeX + 175;	/* fin */
	plane[7] = planeY + 154 * fRatio;
	plane[8] = planeX + 140;
	plane[9] = planeY + 152 * fRatio;
	plane[10] = planeX + 100;	/* stab */
	plane[11] = planeY + 170 * fRatio;
	plane[12] = planeX + 180;
	plane[13] = planeY + 140 * fRatio;
	plane[14] = planeX + 185;
	plane[15] = planeY + 165 * fRatio;
	plane[16] = planeX + 118;
	plane[17] = planeY + 200 * fRatio;
	plane[18] = planeX + 0; 	/* wing */
	plane[19] = planeY + 70 * fRatio;
	plane[20] = planeX + 160;
	plane[21] = planeY + 20 * fRatio;
	plane[22] = planeX + 175;
	plane[23] = planeY + 60 * fRatio;
	plane[24] = planeX + 23;
	plane[25] = planeY + 125 * fRatio;

	setfillstyle(SOLID_FILL, RED);
	fillpoly(3, plane);
	setfillstyle(SOLID_FILL, WHITE);
	fillpoly(4, plane + 10);
	fillpoly(4, plane + 18);
	setfillstyle(SOLID_FILL, RED);
	fillpoly(3, plane + 4);

	setvisualpage(0);
	(void) getch();
	setbkcolor(LIGHTGRAY);
	cleardevice();
}	/* ShowIntroScreen */


#ifdef NEVER_USED
void	MyDelay(int millisec)
{
	delay(millisec);
}
#endif
