/************************************************************************
 *																		*
 * RC-Flyer I															*
 *																		*
 * by Mikko Oksalahti & Harri Rautio									*
 * Vector math 															*
 *																		*
 ************************************************************************/


#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h>
#include <graphics.h>

#include "rc_flyer.h"

floaT	Angle(floaT fX, floaT fY);
void	CalcViewVectors(pointT * pTo, vectorT * vVects);
void	TwistPoint(pointT * p, vectorT * V, pointT * pRet);
void	ProjectToPixel(pointT * p, pixelT * pp);
void	ProjectToPoints(pointT * p, int *pp);
void	RotateVector(vectorT * v, vectorT * vRet, vectorT * axis, floaT fAng);
void	NormalVector(vectorT * v1, vectorT * v2, vectorT * vRet);
floaT	VectorLength(vectorT * v);
void	CalculateRotations(airplaneT * a, vectorT * v, floaT * ang1, floaT * ang2);

extern floaT	fStickXPos;		/* Elevator control */
extern floaT	fStickYPos;		/* Aileron control */

extern floaT	fE;				/* coefficient for aileron throw */
extern floaT	fF;				/* coefficient for elevator throw */
extern floaT	fG;				/* coefficient for viewplane distance */

extern floaT	fTmp;

floaT	Angle(floaT fX, floaT fY)
{
	/* calculate the angle between vector (0,0) to (x,y) and x-axis return
	 * the angle in radians. */
	if (fX == 0)				/* right angle ( 90 or 270 ) */
		if (fY >= 0)
			return (PIPER2);
		else
			return (PI + PIPER2);
	else {
		fTmp = atan(fY / fX);
		if (((fX < 0) && (fY < 0)) || ((fTmp < 0) && (fY >= 0)))
			return (PI + fTmp);
		else if (fTmp < 0)
			return (PI2 + fTmp);
		else
			return (fTmp);
	}
}	/* Angle */


void	CalcViewVectors(pointT * pTo1, vectorT * vVects)
{
/* Calculate three vectors ( length 1, all vectors in right angle with
 * each other ) so that vector k is pointing from ATP to TOP. The vectors
 * are used for projecting the world coordinates to view- coordinates
 * ( and for rotating a movable object ).
 */

/*
	floaT	fAng1, fAng2;
*/
	double long	fAng1,fAng2;		/* v1.4 */
	pointT	pTo;
	char foo[30];

	pTo.fX = pTo1->fX;
	pTo.fY = pTo1->fY;
	pTo.fZ = pTo1->fZ;

	if (pTo.fX == 0)
		pTo.fX = 0.000001;

	fAng1 = Angle(pTo.fY, -pTo.fX);	/* v1.4 */

	pTo.fY = sqrt((pTo.fX * pTo.fX) + (pTo.fY * pTo.fY));
	pTo.fX = 0;

	fAng2 = Angle(-pTo.fZ, pTo.fY);	/* v1.4 */

#define DEBUG 1
#ifdef DEBUG
	sprintf(foo,"%10L %10L",fAng1,fAng2);
	outtextxy(110, 26, foo);
#endif

	vVects[2].fK = -cos(fAng2);
	vVects[2].fJ = sin(fAng2);

	vVects[1].fJ = -vVects[2].fK;
	vVects[1].fK = vVects[2].fJ;

	fTmp = vVects[2].fJ;

	vVects[2].fI = -sin(fAng1) * fTmp;
	vVects[2].fJ = cos(fAng1) * fTmp;	/* 2 is now OK */

	fTmp = vVects[1].fJ;

	vVects[1].fI = -sin(fAng1) * fTmp;
	vVects[1].fJ = cos(fAng1) * fTmp;	/* 1 is now OK */

	vVects[0].fI = cos(fAng1);
	vVects[0].fJ = sin(fAng1);

	vVects[0].fK = 0;			/* 0 is now OK */
}	/* CalcViewVectors */


/* use this method to change coordinate system:
		x := objAt.x * objVectors.i.x +
		 objAt.y * objVectors.j.x +
		 objAt.z * objVectors.k.x;
		y := objAt.x * objVectors.i.y +
		 objAt.y * objVectors.j.y +
		 objAt.z * objVectors.k.y;
		z := objAt.x * objVectors.i.z +
		 objAt.y * objVectors.j.z +
		 objAt.z * objVectors.k.z;
*/


void	TwistPoint(pointT * p, vectorT * V, pointT * pRet)
{
	/* Transform the wolrdcoordinate-point P to viewcoordinate-point PRET
	 * using given view vectors V.
	 */

	floaT	fDetV;

	fDetV = (V[1].fJ * V[2].fK - V[2].fJ * V[1].fK) * V[0].fI -
		(V[0].fJ * V[2].fK - V[2].fJ * V[0].fK) * V[1].fI +
		(V[0].fJ * V[1].fK - V[1].fJ * V[0].fK) * V[2].fI;

	pRet->fX = ((V[1].fJ * V[2].fK - V[2].fJ * V[1].fK) * p->fX -
				(p->fY * V[2].fK - V[2].fJ * p->fZ) * V[1].fI +
				(p->fY * V[1].fK - V[1].fJ * p->fZ) * V[2].fI) / fDetV;

	pRet->fY = ((p->fY * V[2].fK - V[2].fJ * p->fZ) * V[0].fI -
				(V[0].fJ * V[2].fK - V[2].fJ * V[0].fK) * p->fX +
				(V[0].fJ * p->fZ - p->fY * V[0].fK) * V[2].fI) / fDetV;

	pRet->fZ = ((V[1].fJ * p->fZ - p->fY * V[1].fK) * V[0].fI -
				(V[0].fJ * p->fZ - p->fY * V[0].fK) * V[1].fI +
				(V[0].fJ * V[1].fK - V[1].fJ * V[0].fK) * p->fX) / fDetV;
}	/* TwistPoint */



void	ProjectToPixel(pointT * p, pixelT * pp)
{
	/* Project the given 3D-point P to the normalized coordinates
	 * X, Y and Z
	 */

	fTmp = p->fZ / fG;		/* fG = view plane distance (from param file) */
	pp->iX = p->fX / fTmp + 320;
	pp->iY = -0.72916666 * (p->fY / fTmp) + 110;
}	/* ProjectToPixel */


void	ProjectToPoints(pointT * p, int *pp)
{
	/* Project the given 3D-point P to the normalized coordinates
	 *  X, Y and Z
	 */

	fTmp = p->fZ / fG;		/* fG = view plane distance (from param file) */
	*pp = p->fX / fTmp + 320;
	*(pp + 1) = -0.72916666 * (p->fY / fTmp) + 110;
}	/* ProjectToPoints */


floaT	VectorLength(vectorT * v)
{
	return (sqrt(v->fI * v->fI + v->fJ * v->fJ + v->fK * v->fK));
}	/* VectorLength */



void	RotateVector(vectorT * v, vectorT * vRet, vectorT * axis, floaT fAng)
{
	/* rotate the given vector about the given axis the given angle */

	static floaT	fA,
			fD,
			fC,
			fB,
			fB2plusC2,
			fD2plusA2,
			fD2plusA2perD,
			fA2,fC2,fD2,		/* v1.1 */
			cosfAng,sinfAng,	/* v1.1 */
			fCfD, fBfD;			/* v1.1 */

	static vectorT	vTmp;
	static int	iAngle;

	fD = sqrt(axis->fJ * axis->fJ + axis->fK * axis->fK);

	if (fD == 0)
		fD = 0.0000001;

	fC = axis->fK;
	fB = axis->fJ;
	fA = axis->fI;

#ifdef OLDSTUFF
	fB2plusC2 = fB * fB + fC * fC;
	fD2plusA2 = fD * fD + fA * fA;
	fD2plusA2perD = fD * fD + ((fA * fA) / fD);
#else
	fA2 = fA * fA;		/* do this just once v1.1 */
	fC2 = fC * fC;
	fD2 = fD * fD;
	fB2plusC2 = fB * fB + fC2;	/* v1.1 */
	fD2plusA2 = fD2 + fA2;		/* v1.1 */
	fD2plusA2perD = fD2 + ((fA2) / fD);
#endif
	if (fB2plusC2 == 0)
		fB2plusC2 = 0.0000001;

	if (fD2plusA2 == 0)
		fD2plusA2 = 0.0000001;

	if (fD2plusA2perD == 0)
		fD2plusA2perD = 0.0000001;

	/* rotate axis to xz-plane STEP 1: */
	vRet->fI = v->fI;
	vRet->fJ = (fC * v->fJ - fB * v->fK) / fD;
	vRet->fK = (fB * v->fJ + fC * v->fK) / fD;

	/* rotate axis along z-axis STEP 2: */
	vTmp.fI = fD * vRet->fI - fA * vRet->fK;
	vTmp.fJ = vRet->fJ;
	vTmp.fK = fA * vRet->fI + fD * vRet->fK;

	/* perform rotation: */
	if (fAng < 0)
		fAng += PI2;

	iAngle = (int) (fAng * 100);

#ifdef OLDSTUFF
	vRet->fI = cos(fAng) * vTmp.fI - sin(fAng) * vTmp.fJ;
	vRet->fJ = sin(fAng) * vTmp.fI + cos(fAng) * vTmp.fJ;
#else
	cosfAng = cos(fAng);
	sinfAng = sin(fAng);
	vRet->fI = cosfAng * vTmp.fI - sinfAng * vTmp.fJ;
	vRet->fJ = sinfAng * vTmp.fI + cosfAng * vTmp.fJ;
#endif

	vRet->fK = vTmp.fK;

	/* inverse rotate STEP 2: */
	vTmp.fI = vRet->fI / fD2plusA2perD + (fA * vRet->fK) / fD2plusA2;
	vTmp.fJ = vRet->fJ;
	vTmp.fK = (-fA * vRet->fI) / fD2plusA2 + vRet->fK / fD2plusA2perD;

	/* inverse rotate STEP 1: */
	vRet->fI = vTmp.fI;
#ifdef OLDSTUFF
	vRet->fJ = (vTmp.fJ * fC * fD) / fB2plusC2 + (vTmp.fK * fB * fD) / fB2plusC2;
	vRet->fK = -(vTmp.fJ * fB * fD) / fB2plusC2 + (vTmp.fK * fC * fD) / fB2plusC2;
#else
	fCfD = fC * fD;		/* v1.1 */
	fBfD = fB * fD;		/* v1.1 */
	vRet->fJ = (vTmp.fJ * fCfD) / fB2plusC2 + (vTmp.fK * fBfD) / fB2plusC2;
	vRet->fK = -(vTmp.fJ * fBfD) / fB2plusC2 + (vTmp.fK * fCfD) / fB2plusC2;
#endif
}	/* RotateVector */



void	NormalVector(vectorT * v1, vectorT * v2, vectorT * vRet)
{
	vRet->fI = v1->fJ * v2->fK - v1->fK * v2->fJ;
	vRet->fJ = v1->fK * v2->fI - v1->fI * v2->fK;
	vRet->fK = v1->fI * v2->fJ - v1->fJ * v2->fI;
}	/* NormalVector */


void	CalculateRotations(airplaneT * a, vectorT * v, floaT * fAng1, floaT * fAng2)
{
	/* calculate the 2 angles necessary to turn the airplane so that it
	 * points to same direction as vector v does ang1 is the angle to rotate
	 * about vUp and ang2 is the angle to rotate about vWing. */

	floaT		fUpA,
			fUpB,
			fWingA,
			fWingB;

	fUpA = v->fI * a->vWing.fI +
		v->fJ * a->vWing.fJ +
		v->fK * a->vWing.fK;
	fUpB = v->fI * a->vFuselage.fI +
		v->fJ * a->vFuselage.fJ +
		v->fK * a->vFuselage.fK;

	fWingA = fUpB;
	fWingB = v->fI * a->vUp.fI +
		v->fJ * a->vUp.fJ +
		v->fK * a->vUp.fK;

	if (fUpB == 0)
		*fAng1 = 0;
	else
		*fAng1 = atan(fUpA / fUpB);

	if (fWingB == 0)
		*fAng2 = 0;
	else
		*fAng2 = atan(fWingA / fWingB);
}	/* CalculateRotations */
