/*
**  JOYSTICK.C
**
**  Joystick support functions
**
**  Public domain demo by Bob Stout
** From SNIP9503.ZIP
*/

#undef TESTJOY

#include <dos.h>

#ifdef TESTJOY
#include <process.h>		/* exit() */
#include <stdio.h>			/* printf() */
#include <conio.h>			/* gotoxy() */
#endif

#include "joystick.h"

char joycopyright[] = "Joystick routines from Bob Stout, C Snippets";

struct joystick JoyStick;

/*
**  read_joystick()
**
**  returns SUCCESS or ERROR
**
**  fills in global JoyStick structure
*/

LOGICAL 	read_joystick(void)
{
	union REGS	regs;

	regs.h.ah = 0x84;			/* Read the switches	*/
	regs.x.dx = 0;
	int86(0x15, &regs, &regs);
	if (regs.x.cflag)
		return ERROR;
	JoyStick.switch_0 = BOOL(regs.h.al & 0x10);
	JoyStick.switch_1 = BOOL(regs.h.al & 0x20);
	JoyStick.switch_2 = BOOL(regs.h.al & 0x40);
	JoyStick.switch_3 = BOOL(regs.h.al & 0x80);

	regs.h.ah = 0x84;			/* Read positions	*/
	regs.x.dx = 1;
	int86(0x15, &regs, &regs);
	if (regs.x.cflag)
		return ERROR;
	JoyStick.pos_Ax = regs.x.ax;
	JoyStick.pos_Ay = regs.x.bx;
	JoyStick.pos_Bx = regs.x.cx;
	JoyStick.pos_By = regs.x.dx;

	return SUCCESS;
}

#ifdef TESTJOY
void main(void)
{
	char	c;
	clrscr();
	_setcursortype(_NOCURSOR);

	while(1)
	{
		if (kbhit())
		{
			_setcursortype(_NORMALCURSOR);
			c = getch();
			exit(0);
		}
		if(!read_joystick())
		{
			gotoxy(5,10);
			printf("%3u %3u %3u %3u",
				JoyStick.pos_Ax,		/* left/right,	0..75 */
				JoyStick.pos_Ay,		/* up/down,		5..74 */
				JoyStick.pos_Bx,		/* increases with more left */
				JoyStick.pos_By);		/* Throttle full/off  60..5 */
			gotoxy(10,12);
			putch(JoyStick.switch_0 ? '0' : ' ');		/* trigger */
			gotoxy(12,12);
			putch(JoyStick.switch_1 ? '1' : ' ');		/* bomb */
			gotoxy(14,12);
			putch(JoyStick.switch_2 ? '2' : ' ');		/* bomb */
			gotoxy(16,12);
			putch(JoyStick.switch_3 ? '3' : ' ');		/* nothing */
		}
	}
}
#endif
