//Cats20.cpp
//Will not work on any C++ compiler. I used Borland's Turbo C++ v3.0
//Program for CAT calculations. It should import cpm's from keyboard or
//from the file and correct for the toluene, substract background and
//calculate times fold. This is version 2.0. Hurray!
//Also it can save protocol and load it later. This feature is for Ray.
//Written by Srdjan Askovic
//November 09, 1995

#include <conio.h>
#include <iostream.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include <dos.h>
#include <dir.h>
#include <process.h>

#define FALSE 0
#define TRUE 1
#define DEFAULT_FILE "defaults.cat"

void main_menu(void);
void set_defaults(void);
void read_defaults(void);
void find_pound(void);
void write_defaults();
char pause_me(int yn);
void input_from_keyboard(void);
int continue_anyway(void);
int gt_cell_line(int optional);
int gt_target(int optional);
int gt_blank_cpms(void);
void input_from_file(void);
int display_initial(void);
int up_arrow(int index);
int down_arrow(int index);
void display_window(int yn);
void send_to_display(void);
int up_arr(int index);
int down_arr(int index);
void send_to_printer(void);
void send_to_file(void);
void change_defaults(void);
void invalid_entry(void);
int compare_string(char string1[], char string2[], int how_many);
void file_error(char file_name[30], char rw[7], FILE *fptr);
void calculate_all(void);
int get_blevel(void);
void change_background(void);
void restoreme(int which_one);
int change_sample_cpm(void);
int change_sample_name(void);
void change_target_name(void);
void change_cell_line(void);
void load_file(void);
void copy_string(char s1[], char s2[]);
void read_lines(char kw[20], char fname_in[30], FILE *fptr);
void load_protocol(void);
void peek_in(char pname[]);
void add_protocol(void);
void make_window(void);
void make_big_window(void);
void make_change_window(char ww[]);
void restore_screen(void);
void delchars(int number_of_chars);
void welcome_msg(void);
void wrong(void);

FILE *fp1, *fp2, *fp3, *fp4, *fp5, *fp6;        //I realy don't need that many
double t_cor_factor, t_added = 500.0, t_removed = 400.0;
double init_counts[103], blank_counts, tcor_bcor_counts[103];
double tcor_blank_counts, tcor_counts[103], x_fold[103];
char cat_target[11], sample_name[103][16], cell_line[11];
char filename_out[13] = "noname";
int basal_level, saved_yes = TRUE, background_color = 1, buff[25][80];



int main(void)                                     //Main function (obviously)
{
   int to_quit = FALSE, more;

   welcome_msg();                //Prints welcome to cats and pauses for 2 sec
   set_defaults();            //Reads defaults from file or makes default file
   textbackground(background_color);
   textcolor(YELLOW);                                         //Set text color
   while(to_quit != TRUE)                        //MAIN WHILE LOOP starts here
   {
      clrscr();                 //Clears screen and makes background effective
      main_menu();                             //Draws main menu on the screen
      fflush(stdin);
      switch(getch())                                //Main SWITCH starts here
      {
	 case '1':
	    input_from_keyboard();
	    break;
	 case '2':
	    input_from_file();
	    break;
	 case '3':
            do
	       more = display_initial();
            while(more == TRUE);
	    break;
	 case '4':
	    send_to_display();
	    break;
	 case '5':
	    send_to_printer();
	    break;
	 case '6':
	    send_to_file();
	    break;
	 case '7':
	    change_defaults();
	    break;
         case '\x1B':
	    to_quit = continue_anyway();
	    break;
	 default:
	    invalid_entry();
      }                                                //Main SWITCH ends here
   }                                               //Main WHILE LOOP ends here
   textbackground(0);                              //Restore screen parameters
   textcolor(WHITE);
   lowvideo();
   clrscr();
   _setcursortype(_NORMALCURSOR);
   return EXIT_SUCCESS;                                     //Returns 0 to DOS
}                                                       //END OF MAIN FUNCTION


void main_menu(void)                           //Draws main menu on the screen
{
   int i;                                              //Used in several for's

   gotoxy(11, 3);                                          //Possitions cursor
   putch('\xC9');                            //Upper left corner of the window
   for(i = 1; i <= 58; i++)                         //Upper edge of the window
      putch('\xCD');
   putch('\xBB');                           //Upper right corner of the window
   gotoxy(11, 4);
   putch('\xCC');                    //Side with inside extension to the right
   for(i = 1; i <= 58; i++)
      putch('\xCD');                                      //Prints second line
   cputs("\xB9\r\n");                 //Side with inside extension to the left
   gotoxy(35, 4);
   cputs("[ MAIN MENU ]");                          //Goes back and print this
   for(i =1; i < 17; i++)                //This for prints sides of the window
   {
      gotoxy(11, i + 4);
      putch('\xBA');
      gotoxy(70, i + 4);
      putch('\xBA');
   }
   gotoxy(11, 21);
   putch('\xCC');                    //Side with inside extension to the right
   for(i = 1; i <= 58; i++)
      putch('\xCD');                                              //Third line
   putch('\xB9');                     //Side with inside extension to the left
   gotoxy(11, 22);
   putch('\xC8');                                   //Prints lower left corner
   for(i = 1; i <= 58; i++)
      putch('\xCD');                                      //Prints bottom line
   cputs("\xBC\r\n");                              //Prints lower right corner
   gotoxy(35, 21);  cputs("[ ESC TO QUIT ]");      //Goes back and prints this
   gotoxy(25, 6);   cputs("1) Enter CPM's from the keyboard");
   gotoxy(25, 8);   cputs("2) Load CPM's from the file");
   gotoxy(25, 10);  cputs("3) Display initial counts");
   gotoxy(25, 12);  cputs("4) Send output to display");
   gotoxy(25, 14);  cputs("5) Send output to the printer");
   gotoxy(25, 16);  cputs("6) Save output to a file");
   gotoxy(25, 18);  cputs("7) Change defaults");
}



void set_defaults()       //If default file exists, reads it, if not makes one
{
   if((fp1 = fopen(DEFAULT_FILE, "r")) != NULL)      //If not NULL file exists
      read_defaults();                  //This function will read DEFAULT_FILE
   else
      write_defaults();                        //This will create DEFAULT_FILE
   return;                                                   //Returns to main
}                                               //END OF SET_DEFAULTS FUNCTION



void read_defaults(void)                    //Reads settings from default file
{
   char t_added_file_st[6] = "00000", t_removed_file_st[6] = "00000";
   char b_color_string[2] = "1";
   int safety1 = 0, safety2 = 0, index = 0;
                     // NOTE!!!   File was already open by set_defaults()!!!!!
   read_lines("BEGINHERE", DEFAULT_FILE, fp1);           //Looks for BEGINHERE
   find_pound();
   while((t_added_file_st[index] = fgetc(fp1)) != EOF)           //Reads chars
   {                                    //Loop reads file until space is found
      if(t_added_file_st[index++] == ' ') break;
      if(++safety1 > 4)                   //If space not found in 4 loops quit
         file_error(DEFAULT_FILE, "read", fp1);
   }
   t_added = atof(t_added_file_st);                 //Convert string to double
   find_pound();
   index = 0;                                                   //Resets index
   while((t_removed_file_st[index] = fgetc(fp1)) != EOF)         //Reads chars
   {
      if(t_removed_file_st[index++] == ' ') break;           //Breaks on space
      if(++safety2 > 4)                   //If space not found in 4 loops quit
         file_error(DEFAULT_FILE, "read", fp1);
   }
   t_removed = atof(t_removed_file_st);             //Convert string to double
   if(t_added <= t_removed) file_error(DEFAULT_FILE, "read", fp1);
   find_pound();
   if(!isdigit(b_color_string[0] = fgetc(fp1)))    //Load and check background
      file_error(DEFAULT_FILE, "read", fp1);
   background_color = atoi(b_color_string);
   fclose(fp1);                      //Done reading, so it closes default file
   return;              //Returns to set_defaults() which returns it to main()
}                                              //END OF READ_DEFAULTS FUNCTION



void find_pound(void)                       //Looks for pound sign (#) in file
{
   char marker_pound;
   int safe = 0;

   while((marker_pound = fgetc(fp1)) != EOF)     //Read chars until # is found
   {
      if(marker_pound == '#') break;
      if(++safe > 100) break;                          //Or 100 chars are read
   }
   if(marker_pound == EOF || safe > 100)                      //If # not found
      file_error(DEFAULT_FILE, "read", fp1);      //Display error msg and quit
}                                                 //END OF FIND_POUND FUNCTION



void write_defaults(void)      //Makes new or owerwrites existed DEFAULTS_FILE
{
   if((fp1 = fopen(DEFAULT_FILE, "w")) == NULL)   //Tries to open default file
      file_error(DEFAULT_FILE, "create", fp1);//In case of error exits program
   fprintf(fp1, "/%s/\n\n", DEFAULT_FILE);
   fprintf(fp1, "/DO NOT EDIT OR MODIFY THIS FILE/\n");
   fprintf(fp1, "/TO CHANGE DEFAULTS USE CHANGE DEFAULTS OPTION FROM ");
   fprintf(fp1, "FROM THE MAIN MENU/\n\n");
   fprintf(fp1, "BEGINHERE\n");
   fprintf(fp1, "#%0.f  \t\t\t/Toluene added/\n", t_added);
   fprintf(fp1, "#%0.f  \t\t\t/Toluene removed/\n", t_removed);
   fprintf(fp1, "#%d    \t\t\t/Background color/\n", background_color);
   fprintf(fp1, "ENDHERE\n\n");
   fprintf(fp1, "/DO NOT EDIT OR MODIFY THIS FILE/   ");
   fclose(fp1);                                           //Close DEFAULT_FILE
}                                             //END OF WRITE_DEFAULTS FUNCTION



char pause_me(int yn)                  //Pauses screen untill enter is pressed
{
   char c;

   if(yn == 1)
      cprintf("Press ENTER to continue...");
   fflush(stdin);
   while((c = getch()) != '\r')  { }             //Loops until you press enter
   return c;                                //For some reason it returns char?
}                                                   //END OF PAUSE_ME FUNCTION



void input_from_keyboard(void)      //Gets cpm's, cell lines ... from keyboard
{
   char temp_string[12], sn_tmp[18], *ptr1, *ptr2;
   int index2 =0, index3;

   if(init_counts[1] != 0.0 && saved_yes == FALSE) //If previous one not saved
      if(continue_anyway() == FALSE) return;
   if(gt_cell_line(1) != TRUE) return;                         //Get cell line
   for(index3 = 1; index3 < 102; index3++)     //Resets all init_counts to 0.0
      init_counts[index3] = 0.0;
   saved_yes = FALSE;                                             //Raise flag
   strcpy(filename_out, "noname");
   if(gt_target(1) != TRUE) return;                          //Get target name
   if(gt_blank_cpms() != TRUE) return;                   //Get cpms from blank
   make_big_window();
   while(++index2 < 101)      //Colects sample names and CPM's untill have 100
   {
      gotoxy(24, 9);  cprintf("Enter designation for sample # %d", index2);
      gotoxy(29, 11); cprintf("or press ENTER if done");
      textcolor(YELLOW);                                      //Set text color
      textbackground(WHITE);
      textcolor(BLACK);
      gotoxy(32, 13);  delchars(16);                         //Makes white box
      sn_tmp[0] = 16;               //Max number of chars in sample name is 15
      fflush(stdin);
      _setcursortype(_NORMALCURSOR);
      ptr1 = cgets(sn_tmp);                            //Gets sample name(tmp)
      _setcursortype(_NOCURSOR);
      textbackground(background_color);                              //Restore
      textcolor(YELLOW);
      if(strlen(ptr1) < 1) break;                 //If ENTER alone was pressed
      strcpy(sample_name[index2], ptr1);        //Copy from tmp to sample_name
      gotoxy(((80 - (17 + strlen(sample_name[index2])))/2), 16);      //Center
      cprintf("Enter counts for %s", sample_name[index2]);
      textbackground(WHITE);
      textcolor(BLACK);
      gotoxy(35, 18);  delchars(10);                          //Makes wite box
      temp_string[0] = 10;          //Max number of chars in CPM's string is 9
      fflush(stdin);
      _setcursortype(_NORMALCURSOR);
      ptr2 = cgets(temp_string);                             //Get sample cpms
      _setcursortype(_NOCURSOR);
      textbackground(background_color);                              //Restore
      textcolor(YELLOW);
      gotoxy(54, 9); delchars(4);                   //Deletes previous entries
      gotoxy(34, 18); delchars(12);
      gotoxy(20, 16); delchars(40);
      if(isdigit(ptr2[0]))
      {
         init_counts[index2] = atof(ptr2);            //If 1st char was number
         if(init_counts[index2] > 220000.00)//If number is to big mark as 0.66
            init_counts[index2] = 0.66;
         if(init_counts[index2] <= 0.0)            //If 0 or less mark as 0.33
            init_counts[index2] = 0.33;
      }
      else
         init_counts[index2] = 0.33;  //If 1st char isn't num marks it as 0.33
   }                             //End of while which collects names and CPM's
   if(init_counts[1] == 0.0) return;                  //If nothing was entered
   while(get_blevel()) {}                             //I like this expression
}                                       //END OF INPUT_FROM _KEYBOARD FUNCTION



int continue_anyway(void)    //If entry was not saved asks you are you sure...
{
   char yes_no;

   if(saved_yes == TRUE) return(TRUE);                 //This is kind of silly
   make_window();                                          //Little red window
   gotoxy(7, 4); cputs("Your last entry is not saved!");
   gotoxy(8, 5); cputs("Do you want to save it now?");
   textbackground(WHITE);                     //For whilte buttons (no shadow)
   textcolor(BLACK);
   gotoxy(7, 7); cprintf("  YES   ");
   gotoxy(17, 7); cprintf("   NO   ");
   gotoxy(27, 7); cprintf(" CANCEL ");
   textcolor(RED);
   gotoxy(9, 7); putch('Y');
   gotoxy(20, 7); putch('N');
   gotoxy(28, 7); putch('C');
   while(1)                                                    //Loops forewer
   {
      fflush(stdin);
      yes_no = toupper(getche());
      if(yes_no == 'Y')
      {
         send_to_file();
         restore_screen();
         return TRUE;
      }
      else if(yes_no == 'N')
      {
         restore_screen();
         return TRUE;
      }
      else if(yes_no == 'C')
      {
         restore_screen();
         return FALSE;
      }
   }                                                            //End of while
}                                          //END OF CONTINUE_ANYWAY() FUNCTION



int gt_cell_line(int optional)                           //Gets cell line name
{
   char opt[13], cl_tmp[13], *tmp_ptr;

   if(!optional)                             //This is really kind of reversed
      strcpy(opt, " (optional) ");
   else
      strcpy(opt, " ");                       //Needs this to calculate center
   make_big_window();                                        //Big blue window
   gotoxy((80 - (13 + strlen(opt)))/2, 12);                           //Center
   cprintf("Enter cell line%s", opt);
   textbackground(WHITE);
   textcolor(BLACK);
   gotoxy(35, 14); delchars(11);                             //Makes white box
   cl_tmp[0] = 11;               //Max number of chars in cell line name is 10
   fflush(stdin);
   _setcursortype(_NORMALCURSOR);
   tmp_ptr = cgets(cl_tmp);                              //Gets cell line name
   _setcursortype(_NOCURSOR);
   textbackground(background_color);                         //Restores colors
   textcolor(YELLOW);
   gotoxy(25, 12); delchars(42);                      //Deletes previous stuff
   gotoxy(35, 14); delchars(11);
   if(strlen(tmp_ptr) < 1)                        //If ENTER alone was pressed
      return FALSE;
   else
      strcpy(cell_line, tmp_ptr);
   return TRUE;
}                                             //END OF GT_CELL_LINE() FUNCTION



int gt_target(int optional)                                 //Gets target name
{
   char opt[14], t_tmp[13], *tmp_ptr;

   if(!optional)                                      //This is reversed again
      strcpy(opt, " (optional) ");
   else
      strcpy(opt, " ");
   gotoxy((80 - (15 + strlen(opt)))/2, 12);                           //Center
   cprintf("Enter target name%s", opt);
   textbackground(WHITE);
   textcolor(BLACK);
   gotoxy(35, 14); delchars(11);                             //Makes white box
   t_tmp[0] = 11;                   //Max number of chars in target name is 10
   fflush(stdin);
   _setcursortype(_NORMALCURSOR);
   tmp_ptr = cgets(t_tmp);                                  //Gets target name
   _setcursortype(_NOCURSOR);
   textbackground(background_color);                         //Restores colors
   textcolor(YELLOW);
   gotoxy(25, 12); delchars(42);                      //Deletes previous stuff
   gotoxy(35, 14); delchars(11);
   if(strlen(tmp_ptr) < 1)                        //If ENTER alone was pressed
      return FALSE;
   else
      strcpy(cat_target, tmp_ptr);
   return TRUE;
}                                                //END OF GT_TARGET() FUNCTION



int gt_blank_cpms(void)                             //Gets CPM's for the blank
{
   int index = 0, flag = FALSE;
   char blank_counts_st[11], *ptr;
   double tmp_cpms;

   while(flag != TRUE)            //Loops until first char for blank is number
   {
      gotoxy(27, 12); cprintf("Enter counts from the blank");
      textbackground(WHITE);
      textcolor(BLACK);
      gotoxy(36, 14); delchars(9);                           //Makes white box
      blank_counts_st[0] = 9;    //Max number of chars in blank_counts_st is 8
      fflush(stdin);                         //Flush the buffer (just in case)
      _setcursortype(_NORMALCURSOR);
      ptr = cgets(blank_counts_st);                 //Gets blank counts string
      _setcursortype(_NOCURSOR);
      textbackground(background_color);                      //Restores colors
      textcolor(YELLOW);
      if(strlen(ptr) < 1) return FALSE;           //If ENTER alone was pressed
      if(++index > 3) return FALSE;                      //If you fail 3 times
      if(!isdigit(ptr[0]))                     //If first char is not a number
      {
         flag = FALSE;                                          //Keep looping
         gotoxy(21, 8); delchars(40);
         gotoxy(23, 8); cprintf("That was an invalid entry, try again");
      }
      else if((tmp_cpms = atof(ptr)) > 60000.0)   //If blank cpm's are to high
      {
         flag = FALSE;                                          //Keep looping
         gotoxy(21, 8); delchars(40);
         gotoxy(22, 8); cprintf("Counts from the blank are out of range");
      }
      else flag = TRUE;                       //Ends loop if everything was OK
   }                                                            //End of while
   blank_counts = tmp_cpms;            //Finaly assigns number to blank_counts
   return TRUE;                                           //Returns OK message
}                                            //END OF GT_BLANK_CPMS() FUNCTION



void input_from_file(void)//Choice to open file or protocol or to add protocol
{
   char one_two_three;

   make_window();
   gotoxy(13, 3); cputs("1)  Load file");
   gotoxy(13, 5); cputs("2)  Load protocol");
   gotoxy(13, 7); cputs("3)  Add protocol");
   fflush(stdin);
   if((one_two_three = getch()) == '1')  load_file();
   else if(one_two_three == '2') load_protocol();
   else if(one_two_three == '3') add_protocol();
   else if((int) one_two_three == 13)              //If ENTER is pressed alone
      restore_screen();
   else
      invalid_entry();
}                                          //END OF INPUT_FROM_FILE() FUNCTION



int display_initial(void)                  //Displays initial counts and stuff
{
   int index;
   char key;

   if(init_counts[1] == 0.0)    //First checks that at least one # was entered
   {
      make_window();
      gotoxy(6, 4); cputs("What do you want me to display?");
      gotoxy(7, 5); cputs("You didn't enter any numbers");
      gotoxy(10, 8); cputs("Press ENTER to continue");
      pause_me(0);
      restore_screen();
      return FALSE;                       //If not sends you back to main menu
   }
   display_window(TRUE);        //Makes window for displaying counts and stuff
   window(2, 3, 79, 21);                               //Window for cpm's only
   for(index = 1; index < 20; index++)                         //Display cpm's
   {
      if(index != 1)                   //Doesn't put it before the first entry
         cputs("\r\n");
      cprintf("                      #%3d", index);
      cprintf("     %-15s", sample_name[index]);
      cprintf(" %9.2f", init_counts[index]);
      if(init_counts[index + 1] == 0.0) break;            //If next one is 0.0
   }
   while((int)(key = getch()) != 27)              //Loops until esc is pressed
   {
      if(key == 0)                                    //Catches extended codes
         key = (getch() - 100);                     //Substracts 100 from them
      if(key == '5')  change_background();
      if(key == '4')
      {
         if((change_sample_cpm()) != TRUE)
            return TRUE;                     //If changed refresh whole screen
      }
      if(key == '3')
      {
         if((change_sample_name()) != TRUE)
            return TRUE;                     //If changed refresh whole screen
      }
      if(key == '2')  change_target_name();
      if(key == '1')  change_cell_line();
      if((int) key == -28)   index = up_arrow(index);
      if((int) key == -20)   index = down_arrow(index);
   }
   window(1, 1, 80, 25);               //Restores full screen before returning
   return FALSE;                    //False means do not display this any more
}                                          //END OF DISPLAY_INITIAL() FUNCTION



int down_arrow(int index)                 //Moves text down in display_initial
{
   if(index < 20) return index;      //If there are less then 20 entries total
   if(wherey() < 19 && wherey() > 1) return index;   //If cursor in the middle
   if(init_counts[index] == 0.0) return index;            //If no more samples
   gotoxy(1, 19);                        //Goes to the last line in the window
   cputs("\r\n");                        //This scrolls everything up one line
   cprintf("                      #%3d", index);
   cprintf("     %-15s", sample_name[index]);
   cprintf(" %9.2f", init_counts[index]);
   index++;                                               //Increase index now
   return index;                                  //And return new index value
}                                               //END OF DOWN_ARROW() FUNCTION



int up_arrow(int index)                     //Moves text up in display_initial
{
   if((index - 19) <= 1) return index;          //If 1'st sample is at the top
   gotoxy(1, 1);                               //Goes to the top of the window
   insline();                                                   //Inserts line
   cprintf("                      #%3d", (index - 20));
   cprintf("     %-15s", sample_name[(index - 20)]);
   cprintf(" %9.2f", init_counts[(index - 20)]);
   index--;                                              //Now decreases index
   return index;                                  //And returns it's new value
}                                                 //END OF UP_ARROW() FUNCTION



void display_window(int yn)                 //Makes window for display_initial
{
   int i;

   make_big_window();                   //Full screen with double lined border
   textbackground(WHITE);
   textcolor(BLACK);
   gotoxy(1, 1);                                               //For upper bar
   if(yn == TRUE)                                     //If for display initial
   {
      cprintf(" CHANGE:   1)Cell line  2)Target  3)Sample name  ");
      cprintf("4)Sample CPM  5)Background CPM ");
   }
   else                                               //If for send to display
   {
      clreol();
      cprintf(" Correction factor is");
      gotoxy((64 - (strlen(sample_name[basal_level]))), 1);
      cprintf("Basal level is %s", sample_name[basal_level]);
   }
   gotoxy(1, 25);  clreol();                                   //For lower bar
   gotoxy(6, 25);  cprintf("to return");
   gotoxy(54, 25); cprintf("and   to move up and down");
   textcolor(RED);                                              //On upper bar
   if(yn == TRUE)                                     //If for display initial
   {
      gotoxy(12, 1); putch('1');
      gotoxy(25, 1); putch('2');
      gotoxy(35, 1); putch('3');
      gotoxy(50, 1); putch('4');
      gotoxy(64, 1); putch('5');
   }
   else                                               //If for send to display
   {
      gotoxy(23, 1); cprintf("%.2f", t_cor_factor);
      gotoxy((79 - strlen(sample_name[basal_level])), 1);
      cprintf("%s", sample_name[basal_level]);
   }
   gotoxy(2, 25); cprintf("ESC");                               //On lower bar
   gotoxy(52, 25); putch('\x18');                          //Displays up arrow
   gotoxy(58, 25); putch('\x19');                        //Displays down arrow
   textbackground(background_color);
   textcolor(YELLOW);
   gotoxy(1, 22); putch('\xCC');//Next for lines make extra line in the window
   for(i = 1; i <= 78; i++)
      putch('\xCD');
   putch('\xB9');
   gotoxy(6, 23);  cprintf("CELL LINE:");         //Prints in the lower window
   gotoxy(30, 23); cprintf("TARGET:");
   gotoxy(50, 23); cprintf("COUNTS FROM BLANK:");
   gotoxy(17, 23); cprintf("%s", cell_line);
   gotoxy(38, 23); cprintf("%s", cat_target);
   gotoxy(69, 23); cprintf("%.2f", blank_counts);
}



void send_to_display(void)                         //Displays x fold and stuff
{
   int index, i;
   char key;

   if(init_counts[1] == 0.0)    //First checks that at least one # was entered
   {
      make_window();
      gotoxy(6, 4); cputs("What do you want me to display?");
      gotoxy(7, 5); cputs("You didn't enter any numbers");
      gotoxy(10, 8); cputs("Press ENTER to continue");
      pause_me(0);
      restore_screen();
      return;                       //If not sends you back to main menu
   }
   calculate_all();                          //Make sure that it is up to date
   display_window(FALSE);       //Makes window for displaying counts and stuff
   gotoxy(1, 4); putch('\xCC');   //Next 4 lines make extra line in the window
   for(i = 1; i <= 78; i++)
      putch('\xCD');
   putch('\xB9');
   gotoxy(10, 3);
   cprintf("CLONE     ");                  //Right above where samples will be
   cprintf("        INITIAL");
   cprintf("    T-CORR");
   cprintf("    B-CORR");
   cprintf("               X-FOLD");
   window(2, 5, 79, 21);                    //Window for cpm's and x fold only
   for(index = 1; index < 18; index++)              //Display cpm's and x fold
   {
      if(index != 1)                   //Doesn't put it before the first entry
         cputs("\r\n");
      cprintf(" #%3d", index);
      cprintf("   %-15s", sample_name[index]);
      cprintf(" %9.2f", init_counts[index]);
      cprintf(" %9.2f", tcor_counts[index]);
      cprintf(" %9.2f", tcor_bcor_counts[index]);
      cprintf(" %20.2f", x_fold[index]);
      if(init_counts[index + 1] == 0.0) break;              //If next one is 0
   }
   while((int)(key = getch()) != 27)              //Loops until ESC is pressed
   {
      if(key == 0)                                    //Catches extended codes
         key = (getch() - 100);                     //Substracts 100 from them
      if((int) key == -28)   index = up_arr(index);
      if((int) key == -20)   index = down_arr(index);
   }
   window(1, 1, 80, 25);               //Restores full screen before returning
}                                          //END OF SEND_TO_DISPLAY() FUNCTION




int down_arr(int index)                   //Moves text down in send_to_display
{
   if(index <= 17) return index;           //If there are less than 17 samples
   if(wherey() < 17 && wherey() > 1) return index;   //If cursor in the middle
   if(init_counts[index] == 0.0) return index;            //If no more samples
   gotoxy(1, 17);                        //Goes to the last line in the window
   cputs("\r\n");                        //This scrolls everything up one line
   cprintf(" #%3d", index);
   cprintf("   %-15s", sample_name[index]);
   cprintf(" %9.2f", init_counts[index]);
   cprintf(" %9.2f", tcor_counts[index]);
   cprintf(" %9.2f", tcor_bcor_counts[index]);
   cprintf(" %20.2f", x_fold[index]);
   index++;                                               //Increase index now
   return index;                                  //And return new index value
}                                                 //END OF DOWN_ARR() FUNCTION



int up_arr(int index)                       //Moves text up in send_to_display
{
   if((index - 17) <= 1) return index;          //If 1'st sample is at the top
   gotoxy(1, 1);                               //Goes to the top of the window
   insline();                                                   //Inserts line
   cprintf(" #%3d", index - 18);
   cprintf("   %-15s", sample_name[index - 18]);
   cprintf(" %9.2f", init_counts[index - 18]);
   cprintf(" %9.2f", tcor_counts[index - 18]);
   cprintf(" %9.2f", tcor_bcor_counts[index - 18]);
   cprintf(" %20.2f", x_fold[index - 18]);
   index--;                                              //Now decreases index
   return index;                                  //And returns it's new value
}                                                   //END OF UP_ARR() FUNCTION



void send_to_printer(void)              //Prints ... (UNDER CONSTRUCTION)
{
   int index = 1, safe_brake = 1, i;

   if(init_counts[1] == 0.0)    //First checks that at least one # was entered
   {
      make_window();
      gotoxy(7, 4);   cputs("What do you want me to print?");
      gotoxy(7, 5);   cputs("You didn't enter any numbers");
      gotoxy(10, 8);  cputs("Press ENTER to continue");
      pause_me(0);
      restore_screen();
      return;                             //If not sends you back to main menu
   }
   if(saved_yes == FALSE)            //Unfortunatelly this is still neccessary
   {
      make_window();
      gotoxy(4, 4);   cputs("You need to save you results first?");
      gotoxy(2, 5);   cputs("If printer is off they might be lost!");
      gotoxy(10, 8);  cputs("Press ENTER to continue");
      pause_me(0);
      restore_screen();
      return;                             //If not sends you back to main menu
   }
   calculate_all();                             //To ensure that it is updated
   if((fp4 = fopen("PRN", "w")) == NULL)                 //Try to open printer
   {                                          //This part is still not working
      make_window();
      gotoxy(5, 4);  cprintf("Your printer is not responding");
      gotoxy(8, 5);  cprintf("Fix it and then try again");
      gotoxy(9, 7);  cprintf("Press ENTER to continue");
      pause_me(0);
      restore_screen();
      return;
   }
   fprintf(fp4, "\n \xC9");
   for(i = 0; i < 76; i++)
      fprintf(fp4, "\xCD");
   fprintf(fp4, "\xBB\n");
   fprintf(fp4, " \xBA");
   fprintf(fp4, "                            %13s", filename_out);
   fprintf(fp4, "                                   \xBA\n");
   fprintf(fp4, " \xC8");
   for(i = 0; i < 76; i++)
      fprintf(fp4, "\xCD");
   fprintf(fp4, "\xBC\n");
   fprintf(fp4, "                            ");
   fprintf(fp4, "Cell line used was %s\n", cell_line);
   fprintf(fp4, "            CAT target was %-15s", cat_target);
   fprintf(fp4, "  Counts from the blank = %.2f\n", blank_counts);
   fprintf(fp4, "       Correction factor is %.2f", t_cor_factor);
   fprintf(fp4, "               %s ", sample_name[basal_level]);
   fprintf(fp4, "is basal level (1 fold)\n\n");
   fprintf(fp4, "      #   Clone            Initial     T-Corr.");
   fprintf(fp4, "     B.-Corr.    Times fold\n ");
   for(i = 0; i < 78; i++)
      fprintf(fp4, "\xCD");
   fprintf(fp4, "\n");
   while(init_counts[index] != 0.0)
   {
      fprintf(fp4, "     %2d. %-15s", index, sample_name[index]);
      fprintf(fp4, "%10.2f ", init_counts[index]);
      fprintf(fp4, " %10.2f", tcor_counts[index]);
      fprintf(fp4, "   %10.2f ", tcor_bcor_counts[index]);
      fprintf(fp4, "  %9.2f\n", x_fold[index]);
      index++;
      if(++safe_brake > 100) break;
   }
   fprintf(fp4, " ");
   for(i = 0; i < 78; i++)
      fprintf(fp4, "\xCD");
   fprintf(fp4, "\f");
   fclose(fp4);                                              //Closing printer
}                                            //END OF SEND_TO_PRINTER FUNCTION



void send_to_file(void)                          //Saves init_counts to a file
{
   int index = 1, ii;
   char fn_tmp[11], *ptr;

   if(init_counts[1] == 0.0)    //First checks that at least one # was entered
   {
      make_window();
      gotoxy(7, 4);   cputs("What do you want me to save?");
      gotoxy(7, 5);   cputs("You didn't enter any numbers");
      gotoxy(10, 8);  cputs("Press ENTER to continue");
      pause_me(0);
      restore_screen();
      return;                             //If not sends you back to main menu
   }
   if((strcmp(filename_out, "noname")) == 0)             //If file has no name
   {
      make_window();                                       //Little red window
      gotoxy(13, 4);   cprintf("Enter file name");
      textbackground(WHITE);
      textcolor(BLACK);
      gotoxy(17, 6);  delchars(9);                           //Makes white box
      fn_tmp[0] = 9;                    //Max number of chars in filename is 8
      fflush(stdin);
      _setcursortype(_NORMALCURSOR);
      ptr = cgets(fn_tmp);                                     //Gets filename
      _setcursortype(_NOCURSOR);
      textbackground(RED);                     //Restores colors in the window
      textcolor(WHITE);
      if(strlen(ptr) < 1)                         //If ENTER alone was pressed
      {
         restore_screen();
         return;
      }
      strcpy(filename_out, ptr);
      for(ii = 0; ii < (strlen(filename_out) + 1); ii++)
         if(filename_out[ii] == '.') filename_out[ii] = '\0';
      strcat(filename_out, ".caf");
      if((fp2 = fopen(filename_out, "r")) != NULL)         //Does file exists?
      {
         fclose(fp2);          //If yes closes it asks permission to overwrite
         make_window();
         gotoxy((43 - (20 + strlen(filename_out)))/2 , 4);            //Center
         cprintf("File %s already exists", filename_out);
         gotoxy(5, 6);
         cprintf("Is it OK to overwrite it? (y/n)");
         fflush(stdin);
         if((toupper(getch())) != 'Y')
	 {
            restore_screen();
	    return;
         }
      }                                               //End of If(file exists)
   }                                            //End of if(filname is noname)
   if((fp2 = fopen(filename_out, "w")) == NULL)   //Opens out file in "w" mode
      file_error(filename_out, "write", fp2);
   fprintf(fp2, "%s\n\n",   filename_out);        //Starts writing to file_out
   fprintf(fp2, "//DO NOT EDIT THIS FILE!!!\n\n");
   fprintf(fp2, "BEGINHERECELLLINE\n%s\n\n", cell_line);
   fprintf(fp2, "BEGINHERETARGET\n%s\n\n", cat_target);
   fprintf(fp2, "BEGINHEREBLANK\n%f\n\n", blank_counts);
   fprintf(fp2, "BEGINHEREBASALLEVEL\n%d\n\n", basal_level);
   fprintf(fp2, "BEGINHERESAMPLES\n");
   while(init_counts[index] != 0.0)
   {
      fprintf(fp2, "%s\n", sample_name[index]);
      fprintf(fp2, "%f\n", init_counts[index]);
      if(++index > 100) break;
   }
   fprintf(fp2, "ENDHERE\n");
   fclose(fp2);                                    //Done writing, closes file
   saved_yes = TRUE;
   restore_screen();
}                                               //END OF SEND_TO_FILE FUNCTION



void change_defaults(void)                                //To change defaults
{
   char t_added_temp_st[7], t_removed_temp_st[6], one_two, tmp1, tmp1_str[3];
   int t_added_temp, t_removed_temp, tmp1_int;
   char *ptr_added, *ptr_removed;

   make_window();                                          //Little red window
   textcolor(YELLOW);
   gotoxy(13, 3);   cprintf("CHANGING DEFAULTS");
   textcolor(WHITE);
   gotoxy(11, 5);  cputs("1) Ammount of toluene");
   gotoxy(11, 7);  cputs("2) Background color");
   one_two = getch();
   restore_screen();
   if(one_two == '\r') return;
   if(one_two == '1')
   {
      make_big_window();
      gotoxy(32, 3);   cprintf("Current settings:");         //Display current
      gotoxy(18, 5);
      cprintf("You are adding %.2f microliters of toluene", t_added);
      gotoxy(18, 6);
      cprintf("and removing %.2f microliters of toluene", t_removed);
      gotoxy(20, 8);   cprintf("Enter new ammount for added toluene: ");
      t_added_temp_st[0] = 5;
      _setcursortype(_NORMALCURSOR);
      ptr_added = cgets(t_added_temp_st);                    //Gets new number
      _setcursortype(_NOCURSOR);
      if(strlen(ptr_added) < 1) return;           //If ENTER alone was pressed
      if(!isdigit(ptr_added[0]))               //If first char is not a number
      {
         invalid_entry();
         return;
      }
      t_added_temp = atoi(ptr_added);
      if(t_added_temp > 1000 || t_added_temp < 10)  //If not between 10 & 1000
      {
         gotoxy(22, 15);  cprintf("Number has to be between 10 and 1000");
         gotoxy(28, 17);
         pause_me(1);
         return;                                 //Returns to calling function
      }
      gotoxy(20, 10);
      cprintf("Enter new ammount for removed toluene: ");
      t_removed_temp_st[0] = 4;                //MAx number of chars here is 3
      _setcursortype(_NORMALCURSOR);
      ptr_removed = cgets(t_removed_temp_st);    //Gets new number as a string
      _setcursortype(_NOCURSOR);
      if(strlen(ptr_removed) == 0) return;
      if(!isdigit(ptr_removed[0]))
      {
         invalid_entry();
         return;
      }
      t_removed_temp = atoi(ptr_removed);
      if(t_removed_temp > 999 || t_removed_temp < 9)//If # not between 9 & 999
      {
         gotoxy(22, 15);   cprintf("Number has to be between 9 and 999");
         gotoxy(28, 17);
         pause_me(1);
         return;                                 //Returns to calling function
      }
      if(t_removed_temp > t_added_temp)                         //Ray's advice
      {
         make_window();
         gotoxy(4, 4);  cputs("Just how do you think to remove");
         gotoxy(10, 5); cputs("more than you added?");
         gotoxy(10, 8); cputs("Press ENTER to continue");
         pause_me(0);
         restore_screen();
         return;
      }
      if(t_removed_temp == t_added_temp)          //Also based on Ray's advice
      {
         make_window();
         gotoxy(5, 4);  cputs("You think you have steady hand?");
         gotoxy(10, 8); cputs("Press ENTER to continue");
         pause_me(0);
         restore_screen();
         return;
      }      //If all was OK so far it will asign values to non-temp variables
      t_added = t_added_temp;
      t_removed = t_removed_temp;
      gotoxy(28, 12);
      cprintf("Saving new settings...");
      write_defaults();                        //Save new defaults to the disk
      cprintf("Done");                     //Next 4 lines display new settings
      gotoxy(34, 15);   cprintf("New settings:");
      gotoxy(18, 17);
      cprintf("You are adding %.2f microliters of toluene", t_added);
      gotoxy(18, 18);
      cprintf("and removing %.2f microliters of toluene", t_removed);
      gotoxy(27, 21);
      pause_me(1);                                           //Waits for ENTER
      return;                           //Returns to calling function (main())
   }                                               //End of if(one_two == '1')
   else if(one_two == '2')
   {
      clrscr();
      make_big_window();
      gotoxy(30, 3);   cprintf("Current setting is %d", background_color);
      gotoxy(32, 6);   cprintf("Available colors:");
      gotoxy(36, 8);   cprintf("0)  BLACK");
      gotoxy(36, 9);   cprintf("1)  BLUE");
      gotoxy(36, 10);  cprintf("2)  GREEN");
      gotoxy(36, 11);  cprintf("3)  CYAN");
      gotoxy(36, 12);  cprintf("4)  RED");
      gotoxy(36, 13);  cprintf("5)  MAGENTA");
      gotoxy(36, 14);  cprintf("6)  BROWN");
      gotoxy(34, 16);  cprintf("Your choice:");
      fflush(stdin);
      if((tmp1 = getch()) == '\r') return;                     //If it's ENTER
      if((int) tmp1 < 48 || (int) tmp1 > 54)
      {
         invalid_entry();
         return;
      }
      tmp1_str[0] = tmp1;
      tmp1_str[1] = '\0';
      tmp1_int = atoi(tmp1_str);
      background_color = tmp1_int;
      gotoxy(28, 18);   cprintf("Saving new settings...");
      write_defaults();
      cprintf("Done");
      gotoxy(28, 20);
      pause_me(1);
      restore_screen();
   }                                          //End of else if(one_two == '2')
   else  invalid_entry();
}                                            //END OF CHANGE_DEFAULTS FUNCTION



void invalid_entry(void)                 //Just displays invalid entry message
{
   make_window();                                          //Little red window
   gotoxy(10, 4);  cputs("That was invalid entry");
   gotoxy(8, 5);   cputs("Read the options carefully");
   gotoxy(9, 7);   cputs("Press ENTER to continue");
   wrong();                                                            //Beeps
   pause_me(0);
   restore_screen();
   return;
}                                              //END OF INVALID_ENTRY FUNCTION


int compare_string(char string1[], char string2[], int how_many)
{                       //Compares first (how_many) chars in string1 & string2
   int index, flag =  0;                             //Flag is set to 0 (same)

   for(index = 0; index < how_many; index++)          //Loops (how_many) times
      if(string1[index] != string2[index])                 //If chars not same
      {
	 flag = 1;                                                //Raise flag
	 break;                                               //Hit the breaks
      }
   return(flag);                                 //Returns 0 if same, 1 if not
}                                             //END OF COMPARE_STRING FUNCTION



void file_error(char file_name[30], char rw[7], FILE *fptr)
{                   //In case of file error displays message and exits program
   fclose(fptr);
   window(1, 1, 80, 25);
   textbackground(BLACK);
   textcolor(WHITE);
   lowvideo();
   clrscr();
   gotoxy(12, 10);
   cprintf("Error has occured while attempting to %s %s", rw, file_name);
   gotoxy(31, 15); cprintf("Exiting program");
   gotoxy(1, 25);
   _setcursortype(_NORMALCURSOR);
   exit(1);                                    //Also exits program with error
}                                                 //END OF FILE_ERROR FUNCTION



void calculate_all(void)                      //All calculations are done here
{
   int index = 1;
   double blevel;

   init_counts[0] = 0.0;                                        //Just in case
   init_counts[101] = 0.0;                                      //Just in case
   t_cor_factor = t_added / t_removed;          //Calculates correction factor
   tcor_blank_counts = blank_counts * t_cor_factor;   //Corects blank for tol.
   while(init_counts[index] != 0)               //Corects for remained toluene
   {
      tcor_counts[index] = init_counts[index] * t_cor_factor;
      if(index++ > 100) break;
   }
   index = 1;
   while(init_counts[index] !=0)                            //Substracts blank
   {
      tcor_bcor_counts[index] = tcor_counts[index] - tcor_blank_counts;
      if(tcor_bcor_counts[index] < 0) tcor_bcor_counts[index] = 0.0;
      if(index++ > 100) break;
   }
   blevel = tcor_bcor_counts[basal_level];    //Assigns chosen value to blevel
   index = 1;
   while(init_counts[index] !=0)                       //Calculates times fold
   {
      if(tcor_bcor_counts[index] == 0.0 || blevel == 0.0)
      {                                               //Prevents division by 0
         x_fold[index] = 0.0;
         if(index++ > 100) break;
         continue;
      }
      x_fold[index] = tcor_bcor_counts[index] / blevel;
      if(x_fold[index] < 0) x_fold[index] = 0.0;
      if(index++ > 100) break;
   }
   return;                                       //Returns to calling function
}                                              //END OF CALCULATE_ALL FUNCTION




int get_blevel(void)                           //Gets basal level number (int)
{
   char temp_string[6], *ptr;
   int index = 0, flag = TRUE, wrong = 1, i = 0;

   make_big_window();                                        //Big blue window
   do                                                //Get basal level by gets
   {
      if(wrong == 0)                             //If first char is not number
      {
         if(++i == 1)
         {
            gotoxy(28, 8);
            cprintf("That was invalid entry.");  //Prints this only first time
         }
         gotoxy(56, 13);  delchars(10);           //Deletes characters entered
      }
      else
      {
      gotoxy(21, 13);
      cprintf("Which entry number is basal level?: "); //Prints this only once
      }
      fflush(stdin);
      temp_string[0] = 4;                      //Max number of chars here is 3
      _setcursortype(_NORMALCURSOR);
      ptr = cgets(temp_string);                //Does this once for every loop
      _setcursortype(_NOCURSOR);
   }
   while((wrong = isdigit(ptr[0])) == 0);            //Loop untill it's number
   basal_level = atoi(ptr);                                //Convert to number
   if(basal_level < 1 || basal_level > 100) flag = FALSE;
   else
   {
      while(index < 101)                                  //Count # of entries
      {
         index++;
         if(init_counts[index] == 0.0) flag = FALSE;
         if(index >= basal_level) break;          //If no entry number "index"
      }
      if(index >= 101) flag = FALSE;
      if(flag == TRUE) return(0);                        //Returns 0 if all OK
   }
   make_window();      //If entry does not exists displays err msg & returns 1
   gotoxy(11, 5);   cprintf("There is no entry # %d", basal_level);
   gotoxy(11, 8);   cputs("Press ENTER to continue");
   pause_me(0);
   fflush(stdin);
   textbackground(background_color);
   return(1);     //Returns 1 which sends it back at the beginning of function
}                                                 //END OF GET_BLEVEL FUNCTION



void change_background(void)                        //Changes background level
{
   char new_background_string[11], *ptr;
   double old;

   gettext(21, 9, 60, 16, buff);              //Saves text that is owervritten
   make_change_window("CHANGE BLANK COUNTS");
   gotoxy(3, 3);  cprintf("Current counts from blank = %.2f", blank_counts);
   gotoxy(13, 5); cprintf("Enter new counts:");
   textbackground(WHITE);
   gotoxy(17, 7); delchars(9);                               //Makes white box
   new_background_string[0] = 9;               //Max number of chars here is 8
   fflush(stdin);
   _setcursortype(_NORMALCURSOR);
   ptr = cgets(new_background_string);            //Gets new background string
   _setcursortype(_NOCURSOR);
   if(strlen(ptr) < 1)                            //If ENTER alone was pressed
   {
      restoreme(0);
      return;
   }
   if(!isdigit(ptr[0]))                        //If first char is not a number
   {
      invalid_entry();
      restoreme(0);
      return;
   }
   old = blank_counts;
   blank_counts = atof(ptr);
   if(blank_counts > 60000.0)           //Can't have more than this as a blank
   {
      make_change_window("CHANGE BLANK COUNTS");
      textcolor(RED);
      gotoxy(7, 5);   cprintf("That is out of linear range");
      wrong();                                                         //Beeps
      delay(2000);
      blank_counts = old;
      fflush(stdin);
      restoreme(0);
      return;
   }
   if(blank_counts <= 0.0)                                   //If zero or less
   {
      make_change_window("CHANGE BLANK COUNTS");
      textcolor(RED);
      gotoxy(7, 5);   cprintf("That was not a valid entry");
      wrong();                                                         //Beeps
      delay(2000);
      blank_counts = old;
      fflush(stdin);
      restoreme(0);
      return;
   }
   restoreme(3);                      //Restores text and updates blank counts
   saved_yes = FALSE;
   return;                                      //Returns to display_initial()
}                                          //END OF CHANGE_BACKGROUND FUNCTION



void restoreme(int which_one)      //Restores colors and text under the window
{
   textbackground(background_color);
   textcolor(YELLOW);
   window(1, 1, 80, 25);
   if(which_one == 1)
   {
      gotoxy(17, 23);  delchars(10);
      cprintf("%s", cell_line);                       //Updates cell line name
   }
   else if(which_one == 2)
   {
      gotoxy(38, 23);  delchars(10);
      cprintf("%s", cat_target);                         //Updates target name
   }
   else if(which_one == 3)
   {
      gotoxy(69, 23);  delchars(8);
      cprintf("%.2f", blank_counts);                    //Updates blank counts
   }
   puttext(21, 9, 60, 16, buff);         //Restores text that was under window
   window(2, 3, 79, 21);      //Restores window for displaying names and cpm.s
}                                                //END OF RESTOREME() FUNCTION



int change_sample_cpm(void)                  //Changes cpm's for single sample
{
   int index = 0, smpl_nmbr, flag = TRUE;
   char new_sample_cpm_string[6], new_cpms_string[12], *ptr1, *ptr2;
   double tmpdbl;

   gettext(21, 9, 60, 16, buff);                                  //Saves text
   make_change_window("CHANGE SAMPLE CPM");
   gotoxy(8, 4);  cprintf("Enter sample number: ");
   textbackground(WHITE);
   delchars(4);                                              //Makes white box
   new_sample_cpm_string[0] = 4;               //Max number of chars here is 3
   fflush(stdin);
   _setcursortype(_NORMALCURSOR);
   ptr1 = cgets(new_sample_cpm_string);                   //Gets sample number
   _setcursortype(_NOCURSOR);
   textbackground(GREEN);
   if(strlen(ptr1) < 1)                           //If ENTER alone was pressed
   {
      restoreme(0);
      return TRUE;
   }
   if(!isdigit(ptr1[0]))                      //If first char was not a number
   {
      invalid_entry();
      restoreme(0);
      return TRUE;
   }
   window(22, 10, 59, 15);                           //One line smaller window
   clrscr();
   smpl_nmbr = atoi(ptr1);
   while(index < 101)                        //Gets # of samples in the memory
   {
      index++;
      if(init_counts[index] == 0.0) flag = FALSE;
      if(index >= smpl_nmbr) break;
   }
   if(index >= 101) flag = FALSE;                     //If there is no entry #
   if(smpl_nmbr <= 0) flag = FALSE;
   if(flag == TRUE)
   {
      gotoxy(6, 2);  cprintf("Current CPM's for entry # %d", smpl_nmbr);
      gotoxy((38 - ((strlen(sample_name[smpl_nmbr]))+8))/2, 3);       //Center
      cprintf("(%s)", sample_name[smpl_nmbr]);
      cprintf(" = %.2f", init_counts[smpl_nmbr]);
      gotoxy(12, 4);  cprintf("Enter new value:");
      textbackground(WHITE);
      gotoxy(16, 6);  delchars(10);                          //Makes white box
      fflush(stdin);
      new_cpms_string[0] = 10;
      _setcursortype(_NORMALCURSOR);
      ptr2 = cgets(new_cpms_string);               //Gets string for new cpm's
      _setcursortype(_NOCURSOR);
      textbackground(GREEN);
      if(strlen(ptr2) < 1)                        //If ENTER alone was pressed
      {
         restoreme(0);
         return TRUE;
      }
      if(!isdigit(ptr2[0]))                   //If first char was not a number
      {
         invalid_entry();
         restoreme(0);
         return TRUE;
      }
      tmpdbl = atof(ptr2);
      if(tmpdbl > 220000.0)                              //If number is to big
      {
         clrscr();
         gotoxy(12, 4);  cprintf("Number to big");
         wrong();                                                      //Beeps
         delay(2000);                                        //Waits 2 seconds
         restoreme(0);
         return TRUE;
      }
      if(tmpdbl <= 0.0)                                //If number is to small
      {
         clrscr();
         gotoxy(11, 4);  cprintf("Number to small");
         wrong();                                                      //Beeps
         delay(2000);                                        //Waits 2 seconds
         restoreme(0);
         return TRUE;
      }
      saved_yes = FALSE;
      init_counts[smpl_nmbr] = tmpdbl;   //Finaly assigns cpm's to init_counts
   }
   else                //If entry does not exists displays err msg & returns 1
   {
      gotoxy(9, 3);  cprintf("There is no entry # %d", smpl_nmbr);
      wrong();                                                         //Beeps
      delay(2000);                                         //Waits two seconds
      restoreme(0);
      return TRUE;
   }
   restore_screen();
   return FALSE;                            //Returns yes to display_initial()
}                                          //END OF CHANGE_SAMPLE_CPM FUNCTION



int change_sample_name(void)               //Changes the name af single sample
{
   int index = 0, smpl_nmbr, flag = TRUE;
   char smpl_nmbr_str[6], new_name_string[18], *ptr1, *ptr2;

   gettext(21, 9, 60, 16, buff);                                  //Saves text
   make_change_window("CHANGE SAMPLE NAME");
   gotoxy(8, 4);   cprintf("Enter sample number: ");
   textbackground(WHITE);                                    //Makes white box
   delchars(4);
   smpl_nmbr_str[0] = 4;                            //Max number of chars is 3
   fflush(stdin);
   _setcursortype(_NORMALCURSOR);
   ptr1 = cgets(smpl_nmbr_str);                   //Gets # of sample to change
   _setcursortype(_NOCURSOR);
   textbackground(GREEN);
   gotoxy(8, 4);  delchars(27);       //Deletes previous stuff from the screen
   if(strlen(ptr1) < 1)                            //If ENTER alone is pressed
   {
      restoreme(0);
      return TRUE;
   }
   if(!isdigit(ptr1[0]))                       //If first char is not a number
   {
      invalid_entry();
      restoreme(0);
      return TRUE;
   }
   smpl_nmbr = atoi(ptr1);
   while(index < 101)                      //Counts how many samples there are
   {
      index++;
      if(init_counts[index] == 0.0) flag = FALSE;
      if(index >= smpl_nmbr) break;               //Compares it with # entered
   }
   if(index >= 101) flag = FALSE;                               //Just in case
   if(smpl_nmbr <= 0) flag = FALSE;
   if(flag == TRUE)                                       //If number was good
   {
      gotoxy(7, 3);  cprintf("Current name for entry # %d", smpl_nmbr);
      gotoxy((40 - ((strlen(sample_name[smpl_nmbr])) + 3))/2, 4);     //Center
      cprintf("is %s", sample_name[smpl_nmbr]);
      gotoxy(13, 5);  cprintf("Enter new name:");
      textbackground(WHITE);
      gotoxy(13, 7);   delchars(16);                         //Makes white box
      fflush(stdin);
      new_name_string[0] = 16;                   //Max size for the name is 15
      _setcursortype(_NORMALCURSOR);
      ptr2 = cgets(new_name_string);
      _setcursortype(_NOCURSOR);
      textbackground(GREEN);
      if(strlen(ptr2) < 1)                        //If ENTER alone was pressed
      {
         restoreme(0);
	 return TRUE;
      }
      saved_yes = FALSE;
      strcpy(sample_name[smpl_nmbr], ptr2);      //Changes name for the sample
   }
   else                //If entry does not exists displays err msg & returns 1
   {
      gotoxy(9, 4);   cprintf("There is no entry # %d", smpl_nmbr);
      wrong();                                                         //Beeps
      delay(2000);                                           //Waits 2 seconds
      restoreme(0);
      return TRUE;
   }
   restore_screen();
   return FALSE;                            //Returns yes to display_initial()
}                                         //END OF CHANGE_SAMPLE_NAME FUNCTION



void change_target_name(void)                 //Changes the name of the target
{
   char new_target_string[13], *ptr;

   gettext(21, 9, 60, 16, buff);                                  //Saves text
   make_change_window("CHANGE TARGET");
   gotoxy((40 - ((strlen(cat_target)) + 23))/2, 3);                   //Center
   cprintf("Current target name is %s", cat_target);
   gotoxy(13, 5);  cprintf("Enter new name:");
   textbackground(WHITE);
   gotoxy(16, 7);  delchars(11);                             //Makes white box
   fflush(stdin);
   new_target_string[0] = 11;       //Max number of chars for the target is 10
   fflush(stdin);
   _setcursortype(_NORMALCURSOR);
   ptr = cgets(new_target_string);                      //Gets new tagret name
   _setcursortype(_NOCURSOR);
   if(strlen(ptr) < 1)                              //If only ENTER is pressed
   {
      restoreme(0);
      return;
   }
   saved_yes = FALSE;
   strcpy(cat_target, ptr);                              //Changes target name
   restoreme(2);
   return;                                                  //This was to easy
}                                         //END OF CHANGE_TARGET_NAME FUNCTION



void change_cell_line(void)                //Changes the name of the cell line
{
   char new_cell_line[13], *ptr;

   gettext(21, 9, 60, 16, buff);
   make_change_window("CHANGE CELL LINE");
   gotoxy((40 - ((strlen(cell_line)) + 21))/2, 3);                    //Center
   cprintf("Current cell line is %s", cell_line);
   gotoxy(13, 5);  cprintf("Enter new name:");
   textbackground(WHITE);
   gotoxy(16, 7);  delchars(11);                             //Makes white box
   fflush(stdin);
   new_cell_line[0] = 11;             //Max number of chars in cell line is 10
   fflush(stdin);
   _setcursortype(_NORMALCURSOR);
   ptr = cgets(new_cell_line);                           //Gets cell line name
   _setcursortype(_NOCURSOR);
   if(strlen(ptr) < 1)                            //If ENTER alone was pressed
   {
      restoreme(0);
      return;
   }
   saved_yes = FALSE;
   strcpy(cell_line, ptr);                            //Changes cell line name
   restoreme(1);
   return;                                                  //This was to easy
}                                         //END OF CHANGE_CELL_LINE() FUNCTION




void load_file(void)               //Loads names and init_counts from the file
{
   char filename_in[15], file_string[80], key;//, *fsptr, key;
   int index = 1, safe = 1, ii, index3;
   struct ffblk ffblk;
   int done, index5 = 1; //, tmpi, zz =1;
   char files[500][13]; //, tmp[6];

   done = findfirst("*.CAF",&ffblk,0);
   while (!done)
   {
      strcpy(files[index5], ffblk.ff_name);
      index5++;
      done = findnext(&ffblk);
   }
   if(index5 < 2)
   {
      make_window();
      gotoxy(14, 4); cprintf("No files found!");
      gotoxy(10, 6); cprintf("Press ENTER to continue");
      wrong();
      pause_me(0);
      restore_screen();
      return;
   }
   if(init_counts[1] != 0.0 && saved_yes == FALSE) //If previous one not saved
      if(continue_anyway() == FALSE) return;
   make_big_window();
   gotoxy(22, 2); putch('\xCB');                             //Upper connector
   for(ii = 0; ii < 21; ii++)           //Displays vertical line in the window
   {
      gotoxy(22, (ii + 3));
      putch('\xBA');
   }
   gotoxy(22, 24); putch('\xCA');                            //Lower connector
   textcolor(LIGHTGRAY);
   gotoxy(38, 11); cprintf("@@@@@   @@@   @@@@@  @@@@@");
   gotoxy(38, 12); cprintf("@      @   @    @    @");
   gotoxy(38, 13); cprintf("@      @@@@@    @    @@@@@");
   gotoxy(38, 14); cprintf("@      @   @    @        @");
   gotoxy(38, 15); cprintf("@@@@@  @   @    @    @@@@@");
   ii = index5 - 1;                    //Var ii contains total number of files
   textbackground(WHITE);
   textcolor(BLACK);
   gotoxy(1, 1);   clreol();                                   //For upper bar
   gotoxy(8, 1);   cprintf("to open");
   gotoxy(1, 25);  clreol();                                   //For lower bar
   gotoxy(6, 25);  cprintf("to return");
   gotoxy(54, 25); cprintf("and   to move up and down");
   textcolor(RED);
   gotoxy(2, 1);   cprintf("ENTER");                            //On upper bar
   gotoxy(2, 25); cprintf("ESC");                               //On lower bar
   gotoxy(52, 25); putch('\x18');                          //Displays up arrow
   gotoxy(58, 25); putch('\x19');                        //Displays down arrow
   textbackground(background_color);
   textcolor(YELLOW);
   window(5, 3, 20, 23);
   index5 = 1;
   while(index5 < (ii + 1))                              //Displays file names
   {
      cprintf(" %12s", files[index5]);
      if(++index5 > 21) break;
      gotoxy(1, (wherey() + 1));
   }
   index5 = 1;
   gotoxy(1, 1);
   textbackground(WHITE);
   textcolor(BLACK);
   cprintf(" %12s", files[index5]);                 //Highlites first filename
   textbackground(background_color);
   textcolor(YELLOW);
   gotoxy(1, 1);
   while((int)(key = getch()) != 27)             //Loops untill ESC is pressed
   {
      if(key == 0)
         key = (getch() - 100);
      if((int) key == -28)                                          //Up arrow
      {
         if(index5 <= 1) continue;                 //If index5 <= 1 do nothing
         if(wherey() == 1)                        //If cursor is on the line 1
         {
            clreol();                                             //Clear line
            cprintf(" %12s", files[index5]);                      //Print this
            insline();                                           //Insert line
            gotoxy(1, 1);
            index5--;                                         //Decrease index
            textbackground(WHITE);                  //White bkgrnd, black text
            textcolor(BLACK);
            cprintf(" %12s", files[index5]);              //Puts previous file
            gotoxy(1, 1);
            textbackground(background_color);                 //Restore colors
            textcolor(YELLOW);
         }
         else
         {
            cprintf(" %12s", files[index5]);                      //Print this
            gotoxy(1, (wherey() - 1));          //Go to 1 on the previous line
            index5--;                                         //Decrease index
            textbackground(WHITE);                 //White bckgrnd, black text
            textcolor(BLACK);
            cprintf(" %12s", files[index5]);                      //Print this
            gotoxy(1, wherey());              //Move to the left of the window
            textbackground(background_color);                 //Restore colors
            textcolor(YELLOW);
         }
      }                                                   //End of up arrow if
      if((int) key == -20)                                        //Down arrow
      {
         if(index5 >= ii) continue;                               //Do nothing
         cprintf(" %12s   ", files[index5]);                      //Print this
         gotoxy(1, wherey());                           //Begining of the line
         index5++;                                           //Increase index5
         textbackground(WHITE);                    //White bckgrnd, black text
         textcolor(BLACK);
         cprintf(" %12s", files[index5]);                         //Print this
         gotoxy(1, wherey());                    //Begining  of the line again
         textbackground(background_color);                    //Restore colors
         textcolor(YELLOW);
      }
      if((int) key == 13)            //If ENTER is pressed assigns filename_in
      {
         strcpy(filename_in, files[index5]);
         break;
      }
   }
   if((int) key == 27)                                  //If loop ended by ESC
   {
      restore_screen();
      return;
   }                                                 //Else it had to be ENTER
   if((fp3 = fopen(filename_in, "r")) == NULL)
   {
      make_window();
      gotoxy((46 - (14 + strlen(filename_in)))/2 , 5);                //Center
      textcolor(YELLOW);
      cprintf("Cannot open %s", filename_in);
      textcolor(WHITE);
      wrong();
      delay(2000);
      restore_screen();
      return;
   }
   for(index3 = 1; index3 < 102; index3++)     //Resets all init_counts to 0.0
      init_counts[index3] = 0.0;
   read_lines("BEGINHERECELLLINE", filename_in, fp3);     //Loks for cell line
   if(fgets(file_string, 80, fp3) == NULL)                   //Reads cell line
      file_error(filename_in, "read", fp3);
   copy_string(cell_line, file_string);
   read_lines("BEGINHERETARGET", filename_in, fp3);         //Looks for target
   if(fgets(file_string, 80, fp3) == NULL)                  //Reads cat target
      file_error(filename_in, "read", fp3);
   copy_string(cat_target, file_string);
   read_lines("BEGINHEREBLANK", filename_in, fp3);//Looks for cpm's from blank
   if(fgets(file_string, 80, fp3) == NULL)            //Reads cpm's from blank
      file_error(filename_in, "read", fp3);
   blank_counts = atof(file_string);
   read_lines("BEGINHEREBASALLEVEL", filename_in, fp3); //Looks for b. level #
   if(fgets(file_string, 80, fp3) == NULL)           //Reads # for basal level
      file_error(filename_in, "read", fp3);
   basal_level = atoi(file_string);
   read_lines("BEGINHERESAMPLES", filename_in, fp3);       //Looks for samples
   while(safe++ < 102)                  //Reads samples until endhere is found
   {
      if((fgets(file_string, 80, fp3)) == NULL)
         file_error(filename_in, "read", fp3);
      if(compare_string(file_string, "ENDHERE", 6) == 0) break;
      copy_string(sample_name[index], file_string);
      if((fgets(file_string, 80, fp3)) == NULL)
         file_error(filename_in, "read", fp3);
      init_counts[index] = atof(file_string);
      index++;
   }
   fclose(fp3);
   strcpy(filename_out, filename_in);
   saved_yes = TRUE;
   restore_screen();
   return;           //Returns to input_from_file() which returns it to main()
}                                                   //END OF LOAD_FILE FUNCTON





void copy_string(char s1[], char s2[])             //Copies string1 to string2
{
   int index = 0;

   while(index < 81)
   {
      if(s2[index] == '\n' || s2[index] == ' ')   //At first \n or blank space
      {
         s1[index] = '\0';                    //Puts terminator in dest string
         break;
      }
      s1[index] = s2[index];
      index++;
   }
   return;                                       //Returns to calling function
}                                                //END OF COPY_STRING FUNCTION



void read_lines(char kw[20], char fname_in[30], FILE *fptr)
{          //Read line from the file and compares first word with keyword (kw)
   int n_chars, safety1 = 0, flag;
   char one_line[80];

   n_chars = strlen(kw);
   while(fgets(one_line, 80, fptr) != NULL)               //Reads line by line
   {
      if((flag = compare_string(one_line, kw , n_chars)) == 0) break;
      if(++ safety1 > 7) break;
   }
   if(flag == 1)                         //It will be 1 if BEGINHERE not found
      file_error(fname_in, "read", fptr);
   return;                                       //Returns to calling function
}                                                 //END OF READ_LINES FUNCTION



void load_protocol(void)                                      //Loads protocol
{
   char cpms_string[12], *ptr1, files[500][13], key;
   int index = 1, ii, index3, y, done, index5 = 1;
   double tmp;
   struct ffblk ffblk;

   done = findfirst("*.CAP", &ffblk, 0);
   while (!done)
   {
      strcpy(files[index5], ffblk.ff_name);
      index5++;
      done = findnext(&ffblk);
   }
   if(index5 < 2)                                      //If no protocols found
   {
      make_window();
      gotoxy(12, 4); cprintf("No protocols found!");
      gotoxy(10, 6); cprintf("Press ENTER to continue");
      wrong();
      pause_me(0);
      restore_screen();
      return;
   }
   if(init_counts[1] != 0.0 && saved_yes == FALSE) //If previous one not saved
      if(continue_anyway() == FALSE) return;
   for(index3 = 1; index3 < 102; index3++)     //Resets all init_counts to 0.0
      init_counts[index3] = 0.0;
   make_big_window();
   gotoxy(22, 2); putch('\xCB');                             //Upper connector
   for(ii = 0; ii < 21; ii++)           //Displays vertical line in the window
   {
      gotoxy(22, (ii + 3));
      putch('\xBA');
   }
   gotoxy(22, 24); putch('\xCA');                            //Lower connector
   ii = index5 - 1;                    //Var ii contains total number of files
   textbackground(WHITE);
   textcolor(BLACK);
   gotoxy(1, 1);   clreol();                                   //For upper bar
   gotoxy(8, 1);   cprintf("to load");
   gotoxy(1, 25);  clreol();                                   //For lower bar
   gotoxy(6, 25);  cprintf("to return");
   gotoxy(54, 25); cprintf("and   to move up and down");
   textcolor(RED);
   gotoxy(2, 1);   cprintf("ENTER");                            //On upper bar
   gotoxy(2, 25); cprintf("ESC");                               //On lower bar
   gotoxy(52, 25); putch('\x18');                          //Displays up arrow
   gotoxy(58, 25); putch('\x19');                        //Displays down arrow
   textbackground(background_color);
   textcolor(YELLOW);
   window(5, 3, 20, 23);                           //Window for protocol names
   index5 = 1;
   while(index5 < (ii + 1))                //Prints protocol names on the left
   {
      cprintf(" %12s", files[index5]);
      if(++index5 > 21) break;
      gotoxy(1, (wherey() + 1));
   }
   index5 = 1;
   gotoxy(1, 1);
   textbackground(WHITE);
   textcolor(BLACK);
   cprintf(" %12s", files[index5]);            //Highlites first protocol name
   textbackground(background_color);
   textcolor(YELLOW);
   gotoxy(1, 1);
   peek_in(files[index5]);                //Display first protocol on the left
   while((int)(key = getch()) != 27)              //Loops while ESC is the key
   {
      if(key == 0)
         key = (getch() - 100);
      if((int) key == -28)                                          //Up arrow
      {
         if(index5 <= 1) continue;             //Already on the first protocol
         if(wherey() == 1)                                   //It's on the top
         {
            clreol();                                             //Clear line
            cprintf(" %12s", files[index5]); //Displays non highlited filename
            insline();           //This will push all the lines below down one
            gotoxy(1, 1);                                  //Top of the window
            index5--;
            textbackground(WHITE);
            textcolor(BLACK);
            cprintf(" %12s", files[index5]);              //New highlited file
            gotoxy(1, 1);
            textbackground(background_color);                        //Restore
            textcolor(YELLOW);
            peek_in(files[index5]);                      //Display current one
         }
         else                                           //Means not on the top
         {
            cprintf(" %12s", files[index5]);                    //Print normal
            gotoxy(1, (wherey() - 1));                            //Go line up
            index5--;                                        //Decrease index5
            textbackground(WHITE);
            textcolor(BLACK);
            cprintf(" %12s", files[index5]);             //Highlites upper one
            y = wherey();                             //Remember where you are
            textbackground(background_color);
            textcolor(YELLOW);
            peek_in(files[index5]);                      //Display current one
            gotoxy(1, y);                                     //Go to previous
         }
      }                                                      //End of up arrow
      if((int) key == -20)                                        //Down arrow
      {
         if(index5 >= ii) continue;
         cprintf(" %12s   ", files[index5]);                  //Prints normaly
         gotoxy(1, wherey());                          //Begining of thbe line
         index5++;                                                  //Increase
         textbackground(WHITE);
         textcolor(BLACK);
         cprintf(" %12s", files[index5]);                   //Prints highlited
         y = wherey();                                //Remember where you are
         textbackground(background_color);
         textcolor(YELLOW);
         peek_in(files[index5]);                         //Display current one
         gotoxy(1, y);
      }
      if((int) key == 13)  break;                         //If ENTER exit loop
   }
   if((int) key == 27)                              //If loop ended by ESC key
   {
      restore_screen();
      return;
   }       //Else it had to be ENTER so keep the last protocol and get numbers
   restore_screen();
   make_big_window();                                        //Big blue window
   strcpy(filename_out, "noname");
   saved_yes = FALSE;
   if(strcmp(cell_line, "VOID") == 0)      //If protocol didn't have cell line
      if(gt_cell_line(1) == FALSE)
         strcpy(cell_line, "?????");
   if(strcmp(cat_target, "VOID") == 0)         //If protocol did't have target
      if(gt_target(1) == FALSE)
         strcpy(cat_target, "?????");
   gt_blank_cpms();
   index = 1;
   clrscr();
   make_big_window();                                        //Big blue window
   while(compare_string(sample_name[index], "ENDHERE", 6) != 0)
   {                //Gets cpm's for samples untill sample name is not ENDHERE
      gotoxy((80 - (17 + (strlen(sample_name[index]))))/2, 10);      //Centers
      cprintf("Enter counts for %s", sample_name[index]);
      textbackground(WHITE);
      textcolor(BLACK);
      gotoxy(35, 13); delchars(10);                          //Makes white box
      fflush(stdin);
      cpms_string[0] = 10;
      _setcursortype(_NORMALCURSOR);
      ptr1 = cgets(cpms_string);                     //Gets counts as a string
      _setcursortype(_NOCURSOR);
      textbackground(background_color);
      textcolor(YELLOW);
      if(!isdigit(ptr1[0])) init_counts[index] = 0.33;
      else tmp = atof(ptr1);
      if(tmp > 220000.0)
         init_counts[index] = 0.66;
      else if(tmp <= 0.0)
         init_counts[index] = 0.33;
      else
         init_counts[index] = tmp;
      if(index++ > 100) break;
      gotoxy(23, 10);  delchars(34);                  //Deletes previous stuff
   }
   return;             //Returns to input_from_file() which sends it to main()
}                                              //END OF LOAD_PROTOCOL FUNCTION




void peek_in(char pname[])               //Loads and displays current protocol
{
   int i = 0, safe = 0, index = 1;
   char prot_line[81];

   if((fp6 = fopen(pname, "r")) == NULL)
   {
      make_window();
      gotoxy((46 - (14 + strlen(pname)))/2 , 5);                      //Center
      textcolor(YELLOW);
      cprintf("Cannot open %s", pname);
      textcolor(WHITE);
      wrong();
      delay(2000);
      restore_screen();
      clrscr();
      exit(1);
   }
   read_lines("BEGINHERECELLLINE", pname, fp6);           //Loks for cell line
   if(fgets(prot_line, 80, fp6) == NULL)                     //Reads cell line
      file_error(pname, "read", fp6);
   copy_string(cell_line, prot_line);
   read_lines("BEGINHERETARGET", pname, fp6);               //Looks for target
   if(fgets(prot_line, 80, fp6) == NULL)                   //Reads target name
      file_error(pname, "read", fp6);
   copy_string(cat_target, prot_line);
   read_lines("BEGINHEREBASALLEVEL", pname, fp6);    //Looks for basal level #
   if(fgets(prot_line, 80, fp6) == NULL)  //Reads number of basal level sample
      file_error(pname, "read", fp6);
   basal_level = atoi(prot_line);
   read_lines("BEGINHERESAMPLENAMES", pname, fp6);     //Looks for sample names
   while(safe++ < 102)                                    //Reads sample names
   {
      if((fgets(prot_line, 80, fp6)) == NULL)
         file_error(pname, "read", fp6);
      copy_string(sample_name[index], prot_line);
      if(compare_string(prot_line, "ENDHERE", 6) == 0) break;
      index++;
   }
   fclose(fp6);                                          //Close protocol file
   window(24, 3, 77, 23);                 //Window to display protocol content
   clrscr();
   gotoxy(1, 1);
   cprintf("Cell line: %s\r\n", cell_line);
   cprintf("CAT target: %s\r\n", cat_target);
   cprintf("Basal level is sample # %d ", basal_level);
   cprintf("(%s)\r\n", sample_name[basal_level]);
   while(++i < 16)
   {
      if(compare_string(sample_name[i], "ENDHERE", 6) == 0) break;
      cprintf("  # %3d", i);
      cprintf("    %s\r\n", sample_name[i]);
   }
   gotoxy(1, 20);
   cprintf("Protocol %s contains %d sample names", pname, index - 1);
   window(5, 3, 20, 23);
}                                                  //END OF PEEK_IN() FUNCTION



void add_protocol(void)                       //Inputs and then saves protocol
{
   char pfn_ini[11], pfn[13], sn_tmp[18];
   int index = 1, ii;
   char *fsptr, *ptr;

   if(init_counts[1] != 0.0 && saved_yes == FALSE) //If previous one not saved
      if(continue_anyway() == FALSE) return;
   for(ii = 1; ii < 102; ii++)                 //Resets all init_counts to 0.0
      init_counts[ii] = 0.0;
   make_window();
   gotoxy(6, 4);
   cprintf("Enter filename for new protocol");
   gotoxy(17, 6);
   textbackground(WHITE);
   textcolor(BLACK);
   delchars(9);
   pfn_ini[0] = 9;
   fflush(stdin);
   _setcursortype(_NORMALCURSOR);
   fsptr = cgets(pfn_ini);
   _setcursortype(_NOCURSOR);
   if(strlen(fsptr) < 1)
   {
      restore_screen();
      return;
   }
   strcpy(pfn, fsptr);
   for(ii = 0; ii < (strlen(pfn) + 1); ii++)         //Replace first . with \0
      if(pfn[ii] == '.')
         pfn[ii] = '\0';
   strcat(pfn, ".cap");                                        //Add extension
   strupr(pfn);
   if((fp5 = fopen(pfn, "r")) != NULL)                        //If file exists
   {
      fclose(fp5);
      make_window();
      gotoxy(9, 4);
      cprintf("File %s already exists", pfn);
      gotoxy(6, 6);
      cprintf("Is it OK to overwrite it? (y/n)");
      fflush(stdin);
      if((toupper(getche())) != 'Y')
      {
         restore_screen();
         return;
      }
   }
   restore_screen();
   if(gt_cell_line(0) == FALSE)                          //Gets cell line name
      strcpy(cell_line, "VOID");                          //If not puts "VOID"
   if(gt_target(0) == FALSE)                                //Gets target name
      strcpy(cat_target, "VOID");                         //If not puts "VOID"
   clrscr();
   make_big_window();
   while(1)                                                //Gets sample names
   {
      gotoxy(24, 12);
      cprintf("Enter designation for the sample # %d", index);
      textbackground(WHITE);
      textcolor(BLACK);
      gotoxy(34, 14); delchars(16);
      sn_tmp[0] = 16;          //Max number of chars for the sample name is 15
      fflush(stdin);
      _setcursortype(_NORMALCURSOR);
      ptr = cgets(sn_tmp);
      _setcursortype(_NOCURSOR);
      textbackground(background_color);
      textcolor(YELLOW);
      if(strlen(ptr) < 1) break;                 //When ENTER alone is pressed
      strcpy(sample_name[index], ptr);
      init_counts[index] = 0.33;         //This is neccessary for get_blevel()
      if(index++ > 100) break;
   }
   if((strlen(sample_name[1])) < 1) return;  //If no sample names were entered
   while((get_blevel())) {}                                             //Cool
   for(ii = 1; ii < 102; ii++)   //This prevents protocol from being displayed
      init_counts[ii] = 0.0;
   if((fp5 = fopen(pfn, "w")) == NULL)                    //Tries to open file
      file_error(pfn, "create", fp5);
   fprintf(fp5, "%s\n\n", pfn);                      //Writes to protocol file
   fprintf(fp5, "//Do not edit this file!!!\n\n");
   fprintf(fp5, "BEGINHERECELLLINE\n%s\n\n", cell_line);
   fprintf(fp5, "BEGINHERETARGET\n%s\n\n", cat_target);
   fprintf(fp5, "BEGINHEREBASALLEVEL\n%d\n\n", basal_level);
   fprintf(fp5, "BEGINHERESAMPLENAMES\n");
   index = 1;
   while(strlen(sample_name[index]) >= 1)
   {
      fprintf(fp5, "%s\n", sample_name[index]);
      if(index++ > 100) break;
   }
   fprintf(fp5, "ENDHERE\n");                            //Ends with "ENDHERE"
   fclose(fp5);
   restore_screen();
   return;
}                                               //END OF ADD_PROTOCOL FUNCTION



void make_window(void)                               //Makes little red window
{
   int i = 2;

   window(21, 8, 60, 17);                                      //Sets the size
   textbackground(RED);                                          //Sets colors
   textcolor(WHITE);
   gotoxy(1, 2);
   putch('\xC9');                                          //Upper left corner
   while(i++ < 40)
      putch('\xCD');                                         //Horizontal line
   putch('\xBB');                                         //Upper right corner
   for(i = 3; i < 9; i++)
   {
      gotoxy(1, i);
      putch('\xBA');                                           //Vertical line
      delchars(38);
      gotoxy(40, i);
      putch('\xBA');                                           //Vertical line
   }
   gotoxy(1, 11);
   putch('\xC8');                                         //Lower right corner
   i = 2;
   while(i++ < 40)
      putch('\xCD');                                         //Horizontal line
   putch('\xBC');                                          //Lower left corner
   return;
}                                              //END OF MAKE_WINDOW() FUNCTION


void make_big_window(void)                             //Makes big blue window
{
   int i;

   window(1, 1, 80, 25);                   //Size of the window is full screen
   textbackground(background_color);                              //Set colors
   textcolor(YELLOW);
   clrscr();                                                    //Clear screen
   gotoxy(1, 2);
   putch('\xC9');                                          //Upper left corner
   for(i = 1; i <= 78; i++)
      putch('\xCD');                                         //Horizontal line
   putch('\xBB');                                         //Upper right corner
   for(i = 1; i <= 21; i++)
   {
      gotoxy(1, (i + 2));
      putch('\xBA');                                           //Vertical line
      gotoxy(80, (i + 2));
      putch('\xBA');                                           //Vertical line
   }
   gotoxy(1, 24);
   putch('\xC8');                                          //Lower left corner
   for(i = 1; i <= 78; i++)
      putch('\xCD');                                         //Horizontal line
   putch('\xBC');                                         //Lower right corner
   return;
}                                          //END OF MAKE_BIG_WINDOW() FUNCTION



void make_change_window(char ww[]) //Window for changing stuff in display_init
{
   int i;

   window(21, 9, 60, 16);                                    //Set window size
   textbackground(GREEN);                                         //Set colors
   clrscr();                                                        //Clear it
   window(21, 9, 60, 17);    //One line bigger at the bottom prevents scroling
   gotoxy(1, 1);
   textcolor(BLACK);
   putch('\xC9');                                           //Uper left corner
   for(i = 1; i < 39; i++)
      putch('\xCD');                                         //Horizontal line
   putch('\xBB');                                         //Upper right corner
   for(i = 2; i < 8; i++)
   {
      putch('\xBA');                                           //Vertical line
      gotoxy(40, i);
      putch('\xBA');                                           //Vertical line
   }
   putch('\xC8');                                          //Lower left corner
   for(i = 1; i < 39; i++)
      putch('\xCD');                                         //Horizontal line
   putch('\xBC');                                         //Lower right corner
   gotoxy((40 - strlen(ww)) / 2, 1);                                  //Center
   cprintf("%s", ww);                                     //Print window title
}                                       //END OF MAKE_CHANGE_WINDOW() FUNCTION



void restore_screen(void)                      //Restores full size and colors
{
   window(1, 1, 80, 25);
   textcolor(YELLOW);
   textbackground(background_color);
}                                           //END OF RESTORE_SCREEN() FUNCTION



void delchars(int number_of_chars)//Deletes number of chars passed as argument
{
   int xwas, i;

   xwas = wherex();                                   //Remember where you are
   for(i = 0; i < number_of_chars; i++) putch('\xFF');           //Puts spaces
   gotoxy(xwas, wherey());                          //Go to previous possition
   return;
}                                                 //END OF DELCHARS() FUNCTION



void welcome_msg(void)              //Displays welcome message at the begining
{
   textbackground(BLUE);                                         //Sets colors
   textcolor(YELLOW);
   _setcursortype(_NOCURSOR);                                   //Hides cursor
   clrscr();
   gotoxy(3, 3);
   cprintf("@       @  @@@@@@@@@  @           @@@@@@@@   @@@@@@@   @@@   ");
   cprintf("@@@  @@@@@@@@@\r\n");
   cprintf("  @       @  @          @          @          @       @  @  @ @");
   cprintf("  @  @\r\n");
   cprintf("  @   @   @  @@@@@@     @          @          @       @  @   @ ");
   cprintf("  @  @@@@@@\r\n");
   cprintf("  @  @ @  @  @          @          @          @       @  @     ");
   cprintf("  @  @\r\n");
   cprintf("  @@@   @@@  @@@@@@@@@  @@@@@@@@@   @@@@@@@@   @@@@@@@   @     ");
   cprintf("  @  @@@@@@@@@\r\n\r\n");
   cprintf("                               @@@@@@@@@   @@@@@@@\r\n");
   cprintf("                                   @      @       @\r\n");
   cprintf("                                   @      @       @\r\n");
   cprintf("                                   @      @       @\r\n");
   cprintf("                                   @       @@@@@@@\r\n\r\n");
   cprintf("                    @@@@@@@@@   @@@@@@@   @@@@@@@@@  @");
   cprintf("@@@@@@@@\r\n");
   cprintf("                    @          @       @      @      @\r\n");
   cprintf("                    @          @@@@@@@@@      @      @");
   cprintf("@@@@@@@@\r\n");
   cprintf("                    @          @       @      @              @");
   cprintf("\r\n");
   cprintf("                    @@@@@@@@@  @       @      @      @");
   cprintf("@@@@@@@@\r\n");
   gotoxy(37, 22); cprintf("VERSION 2.0");
   gotoxy(24, 24); cprintf("Please wait while program is loading:");
   delay(2000);                                              //Waits 2 seconds
}



void wrong(void)                                      //Plays Bethoven's fifth
{
   sound(400);                                                  //Plays C note
   delay(100);                                                //For 0.1 second
   nosound();
   delay(100);                              //Waits 0.1 second inbetween notes
   sound(400);                                                  //Plays C note
   delay(100);                                                //For 0.1 second
   nosound();
   delay(100);                              //Waits 0.1 second inbetween notes
   sound(400);                                                  //Plays C note
   delay(100);                                                //For 0.1 second
   nosound();
   delay(100);                              //Waits 0.1 second inbetween notes
   sound(314);                                                  //Plays G note
   delay(400);                                               //For 0.4 seconds
   nosound();
   return;
}                                                    //END OF WRONG() FUNCTION




//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//                             END OF PROGRAM                               //
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////