/****************************************************************************
 Sample RIPlocal/RIPdrive program

 For RIPlocal/RIPdrive 1.00, Copyright (C) 1994 by Zachary G. Ives.

 This program may be freely modified and adapted for other uses.

 Language:  Turbo C++ 3.0/Borland C++ 2.0 or later

 ****************************************************************************/


#include <stdio.h>
#include <dos.h>
#include "riplocal.h"           // RIPlocal function definitions

void main(void)
{
  char s[67];
  struct localrip_screeninfo r; // Used to get info on current text window

  if (localrip_detect() == 0)
	return;

   /* Switch into RIP mode, using the current directory for all fonts and
	  icons */
  localrip_activate(".\\",".\\");

   /* Display the SAMPLE.RIP file */
  localrip_readscene("sample.rip");

   /* Now translate the following RIP string, putting text on the screen */
  localrip_display("!|Y04000300|c0A|@5050This is a test of the local RIP viewer.");

   /* Get information on our text window */
  localrip_textinfo(&r);

   /* Use the ANSI/TTY display routines to output our info */
  sprintf(s, "Text window dimensions = %d x %d.  Color scheme = %d on %d.\r\n",
	r.w_bottom - r.w_top + 1, r.w_right - r.w_left + 1, r.t_foreground,
	r.t_background);
  localansi_string(s);

   /* And then an ANSI string */
  localansi_string("[1;35;40mPress a key to continue...\r\n");

   /* Get information on our text attributes */
  localrip_textinfo(&r);

   /* Wait for one key */
  localansi_char(localrip_readkey());

   /* As long as there are more keys, continue to read them in */
  while (localrip_checkkey())
	localansi_char(localrip_readkey());
  delay(72);

   /* Deactivate and close down the RIP module */
  localrip_deactivate();
}
